/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.OpenEndRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector3$;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Box$;
import org.openrndr.shape.BoxKt;
import org.openrndr.shape.IntBox;
import org.openrndr.shape.Movable3D;
import org.openrndr.shape.Scalable3D;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 _2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002_`B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fB=\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u001f\u001a\u00020\u001aJ\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bH\u0096\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bH\u0096\u0002J\"\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020\b2\b\b\u0002\u0010-\u001a\u00020\bJ\u001e\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bJ0\u00102\u001a\u00020\u00002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\b032\f\u00100\u001a\b\u0012\u0004\u0012\u00020\b032\f\u00101\u001a\b\u0012\u0004\u0012\u00020\b03J6\u00102\u001a\u00020\u00002\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bJ\u0011\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0006H\u0086\u0002J\u000e\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0006H\u0016J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0006H\u0016J(\u0010C\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\b2\u0006\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020\bH\u0016J8\u0010C\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020\b2\u0006\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020\bH\u0016J\u000e\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u0000J\t\u0010M\u001a\u00020\u0006H\u00c6\u0003J\t\u0010N\u001a\u00020\bH\u00c6\u0003J\t\u0010O\u001a\u00020\bH\u00c6\u0003J\t\u0010P\u001a\u00020\bH\u00c6\u0003J1\u0010Q\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010R\u001a\u00020;2\b\u0010>\u001a\u0004\u0018\u00010SH\u00d6\u0003J\t\u0010T\u001a\u00020\u000eH\u00d6\u0001J\t\u0010U\u001a\u00020VH\u00d6\u0001J%\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0001\u00a2\u0006\u0002\b^R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013R\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0012R\u0011\u0010(\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006a"}, d2={"Lorg/openrndr/shape/Box;", "Lorg/openrndr/math/LinearType;", "Lorg/openrndr/shape/Movable3D;", "Lorg/openrndr/shape/Scalable3D;", "Ljava/lang/Record;", "corner", "Lorg/openrndr/math/Vector3;", "width", "", "height", "depth", "<init>", "(Lorg/openrndr/math/Vector3;DDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector3;DDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector3;", "()D", "xRange", "Lkotlin/ranges/OpenEndRange;", "()Lkotlin/ranges/OpenEndRange;", "yRange", "zRange", "majorAxis", "Lorg/openrndr/math/Vector3$Axis;", "()Lorg/openrndr/math/Vector3$Axis;", "minorAxis", "dimensions", "ratio", "axis", "plus", "right", "minus", "times", "scale", "div", "volume", "center", "normalized", "()Lorg/openrndr/shape/Box;", "offsetSides", "offset", "offsetY", "offsetZ", "position", "u", "v", "w", "sub", "Lkotlin/ranges/ClosedFloatingPointRange;", "u0", "v0", "w0", "u1", "v1", "w1", "contains", "", "point", "intersects", "other", "toInt", "Lorg/openrndr/shape/IntBox;", "movedBy", "movedTo", "scaledBy", "uAnchor", "vAnchor", "wAnchor", "xScale", "yScale", "zScale", "mapTo", "Lorg/openrndr/math/Matrix44;", "target", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
public final class Box
extends Record
implements LinearType<Box>,
Movable3D,
Scalable3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3 corner;
    private final double width;
    private final double height;
    private final double depth;
    @NotNull
    private static final Box EMPTY = BoxKt.Box(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public Box(@NotNull Vector3 corner, double width, double height, double depth) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @NotNull
    public final Vector3 corner() {
        return this.corner;
    }

    public final double width() {
        return this.width;
    }

    public final double height() {
        return this.height;
    }

    public final double depth() {
        return this.depth;
    }

    @NotNull
    public final OpenEndRange<Double> xRange() {
        return RangesKt.rangeUntil(Math.min(this.corner.x(), this.corner.x() + this.width), Math.max(this.corner.x(), this.corner.x() + this.width));
    }

    @NotNull
    public final OpenEndRange<Double> yRange() {
        return RangesKt.rangeUntil(Math.min(this.corner.y(), this.corner.y() + this.height), Math.max(this.corner.y(), this.corner.y() + this.height));
    }

    @NotNull
    public final OpenEndRange<Double> zRange() {
        return RangesKt.rangeUntil(Math.min(this.corner.z(), this.corner.z() + this.depth), Math.max(this.corner.z(), this.corner.z() + this.depth));
    }

    @NotNull
    public final Vector3.Axis majorAxis() {
        return this.width >= this.height && this.width >= this.depth ? Vector3.Axis.X : (this.height >= this.width && this.height >= this.depth ? Vector3.Axis.Y : Vector3.Axis.Z);
    }

    @NotNull
    public final Vector3.Axis minorAxis() {
        return this.width <= this.height && this.width <= this.depth ? Vector3.Axis.X : (this.height <= this.width && this.height <= this.depth ? Vector3.Axis.Y : Vector3.Axis.Z);
    }

    @NotNull
    public final Vector3 dimensions() {
        return new Vector3(this.width, this.height, this.depth);
    }

    @NotNull
    public final Box ratio(@NotNull Vector3.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)axis, "axis");
        double scale = 1.0 / this.dimensions().dot(axis.getDirection());
        return Companion.fromCenter(Vector3.Companion.getZERO(), this.width * scale, this.height * scale, this.depth * scale);
    }

    public static /* synthetic */ Box ratio$default(Box box, Vector3.Axis axis, int n, Object object) {
        if ((n & 1) != 0) {
            axis = box.majorAxis();
        }
        return box.ratio(axis);
    }

    @Override
    @NotNull
    public Box plus(@NotNull Box right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Box(this.corner.plus(right.corner), this.width + right.width, this.height + right.height, this.depth + right.depth);
    }

    @Override
    @NotNull
    public Box minus(@NotNull Box right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Box(this.corner.minus(right.corner), this.width - right.width, this.height - right.height, this.depth - right.depth);
    }

    @Override
    @NotNull
    public Box times(double scale) {
        return new Box(this.corner.times(scale), this.width * scale, this.height * scale, this.depth * scale);
    }

    @Override
    @NotNull
    public Box div(double scale) {
        return new Box(this.corner.div(scale), this.width / scale, this.height / scale, this.depth / scale);
    }

    public final double volume() {
        return this.width * this.height * this.depth;
    }

    @NotNull
    public final Vector3 center() {
        return this.corner.plus(new Vector3(this.width / 2.0, this.height / 2.0, this.depth / 2.0));
    }

    @NotNull
    public final Box normalized() {
        double nx = this.corner.x();
        double ny = this.corner.y();
        double nz = this.corner.z();
        if (this.width < 0.0) {
            nx += this.width;
        }
        if (this.height < 0.0) {
            ny += this.height;
        }
        if (this.depth < 0.0) {
            nz += this.depth;
        }
        return BoxKt.Box(nx, ny, nz, Math.abs(this.width), Math.abs(this.height), Math.abs(this.depth));
    }

    @NotNull
    public final Box offsetSides(double offset, double offsetY, double offsetZ) {
        return new Box(new Vector3(this.corner.x() - offset, this.corner.y() - offsetY, this.corner.z() - offsetZ), this.width + (double)2 * offset, this.height + (double)2 * offsetY, this.depth + (double)2 * offsetZ);
    }

    public static /* synthetic */ Box offsetSides$default(Box box, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        if ((n & 4) != 0) {
            d3 = d;
        }
        return box.offsetSides(d, d2, d3);
    }

    @NotNull
    public final Vector3 position(double u, double v, double w) {
        return this.corner.plus(new Vector3(u * this.width, v * this.height, w * this.depth));
    }

    @NotNull
    public final Box sub(@NotNull ClosedFloatingPointRange<Double> u, @NotNull ClosedFloatingPointRange<Double> v, @NotNull ClosedFloatingPointRange<Double> w) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        return this.sub(((Number)u.getStart()).doubleValue(), ((Number)v.getStart()).doubleValue(), ((Number)w.getStart()).doubleValue(), ((Number)u.getEndInclusive()).doubleValue(), ((Number)v.getEndInclusive()).doubleValue(), ((Number)w.getEndInclusive()).doubleValue());
    }

    @NotNull
    public final Box sub(double u0, double v0, double w0, double u1, double v1, double w1) {
        Vector3 p0 = this.position(u0, v0, w0);
        Vector3 p1 = this.position(u1, v1, w1);
        double width = p1.x() - p0.x();
        double height = p1.y() - p0.y();
        double depth = p1.z() - p0.z();
        return new Box(p0, width, height, depth);
    }

    public final boolean contains(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return point.x() >= this.corner.x() && point.x() < this.corner.x() + this.width && point.y() >= this.corner.y() && point.y() < this.corner.y() + this.height && point.z() >= this.corner.z() && point.z() < this.corner.z() + this.depth;
    }

    public final boolean intersects(@NotNull Box other) {
        Intrinsics.checkNotNullParameter(other, "other");
        boolean above = this.corner.y() + this.height < other.corner.y();
        boolean below = this.corner.y() > other.corner.y() + other.height;
        boolean rightOf = this.corner.x() > other.corner.x() + other.width;
        boolean leftOf = this.corner.x() + this.width < other.corner.x();
        boolean inFrontOf = this.corner.z() + this.depth < other.corner.z();
        boolean behind = this.corner.z() > other.corner.z() + other.depth;
        return !above && !below && !leftOf && !rightOf && !inFrontOf && !behind;
    }

    @NotNull
    public final IntBox toInt() {
        return new IntBox(this.corner.toInt(), (int)this.width, (int)this.height, (int)this.depth);
    }

    @Override
    @NotNull
    public Box movedBy(@NotNull Vector3 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return Box.copy$default(this, this.corner.plus(offset), 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public Box movedTo(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return Box.copy$default(this, position, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public Box scaledBy(double scale, double uAnchor, double vAnchor, double wAnchor) {
        return this.scaledBy(scale, scale, scale, uAnchor, vAnchor, wAnchor);
    }

    @Override
    @NotNull
    public Box scaledBy(double xScale, double yScale, double zScale, double uAnchor, double vAnchor, double wAnchor) {
        Vector3 anchorPosition = this.position(uAnchor, vAnchor, wAnchor);
        Vector3 d = this.corner.minus(anchorPosition);
        Vector3 nd = anchorPosition.plus(d.times(new Vector3(xScale, yScale, zScale)));
        return new Box(nd, this.width * xScale, this.height * yScale, this.depth * zScale);
    }

    @NotNull
    public final Matrix44 mapTo(@NotNull Box target2) {
        Intrinsics.checkNotNullParameter(target2, "target");
        return TransformBuilderKt.buildTransform$default(null, arg_0 -> Box.mapTo$lambda$0(target2, this, arg_0), 1, null);
    }

    @NotNull
    public final Vector3 component1() {
        return this.corner;
    }

    public final double component2() {
        return this.width;
    }

    public final double component3() {
        return this.height;
    }

    public final double component4() {
        return this.depth;
    }

    @NotNull
    public final Box copy(@NotNull Vector3 corner, double width, double height, double depth) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        return new Box(corner, width, height, depth);
    }

    public static /* synthetic */ Box copy$default(Box box, Vector3 vector3, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = box.corner;
        }
        if ((n & 2) != 0) {
            d = box.width;
        }
        if ((n & 4) != 0) {
            d2 = box.height;
        }
        if ((n & 8) != 0) {
            d3 = box.depth;
        }
        return box.copy(vector3, d, d2, d3);
    }

    @Override
    @NotNull
    public String toString() {
        return "Box(corner=" + this.corner + ", width=" + this.width + ", height=" + this.height + ", depth=" + this.depth + ")";
    }

    @Override
    public int hashCode() {
        int result = this.corner.hashCode();
        result = result * 31 + Double.hashCode(this.width);
        result = result * 31 + Double.hashCode(this.height);
        result = result * 31 + Double.hashCode(this.depth);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Box)) {
            return false;
        }
        Box box = (Box)other;
        if (!Intrinsics.areEqual(this.corner, box.corner)) {
            return false;
        }
        if (Double.compare(this.width, box.width) != 0) {
            return false;
        }
        if (Double.compare(this.height, box.height) != 0) {
            return false;
        }
        return Double.compare(this.depth, box.depth) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Box self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector3$.serializer.INSTANCE, self.corner);
        output.encodeDoubleElement(serialDesc, 1, self.width);
        output.encodeDoubleElement(serialDesc, 2, self.height);
        output.encodeDoubleElement(serialDesc, 3, self.depth);
    }

    public /* synthetic */ Box(int seen0, Vector3 corner, double width, double height, double depth, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 15, $serializer.INSTANCE.getDescriptor());
        }
        this.corner = corner;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    private static final Unit mapTo$lambda$0(Box $target, Box this$0, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($target.corner.minus(this$0.corner));
        $this$buildTransform.scale($target.dimensions().div(this$0.dimensions()));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tJ2\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/shape/Box$Companion;", "", "<init>", "()V", "fromCenter", "Lorg/openrndr/shape/Box;", "center", "Lorg/openrndr/math/Vector3;", "width", "", "height", "depth", "fromAnchor", "anchorUVW", "anchor", "EMPTY", "getEMPTY", "()Lorg/openrndr/shape/Box;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Box fromCenter(@NotNull Vector3 center, double width, double height, double depth) {
            Intrinsics.checkNotNullParameter(center, "center");
            return org.openrndr.shape.Box$Companion.fromAnchor$default(Companion, new Vector3(0.5, 0.5, 0.5), center, width, height, 0.0, 16, null);
        }

        public static /* synthetic */ Box fromCenter$default(Companion companion, Vector3 vector3, double d, double d2, double d3, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = d;
            }
            if ((n & 8) != 0) {
                d3 = d;
            }
            return companion.fromCenter(vector3, d, d2, d3);
        }

        @NotNull
        public final Box fromAnchor(@NotNull Vector3 anchorUVW, @NotNull Vector3 anchor, double width, double height, double depth) {
            Intrinsics.checkNotNullParameter(anchorUVW, "anchorUVW");
            Intrinsics.checkNotNullParameter(anchor, "anchor");
            return BoxKt.Box(anchor.x() - width * anchorUVW.x(), anchor.y() - height * anchorUVW.y(), anchor.z() - depth * anchorUVW.z(), width, height, depth);
        }

        public static /* synthetic */ Box fromAnchor$default(Companion companion, Vector3 vector3, Vector3 vector32, double d, double d2, double d3, int n, Object object) {
            if ((n & 8) != 0) {
                d2 = d;
            }
            if ((n & 0x10) != 0) {
                d3 = d;
            }
            return companion.fromAnchor(vector3, vector32, d, d2, d3);
        }

        @NotNull
        public final Box getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final KSerializer<Box> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

