/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.Program;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LoadFontKt;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/panel/FontManager;", "", "<init>", "()V", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "setProgram", "(Lorg/openrndr/Program;)V", "registry", "", "", "getRegistry", "()Ljava/util/Map;", "contentScale", "", "getContentScale", "()D", "setContentScale", "(D)V", "resolve", "name", "font", "Lorg/openrndr/draw/FontImageMap;", "cs", "Lorg/openrndr/panel/style/StyleSheet;", "register", "", "url", "orx-panel"})
public final class FontManager {
    @Nullable
    private Program program;
    @NotNull
    private final Map<String, String> registry = new LinkedHashMap();
    private double contentScale = 1.0;

    @Nullable
    public final Program getProgram() {
        return this.program;
    }

    public final void setProgram(@Nullable Program program2) {
        this.program = program2;
    }

    @NotNull
    public final Map<String, String> getRegistry() {
        return this.registry;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(double d) {
        this.contentScale = d;
    }

    @Nullable
    public final String resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.registry.get(name);
    }

    @NotNull
    public final FontImageMap font(@NotNull StyleSheet cs) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        String string = this.resolve(StyleSheetKt.getFontFamily(cs));
        if (string == null) {
            string = "cp:fonts/Roboto-Medium.ttf";
        }
        String fontUrl = string;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(cs);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 16.0;
        Object object = this.program;
        if (object == null || (object = LoadFontKt.loadFont$default((Program)object, fontUrl, fontSize, null, 0.0, null, 28, null)) == null) {
            throw new IllegalStateException("no program".toString());
        }
        return object;
    }

    public final void register(@NotNull String name, @NotNull String url) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(url, "url");
        this.registry.put(name, url);
    }
}

