/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils;

import kotlin.Metadata;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0011\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t\u001a\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t\u001a\u001e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t\u001a\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t\u001a\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t\u001a\u001e\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t\u001a&\u0010!\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010!\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t\u001a\u0016\u0010!\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0016\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t\u001a\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t\u001a\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t\u001a\u001e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"SIGNIFICAND_WIDTH", "", "MIN_EXPONENT", "MAX_EXPONENT", "EXP_BIT_MASK", "", "EXP_BIAS", "getExponent", "d", "", "powerOfTwoD", "exp", "ulp", "MACHINE_EPSILON", "getMACHINE_EPSILON", "()D", "SCALAR_EPSILON", "equals", "", "a", "b", "epsilon", "angleEquals", "t0", "t1", "normalize", "n", "lerp", "t", "inside", "min", "max", "clamp", "normalizationFactor", "c", "openrndr-kartifex"})
public final class ScalarsKt {
    public static final int SIGNIFICAND_WIDTH = 53;
    public static final int MIN_EXPONENT = -1022;
    public static final int MAX_EXPONENT = 1023;
    public static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    public static final int EXP_BIAS = 1023;
    private static final double MACHINE_EPSILON = ScalarsKt.ulp(1.0);
    public static final double SCALAR_EPSILON = 1.0E-14;

    public static final int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - (long)1023);
    }

    public static final double powerOfTwoD(double exp) {
        return Math.pow(2.0, exp);
    }

    public static final double ulp(double d) {
        int exp = ScalarsKt.getExponent(d);
        return switch (exp) {
            case 1024 -> Math.abs(d);
            case -1023 -> Double.MIN_VALUE;
            default -> {
                if ((exp -= 52) >= -1022) {
                    yield ScalarsKt.powerOfTwoD(exp);
                }
                yield Double.longBitsToDouble(1L << exp - -1074);
            }
        };
    }

    public static final double getMACHINE_EPSILON() {
        return MACHINE_EPSILON;
    }

    public static final boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static final boolean angleEquals(double t0, double t1, double epsilon) {
        boolean result;
        double t12 = t1;
        double t02 = t0;
        if (t12 < t02) {
            double tmp = t12;
            t12 = t02;
            t02 = tmp;
        }
        boolean bl = result = t12 - t02 < epsilon;
        if (!result) {
            result = t02 - (t12 -= Math.PI * 2) < epsilon;
        }
        return result;
    }

    public static final double normalize(double a, double b, double n) {
        return (n - a) / (b - a);
    }

    public static final double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static final boolean inside(double min, double n, double max) {
        return min < n && n < max;
    }

    public static final double clamp(double min, double n, double max) {
        return n <= min ? min : (n >= max ? max : n);
    }

    public static final double normalizationFactor(double a, double b, double c2, double d) {
        double exponent;
        double maxValue = ScalarsKt.max(ScalarsKt.max(a, b), ScalarsKt.max(c2, d));
        return maxValue == 0.0 ? 1.0 : ((exponent = (double)ScalarsKt.getExponent(maxValue)) < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0);
    }

    public static final double normalizationFactor(double a, double b, double c2) {
        double exponent;
        double maxValue = ScalarsKt.max(a, b, c2);
        return maxValue == 0.0 ? 1.0 : ((exponent = (double)ScalarsKt.getExponent(maxValue)) < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0);
    }

    public static final double normalizationFactor(double a, double b) {
        double exponent;
        double maxValue = ScalarsKt.max(a, b);
        return maxValue == 0.0 ? 1.0 : ((exponent = (double)ScalarsKt.getExponent(maxValue)) < -8.0 || exponent > 8.0 ? Math.pow(2.0, -exponent) : 1.0);
    }

    public static final double max(double a, double b) {
        return a < b ? b : a;
    }

    public static final double max(double a, double b, double c2) {
        return ScalarsKt.max(a, ScalarsKt.max(b, c2));
    }

    public static final double min(double a, double b) {
        return a > b ? b : a;
    }

    public static final double min(double a, double b, double c2) {
        return ScalarsKt.min(a, ScalarsKt.min(b, c2));
    }
}

