/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.utils.ScalarsKt;
import org.openrndr.utils.HashesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0011\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u001e\u0010\u0017\u001a\u00020\u00002\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019j\u0002`\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010$\u001a\u00020\u0003J\b\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/openrndr/kartifex/Interval;", "", "a", "", "b", "<init>", "(DD)V", "lo", "getLo", "()D", "setLo", "(D)V", "hi", "getHi", "setHi", "intersects", "", "i", "contains", "n", "isEmpty", "()Z", "expand", "map", "f", "Lkotlin/Function1;", "Lorg/openrndr/kartifex/DoubleUnaryOperator;", "add", "sub", "mul", "div", "union", "intersection", "normalize", "lerp", "t", "size", "hashCode", "", "equals", "other", "toString", "", "Companion", "openrndr-kartifex"})
public final class Interval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double lo;
    private double hi;
    @NotNull
    private static final Interval EMPTY = new Interval(Double.NaN, Double.NaN);

    public Interval(double a, double b) {
        if (a < b) {
            this.lo = a;
            this.hi = b;
        } else {
            this.lo = b;
            this.hi = a;
        }
    }

    public final double getLo() {
        return this.lo;
    }

    public final void setLo(double d) {
        this.lo = d;
    }

    public final double getHi() {
        return this.hi;
    }

    public final void setHi(double d) {
        this.hi = d;
    }

    public final boolean intersects(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.hi > i.lo && i.hi > this.lo;
    }

    public final boolean contains(double n) {
        return !this.isEmpty() && this.lo <= n && n <= this.hi;
    }

    public final boolean contains(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return !this.isEmpty() && this.contains(i.lo) && this.contains(i.hi);
    }

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    @NotNull
    public final Interval expand(double n) {
        return this.size() + n * (double)2 < 0.0 ? EMPTY : new Interval(this.lo - n, this.hi + n);
    }

    @NotNull
    public final Interval map(@NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return new Interval(((Number)f.invoke((Double)this.lo)).doubleValue(), ((Number)f.invoke((Double)this.hi)).doubleValue());
    }

    @NotNull
    public final Interval add(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo + i.lo, this.hi + i.hi);
    }

    @NotNull
    public final Interval sub(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo - i.lo, this.hi - i.hi);
    }

    @NotNull
    public final Interval mul(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo * this.hi, i.lo * i.hi).union(new Interval(this.lo * i.hi, i.lo * this.hi));
    }

    @NotNull
    public final Interval div(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return i.lo == 0.0 && i.hi == 0.0 ? new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) : (i.lo == 0.0 ? this.mul(new Interval(1.0 / i.hi, Double.POSITIVE_INFINITY)) : (i.hi == 0.0 ? this.mul(new Interval(Double.NEGATIVE_INFINITY, 1.0 / i.lo)) : this.mul(new Interval(1.0 / i.hi, 1.0 / i.lo))));
    }

    @NotNull
    public final Interval union(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.isEmpty() ? i : new Interval(Math.min(this.lo, i.lo), Math.max(this.hi, i.hi));
    }

    @NotNull
    public final Interval union(double n) {
        return this.isEmpty() ? new Interval(n, n) : new Interval(Math.min(this.lo, n), Math.max(this.hi, n));
    }

    @NotNull
    public final Interval intersection(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return this.isEmpty() || i.isEmpty() || !this.intersects(i) ? EMPTY : new Interval(Math.max(this.lo, i.lo), Math.min(this.hi, i.hi));
    }

    public final double normalize(double n) {
        return n == this.hi ? 1.0 : (n - this.lo) / this.size();
    }

    public final double lerp(double t) {
        return t == 1.0 ? this.hi : ScalarsKt.lerp(this.lo, this.hi, t);
    }

    @NotNull
    public final Interval lerp(@NotNull Interval i) {
        Intrinsics.checkNotNullParameter(i, "i");
        return new Interval(this.lerp(i.lo), this.lerp(i.hi));
    }

    public final double size() {
        return this.hi - this.lo;
    }

    public int hashCode() {
        return HashesKt.hash(this.lo, this.hi);
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (other == this) {
            bl = true;
        } else if (other instanceof Interval) {
            Object o = other;
            bl = this.lo == ((Interval)o).lo && this.hi == ((Interval)o).hi;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "Interval(lo=" + this.lo + ", hi=" + this.hi + ")";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/openrndr/kartifex/Interval$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/openrndr/kartifex/Interval;", "getEMPTY", "()Lorg/openrndr/kartifex/Interval;", "interval", "a", "", "b", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Interval getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Interval interval(double a, double b) {
            return new Interval(a, b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

