/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.glcommon;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001d\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/internal/glcommon/LRUCache;", "K", "V", "", "capacity", "", "<init>", "(I)V", "getCapacity", "()I", "map", "", "getMap", "()Ljava/util/Map;", "order", "Lkotlin/collections/ArrayDeque;", "getOrder", "()Lkotlin/collections/ArrayDeque;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getOrSet", "forceSet", "", "valueFunction", "Lkotlin/Function0;", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "openrndr-gl-common"})
public final class LRUCache<K, V> {
    private final int capacity;
    @NotNull
    private final Map<K, V> map;
    @NotNull
    private final ArrayDeque<K> order;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.map = new LinkedHashMap();
        this.order = new ArrayDeque();
    }

    public /* synthetic */ LRUCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        this(n);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public final Map<K, V> getMap() {
        return this.map;
    }

    @NotNull
    public final ArrayDeque<K> getOrder() {
        return this.order;
    }

    @Nullable
    public final V get(K key) {
        return this.map.get(key);
    }

    public final void set(K key, V value) {
        if (this.map.size() >= this.capacity) {
            this.map.remove(this.order.removeFirst());
        }
        this.map.put(key, value);
        this.order.addLast(key);
    }

    public final V getOrSet(K key, boolean forceSet, @NotNull Function0<? extends V> valueFunction) {
        V v;
        Intrinsics.checkNotNullParameter(valueFunction, "valueFunction");
        V v2 = this.get(key);
        if (forceSet || v2 == null) {
            V n = valueFunction.invoke();
            this.set(key, n);
            v = n;
        } else {
            v = v2;
        }
        return v;
    }

    public LRUCache() {
        this(0, 1, null);
    }
}

