/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES30;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderStorageBufferShadow;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.ShaderStorageBufferShadowGL3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ?2\u00020\u0001:\u0001?B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J)\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00160#\u00a2\u0006\u0002\b%H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0016H\u0016J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0007H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010:\u001a\u00020\u00052\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020\u0003H\u00d6\u0001J\t\u0010>\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006@"}, d2={"Lorg/openrndr/internal/gl3/ShaderStorageBufferGL43;", "Lorg/openrndr/draw/ShaderStorageBuffer;", "buffer", "", "ownsBuffer", "", "format", "Lorg/openrndr/draw/ShaderStorageFormat;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IZLorg/openrndr/draw/ShaderStorageFormat;Lorg/openrndr/draw/Session;)V", "getBuffer", "()I", "getOwnsBuffer", "()Z", "getFormat", "()Lorg/openrndr/draw/ShaderStorageFormat;", "getSession", "()Lorg/openrndr/draw/Session;", "destroyed", "clear", "", "write", "source", "Ljava/nio/ByteBuffer;", "writeOffset", "read", "target", "readOffset", "createByteBuffer", "destroy", "put", "elementOffset", "putter", "Lkotlin/Function1;", "Lorg/openrndr/draw/BufferWriter;", "Lkotlin/ExtensionFunctionType;", "realShadow", "Lorg/openrndr/internal/gl3/ShaderStorageBufferShadowGL3;", "getRealShadow$openrndr_gl3", "()Lorg/openrndr/internal/gl3/ShaderStorageBufferShadowGL3;", "setRealShadow$openrndr_gl3", "(Lorg/openrndr/internal/gl3/ShaderStorageBufferShadowGL3;)V", "shadow", "Lorg/openrndr/draw/ShaderStorageBufferShadow;", "getShadow", "()Lorg/openrndr/draw/ShaderStorageBufferShadow;", "elementPosition", "", "elementName", "", "close", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nShaderStorageBufferGL43.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderStorageBufferGL43.kt\norg/openrndr/internal/gl3/ShaderStorageBufferGL43\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 5 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,216:1\n48#2,3:217\n83#2,3:244\n48#2,3:271\n48#2,3:298\n48#2,3:349\n48#2,3:376\n48#2,3:419\n67#3,3:220\n51#3,13:223\n65#3,7:237\n67#3,3:247\n51#3,13:250\n65#3,7:264\n67#3,3:274\n51#3,13:277\n65#3,7:291\n67#3,3:301\n51#3,13:304\n65#3,7:318\n67#3,3:325\n51#3,13:328\n65#3,7:342\n67#3,3:352\n51#3,13:355\n65#3,7:369\n67#3,3:379\n51#3,13:382\n65#3,7:396\n50#3,14:403\n65#3:418\n67#3,3:422\n51#3,13:425\n65#3,7:439\n67#4:236\n67#4:263\n67#4:290\n67#4:317\n67#4:341\n67#4:368\n67#4:395\n67#4:438\n50#5:417\n*S KotlinDebug\n*F\n+ 1 ShaderStorageBufferGL43.kt\norg/openrndr/internal/gl3/ShaderStorageBufferGL43\n*L\n69#1:217,3\n71#1:244,3\n73#1:271,3\n88#1:298,3\n92#1:349,3\n97#1:376,3\n109#1:419,3\n70#1:220,3\n70#1:223,13\n70#1:237,7\n72#1:247,3\n72#1:250,13\n72#1:264,7\n76#1:274,3\n76#1:277,13\n76#1:291,7\n89#1:301,3\n89#1:304,13\n89#1:318,7\n91#1:325,3\n91#1:328,13\n91#1:342,7\n93#1:352,3\n93#1:355,13\n93#1:369,7\n98#1:379,3\n98#1:382,13\n98#1:396,7\n105#1:403,14\n105#1:418\n110#1:422,3\n110#1:425,13\n110#1:439,7\n70#1:236\n72#1:263\n76#1:290\n89#1:317\n91#1:341\n93#1:368\n98#1:395\n110#1:438\n105#1:417\n*E\n"})
public final class ShaderStorageBufferGL43
implements ShaderStorageBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int buffer;
    private final boolean ownsBuffer;
    @NotNull
    private final ShaderStorageFormat format;
    @Nullable
    private final Session session;
    private boolean destroyed;
    @Nullable
    private ShaderStorageBufferShadowGL3 realShadow;

    public ShaderStorageBufferGL43(int buffer, boolean ownsBuffer, @NotNull ShaderStorageFormat format, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(format, "format");
        this.buffer = buffer;
        this.ownsBuffer = ownsBuffer;
        this.format = format;
        this.session = session;
    }

    public /* synthetic */ ShaderStorageBufferGL43(int n, boolean bl, ShaderStorageFormat shaderStorageFormat, Session session, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            session = Session.Companion.getActive();
        }
        this(n, bl, shaderStorageFormat, session);
    }

    public final int getBuffer() {
        return this.buffer;
    }

    public final boolean getOwnsBuffer() {
        return this.ownsBuffer;
    }

    @Override
    @NotNull
    public ShaderStorageFormat getFormat() {
        return this.format;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    @Override
    public void clear() {
        switch (WhenMappings.$EnumSwitchMapping$0[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                Driver driver = Driver.Companion.getInstance();
                Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
                if (((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_5) >= 0) {
                    int[] nArray = new int[]{0};
                    GL45C.glClearNamedBufferData(this.buffer, 33330, 36244, 5121, nArray);
                    break;
                }
                GL33C.glBindBuffer(37074, this.buffer);
                int[] nArray = new int[]{0};
                GL45C.glClearBufferData(37074, 33330, 36244, 5121, nArray);
                break;
            }
            case 2: {
                throw new IllegalStateException("not supported".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void write(@NotNull ByteBuffer source, int writeOffset) {
        block47: {
            block46: {
                int error$iv$iv;
                boolean $i$f$checkGLErrors;
                int target$iv;
                Intrinsics.checkNotNullParameter(source, "source");
                int allowed = this.getFormat().getSize() - writeOffset;
                if (!(source.remaining() <= allowed)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if ((DriverGL3Kt.getGlType(Driver.Companion) != DriverTypeGL.GL || DriverGL3Kt.getGlVersion(Driver.Companion).compareTo((Enum)DriverVersionGL.GL_VERSION_4_5) > 0) && DriverGL3Kt.getGlType(Driver.Companion) != DriverTypeGL.GLES) break block46;
                int n = 37074;
                int buffer$iv = this.buffer;
                boolean $i$f$glBindBuffer = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    case 2: {
                        GLES32.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors = false;
                    error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int n2 = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        int it = n2;
                        Object var14_29 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_29;
                        throw new GL3Exception(string);
                    }
                }
                target$iv = 37074;
                long offset$iv = writeOffset;
                boolean $i$f$glBufferSubData = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBufferSubData(target$iv, offset$iv, source);
                        break;
                    }
                    case 2: {
                        GLES32.glBufferSubData(target$iv, offset$iv, source);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors = false;
                    error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int it = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        Object var14_30 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_30;
                        throw new GL3Exception(string);
                    }
                }
                target$iv = 37074;
                buffer$iv = 0;
                $i$f$glBindBuffer = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBindBuffer(target$iv, buffer$iv);
                        break block47;
                    }
                    case 2: {
                        GLES32.glBindBuffer(target$iv, buffer$iv);
                        break block47;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            GL45C.glNamedBufferSubData(this.buffer, (long)writeOffset, source);
            boolean $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                boolean $i$f$checkGLErrors = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int it = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    Object var14_31 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_31;
                    throw new GL3Exception(string);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull ByteBuffer target2, int readOffset) {
        Intrinsics.checkNotNullParameter(target2, "target");
        int needed = this.getFormat().getSize() - readOffset;
        if (!(target2.remaining() >= needed)) {
            boolean bl = false;
            String string = "target buffer remaining bytes: " + target2.remaining() + ", need " + needed + " bytes";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                int error$iv$iv;
                boolean $i$f$checkGLErrors;
                int target$iv;
                int n = 37074;
                int buffer$iv = this.buffer;
                boolean $i$f$glBindBuffer = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    case 2: {
                        GLES32.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors = false;
                    error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int n2 = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        int it = n2;
                        Object var16_46 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_46;
                        throw new GL3Exception(string);
                    }
                }
                GL45C.glGetBufferSubData(37074, (long)readOffset, target2);
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors = false;
                    error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int it = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        Object var16_47 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_47;
                        throw new GL3Exception(string);
                    }
                }
                target$iv = 37074;
                buffer$iv = 0;
                $i$f$glBindBuffer = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    case 2: {
                        GLES32.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $i$f$debugGLErrors = false;
                if (!DriverGL3Configuration.INSTANCE.getUseDebugContext()) break;
                $i$f$checkGLErrors = false;
                error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv == 0) break;
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int it = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                Object var16_48 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_48;
                throw new GL3Exception(string);
            }
            case 2: {
                boolean $i$f$checkGLErrors;
                int target$iv = 37074;
                int buffer$iv = this.buffer;
                boolean $i$f$glBindBuffer = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    case 2: {
                        GLES32.glBindBuffer(target$iv, buffer$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                int $i$f$debugGLErrors = 0;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors = false;
                    int error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int it = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        Object var16_49 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_49;
                        throw new GL3Exception(string);
                    }
                }
                ByteBuffer mappedBuffer = GLES30.glMapBufferRange(37074, readOffset, target2.remaining(), 1);
                $i$f$checkGLErrors = false;
                int error$iv = GLGLESKt.glGetError();
                if (error$iv != 0) {
                    Object message$iv = switch (error$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv + ">";
                    };
                    int it = error$iv;
                    Object object = message$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    Object var16_50 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_50;
                    throw new GL3Exception(string);
                }
                if (!(mappedBuffer != null)) {
                    String $i$f$checkGLErrors2 = "Failed requirement.";
                    throw new IllegalArgumentException($i$f$checkGLErrors2.toString());
                }
                target2.put(mappedBuffer);
                GLES30.glUnmapBuffer(37074);
                $i$f$debugGLErrors = 36662;
                int buffer$iv2 = 0;
                boolean $i$f$glBindBuffer2 = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void target$iv2;
                        GL45C.glBindBuffer((int)target$iv2, buffer$iv2);
                        break;
                    }
                    case 2: {
                        void target$iv2;
                        GLES32.glBindBuffer((int)target$iv2, buffer$iv2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean $i$f$debugGLErrors2 = false;
                if (!DriverGL3Configuration.INSTANCE.getUseDebugContext()) break;
                boolean $i$f$checkGLErrors3 = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv == 0) break;
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int bl = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl2 = false;
                int it = bl;
                Object var16_51 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_51;
                throw new GL3Exception(string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @NotNull
    public ByteBuffer createByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.getFormat().getSize()).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "order(...)");
        return byteBuffer;
    }

    @Override
    public void destroy() {
        block2: {
            if (this.destroyed) break block2;
            if (this.ownsBuffer) {
                GLGLESKt.glDeleteBuffers(this.buffer);
            }
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
        }
    }

    @Override
    public int put(int elementOffset, @NotNull Function1<? super BufferWriter, Unit> putter) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(putter, "putter");
        BufferWriter w = this.getShadow().writer();
        w.rewind();
        w.setPositionElements(elementOffset);
        putter.invoke(w);
        int position = w.getPosition();
        int alignment = ShaderStorageFormat.lastAlignmentInBytes$default(this.getFormat(), null, 1, null);
        int n3 = position % alignment;
        if (n3 + (alignment & ((n3 ^ alignment) & (n3 | -n3)) >> 31) != 0) {
            n3 = position % alignment;
            position += alignment - (n3 + (alignment & ((n3 ^ alignment) & (n3 | -n3)) >> 31));
        }
        if ((n2 = (n = position) % (n3 = this.getFormat().getSize())) + (n3 & ((n2 ^ n3) & (n2 | -n2)) >> 31) != 0) {
            throw new RuntimeException("incomplete members written (position: " + w.getPosition() + ", size: " + this.getFormat().getSize() + "). likely violating the specified shaders storage format " + this.getFormat());
        }
        int count2 = position / this.getFormat().getSize();
        this.getShadow().uploadElements(elementOffset, count2);
        return count2;
    }

    @Nullable
    public final ShaderStorageBufferShadowGL3 getRealShadow$openrndr_gl3() {
        return this.realShadow;
    }

    public final void setRealShadow$openrndr_gl3(@Nullable ShaderStorageBufferShadowGL3 shaderStorageBufferShadowGL3) {
        this.realShadow = shaderStorageBufferShadowGL3;
    }

    @Override
    @NotNull
    public ShaderStorageBufferShadow getShadow() {
        if (this.destroyed) {
            throw new IllegalStateException("buffer is destroyed");
        }
        if (this.realShadow == null) {
            this.realShadow = new ShaderStorageBufferShadowGL3(this);
        }
        ShaderStorageBufferShadowGL3 shaderStorageBufferShadowGL3 = this.realShadow;
        Intrinsics.checkNotNull(shaderStorageBufferShadowGL3);
        return shaderStorageBufferShadowGL3;
    }

    private final long elementPosition(String elementName) {
        long position = 0L;
        for (ShaderStorageElement element : this.getFormat().getElements()) {
            if (Intrinsics.areEqual(element.getName(), elementName)) break;
            if (element instanceof ShaderStorageStruct) {
                String string = "struct sizes not implemented yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.draw.ShaderStoragePrimitive");
            BufferPrimitiveType t = ((ShaderStoragePrimitive)element).getType();
            int s = switch (WhenMappings.$EnumSwitchMapping$1[t.ordinal()]) {
                case 1, 2, 3, 4 -> 16;
                case 5, 6 -> 8;
                case 7, 8 -> 4;
                default -> {
                    String var8_8 = "size not implemented for " + t;
                    throw new NotImplementedError("An operation is not implemented: " + var8_8);
                }
            };
            position += (long)(s * RangesKt.coerceAtLeast(((ShaderStoragePrimitive)element).getArraySize(), 1));
        }
        return position;
    }

    @Override
    public void close() {
        this.destroy();
    }

    public final int component1() {
        return this.buffer;
    }

    public final boolean component2() {
        return this.ownsBuffer;
    }

    @NotNull
    public final ShaderStorageFormat component3() {
        return this.format;
    }

    @Nullable
    public final Session component4() {
        return this.session;
    }

    @NotNull
    public final ShaderStorageBufferGL43 copy(int buffer, boolean ownsBuffer, @NotNull ShaderStorageFormat format, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(format, "format");
        return new ShaderStorageBufferGL43(buffer, ownsBuffer, format, session);
    }

    public static /* synthetic */ ShaderStorageBufferGL43 copy$default(ShaderStorageBufferGL43 shaderStorageBufferGL43, int n, boolean bl, ShaderStorageFormat shaderStorageFormat, Session session, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = shaderStorageBufferGL43.buffer;
        }
        if ((n2 & 2) != 0) {
            bl = shaderStorageBufferGL43.ownsBuffer;
        }
        if ((n2 & 4) != 0) {
            shaderStorageFormat = shaderStorageBufferGL43.format;
        }
        if ((n2 & 8) != 0) {
            session = shaderStorageBufferGL43.session;
        }
        return shaderStorageBufferGL43.copy(n, bl, shaderStorageFormat, session);
    }

    @NotNull
    public String toString() {
        return "ShaderStorageBufferGL43(buffer=" + this.buffer + ", ownsBuffer=" + this.ownsBuffer + ", format=" + this.format + ", session=" + this.session + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.buffer);
        result = result * 31 + Boolean.hashCode(this.ownsBuffer);
        result = result * 31 + this.format.hashCode();
        result = result * 31 + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShaderStorageBufferGL43)) {
            return false;
        }
        ShaderStorageBufferGL43 shaderStorageBufferGL43 = (ShaderStorageBufferGL43)other;
        if (this.buffer != shaderStorageBufferGL43.buffer) {
            return false;
        }
        if (this.ownsBuffer != shaderStorageBufferGL43.ownsBuffer) {
            return false;
        }
        if (!Intrinsics.areEqual(this.format, shaderStorageBufferGL43.format)) {
            return false;
        }
        return Intrinsics.areEqual(this.session, shaderStorageBufferGL43.session);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/internal/gl3/ShaderStorageBufferGL43$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/ShaderStorageBufferGL43;", "format", "Lorg/openrndr/draw/ShaderStorageFormat;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nShaderStorageBufferGL43.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderStorageBufferGL43.kt\norg/openrndr/internal/gl3/ShaderStorageBufferGL43$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,216:1\n41#2,3:217\n48#2,3:220\n55#2,3:239\n50#3,14:223\n65#3:238\n50#3,14:242\n65#3:257\n50#4:237\n50#4:256\n*S KotlinDebug\n*F\n+ 1 ShaderStorageBufferGL43.kt\norg/openrndr/internal/gl3/ShaderStorageBufferGL43$Companion\n*L\n199#1:217,3\n200#1:220,3\n209#1:239,3\n201#1:223,14\n201#1:238\n211#1:242,14\n211#1:257\n201#1:237\n211#1:256\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShaderStorageBufferGL43 create(@NotNull ShaderStorageFormat format, @Nullable Session session) {
            int $i$f$glBufferData;
            boolean useBufferStorage;
            Intrinsics.checkNotNullParameter(format, "format");
            boolean $i$f$glGenBuffers = false;
            int ssbo = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGenBuffers();
                case 2 -> GLES32.glGenBuffers();
                default -> throw new NoWhenBranchMatchedException();
            };
            int target$iv = 37074;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv, ssbo);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv, ssbo);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int $i$f$checkGLErrors = 0;
            int error$iv2 = GLGLESKt.glGetError();
            if (error$iv2 != 0) {
                Object message$iv = switch (error$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv2 + ">";
                };
                int n = error$iv2;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var14_19 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_19;
                throw new GL3Exception(string);
            }
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            boolean bl = useBufferStorage = ((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_4) >= 0 && DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL;
            if (useBufferStorage) {
                GL45C.glBufferStorage(37074, format.getSize(), 256);
            } else {
                $i$f$checkGLErrors = 37074;
                long error$iv2 = format.getSize();
                int usage$iv = 35050;
                $i$f$glBufferData = 0;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void size$iv;
                        void target$iv2;
                        GL45C.glBufferData((int)target$iv2, (long)size$iv, usage$iv);
                        break;
                    }
                    case 2: {
                        void size$iv;
                        void target$iv2;
                        GLES32.glBufferData((int)target$iv2, (long)size$iv, usage$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean $i$f$checkGLErrors2 = false;
            int error$iv3 = GLGLESKt.glGetError();
            if (error$iv3 != 0) {
                Object message$iv = switch (error$iv3) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv3 + ">";
                };
                $i$f$glBufferData = error$iv3;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl2 = false;
                int it = $i$f$glBufferData;
                Object var14_20 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_20;
                throw new GL3Exception(string);
            }
            return new ShaderStorageBufferGL43(ssbo, true, format, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DriverTypeGL.values().length];
            try {
                nArray[DriverTypeGL.GL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DriverTypeGL.GLES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BufferPrimitiveType.values().length];
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_INT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_INT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.INT32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

