/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES30;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.IndexBuffer;
import org.openrndr.draw.IndexType;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderStorageBufferKt;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.IndexBufferGL3Kt;
import org.openrndr.internal.gl3.ShaderStorageBufferGL43;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J!\u0010\u001d\u001a\u00020\u00152\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00150\u001f\u00a2\u0006\u0002\b H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3;", "Lorg/openrndr/draw/IndexBuffer;", "buffer", "", "indexCount", "type", "Lorg/openrndr/draw/IndexType;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IILorg/openrndr/draw/IndexType;Lorg/openrndr/draw/Session;)V", "getBuffer", "()I", "getIndexCount", "getType", "()Lorg/openrndr/draw/IndexType;", "getSession", "()Lorg/openrndr/draw/Session;", "isDestroyed", "", "bind", "", "unbind", "write", "data", "Ljava/nio/ByteBuffer;", "offsetInBytes", "read", "destroy", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "shaderStorageBufferView", "Lorg/openrndr/draw/ShaderStorageBuffer;", "close", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nIndexBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,137:1\n48#2,3:138\n48#2,3:165\n83#2,3:193\n83#2,3:212\n67#3,3:141\n51#3,13:144\n65#3,7:158\n67#3,3:168\n51#3,13:171\n65#3,7:185\n50#3,14:196\n65#3:211\n67#3,3:215\n51#3,13:218\n65#3,7:232\n67#4:157\n67#4:184\n67#4:231\n1#5:192\n50#6:210\n*S KotlinDebug\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3\n*L\n59#1:138,3\n65#1:165,3\n80#1:193,3\n75#1:212,3\n60#1:141,3\n60#1:144,13\n60#1:158,7\n66#1:168,3\n66#1:171,13\n66#1:185,7\n107#1:196,14\n107#1:211\n76#1:215,3\n76#1:218,13\n76#1:232,7\n60#1:157\n66#1:184\n76#1:231\n107#1:210\n*E\n"})
public final class IndexBufferGL3
implements IndexBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int buffer;
    private final int indexCount;
    @NotNull
    private final IndexType type;
    @Nullable
    private final Session session;
    private boolean isDestroyed;

    public IndexBufferGL3(int buffer, int indexCount, @NotNull IndexType type, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.buffer = buffer;
        this.indexCount = indexCount;
        this.type = type;
        this.session = session;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getIndexCount() {
        return this.indexCount;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - void declaration
     */
    public final void bind() {
        if (this.isDestroyed) {
            throw new IllegalStateException("buffer is destroyed");
        }
        IndexBufferGL3Kt.access$getLogger$p().trace(() -> IndexBufferGL3.bind$lambda$0(this));
        int n = 34963;
        int buffer$iv = this.buffer;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unbind() {
        IndexBufferGL3Kt.access$getLogger$p().trace(IndexBufferGL3::unbind$lambda$1);
        int n = 34963;
        int buffer$iv = 0;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull ByteBuffer data, int offsetInBytes) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (!(!this.isDestroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!data.isDirect()) {
            boolean bl = false;
            String string = "data is not a direct ByteBuffer.";
            throw new IllegalArgumentException(string.toString());
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                this.bound(arg_0 -> IndexBufferGL3.write$lambda$3(offsetInBytes, data, arg_0));
                break;
            }
            case 2: {
                int n = 34963;
                long offset$iv = offsetInBytes;
                boolean $i$f$glBufferSubData = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void target$iv;
                        GL45C.glBufferSubData((int)target$iv, offset$iv, data);
                        break block0;
                    }
                    case 2: {
                        void target$iv;
                        GLES32.glBufferSubData((int)target$iv, offset$iv, data);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void read(@NotNull ByteBuffer data, int offsetInBytes) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (!(!this.isDestroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!data.isDirect()) {
            boolean $i$a$-require-IndexBufferGL3$read$22 = false;
            String $i$a$-require-IndexBufferGL3$read$22 = "data is not a direct ByteBuffer.";
            throw new IllegalArgumentException($i$a$-require-IndexBufferGL3$read$22.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
            case 1: {
                this.bound(arg_0 -> IndexBufferGL3.read$lambda$5(offsetInBytes, data, arg_0));
                break;
            }
            case 2: {
                this.bind();
                int bufferLengthInBytes = this.getType().getSizeInBytes() * this.getIndexCount() - offsetInBytes;
                ByteBuffer buffer = GLES30.glMapBufferRange(34963, offsetInBytes, bufferLengthInBytes, 1);
                data.put(buffer);
                GLES30.glUnmapBuffer(34963);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$checkGLErrors = false;
        int error$iv = GLGLESKt.glGetError();
        if (error$iv != 0) {
            Object message$iv = switch (error$iv) {
                case 1282 -> "GL_INVALID_OPERATION";
                case 1281 -> "GL_INVALID_VALUE";
                case 1280 -> "GL_INVALID_ENUM";
                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 1285 -> "GL_OUT_OF_MEMORY";
                case 1284 -> "GL_STACK_UNDERFLOW";
                case 1283 -> "GL_STACK_OVERFLOW";
                default -> "<untranslated: " + error$iv + ">";
            };
            int n = error$iv;
            Object object = message$iv;
            long l = Driver.Companion.getInstance().getContextID();
            boolean bl = false;
            int it = n;
            Object var11_13 = null;
            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_13;
            throw new GL3Exception(string);
        }
    }

    @Override
    public void destroy() {
        GLGLESKt.glDeleteBuffers(this.buffer);
        this.isDestroyed = true;
    }

    private final void bound(Function1<? super IndexBufferGL3, Unit> f) {
        this.bind();
        f.invoke(this);
        this.unbind();
    }

    @Override
    @NotNull
    public ShaderStorageBuffer shaderStorageBufferView() {
        switch (WhenMappings.$EnumSwitchMapping$1[this.getType().ordinal()]) {
            case 1: {
                throw new IllegalStateException("16 bit indices are not supported.".toString());
            }
            case 2: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ShaderStorageFormat sbf = ShaderStorageBufferKt.shaderStorageFormat(arg_0 -> IndexBufferGL3.shaderStorageBufferView$lambda$6(this, arg_0));
        return new ShaderStorageBufferGL43(this.buffer, false, sbf, this.getSession());
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static final Object bind$lambda$0(IndexBufferGL3 this$0) {
        return "binding vertex buffer " + this$0.buffer;
    }

    private static final Object unbind$lambda$1() {
        return "unbinding vertex buffer";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit write$lambda$3(int $offsetInBytes, ByteBuffer $data, IndexBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        int n = 34963;
        long offset$iv = $offsetInBytes;
        boolean $i$f$glBufferSubData = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBufferSubData((int)target$iv, offset$iv, $data);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBufferSubData((int)target$iv, offset$iv, $data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var13_13 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_13;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit read$lambda$5(int $offsetInBytes, ByteBuffer $data, IndexBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GL33C.glGetBufferSubData(34963, (long)$offsetInBytes, $data);
        return Unit.INSTANCE;
    }

    private static final Unit shaderStorageBufferView$lambda$6(IndexBufferGL3 this$0, ShaderStorageFormat $this$shaderStorageFormat) {
        Intrinsics.checkNotNullParameter($this$shaderStorageFormat, "$this$shaderStorageFormat");
        $this$shaderStorageFormat.primitive("indices", BufferPrimitiveType.INT32, this$0.getIndexCount());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/internal/gl3/IndexBufferGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/IndexBufferGL3;", "elementCount", "", "type", "Lorg/openrndr/draw/IndexType;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nIndexBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,137:1\n69#2,3:138\n41#2,3:141\n48#2,3:144\n55#2,3:163\n48#2,3:182\n50#3,14:147\n65#3:162\n50#3,14:166\n65#3:181\n50#4:161\n50#4:180\n*S KotlinDebug\n*F\n+ 1 IndexBufferGL3.kt\norg/openrndr/internal/gl3/IndexBufferGL3$Companion\n*L\n36#1:138,3\n37#1:141,3\n38#1:144,3\n46#1:163,3\n49#1:182,3\n39#1:147,14\n39#1:162\n48#1:166,14\n48#1:181\n39#1:161\n48#1:180\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IndexBufferGL3 create(int elementCount, @NotNull IndexType type, @Nullable Session session) {
            int target$iv;
            int $i$f$glBufferData;
            boolean useBufferStorage;
            Intrinsics.checkNotNullParameter((Object)type, "type");
            int pname$iv = 34965;
            boolean $i$f$glGetInteger = false;
            int cb = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetInteger(pname$iv);
                case 2 -> GLES32.glGetInteger(pname$iv);
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$glGenBuffers = false;
            int buffer = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGenBuffers();
                case 2 -> GLES32.glGenBuffers();
                default -> throw new NoWhenBranchMatchedException();
            };
            int target$iv2 = 34963;
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv2, buffer);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv2, buffer);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var17_21 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var17_21;
                throw new GL3Exception(string);
            }
            int sizeInBytes = type.getSizeInBytes() * elementCount;
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            boolean bl = useBufferStorage = ((DriverGL3)driver).getVersion().compareTo((Enum)DriverVersionGL.GL_VERSION_4_4) >= 0 && DriverGL3Kt.getGlVersion(Driver.Companion).getType() == DriverTypeGL.GL;
            if (useBufferStorage) {
                GL44C.glBufferStorage(34963, sizeInBytes, 256);
            } else {
                error$iv = 34963;
                long message$iv = sizeInBytes;
                int usage$iv = 35048;
                $i$f$glBufferData = 0;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void size$iv;
                        GL45C.glBufferData(target$iv, (long)size$iv, usage$iv);
                        break;
                    }
                    case 2: {
                        void size$iv;
                        GLES32.glBufferData(target$iv, (long)size$iv, usage$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean $i$f$checkGLErrors2 = false;
            int error$iv2 = GLGLESKt.glGetError();
            if (error$iv2 != 0) {
                Object message$iv = switch (error$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv2 + ">";
                };
                $i$f$glBufferData = error$iv2;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl2 = false;
                int it = $i$f$glBufferData;
                Object var17_22 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var17_22;
                throw new GL3Exception(string);
            }
            target$iv = 34963;
            boolean $i$f$glBindBuffer2 = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv, cb);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv, cb);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return new IndexBufferGL3(buffer, elementCount, type, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DriverTypeGL.values().length];
            try {
                nArray[DriverTypeGL.GL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DriverTypeGL.GLES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IndexType.values().length];
            try {
                nArray[IndexType.INT16.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndexType.INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

