/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002JD\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\rJZ\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\r0\r2\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/openrndr/internal/MeshLineDrawer;", "", "<init>", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "manyVertices", "Lorg/openrndr/draw/VertexBuffer;", "fewVerticesCount", "", "fewVertices", "", "counter", "vertices", "count", "drawLineSegments", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "segments", "Lorg/openrndr/math/Vector3;", "weights", "", "colors", "Lorg/openrndr/color/ColorRGBa;", "drawLineStrips", "strips", "closed", "", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nMeshLineDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshLineDrawer.kt\norg/openrndr/internal/MeshLineDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class MeshLineDrawer {
    @NotNull
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "mesh-line", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).meshLineVertexShader(p0);
        }
    }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).meshLineFragmentShader(p0);
        }
    }, 28, null);
    @NotNull
    private final VertexFormat vertexFormat = VertexFormatKt.vertexFormat$default(null, MeshLineDrawer::vertexFormat$lambda$0, 1, null);
    @NotNull
    private final VertexBuffer manyVertices = VertexBufferKt.vertexBuffer(this.vertexFormat, 0x100000, Session.Companion.getRoot());
    private final int fewVerticesCount;
    @NotNull
    private final List<VertexBuffer> fewVertices;
    private int counter;

    public MeshLineDrawer() {
        this.fewVerticesCount = 1024;
        int n = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        MeshLineDrawer meshLineDrawer = this;
        ArrayList<VertexBuffer> arrayList = new ArrayList<VertexBuffer>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<VertexBuffer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(VertexBufferKt.vertexBuffer(this.vertexFormat, this.fewVerticesCount, Session.Companion.getRoot()));
        }
        meshLineDrawer.fewVertices = arrayList;
    }

    private final VertexBuffer vertices(int count2) {
        VertexBuffer vertexBuffer;
        if (count2 < this.fewVerticesCount) {
            int n = this.counter;
            n = this.counter = n + 1;
            int n2 = this.fewVertices.size();
            int n3 = n % n2;
            vertexBuffer = this.fewVertices.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        } else {
            vertexBuffer = this.manyVertices;
        }
        return vertexBuffer;
    }

    public final void drawLineSegments(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector3> segments, @NotNull List<Double> weights, @NotNull List<ColorRGBa> colors) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter(weights, "weights");
        Intrinsics.checkNotNullParameter(colors, "colors");
        VertexBuffer vertices = this.vertices(segments.size() * 6);
        int colorCount = colors.size();
        ColorRGBa colorRGBa = CollectionsKt.lastOrNull(colors);
        if (colorRGBa == null && (colorRGBa = drawStyle.getStroke()) == null) {
            colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
        }
        ColorRGBa defaultColor = colorRGBa;
        int vertexCount = VertexBuffer.put$default(vertices, 0, arg_0 -> MeshLineDrawer.drawLineSegments$lambda$3(segments, weights, colorCount, colors, defaultColor, drawStyle, arg_0), 1, null);
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), vertices.getVertexFormat());
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.TRIANGLES, 0, vertexCount, 0);
        shader.end();
    }

    public static /* synthetic */ void drawLineSegments$default(MeshLineDrawer meshLineDrawer, DrawContext drawContext, DrawStyle drawStyle, List list, List list2, List list3, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        meshLineDrawer.drawLineSegments(drawContext, drawStyle, list, list2, list3);
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineStrips(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<? extends List<Vector3>> strips, @NotNull List<Double> weights, @NotNull List<ColorRGBa> colors, @NotNull List<Boolean> closed) {
        int n;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(strips, "strips");
        Intrinsics.checkNotNullParameter(weights, "weights");
        Intrinsics.checkNotNullParameter(colors, "colors");
        Intrinsics.checkNotNullParameter(closed, "closed");
        Iterable iterable = strips;
        MeshLineDrawer meshLineDrawer = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            n = n2;
            boolean bl = false;
            int n3 = it.size() * 4 + 4;
            n2 = n + n3;
        }
        n = n2;
        VertexBuffer vertices = meshLineDrawer.vertices(n);
        int colorCount = colors.size();
        ColorRGBa colorRGBa = CollectionsKt.lastOrNull(colors);
        if (colorRGBa == null && (colorRGBa = drawStyle.getStroke()) == null) {
            colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
        }
        ColorRGBa defaultColor = colorRGBa;
        int vertexCount = VertexBuffer.put$default(vertices, 0, arg_0 -> MeshLineDrawer.drawLineStrips$lambda$7(strips, closed, colorCount, colors, defaultColor, weights, drawStyle, arg_0), 1, null);
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), vertices.getVertexFormat());
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.TRIANGLE_STRIP, 0, vertexCount, 0);
        shader.end();
    }

    public static /* synthetic */ void drawLineStrips$default(MeshLineDrawer meshLineDrawer, DrawContext drawContext, DrawStyle drawStyle, List list, List list2, List list3, List list4, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        meshLineDrawer.drawLineStrips(drawContext, drawStyle, list, list2, list3, list4);
    }

    private static final Unit vertexFormat$lambda$0(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        VertexFormat.attribute$default($this$vertexFormat, "previous", VertexElementType.VECTOR3_FLOAT32, 0, 4, null);
        $this$vertexFormat.position(3);
        VertexFormat.attribute$default($this$vertexFormat, "next", VertexElementType.VECTOR3_FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "side", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "width", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        VertexFormat.attribute$default($this$vertexFormat, "element", VertexElementType.FLOAT32, 0, 4, null);
        $this$vertexFormat.color(4);
        return Unit.INSTANCE;
    }

    private static final Unit drawLineSegments$lambda$3(List $segments, List $weights, int $colorCount, List $colors, ColorRGBa $defaultColor, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, $segments.size()), 2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Object object;
                List list = $weights;
                boolean bl = 0 <= i ? i < list.size() : false;
                if (bl) {
                    object = list.get(i);
                } else {
                    int it = i;
                    boolean bl2 = false;
                    object = $drawStyle.getStrokeWeight();
                }
                float width = (float)((Number)object).doubleValue();
                float element = i / 2;
                ColorRGBa color = i < $colorCount ? (ColorRGBa)$colors.get(i) : $defaultColor;
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(-1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(-1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i));
                $this$put.write((Vector3)$segments.get(i + 1));
                $this$put.write(-1.0f);
                $this$put.write(width);
                $this$put.write(Vector2.Companion.getZERO());
                $this$put.write(element);
                $this$put.write(color);
                if (i == n) break;
                i += n2;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawLineStrips$lambda$7(List $strips, List $closed, int $colorCount, List $colors, ColorRGBa $defaultColor, List $weights, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        Iterator iterator2 = ((Iterable)$strips).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Object object;
            ColorRGBa color;
            List it;
            int element = n++;
            List strip = (List)iterator2.next();
            Sequence sequence2 = SequencesKt.windowed$default(CollectionsKt.asSequence(strip), 2, 1, false, 4, null);
            double d = 0.0;
            Iterator iterator3 = sequence2.iterator();
            while (iterator3.hasNext()) {
                Object t = iterator3.next();
                List list = (List)t;
                double d2 = d;
                boolean bl = false;
                double d3 = ((Vector3)it.get(0)).distanceTo((Vector3)it.get(1));
                d = d2 + d3;
            }
            double stripLength = d;
            double offset = 0.0;
            Boolean bl = (Boolean)CollectionsKt.getOrNull($closed, element);
            boolean stripClosed = bl != null ? bl : false;
            ColorRGBa colorRGBa = color = element < $colorCount ? (ColorRGBa)$colors.get(element) : $defaultColor;
            if (strip.size() < 2) continue;
            it = $weights;
            boolean bl2 = 0 <= element ? element < it.size() : false;
            if (bl2) {
                object = it.get(element);
            } else {
                int it2 = element;
                boolean bl3 = false;
                object = $drawStyle.getStrokeWeight();
            }
            float width = (float)((Number)object).doubleValue();
            float elementF = element;
            Vector3 previous = stripClosed ? (Vector3)CollectionsKt.last(strip) : (Vector3)strip.get(0);
            int edgeCount = strip.size() + (stripClosed ? 1 : 0);
            for (int i = 0; i < edgeCount; ++i) {
                int r;
                int n2;
                Vector3 vector3;
                int n3 = i;
                int n4 = strip.size();
                int n5 = n3 % n4;
                Vector3 current = (Vector3)strip.get(n5 + (n4 & ((n5 ^ n4) & (n5 | -n5)) >> 31));
                if (stripClosed) {
                    n4 = i + 1;
                    n5 = strip.size();
                    int n6 = n4 % n5;
                    vector3 = (Vector3)strip.get(n6 + (n5 & ((n6 ^ n5) & (n6 | -n6)) >> 31));
                } else {
                    vector3 = (Vector3)strip.get(RangesKt.coerceIn(i + 1, CollectionsKt.getIndices(strip)));
                }
                Vector3 next = vector3;
                double segmentLength = current.distanceTo(next);
                if (i == 0) {
                    $this$put.write(previous);
                    $this$put.write(Float.NaN);
                    $this$put.write(Float.NaN);
                    $this$put.write(Float.NaN);
                    $this$put.write(next);
                    $this$put.write(-1.0f);
                    $this$put.write(width);
                    $this$put.write(new Vector2(0.0, offset / stripLength));
                    $this$put.write(elementF);
                    $this$put.write(color);
                }
                int n7 = n2 = i == 0 ? 1 : 1;
                for (r = 0; r < n2; ++r) {
                    $this$put.write(previous);
                    $this$put.write(current);
                    $this$put.write(next);
                    $this$put.write(-1.0f);
                    $this$put.write(width);
                    $this$put.write(new Vector2(0.0, offset / stripLength));
                    $this$put.write(elementF);
                    $this$put.write(color);
                }
                int n8 = n2 = i == edgeCount - 1 ? 1 : 1;
                for (r = 0; r < n2; ++r) {
                    $this$put.write(previous);
                    $this$put.write(current);
                    $this$put.write(next);
                    $this$put.write(1.0f);
                    $this$put.write(width);
                    $this$put.write(new Vector2(1.0, offset / stripLength));
                    $this$put.write(elementF);
                    $this$put.write(color);
                    previous = current;
                }
                if (i == edgeCount - 1) {
                    $this$put.write(previous);
                    $this$put.write(Float.NaN);
                    $this$put.write(Float.NaN);
                    $this$put.write(Float.NaN);
                    $this$put.write(next);
                    $this$put.write(1.0f);
                    $this$put.write(width);
                    $this$put.write(new Vector2(1.0, offset / stripLength));
                    $this$put.write(elementF);
                    $this$put.write(color);
                    previous = current;
                }
                offset += segmentLength;
            }
        }
        return Unit.INSTANCE;
    }
}

