/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.shapes.frames;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"frames", "", "Lorg/openrndr/math/Matrix44;", "Lorg/openrndr/math/Vector3;", "up0", "positions", "directions", "orx-shapes"})
@SourceDebugExtension(value={"SMAP\nFrames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Frames.kt\norg/openrndr/extra/shapes/frames/FramesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class FramesKt {
    @NotNull
    public static final List<Matrix44> frames(@NotNull List<Vector3> $this$frames, @NotNull Vector3 up0) {
        Intrinsics.checkNotNullParameter($this$frames, "<this>");
        Intrinsics.checkNotNullParameter(up0, "up0");
        return FramesKt.frames$default($this$frames, null, up0, 2, null);
    }

    @NotNull
    public static final List<Matrix44> frames(@NotNull List<Vector3> positions, @NotNull List<Vector3> directions, @NotNull Vector3 up0) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(directions, "directions");
        Intrinsics.checkNotNullParameter(up0, "up0");
        if (!(up0.squaredLength() > 0.0)) {
            boolean $i$a$-require-FramesKt$frames$22 = false;
            String $i$a$-require-FramesKt$frames$22 = "up0 (" + up0 + ") has 0 or NaN length";
            throw new IllegalArgumentException($i$a$-require-FramesKt$frames$22.toString());
        }
        List result = new ArrayList();
        if (positions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (positions.size() == 1) {
            return CollectionsKt.listOf(Matrix44.Companion.getIDENTITY());
        }
        EuclideanVector up = null;
        up = up0.getNormalized();
        boolean bl = false;
        Vector3 current = positions.get(0);
        Vector3 next = positions.get(1);
        Vector3 vector3 = CollectionsKt.getOrNull(directions, 0);
        if (vector3 == null) {
            vector3 = next.minus(current);
        }
        Vector3 forward = (Vector3)vector3.getNormalized();
        Vector3 right = (Vector3)forward.cross((Vector3)up).getNormalized();
        up = right.cross(forward).getNormalized();
        Matrix44 frame = Matrix44.Companion.fromColumnVectors(right.xyz0(), ((Vector3)up).xyz0(), forward.xyz0().unaryMinus(), current.xyz1());
        double d = frame.determinant();
        if (!(0.99 <= d ? d <= 1.01 : false)) {
            boolean $i$a$-require-FramesKt$frames$2$22 = false;
            String $i$a$-require-FramesKt$frames$2$22 = "Initial frame determinant (" + frame.determinant() + ") != 1.0";
            throw new IllegalArgumentException($i$a$-require-FramesKt$frames$2$22.toString());
        }
        result.add(frame);
        int n = positions.size() - 1;
        for (int i = 1; i < n; ++i) {
            Vector3 forward2;
            Vector3 prev = positions.get(i - 1);
            Vector3 current2 = positions.get(i);
            Vector3 next2 = positions.get(i + 1);
            Vector3 f1 = (Vector3)next2.minus(current2).getNormalized();
            Vector3 f0 = (Vector3)current2.minus(prev).getNormalized();
            Vector3 vector32 = CollectionsKt.getOrNull(directions, i);
            if (vector32 == null) {
                vector32 = f0.plus(f1);
            }
            if (!((forward2 = (Vector3)vector32.getNormalized()).length() > 0.0)) {
                boolean $i$a$-require-FramesKt$frames$72 = false;
                String $i$a$-require-FramesKt$frames$72 = "`forward.length` is zero or NaN in .frames()";
                throw new IllegalArgumentException($i$a$-require-FramesKt$frames$72.toString());
            }
            Vector3 right2 = (Vector3)forward2.cross((Vector3)up).getNormalized();
            if (!(((Vector3)(up = right2.cross(forward2).getNormalized())).length() > 0.0)) {
                boolean $i$a$-require-FramesKt$frames$82 = false;
                String $i$a$-require-FramesKt$frames$82 = "`up.length` is zero or NaN in .frames()";
                throw new IllegalArgumentException($i$a$-require-FramesKt$frames$82.toString());
            }
            if (!(right2.length() > 0.0)) {
                boolean $i$a$-require-FramesKt$frames$92 = false;
                String $i$a$-require-FramesKt$frames$92 = "`right.length` is zero or NaN in .frames()";
                throw new IllegalArgumentException($i$a$-require-FramesKt$frames$92.toString());
            }
            Matrix44 orientation = Matrix44.Companion.fromColumnVectors(right2.xyz0(), ((Vector3)up).xyz0(), forward2.xyz0().unaryMinus(), Vector4.Companion.getUNIT_W());
            double $i$a$-require-FramesKt$frames$92 = orientation.determinant();
            if (!(0.99 <= $i$a$-require-FramesKt$frames$92 ? $i$a$-require-FramesKt$frames$92 <= 1.01 : false)) {
                boolean bl2 = false;
                String string = "Orientation determinant " + orientation.determinant() + " != 1.0";
                throw new IllegalArgumentException(string.toString());
            }
            Matrix44 m = TransformBuilderKt.buildTransform$default(null, arg_0 -> FramesKt.frames$lambda$7(current2, orientation, arg_0), 1, null);
            result.add(m);
        }
        return result;
    }

    public static /* synthetic */ List frames$default(List list, List list2, Vector3 vector3, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return FramesKt.frames(list, list2, vector3);
    }

    private static final Unit frames$lambda$7(Vector3 $current, Matrix44 $orientation, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($current);
        $this$buildTransform.multiply($orientation);
        return Unit.INSTANCE;
    }
}

