/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.mesh.IMeshData;
import org.openrndr.extra.mesh.IndexedPolygon;
import org.openrndr.extra.mesh.MeshData;
import org.openrndr.extra.mesh.MeshDataExtensionsKt;
import org.openrndr.extra.mesh.MutableVertexData;
import org.openrndr.extra.mesh.Polygon;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0000H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/openrndr/extra/mesh/MutableMeshData;", "Lorg/openrndr/extra/mesh/IMeshData;", "vertexData", "Lorg/openrndr/extra/mesh/MutableVertexData;", "polygons", "", "Lorg/openrndr/extra/mesh/IndexedPolygon;", "<init>", "(Lorg/openrndr/extra/mesh/MutableVertexData;Ljava/util/List;)V", "getVertexData", "()Lorg/openrndr/extra/mesh/MutableVertexData;", "getPolygons", "()Ljava/util/List;", "triangulate", "toPolygons", "", "Lorg/openrndr/extra/mesh/Polygon;", "join", "other", "toMutableMeshData", "toMeshData", "Lorg/openrndr/extra/mesh/MeshData;", "component1", "component2", "copy", "equals", "", "", "hashCode", "", "toString", "", "orx-mesh"})
@SourceDebugExtension(value={"SMAP\nMeshData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshData.kt\norg/openrndr/extra/mesh/MutableMeshData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1368#2:245\n1454#2,5:246\n1557#2:251\n1628#2,3:252\n*S KotlinDebug\n*F\n+ 1 MeshData.kt\norg/openrndr/extra/mesh/MutableMeshData\n*L\n225#1:245\n225#1:246,5\n230#1:251\n230#1:252,3\n*E\n"})
public final class MutableMeshData
implements IMeshData {
    @NotNull
    private final MutableVertexData vertexData;
    @NotNull
    private final List<IndexedPolygon> polygons;

    public MutableMeshData(@NotNull MutableVertexData vertexData, @NotNull List<IndexedPolygon> polygons) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(polygons, "polygons");
        this.vertexData = vertexData;
        this.polygons = polygons;
    }

    @Override
    @NotNull
    public MutableVertexData getVertexData() {
        return this.vertexData;
    }

    @NotNull
    public List<IndexedPolygon> getPolygons() {
        return this.polygons;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableMeshData triangulate() {
        MutableMeshData mutableMeshData;
        if (MeshDataExtensionsKt.isTriangular(this)) {
            mutableMeshData = this;
        } else {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = this.getPolygons();
            MutableVertexData mutableVertexData = null;
            MutableMeshData mutableMeshData2 = this;
            boolean $i$f$flatMap = false;
            void var3_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IndexedPolygon it = (IndexedPolygon)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.triangulate(this.getVertexData());
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            mutableMeshData = MutableMeshData.copy$default(mutableMeshData2, mutableVertexData, CollectionsKt.toMutableList(list), 1, null);
        }
        return mutableMeshData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Polygon> toPolygons() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getPolygons();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedPolygon indexedPolygon = (IndexedPolygon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toPolygon(this.getVertexData()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public IMeshData join(@NotNull IMeshData other) {
        Intrinsics.checkNotNullParameter(other, "other");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public MutableMeshData toMutableMeshData() {
        return this;
    }

    @Override
    @NotNull
    public MeshData toMeshData() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final MutableVertexData component1() {
        return this.vertexData;
    }

    @NotNull
    public final List<IndexedPolygon> component2() {
        return this.polygons;
    }

    @NotNull
    public final MutableMeshData copy(@NotNull MutableVertexData vertexData, @NotNull List<IndexedPolygon> polygons) {
        Intrinsics.checkNotNullParameter(vertexData, "vertexData");
        Intrinsics.checkNotNullParameter(polygons, "polygons");
        return new MutableMeshData(vertexData, polygons);
    }

    public static /* synthetic */ MutableMeshData copy$default(MutableMeshData mutableMeshData, MutableVertexData mutableVertexData, List list, int n, Object object) {
        if ((n & 1) != 0) {
            mutableVertexData = mutableMeshData.vertexData;
        }
        if ((n & 2) != 0) {
            list = mutableMeshData.polygons;
        }
        return mutableMeshData.copy(mutableVertexData, list);
    }

    @NotNull
    public String toString() {
        return "MutableMeshData(vertexData=" + this.vertexData + ", polygons=" + this.polygons + ")";
    }

    public int hashCode() {
        int result = this.vertexData.hashCode();
        result = result * 31 + ((Object)this.polygons).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutableMeshData)) {
            return false;
        }
        MutableMeshData mutableMeshData = (MutableMeshData)other;
        if (!Intrinsics.areEqual(this.vertexData, mutableMeshData.vertexData)) {
            return false;
        }
        return Intrinsics.areEqual(this.polygons, mutableMeshData.polygons);
    }
}

