/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.gltf;

import com.google.gson.Gson;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.dnk3.gltf.GlbKt;
import org.openrndr.extra.dnk3.gltf.GltfFile;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"GLTF_FLOAT", "", "GLTF_UNSIGNED_INT", "GLTF_INT", "GLTF_UNSIGNED_SHORT", "GLTF_SHORT", "GLTF_UNSIGNED_BYTE", "GLTF_BYTE", "GLTF_ARRAY_BUFFER", "GLTF_ELEMENT_ARRAY_BUFFER", "loadGltfFromFile", "Lorg/openrndr/extra/dnk3/gltf/GltfFile;", "file", "Ljava/io/File;", "deminityy"})
public final class GltfKt {
    public static final int GLTF_FLOAT = 5126;
    public static final int GLTF_UNSIGNED_INT = 5125;
    public static final int GLTF_INT = 5124;
    public static final int GLTF_UNSIGNED_SHORT = 5123;
    public static final int GLTF_SHORT = 5122;
    public static final int GLTF_UNSIGNED_BYTE = 5121;
    public static final int GLTF_BYTE = 5120;
    public static final int GLTF_ARRAY_BUFFER = 34962;
    public static final int GLTF_ELEMENT_ARRAY_BUFFER = 34963;

    @NotNull
    public static final GltfFile loadGltfFromFile(@NotNull File file) {
        GltfFile gltfFile;
        Intrinsics.checkNotNullParameter(file, "file");
        String string = FilesKt.getExtension(file);
        if (Intrinsics.areEqual(string, "gltf")) {
            GltfFile gltfFile2;
            Gson gson = new Gson();
            String json = FilesKt.readText$default(file, null, 1, null);
            GltfFile $this$loadGltfFromFile_u24lambda_u240 = gltfFile2 = gson.fromJson(json, GltfFile.class);
            boolean bl = false;
            $this$loadGltfFromFile_u24lambda_u240.setFile(file);
            GltfFile gltfFile3 = gltfFile2;
            Intrinsics.checkNotNull(gltfFile3);
            gltfFile = gltfFile3;
        } else if (Intrinsics.areEqual(string, "glb")) {
            gltfFile = GlbKt.loadGltfFromGlbFile(file);
        } else {
            throw new IllegalStateException(("extension " + FilesKt.getExtension(file) + " not supported in " + file).toString());
        }
        return gltfFile;
    }
}

