/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.ComputeStyle;
import org.openrndr.draw.ComputeStyleKt;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DepthFormat;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.Filter;
import org.openrndr.draw.IndexBuffer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.dnk3.ColorBufferFacetCombiner;
import org.openrndr.extra.dnk3.Entity;
import org.openrndr.extra.dnk3.FacetCombiner;
import org.openrndr.extra.dnk3.Feature;
import org.openrndr.extra.dnk3.FilterPostStep;
import org.openrndr.extra.dnk3.Fog;
import org.openrndr.extra.dnk3.InstancedMesh;
import org.openrndr.extra.dnk3.Light;
import org.openrndr.extra.dnk3.LightContext;
import org.openrndr.extra.dnk3.MaterialContext;
import org.openrndr.extra.dnk3.Mesh;
import org.openrndr.extra.dnk3.MeshPrimitive;
import org.openrndr.extra.dnk3.MeshPrimitiveInstance;
import org.openrndr.extra.dnk3.NodeContent;
import org.openrndr.extra.dnk3.PathMesh;
import org.openrndr.extra.dnk3.PostContext;
import org.openrndr.extra.dnk3.PostStep;
import org.openrndr.extra.dnk3.PrimitiveContext;
import org.openrndr.extra.dnk3.RenderContext;
import org.openrndr.extra.dnk3.RenderPass;
import org.openrndr.extra.dnk3.RenderPassKt;
import org.openrndr.extra.dnk3.Scene;
import org.openrndr.extra.dnk3.SceneKt;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.extra.dnk3.ShadowLight;
import org.openrndr.extra.dnk3.Shadows;
import org.openrndr.extra.dnk3.SkinnedMesh;
import org.openrndr.extra.fx.blur.ApproximateGaussianBlur;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Path3D;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\n\u00107\u001a\u000208*\u000204J\u0016\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u00103\u001a\u000204JE\u0010<\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u0002082\u0016\b\u0002\u0010A\u001a\u0010\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u000202\u0018\u00010BH\u0000\u00a2\u0006\u0002\bDR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000fR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u001d\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-\u00a8\u0006E"}, d2={"Lorg/openrndr/extra/dnk3/SceneRenderer;", "", "<init>", "()V", "blur", "Lorg/openrndr/extra/fx/blur/ApproximateGaussianBlur;", "getBlur", "()Lorg/openrndr/extra/fx/blur/ApproximateGaussianBlur;", "shadowLightTargets", "", "Lorg/openrndr/extra/dnk3/ShadowLight;", "Lorg/openrndr/draw/RenderTarget;", "getShadowLightTargets", "()Ljava/util/Map;", "setShadowLightTargets", "(Ljava/util/Map;)V", "meshCubemaps", "Lorg/openrndr/extra/dnk3/Mesh;", "Lorg/openrndr/draw/Cubemap;", "getMeshCubemaps", "setMeshCubemaps", "outputPasses", "", "Lorg/openrndr/extra/dnk3/RenderPass;", "getOutputPasses", "()Ljava/util/List;", "setOutputPasses", "(Ljava/util/List;)V", "outputPassTarget", "getOutputPassTarget", "()Lorg/openrndr/draw/RenderTarget;", "setOutputPassTarget", "(Lorg/openrndr/draw/RenderTarget;)V", "postSteps", "Lorg/openrndr/extra/dnk3/PostStep;", "getPostSteps", "buffers", "", "Lorg/openrndr/draw/ColorBuffer;", "getBuffers", "drawFinalBuffer", "", "getDrawFinalBuffer", "()Z", "setDrawFinalBuffer", "(Z)V", "first", "getFirst", "setFirst", "computeSkinTransform", "", "scene", "Lorg/openrndr/extra/dnk3/Scene;", "node", "Lorg/openrndr/extra/dnk3/SceneNode;", "renderContext", "Lorg/openrndr/extra/dnk3/RenderContext;", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "drawPass", "pass", "materialContext", "Lorg/openrndr/extra/dnk3/MaterialContext;", "context", "shadeStyleTransformer", "Lkotlin/Function1;", "Lorg/openrndr/draw/ShadeStyle;", "drawPass$deminityy", "deminityy"})
@SourceDebugExtension(value={"SMAP\nSceneRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SceneRenderer.kt\norg/openrndr/extra/dnk3/SceneRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,374:1\n1557#2:375\n1628#2,3:376\n774#2:383\n865#2,2:384\n1863#2:386\n1864#2:394\n1863#2,2:395\n1368#2:397\n1454#2,2:398\n1557#2:400\n1628#2,3:401\n1456#2,3:404\n774#2:407\n865#2,2:408\n1863#2,2:410\n1368#2:412\n1454#2,2:413\n1557#2:415\n1628#2,3:416\n1456#2,3:419\n774#2:422\n865#2,2:423\n1863#2,2:425\n1368#2:427\n1454#2,2:428\n1557#2:430\n1628#2,3:431\n1456#2,3:434\n774#2:437\n865#2,2:438\n1863#2,2:440\n774#2:442\n865#2,2:443\n1863#2,2:445\n1755#2,3:447\n1755#2,3:450\n1557#2:453\n1628#2,3:454\n37#3:379\n36#3,3:380\n37#3:457\n36#3,3:458\n381#4,7:387\n*S KotlinDebug\n*F\n+ 1 SceneRenderer.kt\norg/openrndr/extra/dnk3/SceneRenderer\n*L\n49#1:375\n49#1:376,3\n84#1:383\n84#1:384,2\n85#1:386\n85#1:394\n156#1:395,2\n205#1:397\n205#1:398,2\n206#1:400\n206#1:401,3\n205#1:404,3\n213#1:407\n213#1:408,2\n214#1:410,2\n251#1:412\n251#1:413,2\n252#1:415\n252#1:416,3\n251#1:419,3\n258#1:422\n258#1:423,2\n262#1:425,2\n307#1:427\n307#1:428,2\n308#1:430\n308#1:431,3\n307#1:434,3\n318#1:437\n318#1:438,2\n319#1:440,2\n342#1:442\n342#1:443,2\n343#1:445,2\n221#1:447,3\n270#1:450,3\n277#1:453\n277#1:454,3\n51#1:379\n51#1:380,3\n280#1:457\n280#1:458,3\n99#1:387,7\n*E\n"})
public final class SceneRenderer {
    @NotNull
    private final ApproximateGaussianBlur blur = new ApproximateGaussianBlur();
    @NotNull
    private Map<ShadowLight, RenderTarget> shadowLightTargets = new LinkedHashMap();
    @NotNull
    private Map<Mesh, Cubemap> meshCubemaps = new LinkedHashMap();
    @NotNull
    private List<RenderPass> outputPasses;
    @Nullable
    private RenderTarget outputPassTarget;
    @NotNull
    private final List<PostStep> postSteps;
    @NotNull
    private final Map<String, ColorBuffer> buffers;
    private boolean drawFinalBuffer;
    private boolean first;

    public SceneRenderer() {
        RenderPass[] renderPassArray = new RenderPass[]{RenderPassKt.getDefaultOpaquePass(), RenderPassKt.getDefaultTransparentPass()};
        this.outputPasses = CollectionsKt.mutableListOf(renderPassArray);
        this.postSteps = new ArrayList();
        this.buffers = new LinkedHashMap();
        this.drawFinalBuffer = true;
        this.first = true;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur() {
        return this.blur;
    }

    @NotNull
    public final Map<ShadowLight, RenderTarget> getShadowLightTargets() {
        return this.shadowLightTargets;
    }

    public final void setShadowLightTargets(@NotNull Map<ShadowLight, RenderTarget> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.shadowLightTargets = map2;
    }

    @NotNull
    public final Map<Mesh, Cubemap> getMeshCubemaps() {
        return this.meshCubemaps;
    }

    public final void setMeshCubemaps(@NotNull Map<Mesh, Cubemap> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.meshCubemaps = map2;
    }

    @NotNull
    public final List<RenderPass> getOutputPasses() {
        return this.outputPasses;
    }

    public final void setOutputPasses(@NotNull List<RenderPass> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.outputPasses = list;
    }

    @Nullable
    public final RenderTarget getOutputPassTarget() {
        return this.outputPassTarget;
    }

    public final void setOutputPassTarget(@Nullable RenderTarget renderTarget) {
        this.outputPassTarget = renderTarget;
    }

    @NotNull
    public final List<PostStep> getPostSteps() {
        return this.postSteps;
    }

    @NotNull
    public final Map<String, ColorBuffer> getBuffers() {
        return this.buffers;
    }

    public final boolean getDrawFinalBuffer() {
        return this.drawFinalBuffer;
    }

    public final void setDrawFinalBuffer(boolean bl) {
        this.drawFinalBuffer = bl;
    }

    public final boolean getFirst() {
        return this.first;
    }

    public final void setFirst(boolean bl) {
        this.first = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void computeSkinTransform(@NotNull Scene scene, @NotNull SceneNode node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(scene, "scene");
        Intrinsics.checkNotNullParameter(node, "node");
        ComputeStyle computeStyle = ComputeStyleKt.computeStyle(SceneRenderer::computeSkinTransform$lambda$0);
        List<NodeContent<SkinnedMesh>> skinnedMeshes = SceneKt.findContent(node, SceneRenderer::computeSkinTransform$lambda$1);
        SkinnedMesh skinnedMesh = CollectionsKt.first(skinnedMeshes).getContent();
        Matrix44 nodeInverse = node.getWorldTransform().inversed();
        Iterable iterable = CollectionsKt.zip((Iterable)skinnedMesh.getJoints(), (Iterable)skinnedMesh.getInverseBindMatrices());
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(nodeInverse.times(((SceneNode)it.getFirst()).getWorldTransform()).times((Matrix44)it.getSecond()));
        }
        List jointTransforms = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = jointTransforms;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        computeStyle.parameter("jointTransforms", thisCollection$iv.toArray(new Matrix44[0]));
        skinnedMeshes.get(0).getContent().getPrimitives().get(0).getGeometry().getVertexBuffers();
    }

    @NotNull
    public final RenderContext renderContext(@NotNull Scene $this$renderContext) {
        Intrinsics.checkNotNullParameter($this$renderContext, "<this>");
        List<NodeContent<Light>> list = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$3);
        List<NodeContent<Mesh>> list2 = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$4);
        List<NodeContent<SkinnedMesh>> list3 = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$5);
        List<NodeContent<Fog>> list4 = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$6);
        List<NodeContent<InstancedMesh>> list5 = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$7);
        List<NodeContent<PathMesh>> list6 = SceneKt.findContent($this$renderContext.getRoot(), SceneRenderer::renderContext$lambda$8);
        return new RenderContext(list, list2, list3, list5, list6, list4);
    }

    /*
     * Unable to fully structure code
     */
    public final void draw(@NotNull Drawer drawer, @NotNull Scene scene) {
        block24: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Intrinsics.checkNotNullParameter(scene, "scene");
            drawer.pushStyle();
            drawer.setDepthWrite(true);
            drawer.setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
            drawer.setCullTestPass(CullTestPass.FRONT);
            context = this.renderContext(scene);
            $this$draw_u24lambda_u2413 = this;
            $i$a$-run-SceneRenderer$draw$1 = false;
            $this$filter$iv = context.getLights();
            $i$f$filter = false;
            var9_12 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var12_18 = $this$filterTo$iv$iv.iterator();
            while (var12_18.hasNext()) {
                element$iv$iv = var12_18.next();
                it = (NodeContent)element$iv$iv;
                $i$a$-filter-SceneRenderer$draw$1$1 = false;
                if (!(it.getContent() instanceof ShadowLight)) ** GOTO lbl-1000
                v0 = it.getContent();
                Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type org.openrndr.extra.dnk3.ShadowLight");
                if (((ShadowLight)v0).getShadows() instanceof Shadows.MappedShadows) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                it = (NodeContent)element$iv;
                $i$a$-forEach-SceneRenderer$draw$1$2 = false;
                v2 = it.getContent();
                Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type org.openrndr.extra.dnk3.ShadowLight");
                shadowLight = (ShadowLight)v2;
                pass = null;
                $i$a$-filter-SceneRenderer$draw$1$1 = shadowLight.getShadows();
                if ($i$a$-filter-SceneRenderer$draw$1$1 instanceof Shadows.PCF || $i$a$-filter-SceneRenderer$draw$1$1 instanceof Shadows.Simple) {
                    v3 = RenderPassKt.getLightPass();
                } else if ($i$a$-filter-SceneRenderer$draw$1$1 instanceof Shadows.VSM) {
                    v3 = RenderPassKt.getVSMLightPass();
                } else {
                    throw new NotImplementedError(null, 1, null);
                }
                pass = v3;
                $this$getOrPut$iv = $this$draw_u24lambda_u2413.shadowLightTargets;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(shadowLight);
                if (value$iv == null) {
                    $i$a$-getOrPut-SceneRenderer$draw$1$2$target$1 = false;
                    v4 = shadowLight.getShadows();
                    Intrinsics.checkNotNull(v4, "null cannot be cast to non-null type org.openrndr.extra.dnk3.Shadows.MappedShadows");
                    mapSize = ((Shadows.MappedShadows)v4).getMapSize();
                    answer$iv = RenderPassKt.createPassTarget$default(pass, mapSize, mapSize, DepthFormat.DEPTH_STENCIL, null, 8, null);
                    $this$getOrPut$iv.put(shadowLight, answer$iv);
                    v5 = answer$iv;
                } else {
                    v5 = value$iv;
                }
                target = v5;
                RenderTarget.DefaultImpls.clearDepth$default(target, 1.0, 0, 2, null);
                look = shadowLight.view(it.getNode());
                materialContext = new MaterialContext(pass, context.getLights(), context.getFogs(), $this$draw_u24lambda_u2413.shadowLightTargets, MapsKt.emptyMap());
                DrawerKt.isolatedWithTarget(drawer, target, (Function1<Drawer, Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, draw$lambda$13$lambda$12$lambda$11(org.openrndr.draw.Drawer org.openrndr.extra.dnk3.ShadowLight org.openrndr.draw.RenderTarget org.openrndr.math.Matrix44 org.openrndr.extra.dnk3.SceneRenderer org.openrndr.extra.dnk3.RenderPass org.openrndr.extra.dnk3.MaterialContext org.openrndr.extra.dnk3.RenderContext org.openrndr.draw.Drawer ), (Lorg/openrndr/draw/Drawer;)Lkotlin/Unit;)((Drawer)drawer, (ShadowLight)shadowLight, (RenderTarget)target, (Matrix44)look, (SceneRenderer)$this$draw_u24lambda_u2413, (RenderPass)pass, (MaterialContext)materialContext, (RenderContext)context));
                if (!(shadowLight.getShadows() instanceof Shadows.VSM)) continue;
                $this$draw_u24lambda_u2413.blur.setGain(1.0);
                $this$draw_u24lambda_u2413.blur.setSigma(3.0);
                $this$draw_u24lambda_u2413.blur.setWindow(9);
                $this$draw_u24lambda_u2413.blur.setSpread(1.0);
                Filter.apply$default((Filter)$this$draw_u24lambda_u2413.blur, target.colorBuffer(0), target.colorBuffer(0), null, 4, null);
            }
            for (Feature feature : scene.getFeatures()) {
                feature.update(drawer, this, scene, feature, context);
            }
            $this$draw_u24lambda_u2419 = this;
            $i$a$-run-SceneRenderer$draw$2 = false;
            for (RenderPass pass : $this$draw_u24lambda_u2419.outputPasses) {
                materialContext = new MaterialContext(pass, context.getLights(), context.getFogs(), $this$draw_u24lambda_u2419.shadowLightTargets, $this$draw_u24lambda_u2419.meshCubemaps);
                var10_13 = new RenderPass[]{RenderPassKt.getDefaultTransparentPass(), RenderPassKt.getDefaultOpaquePass()};
                defaultPasses = SetsKt.setOf(var10_13);
                if ((!defaultPasses.contains(pass) || ((Collection)$this$draw_u24lambda_u2419.postSteps).isEmpty() == false) && $this$draw_u24lambda_u2419.outputPassTarget == null) {
                    $this$draw_u24lambda_u2419.outputPassTarget = RenderPassKt.createPassTarget$default(pass, RenderTarget.Companion.getActive().getWidth(), RenderTarget.Companion.getActive().getHeight(), null, null, 12, null);
                }
                if (Intrinsics.areEqual(pass, $this$draw_u24lambda_u2419.outputPasses.get(0))) {
                    if ($this$draw_u24lambda_u2419.outputPassTarget != null) {
                        $i$a$-let-SceneRenderer$draw$2$1 = false;
                        drawer.withTarget(it, (Function1<Drawer, Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, draw$lambda$19$lambda$15$lambda$14(org.openrndr.draw.Drawer ), (Lorg/openrndr/draw/Drawer;)Lkotlin/Unit;)());
                    }
                }
                if ($this$draw_u24lambda_u2419.outputPassTarget != null) {
                    $i$a$-let-SceneRenderer$draw$2$2 = false;
                    $this$forEach$iv = pass.combiners();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (FacetCombiner)element$iv;
                        $i$a$-forEach-SceneRenderer$draw$2$2$1 = false;
                        if (!(it instanceof ColorBufferFacetCombiner)) continue;
                        v6 = target.colorAttachmentIndexByName(it.getTargetOutput());
                        if (v6 == null) {
                            throw new IllegalStateException(("attachment not found " + it.getTargetOutput()).toString());
                        }
                        index = v6;
                        target.blendMode(index, ((ColorBufferFacetCombiner)it).getBlendMode());
                    }
                }
                v7 = $this$draw_u24lambda_u2419.outputPassTarget;
                if (v7 != null) {
                    v7.bind();
                }
                SceneRenderer.drawPass$deminityy$default($this$draw_u24lambda_u2419, drawer, pass, materialContext, context, null, 16, null);
                v8 = $this$draw_u24lambda_u2419.outputPassTarget;
                if (v8 != null) {
                    v8.unbind();
                }
                if ($this$draw_u24lambda_u2419.outputPassTarget == null) continue;
                $i$a$-let-SceneRenderer$draw$2$3 = false;
                for (FacetCombiner combiner : pass.combiners()) {
                    var16_27 = $this$draw_u24lambda_u2419.buffers;
                    var17_28 = combiner.getTargetOutput();
                    var18_30 = output.colorAttachmentByName(combiner.getTargetOutput());
                    v9 = var18_30 instanceof ColorBufferAttachment != false ? (ColorBufferAttachment)var18_30 : null;
                    if (v9 == null || (v9 = v9.getColorBuffer()) == null) {
                        throw new IllegalStateException(("attachment not found " + combiner.getTargetOutput()).toString());
                    }
                    var19_33 = v9;
                    var16_27.put(var17_28, (ColorBuffer)var19_33);
                }
            }
            lightContext = new LightContext(context.getLights(), $this$draw_u24lambda_u2419.shadowLightTargets);
            postContext = new PostContext(lightContext, drawer.getView().inversed());
            for (PostStep postStep : $this$draw_u24lambda_u2419.postSteps) {
                postStep.apply($this$draw_u24lambda_u2419.buffers, postContext);
            }
            drawer.popStyle();
            if (!this.drawFinalBuffer) break block24;
            v10 = this.outputPassTarget;
            if (v10 != null) {
                output = v10;
                $i$a$-let-SceneRenderer$draw$3 = false;
                DrawerKt.isolated(drawer, (Function1<Drawer, Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, draw$lambda$21$lambda$20(org.openrndr.draw.Drawer org.openrndr.extra.dnk3.SceneRenderer org.openrndr.draw.Drawer ), (Lorg/openrndr/draw/Drawer;)Lkotlin/Unit;)((Drawer)drawer, (SceneRenderer)this));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPass$deminityy(@NotNull Drawer drawer, @NotNull RenderPass pass, @NotNull MaterialContext materialContext, @NotNull RenderContext context, @Nullable Function1<? super ShadeStyle, Unit> shadeStyleTransformer) {
        void $this$forEach$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterator primitive;
        Object element$iv3;
        void $this$forEach$iv2;
        Iterator $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$flatMapTo$iv$iv2;
        Iterator primitive2;
        Object element$iv22;
        void $this$forEach$iv3;
        Iterator $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3;
        Object object;
        Iterable destination$iv$iv;
        void $this$flatMapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(pass, "pass");
        Intrinsics.checkNotNullParameter(materialContext, "materialContext");
        Intrinsics.checkNotNullParameter(context, "context");
        drawer.setDepthWrite(pass.depthWrite());
        Iterable $this$flatMap$iv = context.getMeshes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv3) {
            void $this$mapTo$iv$iv;
            NodeContent mesh = (NodeContent)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = ((Mesh)mesh.getContent()).getPrimitives();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void primitive3;
                MeshPrimitive meshPrimitive = (MeshPrimitive)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(new NodeContent<void>(mesh.getNode(), primitive3));
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List primitives = (List)destination$iv$iv2;
        $this$flatMap$iv = primitives;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv3 = $this$filter$iv3;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            NodeContent it = (NodeContent)element$iv$iv;
            boolean bl = false;
            if (!(((MeshPrimitive)it.getContent()).getMaterial().getTransparent() && pass.renderTransparent() || !((MeshPrimitive)it.getContent()).getMaterial().getTransparent() && pass.renderOpaque())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv3) {
            NodeContent it = (NodeContent)element$iv22;
            boolean bl = false;
            primitive2 = (MeshPrimitive)it.getContent();
            DrawerKt.isolated(drawer, arg_0 -> SceneRenderer.drawPass$lambda$27$lambda$26((MeshPrimitive)((Object)primitive2), drawer, materialContext, shadeStyleTransformer, it, arg_0));
        }
        Iterable $this$flatMap$iv2 = context.getSkinnedMeshes();
        boolean $i$f$flatMap2 = false;
        element$iv22 = $this$flatMap$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$mapTo$iv$iv;
            NodeContent mesh = (NodeContent)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = ((SkinnedMesh)mesh.getContent()).getPrimitives();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void primitive4;
                object = (MeshPrimitive)item$iv$iv;
                Collection bl2 = destination$iv$iv4;
                boolean bl3 = false;
                bl2.add(new NodeContent<Pair<void, NodeContent>>(mesh.getNode(), new Pair<void, NodeContent>(primitive4, mesh)));
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        List skinnedPrimitives = (List)destination$iv$iv3;
        $this$flatMap$iv2 = skinnedPrimitives;
        boolean $i$f$filter2 = false;
        $this$flatMapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        primitive2 = $this$filterTo$iv$iv2.iterator();
        while (primitive2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = primitive2.next();
            NodeContent it = (NodeContent)element$iv$iv;
            boolean bl = false;
            if (!(((MeshPrimitive)((Pair)it.getContent()).getFirst()).getMaterial().getTransparent() && pass.renderTransparent() || !((MeshPrimitive)((Pair)it.getContent()).getFirst()).getMaterial().getTransparent() && pass.renderOpaque())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            NodeContent it = (NodeContent)element$iv3;
            boolean bl = false;
            primitive = (MeshPrimitive)((Pair)it.getContent()).getFirst();
            SkinnedMesh skinnedMesh = (SkinnedMesh)((NodeContent)((Pair)it.getContent()).getSecond()).getContent();
            DrawerKt.isolated(drawer, arg_0 -> SceneRenderer.drawPass$lambda$34$lambda$33((MeshPrimitive)((Object)primitive), drawer, it, skinnedMesh, materialContext, arg_0));
        }
        Iterable $this$flatMap$iv3 = context.getInstancedMeshes();
        boolean $i$f$flatMap3 = false;
        element$iv3 = $this$flatMap$iv3;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            NodeContent mesh = (NodeContent)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = ((InstancedMesh)mesh.getContent()).getPrimitives();
            boolean $i$f$map = false;
            Iterable destination$iv$iv4 = $this$map$iv;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void primitive5;
                MeshPrimitive bl2 = (MeshPrimitive)item$iv$iv;
                Collection collection = destination$iv$iv6;
                boolean bl4 = false;
                collection.add(new NodeContent<MeshPrimitiveInstance>(mesh.getNode(), new MeshPrimitiveInstance((MeshPrimitive)primitive5, ((InstancedMesh)mesh.getContent()).getInstances(), ((InstancedMesh)mesh.getContent()).getAttributes())));
            }
            Iterable list$iv$iv = (List)destination$iv$iv6;
            CollectionsKt.addAll(destination$iv$iv5, list$iv$iv);
        }
        List instancedPrimitives = (List)destination$iv$iv5;
        $this$flatMap$iv3 = instancedPrimitives;
        boolean $i$f$filter3 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        primitive = $this$filterTo$iv$iv.iterator();
        while (primitive.hasNext()) {
            Object element$iv$iv = primitive.next();
            NodeContent it = (NodeContent)element$iv$iv;
            boolean bl = false;
            if (!(((MeshPrimitiveInstance)it.getContent()).getPrimitive().getMaterial().getTransparent() && pass.renderTransparent() || !((MeshPrimitiveInstance)it.getContent()).getPrimitive().getMaterial().getTransparent() && pass.renderOpaque())) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv5;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            NodeContent it = (NodeContent)element$iv4;
            boolean bl = false;
            MeshPrimitiveInstance primitive6 = (MeshPrimitiveInstance)it.getContent();
            DrawerKt.isolated(drawer, arg_0 -> SceneRenderer.drawPass$lambda$39$lambda$38(primitive6, materialContext, drawer, it, arg_0));
        }
        $this$filter$iv = context.getPathMeshes();
        $i$f$filter3 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv5 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            NodeContent it = (NodeContent)element$iv$iv;
            boolean bl5 = false;
            if (!(((PathMesh)it.getContent()).getMaterial().getTransparent() && pass.renderTransparent() || !((PathMesh)it.getContent()).getMaterial().getTransparent() && pass.renderOpaque())) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv5;
        $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            NodeContent it = (NodeContent)element$iv4;
            boolean bl6 = false;
            DrawerKt.isolated(drawer, arg_0 -> SceneRenderer.drawPass$lambda$42$lambda$41(it, materialContext, drawer, arg_0));
        }
        drawer.setDepthWrite(true);
    }

    public static /* synthetic */ void drawPass$deminityy$default(SceneRenderer sceneRenderer, Drawer drawer, RenderPass renderPass, MaterialContext materialContext, RenderContext renderContext, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        sceneRenderer.drawPass$deminityy(drawer, renderPass, materialContext, renderContext, function1);
    }

    private static final Unit computeSkinTransform$lambda$0(ComputeStyle $this$computeStyle) {
        Intrinsics.checkNotNullParameter($this$computeStyle, "$this$computeStyle");
        $this$computeStyle.setComputeTransform("                ");
        return Unit.INSTANCE;
    }

    private static final SkinnedMesh computeSkinTransform$lambda$1(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof SkinnedMesh ? (SkinnedMesh)$this$findContent : null;
    }

    private static final Light renderContext$lambda$3(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof Light ? (Light)$this$findContent : null;
    }

    private static final Mesh renderContext$lambda$4(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof Mesh ? (Mesh)$this$findContent : null;
    }

    private static final SkinnedMesh renderContext$lambda$5(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof SkinnedMesh ? (SkinnedMesh)$this$findContent : null;
    }

    private static final Fog renderContext$lambda$6(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof Fog ? (Fog)$this$findContent : null;
    }

    private static final InstancedMesh renderContext$lambda$7(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof InstancedMesh ? (InstancedMesh)$this$findContent : null;
    }

    private static final PathMesh renderContext$lambda$8(Entity $this$findContent) {
        Intrinsics.checkNotNullParameter($this$findContent, "$this$findContent");
        return $this$findContent instanceof PathMesh ? (PathMesh)$this$findContent : null;
    }

    private static final Unit draw$lambda$13$lambda$12$lambda$11(Drawer $drawer, ShadowLight $shadowLight, RenderTarget $target, Matrix44 $look, SceneRenderer $this_run, RenderPass $pass, MaterialContext $materialContext, RenderContext $context, Drawer $this$isolatedWithTarget) {
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        $drawer.setProjection($shadowLight.projection($target));
        $drawer.setView($look);
        $drawer.setModel(Matrix44.Companion.getIDENTITY());
        $drawer.clear(ColorRGBa.Companion.getBLACK());
        $drawer.setCullTestPass(CullTestPass.FRONT);
        SceneRenderer.drawPass$deminityy$default($this_run, $drawer, $pass, $materialContext, $context, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$19$lambda$15$lambda$14(Drawer $this$withTarget) {
        Intrinsics.checkNotNullParameter($this$withTarget, "$this$withTarget");
        $this$withTarget.clear(ColorRGBa.Companion.getTRANSPARENT());
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$21$lambda$20(Drawer $drawer, SceneRenderer this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.ortho();
        PostStep postStep = CollectionsKt.lastOrNull(this$0.postSteps);
        Object object = postStep instanceof FilterPostStep ? (FilterPostStep)postStep : null;
        if (object == null || (object = ((FilterPostStep)object).getOutput()) == null) {
            object = "color";
        }
        Object outputName = object;
        ColorBuffer colorBuffer = this$0.buffers.get(outputName);
        if (colorBuffer == null) {
            throw new IllegalArgumentException("can't find " + (String)outputName + " buffer");
        }
        ColorBuffer outputBuffer = colorBuffer;
        $drawer.image(outputBuffer);
        return Unit.INSTANCE;
    }

    private static final Unit drawPass$lambda$27$lambda$26(MeshPrimitive $primitive, Drawer $drawer, MaterialContext $materialContext, Function1 $shadeStyleTransformer, NodeContent $it, Drawer $this$isolated) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
            if ($primitive.getMaterial().getDoubleSided()) {
                $drawer.getDrawStyle().setCullTestPass(CullTestPass.ALWAYS);
            }
            Iterable $this$any$iv = $primitive.getGeometry().getVertexBuffers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VertexBuffer it = (VertexBuffer)element$iv;
                    boolean bl2 = false;
                    if (!it.getVertexFormat().hasAttribute("normal")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasNormalAttribute = bl;
        PrimitiveContext primitiveContext = new PrimitiveContext(hasNormalAttribute, false);
        ShadeStyle shadeStyle = $primitive.getMaterial().generateShadeStyle($materialContext, primitiveContext);
        shadeStyle.parameter("viewMatrixInverse", $drawer.getView().inversed());
        $primitive.getMaterial().applyToShadeStyle($materialContext, shadeStyle);
        Function1 function1 = $shadeStyleTransformer;
        if (function1 != null) {
            function1.invoke(shadeStyle);
        }
        $drawer.setShadeStyle(shadeStyle);
        $drawer.setModel($it.getNode().getWorldTransform());
        if ($primitive.getGeometry().getIndexBuffer() == null) {
            $drawer.vertexBuffer($primitive.getGeometry().getVertexBuffers(), $primitive.getGeometry().getPrimitive(), $primitive.getGeometry().getOffset(), $primitive.getGeometry().getVertexCount());
        } else {
            IndexBuffer indexBuffer = $primitive.getGeometry().getIndexBuffer();
            Intrinsics.checkNotNull(indexBuffer);
            $drawer.vertexBuffer(indexBuffer, $primitive.getGeometry().getVertexBuffers(), $primitive.getGeometry().getPrimitive(), $primitive.getGeometry().getOffset(), $primitive.getGeometry().getVertexCount());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit drawPass$lambda$34$lambda$33(MeshPrimitive $primitive, Drawer $drawer, NodeContent $it, SkinnedMesh $skinnedMesh, MaterialContext $materialContext, Drawer $this$isolated) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
            if ($primitive.getMaterial().getDoubleSided()) {
                $drawer.getDrawStyle().setCullTestPass(CullTestPass.ALWAYS);
            }
            Iterable $this$any$iv = $primitive.getGeometry().getVertexBuffers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    VertexBuffer it = (VertexBuffer)element$iv2;
                    boolean bl2 = false;
                    if (!it.getVertexFormat().hasAttribute("normal")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasNormalAttribute = bl;
        PrimitiveContext primitiveContext = new PrimitiveContext(hasNormalAttribute, true);
        Matrix44 nodeInverse = $it.getNode().getWorldTransform().inversed();
        element$iv2 = CollectionsKt.zip((Iterable)$skinnedMesh.getJoints(), (Iterable)$skinnedMesh.getInverseBindMatrices());
        boolean $i$f$map = false;
        void bl2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(nodeInverse.times(((SceneNode)it.getFirst()).getWorldTransform()).times((Matrix44)it.getSecond()));
        }
        List jointTransforms = (List)destination$iv$iv;
        ShadeStyle shadeStyle = $primitive.getMaterial().generateShadeStyle($materialContext, primitiveContext);
        Collection $this$toTypedArray$iv = jointTransforms;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        shadeStyle.parameter("jointTransforms", thisCollection$iv.toArray(new Matrix44[0]));
        shadeStyle.parameter("viewMatrixInverse", $drawer.getView().inversed());
        $primitive.getMaterial().applyToShadeStyle($materialContext, shadeStyle);
        $drawer.setShadeStyle(shadeStyle);
        $drawer.setModel($it.getNode().getWorldTransform());
        if ($primitive.getGeometry().getIndexBuffer() == null) {
            $drawer.vertexBuffer($primitive.getGeometry().getVertexBuffers(), $primitive.getGeometry().getPrimitive(), $primitive.getGeometry().getOffset(), $primitive.getGeometry().getVertexCount());
        } else {
            IndexBuffer indexBuffer = $primitive.getGeometry().getIndexBuffer();
            Intrinsics.checkNotNull(indexBuffer);
            $drawer.vertexBuffer(indexBuffer, $primitive.getGeometry().getVertexBuffers(), $primitive.getGeometry().getPrimitive(), $primitive.getGeometry().getOffset(), $primitive.getGeometry().getVertexCount());
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawPass$lambda$39$lambda$38(MeshPrimitiveInstance $primitive, MaterialContext $materialContext, Drawer $drawer, NodeContent $it, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        PrimitiveContext primitiveContext = new PrimitiveContext(true, false);
        ShadeStyle shadeStyle = $primitive.getPrimitive().getMaterial().generateShadeStyle($materialContext, primitiveContext);
        shadeStyle.parameter("viewMatrixInverse", $drawer.getView().inversed());
        $primitive.getPrimitive().getMaterial().applyToShadeStyle($materialContext, shadeStyle);
        if ($primitive.getPrimitive().getMaterial().getDoubleSided()) {
            $drawer.getDrawStyle().setCullTestPass(CullTestPass.ALWAYS);
        }
        $drawer.setShadeStyle(shadeStyle);
        $drawer.setModel($it.getNode().getWorldTransform());
        $drawer.vertexBufferInstances($primitive.getPrimitive().getGeometry().getVertexBuffers(), $primitive.getAttributes(), DrawPrimitive.TRIANGLES, $primitive.getInstances(), $primitive.getPrimitive().getGeometry().getOffset(), $primitive.getPrimitive().getGeometry().getVertexCount());
        return Unit.INSTANCE;
    }

    private static final Unit drawPass$lambda$42$lambda$41(NodeContent $it, MaterialContext $materialContext, Drawer $drawer, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        PrimitiveContext primitiveContext = new PrimitiveContext(true, false);
        ShadeStyle shadeStyle = ((PathMesh)$it.getContent()).getMaterial().generateShadeStyle($materialContext, primitiveContext);
        shadeStyle.parameter("viewMatrixInverse", $drawer.getView().inversed());
        ((PathMesh)$it.getContent()).getMaterial().applyToShadeStyle($materialContext, shadeStyle);
        $drawer.getDrawStyle().setCullTestPass(CullTestPass.ALWAYS);
        $drawer.setShadeStyle(shadeStyle);
        $drawer.setModel($it.getNode().getWorldTransform());
        $drawer.setStrokeWeight(((PathMesh)$it.getContent()).getWeight());
        for (Path3D path : ((PathMesh)$it.getContent()).getPaths()) {
            $drawer.path(path.sampleLinear(5.0E-4));
        }
        return Unit.INSTANCE;
    }
}

