/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.composition;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.composition.CompositionKt;
import org.openrndr.extra.composition.CompositionNode;
import org.openrndr.extra.composition.Style;
import org.openrndr.math.Matrix44;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Shape;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u0000J\u0012\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010JJ\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\b\b\u0002\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007\u00a8\u0006!"}, d2={"Lorg/openrndr/extra/composition/ShapeNode;", "Lorg/openrndr/extra/composition/CompositionNode;", "shape", "Lorg/openrndr/shape/Shape;", "<init>", "(Lorg/openrndr/shape/Shape;)V", "getShape", "()Lorg/openrndr/shape/Shape;", "setShape", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "conflate", "flatten", "composition", "Lorg/openrndr/extra/composition/Composition;", "copy", "id", "", "parent", "style", "Lorg/openrndr/extra/composition/Style;", "attributes", "", "equals", "", "other", "", "hashCode", "", "effectiveShape", "getEffectiveShape", "orx-composition"})
public final class ShapeNode
extends CompositionNode {
    @NotNull
    private Shape shape;

    public ShapeNode(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter(shape, "shape");
        super(null);
        this.shape = shape;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter(shape, "<set-?>");
        this.shape = shape;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        Matrix44 t = this.getEffectiveTransform();
        return t == Matrix44.Companion.getIDENTITY() ? this.shape.getBounds() : this.shape.getBounds().contour().transform(t).getBounds();
    }

    @NotNull
    public final ShapeNode conflate() {
        ShapeNode shapeNode;
        ShapeNode it = shapeNode = new ShapeNode(this.shape);
        boolean bl = false;
        it.setId(this.getId());
        it.setParent(this.getParent());
        it.setStyle(this.getStyle());
        it.setTransform(CompositionKt.transform(this));
        it.setAttributes(this.getAttributes());
        return shapeNode;
    }

    @NotNull
    public final ShapeNode flatten(@Nullable Composition composition) {
        ShapeNode shapeNode;
        Object object = composition;
        if (object == null || (object = ((Composition)object).calculateViewportTransform()) == null) {
            object = Matrix44.Companion.getIDENTITY();
        }
        Object viewport = object;
        ShapeNode it = shapeNode = new ShapeNode(this.shape.transform(((Matrix44)viewport).times(CompositionKt.transform(this))));
        boolean bl = false;
        it.setId(this.getId());
        it.setParent(this.getParent());
        it.setStyle(this.getEffectiveStyle());
        it.setAttributes(this.getAttributes());
        return shapeNode;
    }

    public static /* synthetic */ ShapeNode flatten$default(ShapeNode shapeNode, Composition composition, int n, Object object) {
        if ((n & 1) != 0) {
            composition = null;
        }
        return shapeNode.flatten(composition);
    }

    @NotNull
    public final ShapeNode copy(@Nullable String id, @Nullable CompositionNode parent, @NotNull Style style, @NotNull Map<String, String> attributes, @NotNull Shape shape) {
        ShapeNode shapeNode;
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(shape, "shape");
        ShapeNode it = shapeNode = new ShapeNode(shape);
        boolean bl = false;
        it.setId(id);
        it.setParent(parent);
        it.setStyle(style);
        it.setAttributes(attributes);
        return shapeNode;
    }

    public static /* synthetic */ ShapeNode copy$default(ShapeNode shapeNode, String string, CompositionNode compositionNode, Style style, Map map2, Shape shape, int n, Object object) {
        if ((n & 1) != 0) {
            string = shapeNode.getId();
        }
        if ((n & 2) != 0) {
            compositionNode = null;
        }
        if ((n & 4) != 0) {
            style = shapeNode.getStyle();
        }
        if ((n & 8) != 0) {
            map2 = shapeNode.getAttributes();
        }
        if ((n & 0x10) != 0) {
            shape = shapeNode.shape;
        }
        return shapeNode.copy(string, compositionNode, style, map2, shape);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShapeNode)) {
            return false;
        }
        return Intrinsics.areEqual(this.shape, ((ShapeNode)other).shape);
    }

    public int hashCode() {
        return this.shape.hashCode();
    }

    @NotNull
    public final Shape getEffectiveShape() {
        return this.shape.transform(this.getEffectiveTransform());
    }
}

