/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.camera;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.events.Event;
import org.openrndr.extra.camera.ChangeEvents;
import org.openrndr.extra.camera.OrbitalCameraKt;
import org.openrndr.extra.camera.ProjectionType;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b<\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 k2\u00020\u00012\u00020\u0002:\u0001kBC\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010H\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007J\u0016\u0010L\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007J\u000e\u0010L\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010M\u001a\u00020\u001cJ\u0006\u0010N\u001a\u00020\u001cJ\u000e\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020\u0007J\u001e\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u0007J\u000e\u0010U\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010W\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020\u0007J\u000e\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u0007J\u000e\u0010Z\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u0007J\u000e\u0010[\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020\u0007J\u000e\u0010]\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020\u0007J\u000e\u0010^\u001a\u00020\u001c2\u0006\u0010_\u001a\u00020\u0007J\u0006\u0010`\u001a\u00020aJ\u0018\u0010e\u001a\u00020\u001c2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0016J\u0018\u0010j\u001a\u00020\u001c2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\"\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000f\"\u0004\b0\u0010\u0011R\u001a\u00101\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000f\"\u0004\b3\u0010\u0011R\u000e\u00104\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00106\u001a\u00020 2\u0006\u0010#\u001a\u00020 @BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b7\u0010-R\u000e\u00108\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u000f\"\u0004\b;\u0010\u0011R\u001a\u0010<\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u000f\"\u0004\b>\u0010\u0011R\u001a\u0010?\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u000f\"\u0004\bA\u0010\u0011R\u001a\u0010B\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u000f\"\u0004\bD\u0010\u0011R\u001a\u0010E\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u000f\"\u0004\bG\u0010\u0011R\u001a\u0010b\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\"\"\u0004\bd\u0010-\u00a8\u0006l"}, d2={"Lorg/openrndr/extra/camera/OrbitalCamera;", "Lorg/openrndr/Extension;", "Lorg/openrndr/extra/camera/ChangeEvents;", "eye", "Lorg/openrndr/math/Vector3;", "lookAt", "fov", "", "near", "far", "projectionType", "Lorg/openrndr/extra/camera/ProjectionType;", "<init>", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;DDDLorg/openrndr/extra/camera/ProjectionType;)V", "getFov", "()D", "setFov", "(D)V", "getNear", "setNear", "getFar", "setFar", "getProjectionType", "()Lorg/openrndr/extra/camera/ProjectionType;", "setProjectionType", "(Lorg/openrndr/extra/camera/ProjectionType;)V", "changed", "Lorg/openrndr/events/Event;", "", "getChanged", "()Lorg/openrndr/events/Event;", "hasChanged", "", "getHasChanged", "()Z", "value", "Lorg/openrndr/math/Spherical;", "spherical", "getSpherical", "()Lorg/openrndr/math/Spherical;", "getLookAt", "()Lorg/openrndr/math/Vector3;", "depthTest", "getDepthTest", "setDepthTest", "(Z)V", "magnitude", "getMagnitude", "setMagnitude", "magnitudeEnd", "getMagnitudeEnd", "setMagnitudeEnd", "sphericalEnd", "lookAtEnd", "dirty", "setDirty", "lastSeconds", "fovEnd", "getFovEnd", "setFovEnd", "dampingFactor", "getDampingFactor", "setDampingFactor", "zoomSpeed", "getZoomSpeed", "setZoomSpeed", "orthoNear", "getOrthoNear", "setOrthoNear", "orthoFar", "getOrthoFar", "setOrthoFar", "setView", "rotate", "rotX", "rotY", "rotateTo", "dollyIn", "dollyOut", "dolly", "distance", "pan", "x", "y", "z", "panTo", "target", "dollyTo", "scale", "s", "scaleTo", "zoom", "degrees", "zoomTo", "update", "timeDelta", "viewMatrix", "Lorg/openrndr/math/Matrix44;", "enabled", "getEnabled", "setEnabled", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "afterDraw", "Companion", "orx-camera"})
public final class OrbitalCamera
implements Extension,
ChangeEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fov;
    private double near;
    private double far;
    @NotNull
    private ProjectionType projectionType;
    @NotNull
    private final Event<Unit> changed;
    @NotNull
    private Spherical spherical;
    @NotNull
    private Vector3 lookAt;
    private boolean depthTest;
    private double magnitude;
    private double magnitudeEnd;
    @NotNull
    private Spherical sphericalEnd;
    @NotNull
    private Vector3 lookAtEnd;
    private boolean dirty;
    private double lastSeconds;
    private double fovEnd;
    private double dampingFactor;
    private double zoomSpeed;
    private double orthoNear;
    private double orthoFar;
    private boolean enabled;
    private static final double EPSILON = 1.0E-6;

    public OrbitalCamera(@NotNull Vector3 eye, @NotNull Vector3 lookAt, double fov, double near, double far, @NotNull ProjectionType projectionType) {
        Intrinsics.checkNotNullParameter(eye, "eye");
        Intrinsics.checkNotNullParameter(lookAt, "lookAt");
        Intrinsics.checkNotNullParameter((Object)projectionType, "projectionType");
        this.fov = fov;
        this.near = near;
        this.far = far;
        this.projectionType = projectionType;
        this.changed = new Event(null, false, 3, null);
        this.spherical = Spherical.Companion.fromVector(eye);
        this.lookAt = lookAt;
        this.depthTest = true;
        this.magnitudeEnd = this.magnitude = 100.0;
        this.sphericalEnd = Spherical.Companion.fromVector(eye);
        this.lookAtEnd = lookAt;
        this.dirty = true;
        this.lastSeconds = -1.0;
        this.fovEnd = this.fov;
        this.dampingFactor = 0.05;
        this.zoomSpeed = 1.0;
        this.orthoNear = -1000.0;
        this.orthoFar = 1000.0;
        this.enabled = true;
    }

    public /* synthetic */ OrbitalCamera(Vector3 vector3, Vector3 vector32, double d, double d2, double d3, ProjectionType projectionType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3 = Vector3.Companion.getZERO();
        }
        if ((n & 2) != 0) {
            vector32 = Vector3.Companion.getUNIT_Z();
        }
        if ((n & 4) != 0) {
            d = 90.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.1;
        }
        if ((n & 0x10) != 0) {
            d3 = 1000.0;
        }
        if ((n & 0x20) != 0) {
            projectionType = ProjectionType.PERSPECTIVE;
        }
        this(vector3, vector32, d, d2, d3, projectionType);
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    public final double getNear() {
        return this.near;
    }

    public final void setNear(double d) {
        this.near = d;
    }

    public final double getFar() {
        return this.far;
    }

    public final void setFar(double d) {
        this.far = d;
    }

    @NotNull
    public final ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public final void setProjectionType(@NotNull ProjectionType projectionType) {
        Intrinsics.checkNotNullParameter((Object)projectionType, "<set-?>");
        this.projectionType = projectionType;
    }

    @Override
    @NotNull
    public Event<Unit> getChanged() {
        return this.changed;
    }

    @Override
    public boolean getHasChanged() {
        return this.dirty;
    }

    @NotNull
    public final Spherical getSpherical() {
        return this.spherical;
    }

    @NotNull
    public final Vector3 getLookAt() {
        return this.lookAt;
    }

    public final boolean getDepthTest() {
        return this.depthTest;
    }

    public final void setDepthTest(boolean bl) {
        this.depthTest = bl;
    }

    public final double getMagnitude() {
        return this.magnitude;
    }

    public final void setMagnitude(double d) {
        this.magnitude = d;
    }

    public final double getMagnitudeEnd() {
        return this.magnitudeEnd;
    }

    public final void setMagnitudeEnd(double d) {
        this.magnitudeEnd = d;
    }

    private final void setDirty(boolean value) {
        if (value && !this.dirty) {
            this.getChanged().trigger(Unit.INSTANCE);
        }
        this.dirty = value;
    }

    public final double getFovEnd() {
        return this.fovEnd;
    }

    public final void setFovEnd(double d) {
        this.fovEnd = d;
    }

    public final double getDampingFactor() {
        return this.dampingFactor;
    }

    public final void setDampingFactor(double d) {
        this.dampingFactor = d;
    }

    public final double getZoomSpeed() {
        return this.zoomSpeed;
    }

    public final void setZoomSpeed(double d) {
        this.zoomSpeed = d;
    }

    public final double getOrthoNear() {
        return this.orthoNear;
    }

    public final void setOrthoNear(double d) {
        this.orthoNear = d;
    }

    public final double getOrthoFar() {
        return this.orthoFar;
    }

    public final void setOrthoFar(double d) {
        this.orthoFar = d;
    }

    public final void setView(@NotNull Vector3 lookAt, @NotNull Spherical spherical, double fov) {
        Intrinsics.checkNotNullParameter(lookAt, "lookAt");
        Intrinsics.checkNotNullParameter(spherical, "spherical");
        this.lookAt = lookAt;
        this.lookAtEnd = lookAt;
        this.spherical = spherical;
        this.sphericalEnd = spherical;
        this.fov = fov;
        this.fovEnd = fov;
    }

    public final void rotate(double rotX, double rotY) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(rotX, rotY, 0.0));
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.setDirty(true);
    }

    public final void rotateTo(double rotX, double rotY) {
        this.sphericalEnd = Spherical.copy$default(this.sphericalEnd, rotX, rotY, 0.0, 4, null);
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.setDirty(true);
    }

    public final void rotateTo(@NotNull Vector3 eye) {
        Intrinsics.checkNotNullParameter(eye, "eye");
        this.sphericalEnd = Spherical.Companion.fromVector(eye);
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.setDirty(true);
    }

    public final void dollyIn() {
        double zoomScale = OrbitalCameraKt.access$pow(0.95, this.zoomSpeed);
        this.dolly(this.sphericalEnd.radius() * zoomScale - this.sphericalEnd.radius());
    }

    public final void dollyOut() {
        double zoomScale = OrbitalCameraKt.access$pow(0.95, this.zoomSpeed);
        this.dolly(this.sphericalEnd.radius() / zoomScale - this.sphericalEnd.radius());
    }

    public final void dolly(double distance) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(0.0, 0.0, distance));
        this.setDirty(true);
    }

    public final void pan(double x, double y, double z) {
        Matrix44 view = this.viewMatrix();
        Vector3 xColumn = new Vector3(view.c0r0(), view.c1r0(), view.c2r0()).times(x);
        Vector3 yColumn = new Vector3(view.c0r1(), view.c1r1(), view.c2r1()).times(y);
        Vector3 zColumn = new Vector3(view.c0r2(), view.c1r2(), view.c2r2()).times(z);
        this.lookAtEnd = this.lookAtEnd.plus(xColumn.plus(yColumn).plus(zColumn));
        this.setDirty(true);
    }

    public final void panTo(@NotNull Vector3 target2) {
        Intrinsics.checkNotNullParameter(target2, "target");
        this.lookAtEnd = target2;
        this.setDirty(true);
    }

    public final void dollyTo(double distance) {
        this.sphericalEnd = Spherical.copy$default(this.sphericalEnd, 0.0, 0.0, distance, 3, null);
        this.setDirty(true);
    }

    public final void scale(double s) {
        this.magnitudeEnd += s;
        this.setDirty(true);
    }

    public final void scaleTo(double s) {
        this.magnitudeEnd = s;
        this.setDirty(true);
    }

    public final void zoom(double degrees) {
        this.fovEnd += degrees;
        this.setDirty(true);
    }

    public final void zoomTo(double degrees) {
        this.fovEnd = degrees;
        this.setDirty(true);
    }

    public final void update(double timeDelta) {
        if (!this.dirty) {
            return;
        }
        this.setDirty(false);
        double dampingFactor = this.dampingFactor > 0.0 ? this.dampingFactor * timeDelta / 0.006 : 1.0;
        Spherical sphericalDelta = this.sphericalEnd.minus(this.spherical);
        Vector3 lookAtDelta = this.lookAtEnd.minus(this.lookAt);
        double fovDelta = this.fovEnd - this.fov;
        double magnitudeDelta = this.magnitudeEnd - this.magnitude;
        if (Math.abs(sphericalDelta.radius()) > 1.0E-6 || Math.abs(sphericalDelta.theta()) > 1.0E-6 || Math.abs(sphericalDelta.phi()) > 1.0E-6 || Math.abs(lookAtDelta.x()) > 1.0E-6 || Math.abs(lookAtDelta.y()) > 1.0E-6 || Math.abs(lookAtDelta.z()) > 1.0E-6 || Math.abs(fovDelta) > 1.0E-6) {
            this.fov += fovDelta * dampingFactor;
            this.spherical = this.spherical.plus(sphericalDelta.times(dampingFactor));
            this.spherical = this.spherical.makeSafe();
            this.lookAt = this.lookAt.plus(lookAtDelta.times(dampingFactor));
            this.magnitude += magnitudeDelta * dampingFactor;
            this.setDirty(true);
        } else {
            this.magnitude = this.magnitudeEnd;
            this.spherical = Spherical.copy$default(this.sphericalEnd, 0.0, 0.0, 0.0, 7, null);
            this.lookAt = Vector3.copy$default(this.lookAtEnd, 0.0, 0.0, 0.0, 7, null);
            this.fov = this.fovEnd;
        }
        this.spherical = this.spherical.makeSafe();
    }

    @NotNull
    public final Matrix44 viewMatrix() {
        return TransformsKt.lookAt(Vector3.Companion.fromSpherical(this.spherical).plus(this.lookAt), this.lookAt, Vector3.Companion.getUNIT_Y());
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        drawer.pushTransforms();
        if (this.lastSeconds == -1.0) {
            this.lastSeconds = program2.getSeconds();
        }
        double delta = program2.getSeconds() - this.lastSeconds;
        this.lastSeconds = program2.getSeconds();
        this.update(delta);
        OrbitalCameraKt.applyTo(this, drawer);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        drawer.popTransforms();
    }

    @Override
    public void setup(@NotNull Program program2) {
        Extension.DefaultImpls.setup(this, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    public OrbitalCamera() {
        this(null, null, 0.0, 0.0, 0.0, null, 63, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/extra/camera/OrbitalCamera$Companion;", "", "<init>", "()V", "EPSILON", "", "orx-camera"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

