/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.camera;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.events.Event;
import org.openrndr.extra.camera.ChangeEvents;
import org.openrndr.extra.camera.OrbitalCamera;
import org.openrndr.extra.camera.OrbitalControls;
import org.openrndr.extra.camera.ProjectionType;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010G\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010B\u001a\u00020CH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010\nR\u001a\u0010*\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001e\"\u0004\b5\u0010 R\u001b\u00106\u001a\u0002078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b8\u00109R\u001b\u0010<\u001a\u00020=8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010;\u001a\u0004\b>\u0010?\u00a8\u0006H"}, d2={"Lorg/openrndr/extra/camera/Orbital;", "Lorg/openrndr/Extension;", "Lorg/openrndr/extra/camera/ChangeEvents;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "changed", "Lorg/openrndr/events/Event;", "", "getChanged", "()Lorg/openrndr/events/Event;", "hasChanged", "getHasChanged", "eye", "Lorg/openrndr/math/Vector3;", "getEye", "()Lorg/openrndr/math/Vector3;", "setEye", "(Lorg/openrndr/math/Vector3;)V", "lookAt", "getLookAt", "setLookAt", "near", "", "getNear", "()D", "setNear", "(D)V", "far", "getFar", "setFar", "fov", "getFov", "setFov", "userInteraction", "getUserInteraction", "setUserInteraction", "keySpeed", "getKeySpeed", "setKeySpeed", "projectionType", "Lorg/openrndr/extra/camera/ProjectionType;", "getProjectionType", "()Lorg/openrndr/extra/camera/ProjectionType;", "setProjectionType", "(Lorg/openrndr/extra/camera/ProjectionType;)V", "dampingFactor", "getDampingFactor", "setDampingFactor", "camera", "Lorg/openrndr/extra/camera/OrbitalCamera;", "getCamera", "()Lorg/openrndr/extra/camera/OrbitalCamera;", "camera$delegate", "Lkotlin/Lazy;", "controls", "Lorg/openrndr/extra/camera/OrbitalControls;", "getControls", "()Lorg/openrndr/extra/camera/OrbitalControls;", "controls$delegate", "setup", "program", "Lorg/openrndr/Program;", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "afterDraw", "orx-camera"})
public final class Orbital
implements Extension,
ChangeEvents {
    private boolean enabled = true;
    @NotNull
    private final Event<Unit> changed = new Event(null, false, 3, null);
    @NotNull
    private Vector3 eye = Vector3.Companion.getUNIT_Z().times(10.0);
    @NotNull
    private Vector3 lookAt = Vector3.Companion.getZERO();
    private double near = 0.1;
    private double far = 1000.0;
    private double fov = 90.0;
    private boolean userInteraction = true;
    private double keySpeed = 1.0;
    @NotNull
    private ProjectionType projectionType = ProjectionType.PERSPECTIVE;
    private double dampingFactor = 0.05;
    @NotNull
    private final Lazy camera$delegate = LazyKt.lazy(() -> Orbital.camera_delegate$lambda$1(this));
    @NotNull
    private final Lazy controls$delegate = LazyKt.lazy(() -> Orbital.controls_delegate$lambda$2(this));

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    @NotNull
    public Event<Unit> getChanged() {
        return this.changed;
    }

    @Override
    public boolean getHasChanged() {
        return this.getCamera().getHasChanged();
    }

    @NotNull
    public final Vector3 getEye() {
        return this.eye;
    }

    public final void setEye(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.eye = vector3;
    }

    @NotNull
    public final Vector3 getLookAt() {
        return this.lookAt;
    }

    public final void setLookAt(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.lookAt = vector3;
    }

    public final double getNear() {
        return this.near;
    }

    public final void setNear(double d) {
        this.near = d;
    }

    public final double getFar() {
        return this.far;
    }

    public final void setFar(double d) {
        this.far = d;
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    public final boolean getUserInteraction() {
        return this.userInteraction;
    }

    public final void setUserInteraction(boolean bl) {
        this.userInteraction = bl;
    }

    public final double getKeySpeed() {
        return this.keySpeed;
    }

    public final void setKeySpeed(double d) {
        this.keySpeed = d;
    }

    @NotNull
    public final ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public final void setProjectionType(@NotNull ProjectionType projectionType) {
        Intrinsics.checkNotNullParameter((Object)projectionType, "<set-?>");
        this.projectionType = projectionType;
    }

    public final double getDampingFactor() {
        return this.dampingFactor;
    }

    public final void setDampingFactor(double d) {
        this.dampingFactor = d;
    }

    @NotNull
    public final OrbitalCamera getCamera() {
        Lazy lazy = this.camera$delegate;
        return (OrbitalCamera)lazy.getValue();
    }

    @NotNull
    public final OrbitalControls getControls() {
        Lazy lazy = this.controls$delegate;
        return (OrbitalControls)lazy.getValue();
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        this.getControls().setup(program2);
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        this.getCamera().beforeDraw(drawer, program2);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        this.getCamera().afterDraw(drawer, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final OrbitalCamera camera_delegate$lambda$1(Orbital this$0) {
        OrbitalCamera orbitalCamera;
        OrbitalCamera $this$camera_delegate_u24lambda_u241_u24lambda_u240 = orbitalCamera = new OrbitalCamera(this$0.eye, this$0.lookAt, this$0.fov, this$0.near, this$0.far, this$0.projectionType);
        boolean bl = false;
        $this$camera_delegate_u24lambda_u241_u24lambda_u240.setDampingFactor(this$0.dampingFactor);
        $this$camera_delegate_u24lambda_u241_u24lambda_u240.getChanged().listen(this$0.getChanged());
        return orbitalCamera;
    }

    private static final OrbitalControls controls_delegate$lambda$2(Orbital this$0) {
        return new OrbitalControls(this$0.getCamera(), this$0.userInteraction, this$0.keySpeed);
    }
}

