/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.camera;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.MouseButton;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEvents;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.events.Event;
import org.openrndr.extra.camera.ChangeEvents;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\b\u00a8\u0006+"}, d2={"Lorg/openrndr/extra/camera/Camera2D;", "Lorg/openrndr/Extension;", "Lorg/openrndr/extra/camera/ChangeEvents;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "view", "Lorg/openrndr/math/Matrix44;", "getView", "()Lorg/openrndr/math/Matrix44;", "setView", "(Lorg/openrndr/math/Matrix44;)V", "rotationCenter", "Lorg/openrndr/math/Vector2;", "getRotationCenter", "()Lorg/openrndr/math/Vector2;", "setRotationCenter", "(Lorg/openrndr/math/Vector2;)V", "changed", "Lorg/openrndr/events/Event;", "", "getChanged", "()Lorg/openrndr/events/Event;", "value", "dirty", "setDirty", "hasChanged", "getHasChanged", "setupMouseEvents", "mouse", "Lorg/openrndr/MouseEvents;", "setup", "program", "Lorg/openrndr/Program;", "beforeDraw", "drawer", "Lorg/openrndr/draw/Drawer;", "afterDraw", "orx-camera"})
public final class Camera2D
implements Extension,
ChangeEvents {
    private boolean enabled = true;
    @NotNull
    private Matrix44 view = Matrix44.Companion.getIDENTITY();
    @NotNull
    private Vector2 rotationCenter = Vector2.Companion.getZERO();
    @NotNull
    private final Event<Unit> changed = new Event(null, false, 3, null);
    private boolean dirty = true;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final Matrix44 getView() {
        return this.view;
    }

    public final void setView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkNotNullParameter(matrix44, "<set-?>");
        this.view = matrix44;
    }

    @NotNull
    public final Vector2 getRotationCenter() {
        return this.rotationCenter;
    }

    public final void setRotationCenter(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.rotationCenter = vector2;
    }

    @Override
    @NotNull
    public Event<Unit> getChanged() {
        return this.changed;
    }

    private final void setDirty(boolean value) {
        if (value && !this.dirty) {
            this.getChanged().trigger(Unit.INSTANCE);
        }
        this.dirty = value;
    }

    @Override
    public boolean getHasChanged() {
        return this.dirty;
    }

    public final void setupMouseEvents(@NotNull MouseEvents mouse) {
        Intrinsics.checkNotNullParameter(mouse, "mouse");
        mouse.getButtonDown().listen(arg_0 -> Camera2D.setupMouseEvents$lambda$0(this, arg_0));
        mouse.getDragged().listen(arg_0 -> Camera2D.setupMouseEvents$lambda$3(this, arg_0));
        mouse.getScrolled().listen(arg_0 -> Camera2D.setupMouseEvents$lambda$5(this, arg_0));
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        this.setupMouseEvents(program2.getMouse());
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        drawer.pushTransforms();
        drawer.ortho(RenderTarget.Companion.getActive());
        drawer.setView(this.view);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        this.setDirty(false);
        drawer.popTransforms();
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final Unit setupMouseEvents$lambda$0(Camera2D this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.rotationCenter = it.getPosition();
        return Unit.INSTANCE;
    }

    private static final Unit setupMouseEvents$lambda$3$lambda$1(MouseEvent $it, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($it.getDragDisplacement());
        return Unit.INSTANCE;
    }

    private static final Unit setupMouseEvents$lambda$3$lambda$2(Camera2D this$0, MouseEvent $it, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate(this$0.rotationCenter);
        $this$buildTransform.rotate($it.getDragDisplacement().x() + $it.getDragDisplacement().y());
        $this$buildTransform.translate(this$0.rotationCenter.unaryMinus());
        return Unit.INSTANCE;
    }

    private static final Unit setupMouseEvents$lambda$3(Camera2D this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getPropagationCancelled()) {
            switch (WhenMappings.$EnumSwitchMapping$0[it.getButton().ordinal()]) {
                case 1: {
                    this$0.view = TransformBuilderKt.buildTransform$default(null, arg_0 -> Camera2D.setupMouseEvents$lambda$3$lambda$1(it, arg_0), 1, null).times(this$0.view);
                    break;
                }
                case 2: {
                    this$0.view = TransformBuilderKt.buildTransform$default(null, arg_0 -> Camera2D.setupMouseEvents$lambda$3$lambda$2(this$0, it, arg_0), 1, null).times(this$0.view);
                    break;
                }
            }
            this$0.setDirty(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupMouseEvents$lambda$5$lambda$4(MouseEvent $it, double $scaleFactor, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($it.getPosition());
        $this$buildTransform.scale($scaleFactor);
        $this$buildTransform.translate($it.getPosition().unaryMinus());
        return Unit.INSTANCE;
    }

    private static final Unit setupMouseEvents$lambda$5(Camera2D this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getPropagationCancelled()) {
            double scaleFactor = 1.0 - it.getRotation().y() * 0.03;
            this$0.view = TransformBuilderKt.buildTransform$default(null, arg_0 -> Camera2D.setupMouseEvents$lambda$5$lambda$4(it, scaleFactor, arg_0), 1, null).times(this$0.view);
            this$0.setDirty(true);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MouseButton.values().length];
            try {
                nArray[MouseButton.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

