/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayCubemap;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.FilterKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderType;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Matrix55;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 12\u00060\u0001j\u0002`\u0002:\u00011B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J-\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020&2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010'J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$J-\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010(J-\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001eJ\b\u0010+\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020\u001eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010,\u001a\u00020-8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00062"}, d2={"Lorg/openrndr/draw/Filter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "shader", "Lorg/openrndr/draw/Shader;", "watcher", "Lorg/openrndr/draw/ShaderWatcher;", "<init>", "(Lorg/openrndr/draw/Shader;Lorg/openrndr/draw/ShaderWatcher;)V", "filterDrawStyle", "Lorg/openrndr/draw/DrawStyle;", "parameters", "", "", "", "getParameters", "()Ljava/util/Map;", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "depthBufferOut", "Lorg/openrndr/draw/DepthBuffer;", "getDepthBufferOut", "()Lorg/openrndr/draw/DepthBuffer;", "setDepthBufferOut", "(Lorg/openrndr/draw/DepthBuffer;)V", "apply", "", "source", "", "Lorg/openrndr/draw/ColorBuffer;", "target", "clip", "Lorg/openrndr/shape/Rectangle;", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "Lorg/openrndr/draw/RenderTarget;", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/RenderTarget;Lorg/openrndr/shape/Rectangle;)V", "(Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/shape/Rectangle;)V", "untrack", "destroy", "format", "Lorg/openrndr/draw/VertexFormat;", "getFormat", "()Lorg/openrndr/draw/VertexFormat;", "close", "Companion", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Filter.kt\norg/openrndr/draw/Filter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n13402#2,2:411\n13467#2,3:413\n216#3,2:416\n1#4:418\n*S KotlinDebug\n*F\n+ 1 Filter.kt\norg/openrndr/draw/Filter\n*L\n109#1:411,2\n162#1:413,3\n181#1:416,2\n*E\n"})
public class Filter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Shader shader;
    @Nullable
    private final ShaderWatcher watcher;
    @NotNull
    private final DrawStyle filterDrawStyle;
    @NotNull
    private final Map<String, Object> parameters;
    private int padding;
    @Nullable
    private DepthBuffer depthBufferOut;

    /*
     * WARNING - void declaration
     */
    public Filter(@Nullable Shader shader, @Nullable ShaderWatcher watcher) {
        void $this$filterDrawStyle_u24lambda_u240;
        DrawStyle drawStyle;
        this.shader = shader;
        this.watcher = watcher;
        DrawStyle drawStyle2 = drawStyle = new DrawStyle(null, null, null, null, null, 0.0, false, 0.0, null, null, false, null, null, null, false, null, null, null, null, null, null, null, null, 0x7FFFFF, null);
        Filter filter2 = this;
        boolean bl = false;
        $this$filterDrawStyle_u24lambda_u240.setBlendMode(BlendMode.REPLACE);
        $this$filterDrawStyle_u24lambda_u240.setDepthWrite(false);
        $this$filterDrawStyle_u24lambda_u240.setDepthTestPass(DepthTestPass.ALWAYS);
        $this$filterDrawStyle_u24lambda_u240.getStencil().setStencilTest(StencilTest.DISABLED);
        $this$filterDrawStyle_u24lambda_u240.setClip(null);
        filter2.filterDrawStyle = drawStyle;
        this.parameters = new LinkedHashMap();
    }

    public /* synthetic */ Filter(Shader shader, ShaderWatcher shaderWatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shader = null;
        }
        if ((n & 2) != 0) {
            shaderWatcher = null;
        }
        this(shader, shaderWatcher);
    }

    @NotNull
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    @Nullable
    public final DepthBuffer getDepthBufferOut() {
        return this.depthBufferOut;
    }

    public final void setDepthBufferOut(@Nullable DepthBuffer depthBuffer) {
        this.depthBufferOut = depthBuffer;
    }

    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target2, "target");
                if (target2.length == 0) break block8;
                Rectangle rectangle = clip;
                if (!Intrinsics.areEqual(rectangle != null ? Double.valueOf(rectangle.area()) : null, 0.0)) break block9;
            }
            return;
        }
        this.filterDrawStyle.setClip(clip);
        RenderTarget renderTarget = RenderTargetKt.renderTarget$default(target2[0].getWidth(), target2[0].getHeight(), target2[0].getContentScale(), null, null, Filter::apply$lambda$1, 24, null);
        ColorBuffer[] $this$forEach$iv = target2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ColorBuffer element$iv;
            ColorBuffer it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            RenderTarget.DefaultImpls.attach$default(renderTarget, it, 0, null, false, 6, null);
        }
        int n2 = target2.length;
        for (int i = 1; i < n2; ++i) {
            renderTarget.blendMode(i, BlendMode.REPLACE);
        }
        this.apply(source, renderTarget, clip);
        DepthBuffer depthBuffer = this.depthBufferOut;
        if (depthBuffer != null) {
            DepthBuffer it = depthBuffer;
            boolean bl = false;
            renderTarget.attach(it, false);
        }
        if (this.depthBufferOut != null) {
            renderTarget.detachDepthBuffer();
        }
        renderTarget.detachColorAttachments();
        renderTarget.destroy();
    }

    public static /* synthetic */ void apply$default(Filter filter2, ColorBuffer[] colorBufferArray, ColorBuffer[] colorBufferArray2, Rectangle rectangle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            rectangle = null;
        }
        filter2.apply(colorBufferArray, colorBufferArray2, rectangle);
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull ColorBuffer[] source, @NotNull RenderTarget target2, @Nullable Rectangle clip) {
        Shader shader;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        this.filterDrawStyle.setClip(clip);
        if (this.watcher != null) {
            Shader shader2 = this.watcher.getShader();
            shader = shader2;
            Intrinsics.checkNotNull(shader2);
        } else {
            Shader shader3 = this.shader;
            shader = shader3;
            Intrinsics.checkNotNull(shader3);
        }
        Shader shader4 = shader;
        target2.bind();
        if (FilterKt.access$getFilterQuad$p() == null) {
            BufferWriter bufferWriter;
            VertexBuffer fq = VertexBuffer.Companion.createDynamic(FilterKt.access$getFilterQuadFormat$p(), 6, Session.Companion.getRoot());
            BufferWriter $this$apply_u24lambda_u244 = bufferWriter = fq.getShadow().writer();
            boolean bl = false;
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 1.0));
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u244.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 1.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u244.write(new Vector2(1.0, 1.0));
            VertexBufferShadow.DefaultImpls.upload$default(fq.getShadow(), 0, 0, 3, null);
            fq.getShadow().destroy();
            FilterKt.access$setFilterQuad$p(fq);
        }
        shader4.begin();
        ColorBuffer[] $this$forEachIndexed$iv = source;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ColorBuffer item$iv : $this$forEachIndexed$iv) {
            void colorBuffer;
            int n = index$iv++;
            ColorBuffer colorBuffer2 = item$iv;
            int index = n;
            boolean bl = false;
            colorBuffer.bind(index);
            shader4.uniform("tex" + index, index);
            shader4.uniform("textureSize" + index, new Vector2(colorBuffer.getEffectiveWidth(), colorBuffer.getEffectiveHeight()));
        }
        Driver.Companion.getInstance().setState(this.filterDrawStyle);
        shader4.uniform("projectionMatrix", TransformsKt.ortho(0.0, target2.getWidth(), target2.getHeight(), 0.0, -1.0, 1.0));
        shader4.uniform("targetSize", new Vector2(target2.getWidth(), target2.getHeight()));
        shader4.uniform("padding", new Vector2(this.padding, this.padding));
        int textureIndex = 0;
        textureIndex = source.length + 0;
        Map<String, Object> $this$forEach$iv = this.getParameters();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            String uniform = entry.getKey();
            Object value = entry.getValue();
            Object object = value;
            if (object instanceof Double) {
                shader4.uniform(uniform, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Boolean) {
                shader4.uniform(uniform, (Boolean)value);
                continue;
            }
            if (object instanceof Float) {
                shader4.uniform(uniform, ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Matrix44) {
                shader4.uniform(uniform, (Matrix44)value);
                continue;
            }
            if (object instanceof Vector2) {
                shader4.uniform(uniform, (Vector2)value);
                continue;
            }
            if (object instanceof Vector3) {
                shader4.uniform(uniform, (Vector3)value);
                continue;
            }
            if (object instanceof Vector4) {
                shader4.uniform(uniform, (Vector4)value);
                continue;
            }
            if (object instanceof IntVector2) {
                shader4.uniform(uniform, (IntVector2)value);
                continue;
            }
            if (object instanceof IntVector3) {
                shader4.uniform(uniform, (IntVector3)value);
                continue;
            }
            if (object instanceof IntVector4) {
                shader4.uniform(uniform, (IntVector4)value);
                continue;
            }
            if (object instanceof ColorRGBa) {
                shader4.uniform(uniform, (ColorRGBa)value);
                continue;
            }
            if (object instanceof Integer) {
                shader4.uniform(uniform, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Matrix55) {
                shader4.uniform(uniform, ((Matrix55)value).floatArray());
                continue;
            }
            if (object instanceof float[]) {
                shader4.uniform(uniform, (float[])value);
                continue;
            }
            if (object instanceof Object[]) {
                if (((Object[])value).length <= 0) continue;
                Object object2 = ((Object[])value)[0];
                if (object2 instanceof Vector2) {
                    Object object3 = value;
                    Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector2>");
                    shader4.uniform(uniform, (Vector2[])object3);
                    continue;
                }
                if (object2 instanceof Vector3) {
                    Object object4 = value;
                    Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector3>");
                    shader4.uniform(uniform, (Vector3[])object4);
                    continue;
                }
                if (object2 instanceof Vector4) {
                    Object object5 = value;
                    Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector4>");
                    shader4.uniform(uniform, (Vector4[])object5);
                    continue;
                }
                if (object2 instanceof IntVector2) {
                    Object object6 = value;
                    Intrinsics.checkNotNull(object6, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector2>");
                    shader4.uniform(uniform, (IntVector2[])object6);
                    continue;
                }
                if (object2 instanceof IntVector3) {
                    Object object7 = value;
                    Intrinsics.checkNotNull(object7, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector3>");
                    shader4.uniform(uniform, (IntVector3[])object7);
                    continue;
                }
                if (object2 instanceof IntVector4) {
                    Object object8 = value;
                    Intrinsics.checkNotNull(object8, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.IntVector4>");
                    shader4.uniform(uniform, (IntVector4[])object8);
                    continue;
                }
                if (object2 instanceof ColorRGBa) {
                    Object object9 = value;
                    Intrinsics.checkNotNull(object9, "null cannot be cast to non-null type kotlin.Array<org.openrndr.color.ColorRGBa>");
                    shader4.uniform(uniform, (ColorRGBa[])object9);
                    continue;
                }
                if (object2 instanceof Double) {
                    Object object10 = value;
                    Intrinsics.checkNotNull(object10, "null cannot be cast to non-null type kotlin.Array<kotlin.Double>");
                    shader4.uniform(uniform, (Double[])object10);
                    continue;
                }
                if (object2 instanceof Matrix33) {
                    Object object11 = value;
                    Intrinsics.checkNotNull(object11, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Matrix33>");
                    shader4.uniform(uniform, (Matrix33[])object11);
                    continue;
                }
                if (object2 instanceof Matrix44) {
                    Object object12 = value;
                    Intrinsics.checkNotNull(object12, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Matrix44>");
                    shader4.uniform(uniform, (Matrix44[])object12);
                    continue;
                }
                Object object13 = ((Object[])value)[0];
                Intrinsics.checkNotNull(object13);
                throw new IllegalArgumentException("unsupported array value: " + Reflection.getOrCreateKotlinClass(object13.getClass()));
            }
            if (object instanceof DepthBuffer) {
                shader4.uniform(uniform, textureIndex);
                ((DepthBuffer)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof ColorBuffer) {
                shader4.uniform(uniform, textureIndex);
                shader4.uniform("textureSize" + textureIndex, new Vector2(((ColorBuffer)value).getEffectiveWidth(), ((ColorBuffer)value).getEffectiveHeight()));
                ((ColorBuffer)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof Cubemap) {
                shader4.uniform(uniform, textureIndex);
                ((Cubemap)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof ArrayCubemap) {
                shader4.uniform(uniform, textureIndex);
                ((ArrayCubemap)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (!(object instanceof BufferTexture)) continue;
            shader4.uniform(uniform, textureIndex);
            ((BufferTexture)value).bind(textureIndex);
            ++textureIndex;
        }
        Driver driver = Driver.Companion.getInstance();
        VertexBuffer vertexBuffer = FilterKt.access$getFilterQuad$p();
        Intrinsics.checkNotNull(vertexBuffer);
        Driver.DefaultImpls.drawVertexBuffer$default(driver, shader4, CollectionsKt.listOf(vertexBuffer), DrawPrimitive.TRIANGLES, 0, 6, 0, 32, null);
        shader4.end();
        target2.unbind();
    }

    public static /* synthetic */ void apply$default(Filter filter2, ColorBuffer[] colorBufferArray, RenderTarget renderTarget, Rectangle rectangle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            rectangle = null;
        }
        filter2.apply(colorBufferArray, renderTarget, rectangle);
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{source};
        ColorBuffer[] colorBufferArray2 = colorBufferArray;
        colorBufferArray = new ColorBuffer[]{target2};
        this.apply(colorBufferArray2, colorBufferArray, clip);
    }

    public static /* synthetic */ void apply$default(Filter filter2, ColorBuffer colorBuffer, ColorBuffer colorBuffer2, Rectangle rectangle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            rectangle = null;
        }
        filter2.apply(colorBuffer, colorBuffer2, rectangle);
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer[] target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{source};
        this.apply(colorBufferArray, target2, clip);
    }

    public static /* synthetic */ void apply$default(Filter filter2, ColorBuffer colorBuffer, ColorBuffer[] colorBufferArray, Rectangle rectangle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            rectangle = null;
        }
        filter2.apply(colorBuffer, colorBufferArray, rectangle);
    }

    public final void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer target2, @Nullable Rectangle clip) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        ColorBuffer[] colorBufferArray = new ColorBuffer[]{target2};
        this.apply(source, colorBufferArray, clip);
    }

    public static /* synthetic */ void apply$default(Filter filter2, ColorBuffer[] colorBufferArray, ColorBuffer colorBuffer, Rectangle rectangle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            rectangle = null;
        }
        filter2.apply(colorBufferArray, colorBuffer, rectangle);
    }

    public final void untrack() {
        block0: {
            Shader shader = this.shader;
            if (shader == null) break block0;
            Shader it = shader;
            boolean bl = false;
            Session.Companion.getActive().untrack(this.shader);
        }
    }

    public void destroy() {
        block0: {
            Shader shader = this.shader;
            if (shader == null) break block0;
            shader.destroy();
        }
    }

    @NotNull
    protected final VertexFormat getFormat() {
        return FilterKt.access$getFilterQuadFormat$p();
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static final Unit apply$lambda$1(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        return Unit.INSTANCE;
    }

    public Filter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/draw/Filter$Companion;", "", "<init>", "()V", "filterVertexCode", "", "getFilterVertexCode", "()Ljava/lang/String;", "openrndr-draw"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFilterVertexCode() {
            return Driver.Companion.getInstance().shaderConfiguration(ShaderType.VERTEX) + "\n\n#ifdef OR_IN_OUT\nin vec2 a_texCoord0;\nin vec2 a_position;\n#else\nattribute vec2 a_texCoord0;\nattribute vec2 a_position;\n#endif\n\nuniform vec2 targetSize;\nuniform vec2 padding;\nuniform mat4 projectionMatrix;\n\n#ifdef OR_IN_OUT\nout vec2 v_texCoord0;\n#else\nvarying vec2 v_texCoord0;\n#endif\n\nvoid main() {\n    v_texCoord0 = a_texCoord0;\n    vec2 transformed = a_position * (targetSize - 2.0 * padding) + padding;\n    gl_Position = projectionMatrix * vec4(transformed, 0.0, 1.0);\n}";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

