/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.antlr.v4.kotlinruntime.misc.AbstractEqualityComparator;
import org.antlr.v4.kotlinruntime.misc.MurmurHash;
import org.antlr.v4.kotlinruntime.misc.ObjectEqualityComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 O*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002OPB)\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0015\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\u0019\u0010(\u001a\u0004\u0018\u00018\u00002\b\u0010)\u001a\u0004\u0018\u00010*H\u0014\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010$J\u0016\u0010/\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\u0015\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u001d\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\n2\u0006\u00103\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u00104J%\u00105\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\n0\n2\u0006\u00103\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u00106J\u0013\u00107\u001a\u00020\"2\b\u00108\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u00109\u001a\u00020-H\u0004J\u001a\u0010:\u001a\u0004\u0018\u00018\u00002\b\u0010)\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010+J\u0015\u0010;\u001a\u00020\u00062\u0006\u0010)\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0015\u0010>\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010+J\b\u0010?\u001a\u00020\u0006H\u0016J\b\u0010@\u001a\u00020\"H\u0016J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BH\u0096\u0002J\u0015\u0010C\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010D\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\u0015\u0010E\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u0016\u0010F\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\u0011\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010HJ%\u0010G\u001a\b\u0012\u0004\u0012\u0002HI0\n\"\u0004\b\u0001\u0010I2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\n\u00a2\u0006\u0002\u0010KJ\b\u0010L\u001a\u00020MH\u0016J\u0006\u0010N\u001a\u00020MR,\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\n0\nX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0019\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016R\u0014\u0010\u001c\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010\u0016\u00a8\u0006Q"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/Array2DHashSet;", "T", "", "comparator", "Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;", "initialCapacity", "", "initialBucketCapacity", "(Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;II)V", "buckets", "", "getBuckets", "()[[Ljava/lang/Object;", "setBuckets", "([[Ljava/lang/Object;)V", "[[Ljava/lang/Object;", "getComparator", "()Lorg/antlr/v4/kotlinruntime/misc/AbstractEqualityComparator;", "currentPrime", "getCurrentPrime", "()I", "setCurrentPrime", "(I)V", "getInitialBucketCapacity", "getInitialCapacity", "n", "getN", "setN", "size", "getSize", "threshold", "getThreshold", "setThreshold", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "asElementType", "o", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "clear", "", "contains", "containsAll", "containsFast", "obj", "createBucket", "capacity", "(I)[Ljava/lang/Object;", "createBuckets", "(I)[[Ljava/lang/Object;", "equals", "other", "expand", "get", "getBucket", "(Ljava/lang/Object;)I", "getOrAdd", "getOrAddImpl", "hashCode", "isEmpty", "iterator", "", "remove", "removeAll", "removeFast", "retainAll", "toArray", "()[Ljava/lang/Object;", "U", "a", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toString", "", "toTableString", "Companion", "SetIterator", "antlr-kotlin-runtime"})
@SourceDebugExtension(value={"SMAP\nArray2DHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Array2DHashSet.kt\norg/antlr/v4/kotlinruntime/misc/Array2DHashSet\n+ 2 Assert.kt\ncom/strumenta/antlrkotlin/runtime/AssertKt\n*L\n1#1,541:1\n13#2,9:542\n*S KotlinDebug\n*F\n+ 1 Array2DHashSet.kt\norg/antlr/v4/kotlinruntime/misc/Array2DHashSet\n*L\n201#1:542,9\n*E\n"})
public class Array2DHashSet<T>
implements Set<T>,
KMutableSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractEqualityComparator<T> comparator;
    private final int initialCapacity;
    private final int initialBucketCapacity;
    @NotNull
    private T[][] buckets;
    private int n;
    private int currentPrime;
    private int threshold;
    public static final int INITIAL_CAPACITY = 16;
    public static final int INITIAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;

    public Array2DHashSet(@NotNull AbstractEqualityComparator<? super T> comparator, int initialCapacity, int initialBucketCapacity) {
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        this.comparator = comparator;
        this.initialCapacity = initialCapacity;
        this.initialBucketCapacity = initialBucketCapacity;
        this.currentPrime = 1;
        this.buckets = this.createBuckets(this.initialCapacity);
        this.threshold = (int)Math.floor((double)this.initialCapacity * 0.75);
    }

    public /* synthetic */ Array2DHashSet(AbstractEqualityComparator abstractEqualityComparator, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            abstractEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        if ((n3 & 2) != 0) {
            n = 16;
        }
        if ((n3 & 4) != 0) {
            n2 = 8;
        }
        this(abstractEqualityComparator, n, n2);
    }

    @NotNull
    protected final AbstractEqualityComparator<T> getComparator() {
        return this.comparator;
    }

    protected final int getInitialCapacity() {
        return this.initialCapacity;
    }

    protected final int getInitialBucketCapacity() {
        return this.initialBucketCapacity;
    }

    @NotNull
    protected final T[][] getBuckets() {
        return this.buckets;
    }

    protected final void setBuckets(@NotNull T[][] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "<set-?>");
        this.buckets = TArray;
    }

    protected final int getN() {
        return this.n;
    }

    protected final void setN(int n) {
        this.n = n;
    }

    protected final int getCurrentPrime() {
        return this.currentPrime;
    }

    protected final void setCurrentPrime(int n) {
        this.currentPrime = n;
    }

    protected final int getThreshold() {
        return this.threshold;
    }

    protected final void setThreshold(int n) {
        this.threshold = n;
    }

    public final T getOrAdd(T o) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(o);
    }

    protected final T getOrAddImpl(T o) {
        int b = this.getBucket(o);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            bucket = this.createBucket(this.initialBucketCapacity);
            bucket[0] = o;
            this.buckets[b] = bucket;
            int n = this.n;
            this.n = n + 1;
            return o;
        }
        int n = bucket.length;
        for (int i = 0; i < n; ++i) {
            T existing = bucket[i];
            if (existing == null) {
                bucket[i] = o;
                int n2 = this.n;
                this.n = n2 + 1;
                return o;
            }
            if (!this.comparator.equals(existing, o)) continue;
            return existing;
        }
        int oldLength = bucket.length;
        T[] TArray = Arrays.copyOf(bucket, bucket.length * 2);
        Intrinsics.checkNotNullExpressionValue(TArray, "copyOf(...)");
        bucket = TArray;
        this.buckets[b] = bucket;
        bucket[oldLength] = o;
        n = this.n;
        this.n = n + 1;
        return o;
    }

    @Nullable
    public final T get(@Nullable T o) {
        if (o == null) {
            return o;
        }
        int b = this.getBucket(o);
        T[] TArray = this.buckets[b];
        if (TArray == null) {
            return null;
        }
        for (T e : TArray) {
            if (e == null) {
                return null;
            }
            if (!this.comparator.equals(e, o)) continue;
            return e;
        }
        return null;
    }

    protected final int getBucket(T o) {
        int hash = this.comparator.hashCode(o);
        return hash & ((Object[])this.buckets).length - 1;
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize$default(MurmurHash.INSTANCE, 0, 1, null);
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int i = 0; i < n; ++i) {
            T o;
            T[] bucket = TArray[i];
            if (bucket == null) continue;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                hash = MurmurHash.INSTANCE.update(hash, this.comparator.hashCode(o));
            }
        }
        hash = MurmurHash.INSTANCE.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Array2DHashSet)) {
            return false;
        }
        return ((Array2DHashSet)other).size() == this.size() && ((Collection)this).containsAll((Collection)other);
    }

    protected final void expand() {
        T[][] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = ((Object[])this.buckets).length * 2;
        T[][] newTable = this.createBuckets(newCapacity);
        int[] newBucketLengths = new int[((Object[])newTable).length];
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        int n = ((Object[])old).length;
        for (int i = 0; i < n; ++i) {
            T o;
            T[] bucket = old[i];
            if (bucket == null) continue;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                int b = this.getBucket(o);
                int bucketLength = newBucketLengths[b];
                T[] newBucket = null;
                if (bucketLength == 0) {
                    newBucket = this.createBucket(this.initialBucketCapacity);
                    newTable[b] = newBucket;
                } else {
                    T[] TArray = newTable[b];
                    Intrinsics.checkNotNull(TArray);
                    newBucket = TArray;
                    if (bucketLength == newBucket.length) {
                        T[] TArray2 = Arrays.copyOf(newBucket, newBucket.length * 2);
                        Intrinsics.checkNotNullExpressionValue(TArray2, "copyOf(...)");
                        newBucket = TArray2;
                        newTable[b] = newBucket;
                    }
                }
                newBucket[bucketLength] = o;
                int n2 = newBucketLengths[b];
                newBucketLengths[b] = n2 + 1;
            }
        }
        boolean condition$iv = this.n == oldSize;
        Object message$iv = null;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            throw new AssertionError((Object)message$iv);
        }
    }

    @Override
    public boolean add(T element) {
        T existing = this.getOrAdd(element);
        return existing == element;
    }

    public int getSize() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public boolean contains(T element) {
        return this.containsFast(element);
    }

    public final boolean containsFast(@Nullable T obj) {
        return obj == null ? false : this.get(obj) != null;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new SetIterator(this.toArray());
    }

    @Override
    @NotNull
    public final T[] toArray() {
        T[] a = this.createBucket(this.size());
        int i = 0;
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int j = 0; j < n; ++j) {
            T o;
            T[] bucket = TArray[j];
            if (bucket == null) continue;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                a[i++] = o;
            }
        }
        return a;
    }

    @Override
    @NotNull
    public final <U> U[] toArray(@NotNull U[] a) {
        Intrinsics.checkNotNullParameter(a, "a");
        U[] a2 = a;
        if (a2.length < this.size()) {
            U[] UArray = Arrays.copyOf(a2, this.size());
            Intrinsics.checkNotNullExpressionValue(UArray, "copyOf(...)");
            a2 = UArray;
        }
        int i = 0;
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int j = 0; j < n; ++j) {
            T o;
            T[] bucket = TArray[j];
            if (bucket == null) continue;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                T targetElement = o;
                a2[i++] = targetElement;
            }
        }
        return a2;
    }

    @Override
    public boolean remove(T element) {
        return this.removeFast(this.asElementType(element));
    }

    public final boolean removeFast(@Nullable T obj) {
        if (obj == null) {
            return false;
        }
        int b = this.getBucket(obj);
        T[] TArray = this.buckets[b];
        if (TArray == null) {
            return false;
        }
        T[] bucket = TArray;
        int n = bucket.length;
        for (int i = 0; i < n; ++i) {
            T e;
            if (bucket[i] == null) {
                return false;
            }
            if (!this.comparator.equals(e, obj)) continue;
            ArraysKt.copyInto(bucket, bucket, i, i + 1, bucket.length);
            bucket[bucket.length - 1] = null;
            int n2 = this.n;
            this.n = n2 + -1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements instanceof Array2DHashSet) {
            void var3_5;
            T[][] TArray = this.buckets;
            boolean i = false;
            int n = ((Object[])TArray).length;
            while (var3_5 < n) {
                T[] bucket = TArray[var3_5];
                if (bucket != null) {
                    T o;
                    Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
                    while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                        if (this.containsFast(this.asElementType(o))) continue;
                        return false;
                    }
                }
                ++var3_5;
            }
        } else {
            for (Object object : elements) {
                if (object == null || this.containsFast(this.asElementType(object))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean changed = false;
        for (T o : elements) {
            T existing = this.getOrAdd(o);
            if (existing == o) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int newSize = 0;
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int i = 0; i < n; ++i) {
            T[] bucket = TArray[i];
            if (bucket == null) continue;
            int i2 = 0;
            int j = 0;
            while (i2 < bucket.length && bucket[i2] != null) {
                if (!CollectionsKt.contains((Iterable)elements, bucket[i2])) {
                    ++i2;
                    continue;
                }
                if (i2 != j) {
                    bucket[j] = bucket[i2];
                }
                ++i2;
                ++j;
                ++newSize;
            }
            newSize += j;
            while (j < i2) {
                bucket[j] = null;
                ++j;
            }
        }
        boolean changed = newSize != this.n;
        this.n = newSize;
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean changed = false;
        for (Object object : elements) {
            changed |= this.removeFast(this.asElementType(object));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.n = 0;
        this.buckets = this.createBuckets(this.initialCapacity);
        this.threshold = (int)Math.floor((double)this.initialCapacity * 0.75);
    }

    @NotNull
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        boolean first2 = true;
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int i = 0; i < n; ++i) {
            T o;
            T[] bucket = TArray[i];
            if (bucket == null) continue;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext() && (o = iterator2.next()) != null) {
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(", ");
                }
                buf.append(o.toString());
            }
        }
        buf.append("}");
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String toTableString() {
        StringBuilder buf = new StringBuilder();
        T[][] TArray = this.buckets;
        int n = ((Object[])TArray).length;
        for (int i = 0; i < n; ++i) {
            T[] bucket = TArray[i];
            if (bucket == null) {
                buf.append("null\n");
                continue;
            }
            buf.append("[");
            boolean first2 = true;
            Iterator<T> iterator2 = ArrayIteratorKt.iterator(bucket);
            while (iterator2.hasNext()) {
                T o = iterator2.next();
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(" ");
                }
                if (o == null) {
                    buf.append("_");
                    continue;
                }
                buf.append(o.toString());
            }
            buf.append("]\n");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Nullable
    protected T asElementType(@Nullable Object o) {
        return (T)o;
    }

    @NotNull
    protected T[][] createBuckets(int capacity) {
        return new Object[capacity][];
    }

    @NotNull
    protected T[] createBucket(int capacity) {
        return new Object[capacity];
    }

    public Array2DHashSet() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/Array2DHashSet$Companion;", "", "()V", "INITIAL_BUCKET_CAPACITY", "", "INITIAL_CAPACITY", "LOAD_FACTOR", "", "antlr-kotlin-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0084\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0014\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/Array2DHashSet$SetIterator;", "", "data", "", "(Lorg/antlr/v4/kotlinruntime/misc/Array2DHashSet;[Ljava/lang/Object;)V", "getData$antlr_kotlin_runtime", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "nextIndex", "", "getNextIndex$antlr_kotlin_runtime", "()I", "setNextIndex$antlr_kotlin_runtime", "(I)V", "removed", "", "getRemoved$antlr_kotlin_runtime", "()Z", "setRemoved$antlr_kotlin_runtime", "(Z)V", "hasNext", "next", "()Ljava/lang/Object;", "remove", "", "antlr-kotlin-runtime"})
    protected final class SetIterator
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final T[] data;
        private int nextIndex;
        private boolean removed;

        public SetIterator(T[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            this.data = data;
            this.removed = true;
        }

        @NotNull
        public final T[] getData$antlr_kotlin_runtime() {
            return this.data;
        }

        public final int getNextIndex$antlr_kotlin_runtime() {
            return this.nextIndex;
        }

        public final void setNextIndex$antlr_kotlin_runtime(int n) {
            this.nextIndex = n;
        }

        public final boolean getRemoved$antlr_kotlin_runtime() {
            return this.removed;
        }

        public final void setRemoved$antlr_kotlin_runtime(boolean bl) {
            this.removed = bl;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            int n = this.nextIndex;
            this.nextIndex = n + 1;
            return this.data[n];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            Array2DHashSet.this.remove(this.data[this.nextIndex - 1]);
            this.removed = true;
        }
    }
}

