/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import lib.OrientationTranslation;
import lib.ParametricPoseProvider;
import lib.PosePathKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.shapes.frames.Path3DExtensionsKt;
import org.openrndr.extra.shapes.rectify.RectifiedPath3D;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Quaternion;
import org.openrndr.math.QuaternionKt;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Llib/PosePath3D;", "Llib/ParametricPoseProvider;", "path", "Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "up", "Lorg/openrndr/math/Vector3;", "<init>", "(Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;Lorg/openrndr/math/Vector3;)V", "getPath", "()Lorg/openrndr/extra/shapes/rectify/RectifiedPath3D;", "frames", "", "Lorg/openrndr/math/Quaternion;", "getFrames", "()Ljava/util/List;", "pose", "Lorg/openrndr/math/Matrix44;", "t", "", "blendPose", "offset", "blend", "deminityy"})
@SourceDebugExtension(value={"SMAP\nPosePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosePath.kt\nlib/PosePath3D\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1557#2:69\n1628#2,3:70\n*S KotlinDebug\n*F\n+ 1 PosePath.kt\nlib/PosePath3D\n*L\n29#1:69\n29#1:70,3\n*E\n"})
public final class PosePath3D
implements ParametricPoseProvider {
    @NotNull
    private final RectifiedPath3D path;
    @NotNull
    private final List<Quaternion> frames;

    public PosePath3D(@NotNull RectifiedPath3D path, @NotNull Vector3 up) {
        Matrix44 it;
        Collection<Double> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(up, "up");
        this.path = path;
        Iterable iterable = this.path.getPoints();
        Object object = this.path;
        PosePath3D posePath3D = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)((Pair)((Object)it)).getSecond()).doubleValue());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = Path3DExtensionsKt.frames((RectifiedPath3D)object, (List<Double>)collection, up, false);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Matrix44)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(Quaternion.Companion.fromMatrix(it.matrix33()));
        }
        posePath3D.frames = (List)destination$iv$iv;
    }

    public /* synthetic */ PosePath3D(RectifiedPath3D rectifiedPath3D, Vector3 vector3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vector3 = Vector3.Companion.getUNIT_Y();
        }
        this(rectifiedPath3D, vector3);
    }

    @NotNull
    public final RectifiedPath3D getPath() {
        return this.path;
    }

    @NotNull
    public final List<Quaternion> getFrames() {
        return this.frames;
    }

    @Override
    @NotNull
    public Matrix44 pose(double t) {
        Matrix44 matrix44;
        Matrix44 tr = TransformsKt.translate(Matrix44.Companion, (Vector3)this.path.position(t));
        Vector3 direction = (Vector3)((Vector3)this.path.direction(t)).getNormalized();
        if (t <= 0.0) {
            matrix44 = PosePathKt.findFrame(direction, this.frames.get(0).times(Vector3.Companion.getUNIT_Y()));
        } else if (t >= 1.0) {
            matrix44 = PosePathKt.findFrame(direction, CollectionsKt.last(this.frames).times(Vector3.Companion.getUNIT_Y()));
        } else {
            double t0 = t * (double)this.frames.size();
            int i0 = RangesKt.coerceIn((int)t0, CollectionsKt.getIndices((Collection)this.frames));
            int i1 = RangesKt.coerceIn(i0 + 1, CollectionsKt.getIndices((Collection)this.frames));
            double f = t0 - (double)i0;
            Quaternion o0 = this.frames.get(i0);
            Quaternion o1 = this.frames.get(i1);
            Quaternion o = QuaternionKt.slerp(o0, o1, f);
            matrix44 = PosePathKt.findFrame(direction, o.times(Vector3.Companion.getUNIT_Y()));
        }
        return tr.times(matrix44);
    }

    @NotNull
    public final Matrix44 blendPose(double t, double offset, double blend) {
        OrientationTranslation p0 = PosePathKt.decompose(this.pose(t));
        OrientationTranslation p1 = PosePathKt.decompose(this.pose(t + offset));
        Quaternion q0 = Quaternion.Companion.fromMatrix(p0.getOrientation());
        Quaternion q1 = Quaternion.Companion.fromMatrix(p1.getOrientation());
        Quaternion q = QuaternionKt.slerp(q0, q1, blend);
        return TransformBuilderKt.buildTransform$default(null, arg_0 -> PosePath3D.blendPose$lambda$2(p0, q, arg_0), 1, null);
    }

    private static final Unit blendPose$lambda$2(OrientationTranslation $p0, Quaternion $q, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($p0.getTranslation());
        $this$buildTransform.rotate($q);
        return Unit.INSTANCE;
    }
}

