/*
 * Decompiled with CFR 0.152.
 */
package demo.view.objects;

import demo.model.Layer;
import demo.view.IObjectView;
import demo.view.LayerView;
import demo.view.objects.ObjectInputType;
import demo.view.objects.ObjectOutputType;
import demo.view.objects.ObjectTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import lib.ParametricPoseProvider;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;

@ObjectTypeName(name="pose-transform")
@ObjectInputType(type=ParametricPoseProvider.class)
@ObjectOutputType(type=Matrix44.class)
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020!0 0\u001fH\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Ldemo/view/objects/PoseTransformObjectView;", "Ldemo/view/IObjectView;", "obj", "Ldemo/model/Layer$Object;", "layerView", "Ldemo/view/LayerView;", "<init>", "(Ldemo/model/Layer$Object;Ldemo/view/LayerView;)V", "getObj", "()Ldemo/model/Layer$Object;", "getLayerView", "()Ldemo/view/LayerView;", "renderable", "", "getRenderable", "()Z", "outputFunction", "", "getOutputFunction", "()Ljava/lang/String;", "input", "", "Llib/ParametricPoseProvider;", "x", "", "count", "", "offset0", "offset1", "offsetBlend", "builtInFunctions", "", "Lkotlin/Function1;", "", "close", "", "deminityy"})
@SourceDebugExtension(value={"SMAP\nPoseTransformObjectView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoseTransformObjectView.kt\ndemo/view/objects/PoseTransformObjectView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1368#2:92\n1454#2,2:93\n1557#2:95\n1628#2,3:96\n1456#2,3:99\n*S KotlinDebug\n*F\n+ 1 PoseTransformObjectView.kt\ndemo/view/objects/PoseTransformObjectView\n*L\n75#1:92\n75#1:93,2\n76#1:95\n76#1:96,3\n75#1:99,3\n*E\n"})
public final class PoseTransformObjectView
extends IObjectView {
    @NotNull
    private final Layer.Object obj;
    @NotNull
    private final LayerView layerView;
    private final boolean renderable;

    public PoseTransformObjectView(@NotNull Layer.Object obj, @NotNull LayerView layerView) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(layerView, "layerView");
        this.obj = obj;
        this.layerView = layerView;
    }

    @Override
    @NotNull
    public Layer.Object getObj() {
        return this.obj;
    }

    @Override
    @NotNull
    public LayerView getLayerView() {
        return this.layerView;
    }

    @Override
    public boolean getRenderable() {
        return this.renderable;
    }

    @Override
    @NotNull
    protected String getOutputFunction() {
        return "transform";
    }

    @NotNull
    public final List<ParametricPoseProvider> input(double x) {
        Function1<Double, Object> function1 = this.getFunctions1().get("input");
        Function1<Double, Object> input = TypeIntrinsics.isFunctionOfArity(function1, 1) ? function1 : null;
        return input == null ? CollectionsKt.emptyList() : (List)input.invoke(x);
    }

    public final int count(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("count");
        return function1 != null ? MathKt.roundToInt(((Number)function1.invoke(x)).doubleValue()) : 1;
    }

    public final double offset0(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("offset-0");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.0;
    }

    public final double offset1(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("offset-1");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.0;
    }

    public final double offsetBlend(double x) {
        Function1<Double, Double> function1 = this.getSamplers().get("offset-blend");
        return function1 != null ? ((Number)function1.invoke(x)).doubleValue() : 0.0;
    }

    @Override
    @NotNull
    public Map<String, Function1<Double, Object>> builtInFunctions() {
        return MapsKt.mapOf(TuplesKt.to("transform", arg_0 -> PoseTransformObjectView.builtInFunctions$lambda$2(this, arg_0)));
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List builtInFunctions$lambda$2(PoseTransformObjectView this$0, double x) {
        void $this$flatMapTo$iv$iv;
        int count2 = this$0.count(x);
        double offsetBlend = this$0.offsetBlend(x);
        Iterable $this$flatMap$iv = this$0.input(x);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ParametricPoseProvider pose = (ParametricPoseProvider)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = RangesKt.until(0, count2);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                double d;
                double offset1;
                void instance;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                double f = count2 >= 1 ? (double)instance / ((double)count2 - 1.0) : 0.0;
                double offset0 = this$0.offset0(f);
                double offset = MappingKt.mix(offset0, offset1 = this$0.offset1(f), offsetBlend);
                double d2 = x + offset;
                double d3 = d2 % (d = 1.0);
                collection.add(pose.pose(!(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d)) ? d3 + d : d3));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

