;
;======================================================================================================================
; JOSEF K AND THE CATHODIC-GUILLOTINE (KNOWN AS THE UGLY DEMO)
;======================================================================================================================
; 
;  CODE & VISUALS: IXISTENZ/LA1N (info@la1n.ch)
;  MUSIC: COMPUTERMUSIKER
;
; AREA: EXPERIMENTAL ARCHEOLOGY
; RESEARCH: - WHY NO UGLY DEMOS 
;           - WHY NO KNOWN-CULTURE
;           - WHY NOT ART OF 80/90ies 
;           - WHY OFTEN NO ABSTRACTION vs DEMO-ABSTRACTION (TECHNO?)
;           - WYH NO SOURCE-CODE IN DEMOS?
;
;======================================================================================================================
; made with and for VisualStudioCode and Amiga-Assembly-Modul 
;======================================================================================================================

; More ideas (not released):
; CATHODIC BEAM ... 
; Digitale Krankheiten ... PIXEL ... THE DEMO DIED

			;======================================================================================================================
			; FS-UAE (Emulator):
			;
			; (FS-LUAE: Ctrl+w > fast forward)
			; Ctrl+return > fullscrren
			; Ctrl+A > several times > real fullscreen
			; Command: pause/resum
			;
			;======================================================================================================================

			; ---------------------
			; TITLE-SCREEN
			; ---------------------
			; Image-Data
			; C_DATA.s
			; - exported by https://www.stef.be/dpaint/ (chrome) > load it > Save as > planes
			; colors:
			; colors.S (automatic)
			; - exported by https://www.stef.be/dpaint/ > Save as > planes > .palette.xt
			; > colorsTitle.s update manual!!! 

			; if you export a picture 
			; than change colors (> PALETTE)

			; if you wanna use the 'scrolltext', you need to have 1 as the white color
			; > 1. go to palette (menu) > from image 2. edit palette 2.1 swap color 
			; > 2.2 lock 2.3. reduce?

			; ---------------------
			; BLOCKS
			; ---------------------
			; use Processing-Tool


			; ---------------------
			; CODING
			; ---------------------
			; ATTENTION: DONT USE D7,D6,A7,A& 
			; IS SOMEHOW NEEDED BY MUSIC AND MOUSE

			; ------------------------------
			; 68000 KNOWHOW
			; ------------------------------

			; 68k online ausprobieren
			; https://asm-editor.specy.app/projects/GuILvBB

			; CLR.[B/W/L]
			; ADD.[B/W/L]
			; SUB.[B/W/L]
			; MOVE.[B/W/L]
			; SWAP.[B/W/L]

			; WITHOUT .B/W/L > WORD
			; MOVE #4,d0 MEANS MOVE.W #4,d0!!!

			; MULTIPLY:
			; ROL ETC 
			; DIV[U|S] / (int)   W1: RESULT  W2: REST %
			; MUL[U|S] * (int)
			;
			; Data-Register: d0-d7
			; Adress-Register: a0-a7
			; 
			; CMP.[B/W/L]
			; BNE/BEQ etc.
			;
			; UNSIGMED
			; BHI.w >
			; BCS.w <
			;
			; SIGNED
			; BGT.w >
			; BLT.w <
			;

			;         even
			; label:  must be even for 68k!

			; DBRA: FOR-NEXT
			;    move.l #10
			; lab:
			;    dbra d0,lab

			; ------------------
			; errors/failures
			; ------------------
			; cmp.l xyz,d0  ; < d0 and xyz not long!!!


			;
			; COPPER - graphic processor binded to crt-raster
			;
			; If you install a copper list, this will be executed forever! 
			; but you can put labels and write direct there !
			;
			; commands WAIT,MOVE,SKIP
			;  
			;
			; water ... 
			;		; data, command
			;		; will be always executed
			;		DC.W    $9601,$FF00 	; wait for line 150
			;		dc.w	$0180,$0fff   ; set color

; ------------------
; DEFAULT CONSTS
; ------------------

BLTDDAT	=0	;result of the last word. used for bob collision detection and 
		;MFM decoding
DMACONR	=2	;bit 14=blitter busy flag

BLTCON0	=$40	;blitter operation setup
BLTCON1	=$42
BLTAFWM	=$44
BLTALWM	=$46

BLTCPTH	=$48	;sources, destination, and size
BLTCPTL	=$4a
BLTBPTH	=$4c
BLTBPTL	=$4e
BLTAPTH	=$50
BLTAPTL	=$52
BLTDPTH	=$54
BLTDPTL	=$56

BLTSIZE	=$58

BLTCON0L=$5a	;ECS/AGA registers
BLTSIZV	=$5c
BLTSIZH	=$5e

BLTCMOD	=$60	;modulos
BLTBMOD	=$62

BLTAMOD	=$64 ; 108
BLTDMOD	=$66 ; 

; BLTDMOD	=$66 ; 
; BLTDMOD	=$66 ; 



BLTCDAT	=$70	;data to replace sources
BLTBDAT	=$72
BLTADAT	=$74



DMACON	=$96	;bit 6: enable blitter DMA. bit 10: give blitter priority over
		;the CPU.


; ------------------
; DEMO CODE
; ------------------

; music
musicMode equ 1 ; music on 1 off 0

; font mask
createFontMask equ 1 ; create font mask automatic (black is transparent) otherwise paint it .-)

; mouse active in menu?
MouseMenuActive equ 1

; screenfactor
screenFactorWidth = 1
screenFactorHeight = 3





	section	GameCode,CODE_P

;======================================================================================================================
; Startup File
; Makes sure we take control of the OS the proper way
;======================================================================================================================

	include	"lib/startup.s"

;======================================================================================================================
; Which DMAs we will enable
;
; 15	SET/CLR	Set/Clear control bit.
;				Determines if bits written with a 1 get set or cleared
;			    Bits written with a zero are unchanged
; 14	BBUSY	Blitter busy status bit (read only)
; 13	BZERO	Blitter logic zero status bit (read only)
; 12	X	
; 11	X	
; 10	BLTPRI	Blitter DMA priority (also called "blitter nasty" for stealing from CPU)
; 09	DMAEN	Enable all DMA below (also UHRES DMA)
; 08	BPLEN	Bit plane DMA enable
; 07	COPEN	Coprocessor DMA enable
; 06	BLTEN	Blitter DMA enable
; 05	SPREN	Sprite DMA enable
; 04	DSKEN	Disk DMA enable
; 03	AUD3EN	Audio channel 3 DMA enable
; 02	AUD2EN	Audio channel 2 DMA enable
; 01	AUD1EN	Audio channel 1 DMA enable
; 00	AUD0EN	Audio channel 0 DMA enable
;======================================================================================================================

								;5432109876543210
DMASET					equ		%1000001110101111	; Enable Copper, Bitplane DMA, Sprite DMA, Sound DMA

WaitDisk				equ		30		; Defined in Startup.s : Time to wait 50-150 to save/load (50 = 1 second in Pal system)


;======================================================================================================================
; Main Program Start
;======================================================================================================================

border_offset = 32 ; border around ...
		; border_offset_blt1 = border_offset/4
border_offset_byte = border_offset/8
border_offset_word = border_offset/16 ; tiles
address_screen_addframe =  border_offset_byte;  + 8*(320/8);  +  +border_offset_byte*(320+2*border_offset)/8 

;======================================================================================================================
; memory organisation
;======================================================================================================================
; screen 256
; screen 256+: screenbuffer for music
; screen 256+16+: guillotine design

;======================================================================================================================
; memory 
;======================================================================================================================

; 256 - 256+16 used for the incoming guillotine!

; guillotine 0
dguillotinePosition = 256+16 ; memory

; guillotine 1 ...
dguillotinePosition1 = 256+32 ; memory ; 288
dguillotinePosition2 = 256+32+16 ; memory

; scrolltext

; textbuffer
dtextBackground = 256+80-16
dtextbufferMemory = 256+80
dtextbuffer = 256+80

dtilesGuillotine = 512
dtilesGuillotine1 = 608

dtilesGuillotine2 = 624+16-32

dtilesPlayfield = 512+16


; textbuffer+16 < mask


;======================================================================================================================
; Libs und co
;======================================================================================================================

; Libs
		include	"Source/Constants.s"
		include	"Source/Utils.s"
		include	"Lib/music.s"


START:
		;--------------------------------------------------------------------------------------------------------------
		; Saving everything for startup file
		;--------------------------------------------------------------------------------------------------------------

		movem.l	d0-d7/a0-a6,-(SP)

		; bsr.w	WaitForRaster

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		; DMA Set / Enable
		move.w	#DMASET,$96(a5)		; DMACON - Enable Bitplane, Copper DMA, Sprties

		; Disable AGA for compatibility
		move.w	#0,$1fc(a5)			; Disable AGA
		move.w	#$c00,$106(a5)		; Disable AGA
		move.w	#$11,$10c(a5)		; Disable AGA

		; ----------------------
		; BLITTER ENABLING
		; ----------------------
		move.w #$8040,$dff096 ; enable blitter
		; move.w #$87e0,$dff096
		
		;--------------------------------------------------------------------------------------------------------------
		; Init Main Game Screen
		; This only need to be initialised once
		;--------------------------------------------------------------------------------------------------------------

		; bsr.w	InitBitPlanes
		; bsr.w	InitColours

	

		;--------------------------------------------------------------------------------------------------------------
		; Init the Intro Screen
		;--------------------------------------------------------------------------------------------------------------

		; Init the Intro Screen Bitplanes and Colours
		; bsr.w	InitIntroScr  ; wird nachträglich gemacht!
		; bsr.w	SetIntroCol	

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		;--------------------------------------------------------------------------------------------------------------
		; ENABLE COPPER
		;--------------------------------------------------------------------------------------------------------------
		lea		$dff000,a5
		move.l	#CopperList,$80(a5)	; Point to our copper


		;--------------------------------------------------------------------------------------------------------------
		; Init Bitplanes
		;--------------------------------------------------------------------------------------------------------------

		move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes				; Set the Bitplane Pointers

		;--------------------------------------------------------------------------------------------------------------
		; Init Music
		;--------------------------------------------------------------------------------------------------------------

		IF musicMode
			bsr.w	mt_init
		ENDIF


		;--------------------------------------------------------------------------------------------------------------
		; Colors
		;--------------------------------------------------------------------------------------------------------------
		jsr updateColors

		; jsr colorsToGameColors

		; -----------------------------
		; create mask for 
		; font 
		; -----------------------------
		IF createFontMask


				move.l #2,d6

				move.l #screen,a0
				add.l #(512-6*16)*(64+320)/8,a0

			lines3:

				move.l #(320+64)*16/8,d3
			xorit:

				; plane 0
				clr.l d0
				move.b (a0),d0			
				move.l a0,a1
				; plane 1
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0
				; plane 2
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0
				; plane 3
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0

				; store
				move.l a0,a2
				add.l  #16*(320+64)/8,a2
;				move.b #111,(a2)
				move.b d0,(a2)

				add.l #1,a0
				dbra d3,xorit


				add.l #16*(64+320)/8,a0

				dbra d6,lines3

		ENDIF

		;--------------------------------------------------------------------------------------------------------------
		; setup borders & co
		;--------------------------------------------------------------------------------------------------------------
		; https://www.amigarealm.com/computing/knowledge/hardref/ch3.htm#:~:text=The%20register%20DIWSTRT%20(for%20%22Display,DIWSTRT%20for%20a%20basic%20playfield.
		; display area
		; 
		; []
		; low-resolution:
		; playfield 320x200 

		move.w #border_offset_byte*2,screenoffset_x_borderleft ; odd  ; border_offset_byte
		move.w #border_offset_byte*2,screenoffset_x_borderright ; even

		move.w #0,scrollX
		move.w #0,scrollY
;		move.w #256,scrollY
		jsr updateCameraAndScrolling

		; move.w    $DFF006,$DFF180 ; background

		; up & down 
		move.w #1,direction

		; ------------------
		; some democode
		; ------------------
		; more complex than in the code
		; in the demo of course (32 pixels border)
;			move.l #screen+(320+2*32)/8*(238),a0;  screen-address:
;			move.l #screen+(320+2*32)/8*(256+239),a1 ; screen-address:
;			move.l #screen+(320+2*32)/8*(256*2+240),a2 ; screen-address:
;			move.l #screen+(320+2*32)/8*(256*3+241),a3 ; screen-address:

;			move.l #(320+2*32)/8,d3	; bytes of one line * 8 
;		copyfor: 						; jump 
;			move.b #%011001010,(a0)+    ; set the pixels activ 
;			move.b #%011001010,(a1)+    ; set the pixels activ 
;			move.b #%011001010,(a2)+    ; set the pixels activ 
;			move.b #%011001010,(a3)+    ; set the pixels activ 
;			dbra d3,copyfor				; d3 = d3-1 ; if (d3>0) jmp copfor

scrollTextY = 256-22



		; ------------------
		; sin thing ... 
		; ------------------
		;move.w #768-85,copySourceY
		;move.w #85,copyTargetY
		;move.w #80,copyHeight
		;move.w #1,copyBitplane
		;jsr copySliceVertical		
		;move.w #0,copyBitplane
		;move.w #16,copyHeight

		; ------------------------
		; guillotine!
		; ------------------------
		jsr genenerateGuillotine

		; ------------------------
		; copy scroll background
		; ------------------------
		move.w #scrollTextY,copySourceY
		move.w scrollerPositionY,copySourceY
		move.w #dtextBackground,copyTargetY
		jsr copySliceVertical		

		; debug
	;	move.l #5,stageStage


		; wait
		move.l #7*25,d4
		jsr timeToWait

; ------------------
demoloop:
; ------------------

		; -----------------
		; vsync
		; -----------------
		bsr.w	WaitForRaster
		
		; -----------------
		; keyboard
		; -----------------
		jsr _keyboard

		; --------------------
		; mouse interactions
		; --------------------
		jmp nomouse_interactions
	
			btst   #6,$BFE001      
			bne   if_mouseclicked

				cmp.l #1,clicked
				beq eee
					move.w #0,scrollX
					cmp.w #0,scrollY
					bne gbto
						move.w #256,scrollY
						jmp xtl
					gbto:
					cmp.w #256,scrollY
					bne gbt 
						move.w #512,scrollY
						jmp xtl
					gbt:
					cmp.w #512,scrollY
					bne gbtx 
						move.w #0,scrollY
						jmp xtl
					gbtx:

	;				move.w #256,scrollY
					xtl:
					jsr updateCameraAndScrolling

				eee:

				jmp if_mouseclicked_e

			if_mouseclicked:
				move.l #0,clicked
			if_mouseclicked_e:

		nomouse_interactions:

		; -----------------
		; music
		; -----------------
		IF musicMode
			bsr.w	mt_music
		ENDIF

		



		; ---------------------------------------
		; RENDER STAGE & HANDLE STAGES
		; ---------------------------------------

		; -----------------------
		; STAGE 0
		; CLEAR TITLE 
		; -----------------------
		cmp.l #0,stageStage
		bne   if_stage_0

			; GUILLOTINE 0 RENDER IT
			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; HANDLE GUILLOTINE 0 
			add.w #1,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo0

				; handling
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

				add.l #1,stageCounter
				cmp.l #1,stageCounter
				bne if_stage_0
						move.l #1,stageStage
						move.l #0,stageCounter
			restart_guillo0:
		if_stage_0:

		; -----------------------
		; STAGE 1
		; FASTER FASTER
		; -----------------------
		cmp.l #1,stageStage
		bne   if_stage_1

			; GUILLOTINE 0 RENDER IT

			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			sub.w #1,copyTargetY
			move.w #1,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #2,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo1
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

				add.l #1,stageCounter
				cmp.l #2,stageCounter
				bne if_stage_0
						move.l #2,stageStage
						move.l #0,stageCounter
				
			restart_guillo1:

		if_stage_1:

		; -----------------------
		; STAGE 2
		; SOURCE CODE
		; -----------------------
		cmp.l #2,stageStage
		bne   if_stage_2

			; GUILLOTINE 0 RENDER IT
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			sub.w #1,copyTargetY
			move.w #1,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #2,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo2
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

codeScreenStartY = 80
codeOffscreenStartY = 657
codeScreenSize = 3*256-657

				; copy the code here
				;move.w #codeOffscreenStartY,copySourceY
				;move.w #256-codeScreenSize,copyTargetY
				;move.w #codeScreenSize,copyHeight
				;jsr copyBitplaneVertical
				;move.l #0,tmpScreenAddressAddOn
				;move.w #16,copyHeight
				add.l #1,stageCounter
				cmp.l #2,stageCounter
				bne restart_guillo2
						move.l #4,stageStage
						move.l #0,stageCounter
			restart_guillo2:

			; copy the code here
			move.w #codeScreenSize+10,d0
			cmp.w guillotine,d0
			blt if_biggerthan_bottom

				move.w #codeOffscreenStartY+codeScreenSize,d0
				sub.w guillotine,d0
				move.w d0,copySourceY
				move.w #256,d0
				sub.w guillotine,d0
				move.w d0,copyTargetY
				move.w #2,copyHeight
				jsr copyBitplaneVertical
				move.l #0,tmpScreenAddressAddOn
				move.w #16,copyHeight
				jmp if_biggerthan_bottom_E
			if_biggerthan_bottom:
						; jsr rainbow
			if_biggerthan_bottom_E:

			; GUILLOTINE 1 RENDER IT
			move.w #dguillotinePosition1,copySourceY
			move.w guillotine1,d0
			move.w d0,copyTargetY
			move.w #16,copyHeight
			move.l #BitplaneSizeWide,tmpScreenAddressAddOn
			jsr copyBitplaneVertical
			move.l #0,tmpScreenAddressAddOn
			move.w #16,copyHeight						
		if_stage_2:		


		; -----------------------
		; STAGE 3
		; DOUBLE BEAM
		; NOT USED!!
		; -----------------------
		cmp.l #3,stageStage
		bne   if_stage_3

			; GUILLOTINE 0 RENDER IT
			; move.w #dguillotinePosition,copySourceY
			; move.w guillotine,copyTargetY
			; sub.w #1,copyTargetY
			; move.w #1,copyHeight
			; jsr copyBitplaneVertical
			;  move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #1,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo3
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

				add.l #1,stageCounter
				cmp.l #2,stageCounter
				bne restart_guillo3
						move.l #4,stageStage
						move.l #0,stageCounter
			restart_guillo3:

			; GUILLOTINE 1 RENDER IT
			move.w #dguillotinePosition1,copySourceY
			move.w guillotine1,d0
			move.w d0,copyTargetY
			move.w #16,copyHeight
			move.l #BitplaneSizeWide,tmpScreenAddressAddOn
			jsr copyBitplaneVertical
			move.l #0,tmpScreenAddressAddOn
			move.w #16,copyHeight	


			; GUILLOTINE 1 RENDER IT

			move.w #dguillotinePosition1+2,copySourceY
			move.w guillotine1,d0
			sub.w  #1,d0
			move.w d0,copyTargetY
			move.w #1,copyHeight
			move.l #BitplaneSizeWide,tmpScreenAddressAddOn
			jsr copyBitplaneVertical
			move.l #0,tmpScreenAddressAddOn
			move.w #16,copyHeight

			; ... 
			move.w #dguillotinePosition1+2,copySourceY
			move.w guillotine1,d0
			move.w d0,copyTargetY
			move.w #16,copyHeight
			move.l #BitplaneSizeWide,tmpScreenAddressAddOn
			jsr copyBitplaneVertical
			move.l #0,tmpScreenAddressAddOn
			move.w #16,copyHeight

			; HANDLE guillotine 1
			add.w #2,guillotine1
			cmp.w #256,guillotine1
			blt   restart_guillo21
				; move.w #0,guillotine
				move.w #0,guillotine1
				jsr genenerateGuillotine1			

			restart_guillo21:
			noguillotine1_here:			

								
		if_stage_3:		

		; -----------------------
		; STAGE 4
		; ADD CIRCLES
		; -----------------------
		cmp.l #4,stageStage
		bne   if_stage_4

			; GUILLOTINE 0 RENDER IT
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			sub.w #2,copyTargetY
			move.w #1,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			sub.w #1,copyTargetY
			move.w #1,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight


			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #3,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo4
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

				add.l #1,stageCounter
				cmp.l #2,stageCounter
				bne restart_guillo4
						move.l #5,stageStage
						move.l #0,stageCounter
			restart_guillo4:
		
		if_stage_4:

		; -----------------------
		; STAGE 5
		; PICTURES
		; -----------------------
		cmp.l #5,stageStage
		bne   if_stage_5

			; GUILLOTINE 0 RENDER IT
		;	move.w #dguillotinePosition,copySourceY
		;	move.w guillotine,copyTargetY
		;	sub.w #1,copyTargetY
		;	move.w #1,copyHeight
		;	jsr copyBitplaneVertical
		;	move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #1,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo5
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine
				; jsr genenerateGuillotine1Fallbeil

				jsr renderLevel
				add.l #1,level

				; add.l #1,stageCounter
				cmp.l #25,level
				bne restart_guillo5
						move.l #6,stageStage
						move.l #0,stageCounter
			restart_guillo5:		
		if_stage_5:


		; -----------------------
		; STAGE 6
		; SOURCE CODE
		; -----------------------
		cmp.l #6,stageStage
		bne   if_stage_6

			; GUILLOTINE 0 RENDER IT
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			sub.w #1,copyTargetY
			move.w #1,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #2,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo26
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine	

				; copy the code here
				;move.w #codeOffscreenStartY,copySourceY
				;move.w #256-codeScreenSize,copyTargetY
				;move.w #codeScreenSize,copyHeight
				;jsr copyBitplaneVertical
				;move.l #0,tmpScreenAddressAddOn
				;move.w #16,copyHeight
				add.l #1,stageCounter
				cmp.l #7,stageCounter
				bne restart_guillo26
						move.l #7,stageStage
						move.l #0,stageCounter
			restart_guillo26:

			move.l stageCounter,d0
			divu #3,d0
			swap d0
			ext.l d0

			; %7 == 0
			cmp #0,d0
			bne if_stage_6

			; copy the code here
			move.w #codeScreenSize+10,d0
			cmp.w guillotine,d0
			blt if_biggerthan_bottom6

				move.w #codeOffscreenStartY+codeScreenSize,d0
				sub.w guillotine,d0
				move.w d0,copySourceY
				move.w #256,d0
				sub.w guillotine,d0
				move.w d0,copyTargetY
				move.w #2,copyHeight
				jsr copyBitplaneVertical
				move.l #0,tmpScreenAddressAddOn
				move.w #16,copyHeight
				jmp if_biggerthan_bottom_E6
			if_biggerthan_bottom6:
						; jsr rainbow
			if_biggerthan_bottom_E6:

			; GUILLOTINE 1 RENDER IT
			move.w #dguillotinePosition1,copySourceY
			move.w guillotine1,d0
			move.w d0,copyTargetY
			move.w #16,copyHeight
			move.l #BitplaneSizeWide,tmpScreenAddressAddOn
			jsr copyBitplaneVertical
			move.l #0,tmpScreenAddressAddOn
			move.w #16,copyHeight	

		if_stage_6:

		; endless through the memory
		; -----------------------
		; STAGE 7
		; PICTURES
		; -----------------------
		cmp.l #7,stageStage
		bne   if_stage_7

			; GUILLOTINE 0 RENDER IT
		;	move.w #dguillotinePosition,copySourceY
		;	move.w guillotine,copyTargetY
		;	sub.w #1,copyTargetY
		;	move.w #1,copyHeight
		;	jsr copyBitplaneVertical
		;	move.w #16,copyHeight

			; move.w #scrollTextY,copySourceY
			move.w #dguillotinePosition,copySourceY
			move.w guillotine,copyTargetY
			move.w #16,copyHeight
			jsr copyBitplaneVertical
			move.w #16,copyHeight

			; GUILLOTINE 0 HANDLING
			add.w #1,guillotine
			cmp.w #256,guillotine
			blt   restart_guillo7
				; move.w #0,guillotine
				move.w #0,guillotine
				move.w #0,scrollerDownInterruptedFlag	
				jsr genenerateGuillotine
				; jsr genenerateGuillotine1Fallbeil

				jsr renderLevel
				add.l #1,level

				; add.l #1,stageCounter
				cmp.l #40,level
				bne restart_guillo7
						move.l #5,stageStage
						move.l #0,level
						move.l #0,stageCounter
			restart_guillo7:		
		if_stage_7:


; --------------------------------
		jmp demoloop
; --------------------------------

		bsr.w	mt_end

		; ---------------------------
		; BACK TO AMIGADOS
		; ---------------------------

;		movem.l	d0-d7/a0-a6,-(SP)
		movem.l	(SP)+,d0-d7/a0-a6

		rts

; ---------------------------
; demo specific
; ---------------------------
genenerateGuillotine:

				; ----------------------
				; fallbeil design
				; ----------------------
					move.l #20,d4
					move.l #32,d3
				cpxy:				
					; move.w d3,copySourceX

					move.l #0,d0
					jsr RndA 
					divu #20,d0
					swap d0
					ext.l d0
					mulu #16,d0
					add.l #32,d0
					move.w d0,copySourceX

					move.w #dtilesGuillotine,copySourceY
					move.w d3,copyTargetX
					move.w #dguillotinePosition,copyTargetY
					add.l #16,d3
					jsr copyBlock16
					dbra d4,cpxy

			rts

genenerateGuillotine1:

				; ----------------------
				; fallbeil design
				; ----------------------
					move.l #20,d4
					move.l #32,d3
				cpxyx:				
					; move.w d3,copySourceX

					move.l #0,d0
					jsr RndA 
					divu #20,d0
					swap d0
					ext.l d0
					mulu #16,d0
					add.l #32,d0
					move.w d0,copySourceX

					move.w #dtilesGuillotine1,copySourceY
					move.w d3,copyTargetX
					move.w #dguillotinePosition1,copyTargetY
					add.l #16,d3
					jsr copyBlock16
					dbra d4,cpxyx

			rts


genenerateGuillotine1Fallbeil:

				; ----------------------
				; fallbeil design
				; ----------------------
					move.l #20,d4
					move.l #32,d3
				cpxyxt:				
					; move.w d3,copySourceX

					move.l #9,d0
					mulu #16,d0
					move.w d0,copySourceX
					move.w #dtilesGuillotine,copySourceY
					move.w d3,copyTargetX
					move.w #dguillotinePosition,copyTargetY
					add.l #16,d3
					jsr copyBlock16
					dbra d4,cpxyxt

			rts

genenerateGuillotine2:

				; ----------------------
				; fallbeil design
				; ----------------------
					move.l #20,d4
					move.l #32,d3
				cpxyxx:				
					; move.w d3,copySourceX

					move.l #0,d0
					jsr RndA 
					divu #20,d0
					swap d0
					ext.l d0
					mulu #16,d0
					add.l #32,d0
					move.w d0,copySourceX

					move.w #dtilesGuillotine2,copySourceY
					move.w d3,copyTargetX
					move.w #dguillotinePosition2,copyTargetY
					add.l #16,d3
					jsr copyBlock16
					dbra d4,cpxyxx

			rts

; ----------------------
; create playfield
; random
; ----------------------

createPlayfield:
					move.l #20,d4
				nexty:
	
					move.l #16,d5
				nextx:

					; steps 
					move.l d4,d0
					mulu #16,d0
					add.l #32,d0
					move.l d0,d2

					move.l d5,d0
					mulu #16,d0
					move.l d0,d3

					move.l #0,d0
					jsr RndA 
					divu #20,d0
					swap d0
					ext.l d0
					mulu #16,d0
					add.l #32,d0
					move.w d0,copySourceX

					move.l #0,d0
					jsr RndA 
					divu #256,d0
					swap d0
					cmp.w #128,d0
					blt   taxus
						move.w #32,copySourceX
					taxus:

					move.w #512+16,copySourceY

					move.w d2,copyTargetX
					move.w d3,copyTargetY
					add.l #16,d3
					jsr copyBlock16


					; nextx
					dbra d5,nextx

					; nexty
					dbra d4,nexty

				rts


; ---------------
; DISPLAY 
; ---------------
; in level 0-10

renderLevel:

		; wait
		move.l #1*25,d4
		jsr timeToWait

		move.l #levels,a1

		move.l level,d0
		mulu #20*16+2,d0
		add.l d0,a1

		; show in slices 
		; because otherwise the music
		; is interrupted
	
					move.l #15,d5
				nextyy:

					; fuck is this simple

					; -----------------
					; vsync
					; -----------------
					bsr.w	WaitForRaster

					; -----------------
					; music
					; -----------------
					IF musicMode
						bsr.w	mt_music
					ENDIF

					move.l #19,d4
				nextxx:

					clr.l d0
					move.b (a1)+,d0

					; 0-9
					cmp.b #129,d0
					blt if_sonder_plus_number
					cmp.b #128+10,d0
					bgt if_sonder_plus_number

						sub.b #129,d0
						add.b #48,d0

						move.l #20,d1
						sub.l  d4,d1
						mulu   #16,d1
						add.l  #16,d1
						move.w d1,copyTargetX

						move.l #15,d1
						sub.l  d5,d1
						mulu   #16,d1
						move.w d1,copyTargetY

						; move.b #65,d0
						; 

						jsr copyCharAt
						jmp copyDone

					if_sonder_plus_number:


					; chars
					cmp.b #96,d0
					blt if_char
					cmp.b #121,d0
					bgt if_char


						sub.b #96,d0
						add.b #65,d0

						move.l #20,d1
						sub.l  d4,d1
						mulu   #16,d1
						add.l  #16,d1
						move.w d1,copyTargetX

						move.l #15,d1
						sub.l  d5,d1
						mulu   #16,d1
						move.w d1,copyTargetY

						; move.b #65,d0
						; 

						jsr copyCharAt
						jmp copyDone

					if_char:


						; sonderzeichen
						; 0-9
						cmp.b #126,d0
						bne if_sonder_plus_
							move.b #58,d0
							jmp sonderzeichen_start
						if_sonder_plus_:

						; sonderzeichen
						; $
						cmp.b #125,d0
						bne if_sonder_plus_2
							move.b #36,d0
							jmp sonderzeichen_start
						if_sonder_plus_2:
						; +
						cmp.b #127,d0
						bne if_sonder_plus
							move.b #43,d0
							jmp sonderzeichen_start
						if_sonder_plus:
						; . 
						cmp.b #122,d0
						bne if_sonder_1
							move.b #46,d0
							jmp sonderzeichen_start
						if_sonder_1:
						; , 
						cmp.b #123,d0
						bne if_sonder_2
							move.b #44,d0
							jmp sonderzeichen_start
						if_sonder_2:
						; #
						cmp.b #124,d0
						bne if_sonder_3
							move.b #35,d0
							jmp sonderzeichen_start
						if_sonder_3:
					jmp if_char_sonderzeichen
					sonderzeichen_start:


						move.l #20,d1
						sub.l  d4,d1
						mulu   #16,d1
						add.l  #16,d1
						move.w d1,copyTargetX

						move.l #15,d1
						sub.l  d5,d1
						mulu   #16,d1
						move.w d1,copyTargetY

						; move.b #65,d0
						; 

						jsr copyCharAt
						jmp copyDone

					if_char_sonderzeichen:					


					; / 20 
					; swap 20
					divu #24,d0
					clr.l d1
					move.w d0,d1
					mulu #16,d1
					add.l #528,d1
					move.w d1,copySourceY

					swap d0
					ext.l d0 
					mulu #16,d0
					move.w d0,copySourceX
					; move.w #528+16,copySourceY

					move.l #20,d0
					sub.l  d4,d0
					mulu   #16,d0
					add.l  #16,d0
					move.w d0,copyTargetX

					move.l #15,d0
					sub.l  d5,d0
					mulu   #16,d0
					move.w d0,copyTargetY

					; copy now .. 
					jsr copyBlock16

					copyDone:


					; nexty
					dbra d4,nextxx

					; nextx
					dbra d5,nextyy




		; wait
		move.l #5*25,d4
		jsr timeToWait

		rts 


; no of frames in d4
timeToWait:
			; -----------------
			; vsync
			; -----------------
			bsr.w	WaitForRaster

			; -----------------
			; music
			; -----------------
			IF musicMode
				bsr.w	mt_music
			ENDIF

			dbra d4,timeToWait

			rts

; ---------------------------
; SUBROUTINES
; ---------------------------

copySourceX: 	dc.w 0 ; 16?
copySourceY: 	dc.w 0

copyTargetX: 	dc.w 0  ; default 0
copyTargetY: 	dc.w 0

copyHeight: 	dc.w 16

; ----------------------------------
; COPYSLICE (Vertical)
; ----------------------------------
copySliceVertical:

		movem.l	d0-d7/a0-a6,-(SP)
		; movem.l	(SP)+,d0-d7/a0-a6

		; ----------------------------------
		; direct copying
		; ----------------------------------
		move.l #3,d4

			move.l #screen,tmpScreenAddress		

		copy_direct:
			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddress,a4

			cmp.w #0,copyBitplane
			beq next_next_NExT

				cmp.w copyBitplane,d4		
				bne next_next_NExT_XYT  

			next_next_NExT:


			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!!

				clr.l d0
				move.w copyHeight,d0
				mulu   #64,d0
				add.l  (2*32+320)/16,d0  
				move.w d0,BLTSIZE(a6) ; $dff058 ; set size		
				

			next_next_NExT_XYT:

			add.l #BitplaneSizeWide,tmpScreenAddress
		dbra d4,copy_direct

		movem.l	(SP)+,d0-d7/a0-a6

		rts

; ----------------------------------
; COPYSLICE (Vertical)
; ----------------------------------
copyBitplaneVertical:

		movem.l	d0-d7/a0-a6,-(SP)
		; movem.l	(SP)+,d0-d7/a0-a6

		; ----------------------------------
		; direct copying
		; ----------------------------------
			move.l #screen,tmpScreenAddress		

			cmp.l #0,tmpScreenAddressAddOn
			beq   noadd_here
				move.l tmpScreenAddressAddOn,d0
				add.l d0,tmpScreenAddress
			noadd_here:

			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddress,a4

			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!!
				clr.l d0
				move.w copyHeight,d0
				mulu   #64,d0
				add.l #(2*32+320)/16,d0
				move.w d0,BLTSIZE(a6) ; $dff058 ; set size		


		movem.l	(SP)+,d0-d7/a0-a6

		rts


; ----------------------------------
; copyBlock16:
; ----------------------------------
copyBlock16:

		movem.l	d0-d7/a0-a6,-(SP)


		; ----------------------------------
		; direct copying
		; ----------------------------------
		move.l #3,d4

			move.l #screen,tmpScreenAddress					
				clr.l d0
				move.w copySourceX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddress

			move.l #screen,tmpScreenAddressTarget		
				clr.l d0
				move.w copyTargetX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddressTarget

		copy_direct16:
			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddressTarget,a4

			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
		
			move.w #(2*32+320-16)/8,BLTAMOD(a6); $dff066
			move.w #(2*32+320-16)/8,BLTDMOD(a6) ; todo: add skip factor !!!
			
;			move.w #64*16+16/16,BLTSIZE(a6) ; $dff058 ; set size		

				clr.l d1
				move.w copyHeight,d1
				mulu #64,d1
				add.l #+16/16,d1
				move.w d1,BLTSIZE(a6)

			add.l #BitplaneSizeWide,tmpScreenAddress
			add.l #BitplaneSizeWide,tmpScreenAddressTarget

		dbra d4,copy_direct16

		movem.l	(SP)+,d0-d7/a0-a6

		rts


; ----------------------------------
; copyBitlpaneBlock16:
; ----------------------------------
; 			add.l #BitplaneSizeWide,tmpScreenAddress
; move.l #screen,tmpScreenAddress	

copyBitplaneBlock16:

		movem.l	d0-d7/a0-a6,-(SP)

		; ----------------------------------
		; direct copying
		; ----------------------------------

			; move.l #screen,tmpScreenAddress					
				clr.l d0
				move.w copySourceX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddress

			; move.l #screen,tmpScreenAddressTarget		
				clr.l d0
				move.w copyTargetX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddressTarget

			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddressTarget,a4

			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
		
			move.w #(2*32+320-16)/8,BLTAMOD(a6); $dff066
			move.w #(2*32+320-16)/8,BLTDMOD(a6) ; todo: add skip factor !!!
			
;			move.w #64*16+16/16,BLTSIZE(a6) ; $dff058 ; set size		

				clr.l d1
				move.w copyHeight,d1
				mulu #64,d1
				add.l #16/16,d1
				move.w d1,BLTSIZE(a6)


		movem.l	(SP)+,d0-d7/a0-a6

		rts

; ----------------------------------
; COPY SHIFT LEFT SLICE (Vertical)
; ----------------------------------
copySliceVerticalShiftLeft:

		move.l #3,d4

			move.l #screen,tmpScreenAddress	
			add.l #2,tmpScreenAddress	
			move.l #screen,tmpScreenAddressTarget	

		copy_direct_shift:

			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddressTarget,a4

			jsr waitForBlitter	

			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #2,BLTAMOD(a6); $dff066
				move.w #2,BLTDMOD(a6) ; todo: add skip factor !!!
				; move.w #64*16+(2*32+320-16)/16,BLTSIZE(a6) ; $dff058 ; set size
				clr.l d1
				move.w copyHeight,d1
				mulu #64,d1
				add #(2*32+320-16)/16,d1
				move.w d1,BLTSIZE(a6)		

			add.l #BitplaneSizeWide,tmpScreenAddress
			add.l #BitplaneSizeWide,tmpScreenAddressTarget

		dbra d4,copy_direct_shift

		rts

; --------------
; COPY & SHIFT Horizontal
; --------------
bobCopyShifted:

			; params
			move.l #screen,scrollingSource

			move.l #screen,scrollingTarget

			move.l #3,d6
all_planes:

			jsr waitForBlitter

				move.w #0,bob1616_x_raster
				move.w #0,bob1616_x_rest

				; bob1616_x_raster
				clr.l  d0
				move.w copyTargetX,d0
				divu   #16,d0
				swap.w   d0
				move.w d0,bob1616_x_rest
				clr.w  d0
				swap.w   d0
				move.w d0,bob1616_x_raster

				; COMMAND
					clr.l d1
					move.w  bob1616_x_rest,d1 
					ror.w	#4,d1
					move.w	d1,BLTCON1(a6) ;  set up the B scroll value !!!! (forgotten)   --- was not set!!!! 4 
					or.w	#$0fca,d1	; 	set up the A scroll value and the
					move.w	d1,BLTCON0(a6)	;	minterm for D = notA.C + B
				; TYPE OF MASK
				move.l #$ffff0000,BLTAFWM(a6) ; mask 
				; SOURCE
					move.l scrollingSource,a5
					clr.l d1
				move.w copySourceY,d1
					mulu #(2*border_offset_byte+40),d1
					add.l  d1,a5
					cmp.l #3,d6
					bne notthe_defaultmask

						move.l a5,scrollingSourceMask
						; version 1: no add
						; version 2: add on
						add.l #16*(320+64)/8,scrollingSourceMask

					notthe_defaultmask:

; try out
;	move.l scrollingSource,a5
;	add.l  #(320+2*32)/8,a5

					move.l a5,BLTBPTH(a6); 
				; MASK
				move.l scrollingSourceMask,BLTAPTH(a6); MASK

				; TARGET
					move.l scrollingTarget,a4
					clr.l d1
					move.w copyTargetY,d1
					mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4

				move.l a4,BLTCPTH(a6); target - screen - xor screen
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066 ; skip source
				move.w #0,BLTBMOD(a6); $dff066 ; skip source
				move.w #0,BLTCMOD(a6) ; todo: add skip factor !!! ; skip target
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!! ; skip target

			; SIZE - copyHeight
			move.w #64*16+(2*32+320)/16,BLTSIZE(a6) ; $dff058 ; set size	

			add.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight,scrollingSource 
			add.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight,scrollingTarget
				
		dbra d6,all_planes
		; all 4 planes :-(

		rts

; ------------------
; SHIFT HORIZONTAL
; ------------------
; copyTargetX
;
bitplaneShift:

			; params
			move.l #screen,scrollingSource
			move.l #screen,scrollingTarget
			move.l #screen,scrollingSourceMask

			move.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight*2,d0
			add.l d0,scrollingSource 
			add.l d0,scrollingTarget 

			move.l #screen,scrollingSourceMask 
			add.l #(320*screenFactorWidth+2*border_offset)/8*512,scrollingSourceMask

			jsr waitForBlitter

				move.w #0,bob1616_x_raster
				move.w #0,bob1616_x_rest

				; bob1616_x_raster
				clr.l  d0
				move.w copyTargetX,d0
				divu   #16,d0
				swap.w   d0
				move.w d0,bob1616_x_rest
				clr.w  d0
				swap.w   d0
				move.w d0,bob1616_x_raster

				; COMMAND
					clr.l d1
					move.w  bob1616_x_rest,d1 
					ror.w	#4,d1
					move.w	d1,BLTCON1(a6) ;  set up the B scroll value !!!! (forgotten)   --- was not set!!!! 4 
					or.w	#$0fca,d1	; 	set up the A scroll value and the
					move.w	d1,BLTCON0(a6)	;	minterm for D = notA.C + B
				; TYPE OF MASK
				move.l #$ffff0000,BLTAFWM(a6) ; mask 
				; SOURCE
					move.l scrollingSource,a5
					clr.l d1
				move.w copySourceY,d1
					mulu #(2*border_offset_byte+40),d1
					add.l  d1,a5
					; cmp.l #3,d6
					; bne notthe_defaultmaskx

					; 	move.l a5,scrollingSourceMask
						; version 1: no add
						; version 2: add on
					; 	add.l #16*(320+64)/8,scrollingSourceMask

					; notthe_defaultmaskx:

; try out
;	move.l scrollingSource,a5
;	add.l  #(320+2*32)/8,a5

				move.l a5,BLTBPTH(a6); 
				
				; MASK
				move.l scrollingSourceMask,BLTAPTH(a6); MASK


				; TARGET
					move.l scrollingTarget,a4
					clr.l d1
					move.w copyTargetY,d1
					mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4

				move.l a4,BLTCPTH(a6); target - screen - xor screen
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066 ; skip source
				move.w #0,BLTBMOD(a6); $dff066 ; skip source
				move.w #0,BLTCMOD(a6) ; todo: add skip factor !!! ; skip target
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!! ; skip target

			; SIZE - copyHeight
			move.w #64*100+(2*32+320)/16,BLTSIZE(a6) ; $dff058 ; set size	

	;		add.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight,scrollingSource 
	
		rts


; ---------------------------
; CHAR
; ---------------------------

charParsed: dc.l 1

copyCharAt:

			move.l #0,charParsed
			movem.l	d0-d7/a0-a6,-(SP)

			; start x/y
			move.w #32+16,copySourceX
			move.w #512-6*16,copySourceY

			; space
			cmp.b #32,d0
			bne if_space
				move.w #32,copySourceX
				move.w #0,d0
				move.l #1,charParsed
				jmp direct_char				
			if_space:

			; 0-9 48
			cmp.b #48,d0
			blt if_num
			cmp.b #48+10,d0
			bgt if_num
				sub.l #48,d0
				move.w #32,copySourceX				
				move.w #512-2*16,copySourceY
				move.l #1,charParsed
				jmp direct_char
			if_num:

			; T+
			cmp.w #84,d0
			blt if_tplus
			cmp.w #65+28,d0
			bgt if_tplus
				sub.w #84,d0
				move.w #32,copySourceX
				move.w #512-4*16,copySourceY
				move.l #1,charParsed
				jmp direct_char
			if_tplus:

; sonderzeichen
			move.l #sonderzeichen,a0
		searchchar:
			clr.l d1
			clr.l d2
			move.b (a0)+,d1
			move.b (a0)+,d2

				cmp.b d0,d1
				bne if_foundsonderzeichen
					move.w #32,copySourceX
					clr.l d0
					move.w d2,d0
					move.w #512-4*16,copySourceY	
					move.l #1,charParsed				
					jmp direct_char		
				if_foundsonderzeichen:

			cmp.b #0,d1
			bne searchchar

		sonderzeichen_done:

			; default
			; d0
			cmp.w #64,d0
			bls   if_aplus
			cmp.w #65+30,d0
			bgt   if_aplus
				sub.l #65,d0
				move.l #1,charParsed
			if_aplus:
			; update source

			

			cmp.l #0,charParsed
			bne parsedXYZ
			    move.w #0,d0
				move.w #144,copySourceX
				move.w #480,copySourceY		
			parsedXYZ:

		direct_char:

			; copy char
			mulu #16,d0
			add.w d0,copySourceX

		direct_char_direct: ; .-) stupid name

			jsr copyBlock16

			; and the mask!
			; copy the mask now

		; todo: param!

			add.w #16,copySourceY
			add.w #16,copyTargetY
			jsr copyBlock16

			movem.l	(SP)+,d0-d7/a0-a6

			rts



; ---------------------------
; HELPERS
; ---------------------------

waitForBlitter:
			lea $dff000,a6  ; blitter base 
					move.w #$8040,DMACON(a6) ; enable blitter with offset
					tst DMACONR(a6); $dff002
			waitblittingbob16:
					btst #6,DMACONR(a6); $dff002
					bne waitblittingbob16

			rts 


; ------------------------
; debug effect
; ------------------------
rainbow: 
		move.w    $DFF006,$DFF180 ; background
		rts

work_start: 
		move.w    $0,$DFF180 ; background
		rts

work_stop: 
		move.w    $DFF002,$DFF180 ; background
		rts


; ------------------------
; screen
; ------------------------

updateCameraAndScrolling: 

		jmp xyz
		; check if something changed
		move.w  scrollX,d0
		cmp.w hscrollX,d0
		bne   updateCamera
		move.w  scrollY,d0
		cmp.w hscrollY,d0
		bne   updateCamera
		jmp   nocameraupdate
updateCamera:

		xyz:



BitplaneSizeWide =((320*screenFactorWidth+2*32)/8)*256*screenFactorHeight	; 256!			; Size of 1 Bitplanes

	    move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
;		cmp.l #0,scrollCameraAddress
;		beq    noextracamera
;			move.l scrollCameraAddress,d0
noextracamera:		

	   add.l   #address_screen_addframe,d0  ; border

;
;		clr.l   d5
;		move.w  scrollY,d5
;		divu    #16,d5
;		ext.l   d5
;		add.l   d5,d0
		
		; yscroll
		clr.l   d5
		move.w scrollY,d5
		mulu    #40*screenFactorWidth+2*border_offset_byte,d5
		add.l   d5,d0
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper

		lea		$dff000,a5
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSizeWide,d2			; Add the bitplane size to the source start Image Address
		bsr	SetBitPlanes 



nocameraupdate:

		rts

;======================================================================================================================
;  Chip Data Section / Chipmemory
;======================================================================================================================

; --------------------------------
; LEVELS
; --------------------------------


	even

levels:
	include	"level0.s"
	include	"level1.s"
	include	"level2.s"
	include	"level3.s"
	include	"level4.s"
	include	"level5.s"
	include	"level6.s"
	include	"level7.s"
	include	"level8.s"
	include	"level9.s"
	include	"level10.s"
	include	"level11.s"
	include	"level12.s"
	include	"level13.s"
	include	"level14.s"
	include	"level15.s"
	include	"level16.s"
	include	"level17.s"
	include	"level18.s"
	include	"level19.s"
	include	"level20.s"
	include	"level21.s"
	include	"level22.s"
	include	"level23.s"
	include	"level24.s"

	even

;======================================================================================================================
; Requires Chip Memory
;======================================================================================================================

		SECTION	Copper,DATA_C

;======================================================================================================================
; Main Game Screen - Copper List
;======================================================================================================================

CopperList:


SpritePointers:
SpritePointer0:
		dc.w	$0120,$0000,$0122,$0000		; Sprite 0
SpritePointer1:
		dc.w	$0124,$0000,$0126,$0000		; Sprite 1
SpritePointer2:
		dc.w	$0128
EnemySpritePtr:
		dc.w	$0000,$012a,$0000			; Sprite 2
SpritePointer3:
		dc.w	$012c,$0000,$012e,$0000		; Sprite 3
SpritePointer4:
		dc.w	$0130,$0000,$0132,$0000		; Sprite 4
SpritePointer5:
		dc.w	$0134,$0000,$0136,$0000		; Sprite 5
SpritePointer6:
		dc.w	$0138,$0000,$013a,$0000		; Sprite 6
SpritePointer7:
		dc.w	$013c,$0000,$013e,$0000		; Sprite 7

ScreenDefinition:
		; Screen Definition

ScreenDefStartY:
		dc.w	$008e,$2c81					; DiwStrt
		dc.w	$0090,$2cc1					; DiwStop
		dc.w	$0092,$0038					; DdfStart LoRes
		dc.w	$0094,$00d0					; DdfStop LoRes
		dc.w	$0102,$0000					; BplCon1
		dc.w	$0104,$003f					; BplCon2 - Sprite on top of Both Playfields (%0000 0000 0011 1111)
;       screen offset 
		dc.w	$0108
screenoffset_x_borderleft:		
		dc.w $0000					; Bpl1Mod - left - even 		
		dc.w	$010a
screenoffset_x_borderright:
		dc.w $0000					; Bpl2Mod - right - odd?

		;15	HIRES	    HIRES = High resolution (640*200/640*400 interlace) mode
		;14	BPUx	    Bit planes use
		;13	BPUx	    Bit planes use
		;12	BPUx	    Bit planes use
		;11	HAM	        Hold and modify mode, now using either 6 or 8 bit planes.
		;10	DPF	        Double playfield (PF1 = odd & PF2 = even bit planes) now available in all resolutions.
		;               If BPU = 6 and HAM = 0 and DPF = 0 a special mode is defined that allows bitplane
		;               6 to cause an intensity reduction of the other 5 bitplanes. 
		;               The color register output selected by 5 bitplanes is shifted to half intensity by the 6th bit plane.
		;               This is called EXTRA-HALFBRITE Mode.
		;09	COLOR	    Enables color burst output signal
		;08	GAUD	    Genlock audio enable. This level appears on the ZD pin on denise during all blanking periods, unless ZDCLK bit is set.
		;07	UHRES	    Ultrahi res enables the UHRES pointers (for 1k*1k) also needs bits in DMACON (hires chips only).
		;               Disables hard stops for vert, horiz display windows.
		;06	SHRES	    Super hi-res mode (35ns pixel width)
		;05	BYPASS=0	Bit planes are scrolled and prioritized normally, but bypass color table and 8 bit wide data appear on R(7:0).
		;04	BPU3=0	    See above (BPUx)
		;03	LPEN	    Light pen enable (reset on power up)
		;02	LACE	    Interlace enable (reset on power up)
		;01	ERSY	    External resync (HSYNC, VSYNC pads become inputs) (reset on power up)
		;00	ECSENA=0	When low (default), the following bits in BPLCON3 are disabled: BRDRBLNK,BRDNTRAN,ZDCLKEN,BRDSPRT, and EXTBLKEN.
		;               These 5 bits can always be set by writing to BPLCON3, however there effects are inhibited until ECSENA goes high.
		;               This allows rapid context switching between pre-ECS viewports and new ones.

	BPLCON0:
					;  5432109876543210
		dc.w	$0100,%0100001000000000		; bit 13 - 4 bitplanes, 16 colors, Lo-Res

		;15	ENSP7	Enable Sprite 7 (ORed with Sprite 6)
		;14	ENSP5	Enable Sprite 5 (ORed with Sprite 4)
		;13	ENSP3	Enable Sprite 3 (ORed with Sprite 2)
		;12	ENSP1	Enable Sprite 1 (ORed with Sprite 0)
		;11	ENSP6	Enable bit plane 6 (match reqd. for collision)
		;10	ENSP5	Enable bit plane 5 (match reqd. for collision)
		;09	ENSP4	Enable bit plane 4 (match reqd. for collision)
		;08	ENSP3	Enable bit plane 3 (match reqd. for collision)
		;07	ENSP2	Enable bit plane 2 (match reqd. for collision)
		;06	ENSP1	Enable bit plane 1 (match reqd. for collision)
		;05	ENSP6	Match value for bit plane 6 collision
		;04	ENSP5	Match value for bit plane 5 collision
		;03	ENSP4	Match value for bit plane 4 collision
		;02	ENSP3	Match value for bit plane 3 collision
		;01	ENSP2	Match value for bit plane 2 collision
		;00	ENSP1	Match value for bit plane 1 collision

				;      5432109876543210
		dc.w	$0098,%1111000000000000		; CLXCON  $dff098
; 		dc.w	$0098,%1110000000000000		; CLXCON  $dff098

		dc.w	$00e0
GameBitplanePointers:
		dc.w	$0000,$00e2,$0000			; bitplane 1
		dc.w	$00e4,$0000,$00e6,$0000		; bitplane 2
		dc.w	$00e8,$0000,$00ea,$0000		; bitplane 3
		dc.w	$00ec,$0000,$00ee,$0000		; bitplane 4

InGameColors:
    dc.w    $0180
GameScreenColours:

; PALETTE CHANGE HERE ... 

; {0X000,0X111,0X610,0X444,0X910,0X060,0X088,0Xf10,0X888,0X0a0,0X0cc,0Xccc,0X0ff,0X0f0,0Xff0,0Xfff}

color_0:
    dc.w    $0000                       ; color00 - plane 1
    dc.w    $0182
color_1:
	dc.w $0111                 ; color01 - plane 1 
    dc.w    $0184
color_2:	
	dc.w $0610                 ; color02 - plane 2
    dc.w    $0186
color_3:	
	dc.w $0444                 ; color03 - plane 2
    dc.w    $0188
color_4:		
	dc.w $0910                 ; color04 - plane 3
    dc.w    $018A
color_5:			
	dc.w $0060                 ; color05 - plane 3
    dc.w    $018C
color_6:
	dc.w $0088                 ; color06 - plane 3
    dc.w    $018E
color_7:
	dc.w $0f10                 ; color07 - plane 3
    dc.w    $0190
color_8:	
	dc.w $0888                 ; color08 - plane 4
    dc.w    $0192

; 0X0a0,0X0cc,0Xccc,0X0ff,0X0f0,0Xff0,0Xfff}

color_9:
	dc.w $00a0                ; color09 - plane 4
    dc.w    $0194
color_10:
	dc.w $00cc                 ; color10 - plane 4
    dc.w    $0196
color_11:
	dc.w $0ccc                 ; color11 - plane 4
    dc.w    $0198
color_12:	
	dc.w $00ff                 ; color12 - plane 4
    dc.w    $019A
color_13:	
	dc.w $00f0                ; color13 - plane 4
    dc.w    $019C
color_14:
	dc.w $0ff0                ; color14 - plane 4
    dc.w    $019E
color_15:	
	dc.w $0fff                 ; color15 - plane 4
 
;    dc.w    $0000                       ; color00 - plane 1
;    dc.w    $0182,$0fff                 ; color01 - plane 1 
;    dc.w    $0184,$0fff                 ; color02 - plane 2
;    dc.w    $0186,$0fff                 ; color03 - plane 2
;    dc.w    $0188,$0fff                 ; color04 - plane 3
;    dc.w    $018A,$0fff                 ; color05 - plane 3
;    dc.w    $018C,$0fff                 ; color06 - plane 3
;    dc.w    $018E,$0fff                 ; color07 - plane 3
;    dc.w    $0190,$0fff                 ; color08 - plane 4
;    dc.w    $0192,$0fff                 ; color09 - plane 4
;    dc.w    $0194,$0fff                 ; color10 - plane 4
;    dc.w    $0196,$0fff                 ; color11 - plane 4
;    dc.w    $0198,$0fff                 ; color12 - plane 4
;    dc.w    $019A,$0fff                 ; color13 - plane 4
;    dc.w    $019C,$0fff                 ; color14 - plane 4
;    dc.w    $019E,$0fff                 ; color15 - plane 4


; 0 always transprent
; _1,2,3 for two sprites !

SpritesColours:
		; Sprite 0 and 1 Colours
		dc.w	$01A0
spritecolor_01_0:		
		dc.w	$0000					; color16 - Transparent
		dc.w	$01A2
spritecolor_01_1:				
		dc.w 	$0fff					; color17 - Sprite Colour 1 - White 
		dc.w	$01A4

PlayerColour:
spritecolor_01_2:		
		dc.w	$0fff							; color18 - Sprite Colour 2 - Brown
		dc.w	$01A6
spritecolor_01_3:		
		dc.w 	$0fff					; color19 - Sprite Colour 3 - Black

		; Sprite 2 and 3 Colours
spritecolor_4:
		dc.w	$01A8
spritecolor_23_0:		
		dc.w    $0000					; color20 - Transparent
		dc.w	$01AA
spritecolor_23_1:				
		dc.w 	$00c0					; color21 - Sprite Colour 1
		dc.w	$01AC
spritecolor_23_2:						
		dc.w 	$0080					; color22 - Sprite Colour 2
		dc.w	$01AE
spritecolor_23_3:						
		dc.w 	$0040					; color23 - Sprite Colour 3

		; Sprite 4 and 5 Colours
		dc.w	$01b0
spritecolor_45_0:				
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b2
spritecolor_45_1:						
		dc.w 	$0c00					; color21 - Sprite Colour 1
		dc.w	$01b4
spritecolor_45_2:					
		dc.w 	$0800					; color22 - Sprite Colour 2
		dc.w	$01b6
spritecolor_45_3:
		dc.w 	$0400					; color23 - Sprite Colour 3

		; Sprite 6 and 7 Colours
		dc.w	$01b8
spritecolor_67_0:		
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b
spritecolor_67_1:		
		dc.w 	$00cc					; color21 - Sprite Colour 1
		dc.w	$01bC
spritecolor_67_2:		
		dc.w 	$0088					; color22 - Sprite Colour 2
		dc.w	$01bE
spritecolor_67_3:
		dc.w    $0044					; color23 - Sprite Colour 3

		; band
;		DC.W    $FFA1,$FF00 	; wait 
		; http://amigadev.elowar.com/read/ADCD_2.1/Hardware_Manual_guide/node004B.html
;		dc.w	$0180,$0200   ; set color
;		DC.W    $FFA8,$FF00 	; wait 
;		dc.w	$0180,$0900   ; set color

		
		dc.w	$ffdf,$fffe		; ?
		dc.w	$FFFF,$FFFE					; End of copperlist


; -----------------------------
 ; KEYBOARD
 ; -----------------------------

		even
keyPressed:
	dc.w 1

_keyboard:
	movem.l d0-d2,-(sp)

	;Vérifier dans ICR que la requête est bien générée par le CIA A aur l'événement SP (bascule des 8 bits reçus du clavier dans SDR)

	btst #3,$BFED01
	beq _keyboardNotKeyboard

	;Lire les 8 bits dans SDR et détecter s'il s'agit de la pression ou du relâchement d'une touche

	move.b $BFEC01,d0
	btst #0,d0
	bne _keyboardKeyDown
	move.w #$00F0,d1		;Touche relâchée : couleur vert
	bra _keyboardKeyUp
_keyboardKeyDown:
	move.w #$0F00,d1		;Touche pressée : couleur rouge
_keyboardKeyUp:

	;Changer la couleur de fond si la touche pressée est celle attendue (ESC)

	not.b d0
	lsr.b #1,d0

	move.l #0,d1

	; key pressed
	clr.l d2
	move.b d0,d2
	move.w d2,keyPressed

	; speed 1x 
	cmpi.b #$20,d0
	bne _keyboardNotA

		move.w #0,cursorLeft
		move.w #0,scrollLeftUp

	_keyboardNotA:

	; speed 2x
	cmpi.b #$21,d0
	bne _keyboardNotS

		move.w #1,cursorLeft
		move.w #0,scrollLeftUp

	_keyboardNotS:






	cmpi.b #$45,d0
	bne _keyboardNotESC
	; move.w d1,COLOR00(a5)
	  move.w    $DFF006,$DFF180 ; background
	;  move.w #1,cursorLeft
_keyboardNotESC:

	; 1 ... 
	cmpi.b #$01,d0
	bne _keyboardNot1
		move.l #demo_project-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot1:

	; 2 ... 
	cmpi.b #$02,d0
	bne _keyboardNot2
		move.l #team_project-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot2:

	; 3 ... 
	cmpi.b #$03,d0
	bne _keyboardNot3
		move.l #demo_greets-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot3:

	; 4
	cmpi.b #$04,d0
	bne _keyboardNot4
		move.l #demo_tech-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot4:

	; 5
	cmpi.b #$05,d0
	bne _keyboardNot5
		move.l #team_zuerich-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot5:

	; 6 
	cmpi.b #$06,d0
	bne _keyboardNot6
		move.l #team_hkb-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot6:

	; 7 
	cmpi.b #$07,d0
	bne _keyboardNot7
		move.l #team_unibe-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot7:

	; 8
	cmpi.b #$08,d0
	bne _keyboardNot8
		move.l #team_unil-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot8:

	; 9
	cmpi.b #$09,d0
	bne _keyboardNot9
		move.l #demo_results-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot9:

	; jump to ... 
	cmp.l #1,d1
	bne if_scrolljump

		move.w    $DFF006,$DFF180 ; background

		move.w #256-8,copySourceY
		move.w #256+80,copyTargetY
		jsr copySliceVertical	

		move.w #256-8,copySourceY
		move.w #256+80+16,copyTargetY
		jsr copySliceVertical	

		jsr reset_all

	if_scrolljump:


	;Acquitter auprès du clavier en maintenant à 0 le signal sur sa ligne KDAT durant 85 us, ce qui s'effectue en positionnant SPMODE à 1 dans CRA ("software must pulse the line low for 85 microseconds to ensure compatibility with all keyboard models" et "the KDAT line is active low [...] a low level (0V) is interpreted as 1"). Pour rappel, une ligne raster, c'est 227,5 cycles de 280 ns, donc 63,7 us, ce qui signifie qu'il faut attendre que le raster ait parcouru deux lignes. Maintenant, ce n'est pas très élégant d'attendre que le raster se balade en se tournant les pouces...

	bset #6,$BFEE01
	
	move.l $DFF004,d0
	lsr.l #8,d0
	and.w #$01FF,d0
	moveq #2-1,d1
_keyboardWait85us:
	move.l $DFF004,d2
	lsr.l #8,d2
	and.w #$01FF,d2
	cmp.w d0,d2
	beq _keyboardWait85us
	move.w d2,d0
	dbf d1,_keyboardWait85us

	bclr #6,$BFEE01

_keyboardNotKeyboard:
	movem.l (sp)+,d0-d2
	rts

 
 ; rest all 
 reset_all:
    
		move.l #0,direction
		move.l #0,waitingCounter

		move.w #0,scrollDoIt

		move.w #1,showfont

		; waitingCounter
		move.w #0,scrollX
		move.w #0,scrollY
		jsr updateCameraAndScrolling		

	rts

 even





; linedraw
; https://www.markwrobel.dk/post/amiga-machine-code-letter12-linedraw3/
; Subroutine linedraw
; If both points are equal, then no line is drawn.
; Input:
;   d0: x1 x-coordinate of first point
;   d1: y1 y-coordinate of first point
;   d2: x2 x-coordinate of second point
;   d3: y2 y-coordinate of second point
;   a0: pointer to the bitplane
;   a1: pointer to the octant table
;   a2: base address of the custom chip register $dff000



swid = 40 + (2*32)/8                        ; screen width in bytes

initlinedraw:
    move.l	#screen(pc),a0      ; move address of screen into a0
   ; move.l #screen,a0
	lea.l	octant(pc),a1      ; move screen of octant into a1
    move.l	#$dff000,a2        ; move value into a2

waitinit:                          ; wait for blitter
    btst	#6,$2(a2)          ; DMACONR test Blitter DMA enable
    bne.s	waitinit           ; if not Blitter DMA enable goto waitinit
    move.l	#-1,$44(a2)        ; BLTAFWM / BLTALWM
    move.l	#$ffff8000,$72(a2) ; BLTBDAT / BLTADAT
    move.w	#swid,$60(a2)      ; BLTCMOD
    move.w	#swid,$66(a2)      ; BLTDMOD
    rts  


linedraw:
    cmp.w	d0,d2              ; compare x1 and x2
    bne.s	ld_not1pix         ; if x1 != x2 goto ld_not1pix
    cmp.w	d1,d3              ; compare y1 and y2
    bne.s	ld_not1pix         ; if y1 != y2 goto ld_not1pix 
    rts                            ; return from subroutine

ld_not1pix:                        ; Points are not the same pixel
    movem.l	d4/d7/a3-a4,-(a7)  ; push registers on the stack
    moveq	#0,d7              ; clear octant index d7
    sub.w	d0,d2              ; store dx=x2-x1 in d2
    bge.s	ld_xok             ; if dx>=0 goto ld_xok
    neg.w	d2                 ; store -dx in d2
    addq.w	#2,d7              ; add 2 to octant index d7 (dx < 0)

ld_xok:                            ; dx is OK
    sub.w	d1,d3              ; store dy=y2-y1 in d3
    bge.s	ld_yok             ; if dy>=0 goto ld_yok
    neg.w	d3                 ; store -dy in d3
    addq.w	#4,d7              ; add 4 to octant index d7 (dy < 0)

ld_yok:                            ; dy is OK
    cmp.w	d3,d2              ; compare dy and dx
    bgt.s	ld_xyok            ; if dx > dy goto ld_xyok 
    bne.s	ld_not45           ; if dx != dy goto ld_not45
    add.w	#16,d7             ; add 16 to octant index d7 (dx == dy)

ld_not45:                          ; line is not 45 degrees
    exg	d2,d3                      ; exchange dx and dy so that dx is largest
    addq.w	#8,d7              ; add 8 to octant index d7 (dy > dx)

ld_xyok:                           ; dx and dy is OK
    add.w	d3,d3              ; 2dy to d3 
    move.w	d3,d4              ; 2dy to d4
    sub.w	d2,d4              ; 2dy-dx to d4
    add.w	d3,d3              ; 4dy to d3
    move.w	d3,a3              ; 4dy to a3
    add.w	d2,d2              ; 2dx in d2
    add.w	d2,d2              ; 4dx in d2
    sub.w	d2,d3              ; 4dy - 4dx in d3
    mulu	#swid,d1           ; convert y1 coordinate to byte offset
    move.l	a0,a4              ; Screen pointer to a4
    add.w	d1,a4              ; Screen + y1 to a4
    move.w	d0,d1              ; x1 to d1
    lsr.w	#3,d1              ; convert x1 coordinate to byte offset (x1/8)
    add.w	d1,a4              ; Screen + y1 + x1 to a4.
    andi.w	#$f,d0             ; d0 sets BLTCON0 / BLTCON1 Keep the first four bits of x1
    ror.w	#4,d0              ; Within a word rotate right 4 bits.
    add.w	#$bc8,d0           ; Add values to three lowest nibbles 
    swap	d0                 ; Swap the words in d0
    move.w	(a1,d7.w),d0       ; move octant value at d7 into d0
    lsl.w	#4,d2              ; d2 sets BLTSIZE bit 15-6 holds dx  
    addq.w	#2,d2              ; bit 5-0 holds 2

ld_wldraw:
    btst	#6,$2(a2)          ; DMACONR test Blitter DMA enable
    bne.s	ld_wldraw          ; if not set then goto ld_wldraw
    move.l	d0,$40(a2)         ; BLTCON0 / BLTCON1
    move.w	d3,$64(a2)         ; BLTAMOD
    move.w	a3,$62(a2)         ; BLTBMOD
    move.w	d4,$52(a2)         ; BLTAPTL
    move.l	a4,$48(a2)         ; BLTCPTH / BLTCPTL
    move.l	a4,$54(a2)         ; BLTDPTH / BLTDPTL
    move.w	d2,$58(a2)         ; BLTSIZE
    movem.l	(a7)+,d4/d7/a3-a4  ; pop the stack into registers
    rts 
	
	even

octant:
    dc.w	$0051,$0055,$0059,$005d
    dc.w	$0041,$0049,$0045,$004d
    dc.w	$0011,$0015,$0019,$001d
    dc.w	$0001,$0009,$0005,$000d
	even
;======================================================================================================================
;  VARS
;======================================================================================================================

stageStage: dc.l 0 ; state
stageCounter: dc.l 0

;
;  0 kill the title
;  1 some lines
;  2
;  3
;  


clicked: dc.l 0

counter: dc.w 0

scrollTextX: dc.w 1 

showTech: dc.w 0

direction: dc.w 1

waitingCounter: dc.l 0

scrollingSource: dc.l 0
scrollingSourceMask: dc.l 0
scrollingTarget: dc.l 0

bob1616_screen: dc.l 0

bob1616_id:	dc.w 0
bob1616_x:	dc.w 10   
bob1616_y:	dc.W 10  

bob1616_x_raster: dc.w 10
bob1616_x_rest: dc.w 0

actualHiddenScreenAddress: dc.l 0
actualHiddenScreenAddressAdd: dc.l 0

tmpScreenAddress: dc.l 0
tmpScreenAddressTarget: dc.l 0

tmpScreenAddressAddOn: dc.l 0


guillotine: dc.w 0
guillotine1: dc.w 0
guillotine2: dc.w 0

level: dc.w 0

middleScrolling: dc.l 0

scrollX: dc.w 0
scrollY: dc.w 0
hscrollX: dc.w 2001
hscrollY: dc.w 2001

; scrolling
scrollDoIt: dc.w 0
scrollYTo: dc.w 0

scrollTextPositionY: dc.w 196

scrollCameraAddress: dc.l 0

scrollCharXCounter: dc.l 0

showfont: dc.w 1

scrollerPositionY: dc.w 256-22
scrollerPositionDirection: dc.w 0
scrollerDownInterruptedFlag: dc.w 0

copyBitplane: dc.w 0

cursorLeft: dc.w 0

scrollLeftUp: dc.w 0

wave: dc.l 0
waveindex: dc.l 0
	even 
wave_tab: 
	dc.b 0
	dc.b 0
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 3
	dc.b 3
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 255

; --------------------------------
; SCROLLING-TEXT
; --------------------------------
	even
scrollindex: dc.l 0
	even
scrolltext: 
	; test
	; dc.b "  FONT:  +':,()[]#.-!? ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 "

;	dc.b "  COMMANDS: GLITCH gggg WAIT  SCROLLING s TOP t CODE c MESSAGE _ TOGGLEFONT f "

	; dc.b "  CODEggc  f  WAS SOLL DAS? WO BIST DU? e  WOW d IS ALL GOD THIS t "

;	dc.b " HELLO WORLD. wARE YOU OUT THERE? I LIVE INSIDE THIS COMPUTER. AND GUESS WHAT. ONCE COMPUTERS WILL RULE THE WORLD HAHA "

	dc.b " f'FUCK WHAT A DIRTY PLAIN FONT! COULDNT YOU DO SOMETHING WITH MORE COLORS AND HAND RENDERED 3D? THE AMIGA IS ABOUT COLORS!' e OF COURSE WE CAN. :-) "

demo_project: 
	; demo

	dc.b " THIS IS A SIMPLE RESEARCH DEMO OF OUR EXPERIMENTAL ARCHEOLOGY FOCUS. THE RESEARCH QUESTION WAS:'HOW COMPLEX WAS IT TO CREATE A SIMPLE AMIGA DEMO?'. THE TOPIC THE RESEARCH PROJECT CHLUDENS. THE RESULT YOU FIND AT THE END OF THE SCROLLTEXT OR ON RESEARCH.SWISSIGITIZATION.CH. THE DEMO WAS RELEASED AT MOUNTAIN-BYTES.CH 2025. CODE AND VISUALS BY LA1N, MUSIC BY COMPUTERMUSIKER.  "

team_project:

demo_greets: 

demo_tech: 


team_zuerich:

team_hkb:

team_unibe:

team_unil:

demo_results:

restart: 
	dc.b " NO 3 ACTS. SORRY 3 2 1 [RESTART]  "
	dc.b 0
	even


; https://www.gladir.com/LEXIQUE/POLICES/amigaascii.htm
sonderzeichen: ; there is no better word than sonderzeichen .-) 
			   ; it is also one point, why so long there were no german/french software versions .-(

	; +':,()[]#.-!?

	dc.b 36,20 ;$ 

	dc.b 43,7 ;+ 
	dc.b 39,8 ;'
	dc.b 58,9 ;:
	dc.b 44,10 ;,

	dc.b 40,11 ;(
	dc.b 41,12 ;)

	dc.b 91,13 ;[
	dc.b 93,14 ;]

	dc.b 35,15 ;#
	dc.b 46,16 ;.

	dc.b 45,17 ;-
	dc.b 33,18 ;!
	dc.b 63,19 ;?

	dc.b 0,0	


	even

; --------------------------------
; MUSIC AREA
; --------------------------------
mt_data:
		incbin "music.mod"
mt_data_End:

; --------------------------------
; SCREENS (DoubleBuffering)
; --------------------------------
virtual_showed: dc.l 0
virtual_screenHidden: dc.l 0

virtual_screenA: dc.l 0
virtual_screenB: dc.l 0

; --------------------------------
; COLORS
; --------------------------------

updateColors: 
		; a list 
		lea.l colorsTitle,a0						; Move to A0 since we will work with Address Register

		lea		InGameColors,a1			; Get the Address of where the colours are in the Copper list
		moveq	#15,d1						; Number of Colours
		addq.l	#2,a1							; Add 4 to the Copper list Address
nextcol2:
		; move.w	d1,(a1)						; Copy the Word to teh Copper list Address Word
		move.w	(a0),(a1)						; Copy the Word to teh Copper list Address Word
		add.l	#2,a0							; Add 4 to the Copper list Address
		add.l	#4,a1							; Add 4 to the Copper list Address
		dbra	d1,nextcol2					; Loop

		rts
; colors

; http://deadliners.net/ImageTool/index.html
;	palette for: title
;	Thu Jan 16 2025 21:39:09 GMT+0100 (Mitteleuropäische Normalzeit)
	dc.w	16	; colors count
colorsTitle: 
	;	      dc.w $0000,$0fff,$0f00,$0fc0,$0161,$03b1,$03f4,$0ca9,$0ff5,$0eb3,$0e9f,$089b,$000f,$0bcf,$0b25,$0111,$0295,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0

	dc.w	$0000
	dc.w    $0fff
	dc.w	$0bbb 
	dc.w	$0888
	dc.w	$0333
	dc.w	$00f0
	dc.w	$00a0
	dc.w	$0060
	dc.w	$0fe0
	dc.w	$00ff
	dc.w	$00bc
	dc.w	$0077
	dc.w	$0f10
	dc.w	$0910
	dc.w	$0500
	dc.w	$0111


	dc.w	$0000
	dc.w	$0f00 ; color 1
	dc.w	$00f0 ; color 2
  		dc.w	$0ff0 ; 3 color 1+2
	dc.w	$000f ; color 4:
		dc.w	$0909 ; color 5: 4+1
		dc.w	$0099 ; color 6: 4+2
		dc.w	$0999 ; color 7: 4+2+1
	dc.w	$0fff ; color 8
		dc.w	$0f4f ; color 9: 8+1
		dc.w	$04ff ; color 10: 8+2
		dc.w	$0fff ; color 11: 8+2+1
		dc.w	$0f4f ; color 12: 8+4
		dc.w	$0fff ; color 13: 8+4+1
		dc.w	$0fff ; color 14: 8+4+2+1
		dc.w	$0fff ; color 14: 8+4+2+1


	; rgb
	dc.w	$0000
	dc.w	$0f00 ; color 1
	dc.w	$00f0 ; color 2
  		dc.w	$0ff0 ; 3 color 1+2
	dc.w	$000f ; color 4:
		dc.w	$0909 ; color 5: 4+1
		dc.w	$0099 ; color 6: 4+2
		dc.w	$0999 ; color 7: 4+2+1
	dc.w	$0fff ; color 8
		dc.w	$0f4f ; color 9: 8+1
		dc.w	$04ff ; color 10: 8+2
		dc.w	$0fff ; color 11: 8+2+1
		dc.w	$0f4f ; color 12: 8+4
		dc.w	$0fff ; color 13: 8+4+1
		dc.w	$0fff ; color 14: 8+4+2+1
		dc.w	$0fff ; color 14: 8+4+2+1


	; 
	dc.w	$0000
	dc.w    $0fff; $0ccc ; $0400; $0fff
	dc.w	$0ccc; $0fff; $0bbb 
	dc.w	$0888
	dc.w	$0333
	dc.w	$00f0
	dc.w	$00a0
	dc.w	$0060
	dc.w	$0fe0
	dc.w	$00ff
	dc.w	$00bc
	dc.w	$0077
	dc.w	$0f10
	dc.w	$0910
	dc.w	$0500
	dc.w	$0111



; --------------------------------
; SCREEN AREA
; --------------------------------
screen:
BackofficeBitplanes:
GameScreenBitplanes:
IntroScreen:

		; http://deadliners.net/ImageTool/index.html
		incbin "gfx/title_bitplanes.bin"
		; https://www.stef.be/dpaint/
		; incbin "gfx/title.planes"
		
		; blk.b (2*border_offset_byte+40*screenFactorWidth)*256*screenFactorHeight*4,0 ; 256 y coords
screen_flip:
		; blk.b (2*border_offset_byte+40*screenFactorWidth)*256*screenFactorHeight*4,0 ; 256 y coords
		; add ... 
 
  