;======================================================================================================================
; CHLUDENS-DEMOSCENE
;======================================================================================================================
; 
;  CODE & VISUALS: LA1N (info@la1n.ch)
;  MUSIC: COMPUTERMUSIKER
;  SCROLLTEXT: THE TEAMS
;
; AREA: EXPERIMENTAL ARCHEOLOGY
; RESEARCH: HOW COMPLEX WAS IT TO MAKE A SIMPLE DEMO ON THE AMIGA
;
;======================================================================================================================
; made with and for VisualStudioCode and Amiga-Assembly-Modul 
;======================================================================================================================

; More ideas (not released):
; Chars explode at the end of the line  


;======================================================================================================================
; FS-UAE (Emulator):
;
; (FS-LUAE: Ctrl+w > fast forward)
; Ctrl+return > fullscrren
; Ctrl+A > several times > real fullscreen
; Command: pause/resum
;
;======================================================================================================================

; ---------------------
; TITLE-SCREEN
; ---------------------
; Image-Data
; C_DATA.s
; - exported by https://www.stef.be/dpaint/ (chrome) > load it > Save as > planes
; colors:
; colors.S (automatic)
; - exported by https://www.stef.be/dpaint/ > Save as > planes > .palette.xt
; > colorsTitle.s update manual!!! 

; if you export a picture 
; than change colors (> PALETTE)

; if you wanna use the 'scrolltext', you need to have 1 as the white color
; > 1. go to palette (menu) > from image 2. edit palette 2.1 swap color 
; > 2.2 lock 2.3. reduce?

; ---------------------
; BLOCKS
; ---------------------
; use Processing-Tool

; ---------------------
; SPRITE
; ---------------------
; use Processing-Tool

; ---------------------
; BOBS
; ---------------------
; use Processing-Tool

; ---------------------
; CODING
; ---------------------
; ATTENTION: DONT USE D7,D6,A7,A& 
; IS SOMEHOW NEEDED BY MUSIC AND MOUSE

; ------------------------------
; 68000 KNOWHOW
; ------------------------------

; 68k online ausprobieren
; https://asm-editor.specy.app/projects/GuILvBB

; CLR.[B/W/L]
; ADD.[B/W/L]
; SUB.[B/W/L]
; MOVE.[B/W/L]
; SWAP.[B/W/L]

; WITHOUT .B/W/L > WORD
; MOVE #4,d0 MEANS MOVE.W #4,d0!!!

; MULTIPLY:
; ROL ETC 
; DIV[U|S] / (int)   W1: RESULT  W2: REST %
; MUL[U|S] * (int)
;
; Data-Register: d0-d7
; Adress-Register: a0-a7
; 
; CMP.[B/W/L]
; BNE/BEQ etc.
;
; UNSIGMED
; BHI.w >
; BCS.w <
;
; SIGNED
; BGT.w >
; BLT.w <
;

;         even
; label:  must be even for 68k!

; DBRA: FOR-NEXT
;    move.l #10
; lab:
;    dbra d0,lab

; ------------------
; errors/failures
; ------------------
; cmp.l xyz,d0  ; < d0 and xyz not long!!!


;
; COPPER - graphic processor binded to crt-raster
;
; If you install a copper list, this will be executed forever! 
; but you can put labels and write direct there !
;
; commands WAIT,MOVE,SKIP
;  
;
; water ... 
;		; data, command
;		; will be always executed
;		DC.W    $9601,$FF00 	; wait for line 150
;		dc.w	$0180,$0fff   ; set color

; music
musicMode equ 1 ; music on 1 off 0

; font mask
createFontMask equ 1 ; create font mask automatic (black is transparent) otherwise paint it .-)

; mouse active in menu?
MouseMenuActive equ 1

; screenfactor
screenFactorWidth = 1
screenFactorHeight = 2

BLTDDAT	=0	;result of the last word. used for bob collision detection and 
		;MFM decoding
DMACONR	=2	;bit 14=blitter busy flag

BLTCON0	=$40	;blitter operation setup
BLTCON1	=$42
BLTAFWM	=$44
BLTALWM	=$46

BLTCPTH	=$48	;sources, destination, and size
BLTCPTL	=$4a
BLTBPTH	=$4c
BLTBPTL	=$4e
BLTAPTH	=$50
BLTAPTL	=$52
BLTDPTH	=$54
BLTDPTL	=$56

BLTSIZE	=$58

BLTCON0L=$5a	;ECS/AGA registers
BLTSIZV	=$5c
BLTSIZH	=$5e

BLTCMOD	=$60	;modulos
BLTBMOD	=$62

BLTAMOD	=$64 ; 108
BLTDMOD	=$66 ; 

; BLTDMOD	=$66 ; 
; BLTDMOD	=$66 ; 



BLTCDAT	=$70	;data to replace sources
BLTBDAT	=$72
BLTADAT	=$74



DMACON	=$96	;bit 6: enable blitter DMA. bit 10: give blitter priority over
		;the CPU.



	section	GameCode,CODE_P

;======================================================================================================================
; Startup File
; Makes sure we take control of the OS the proper way
;======================================================================================================================

	include	"lib/startup.s"

;======================================================================================================================
; Which DMAs we will enable
;
; 15	SET/CLR	Set/Clear control bit.
;				Determines if bits written with a 1 get set or cleared
;			    Bits written with a zero are unchanged
; 14	BBUSY	Blitter busy status bit (read only)
; 13	BZERO	Blitter logic zero status bit (read only)
; 12	X	
; 11	X	
; 10	BLTPRI	Blitter DMA priority (also called "blitter nasty" for stealing from CPU)
; 09	DMAEN	Enable all DMA below (also UHRES DMA)
; 08	BPLEN	Bit plane DMA enable
; 07	COPEN	Coprocessor DMA enable
; 06	BLTEN	Blitter DMA enable
; 05	SPREN	Sprite DMA enable
; 04	DSKEN	Disk DMA enable
; 03	AUD3EN	Audio channel 3 DMA enable
; 02	AUD2EN	Audio channel 2 DMA enable
; 01	AUD1EN	Audio channel 1 DMA enable
; 00	AUD0EN	Audio channel 0 DMA enable
;======================================================================================================================

								;5432109876543210
DMASET					equ		%1000001110101111	; Enable Copper, Bitplane DMA, Sprite DMA, Sound DMA

WaitDisk				equ		30		; Defined in Startup.s : Time to wait 50-150 to save/load (50 = 1 second in Pal system)


;======================================================================================================================
; Main Program Start
;======================================================================================================================

border_offset = 32 ; border around ...
		; border_offset_blt1 = border_offset/4
border_offset_byte = border_offset/8
border_offset_word = border_offset/16 ; tiles
address_screen_addframe =  border_offset_byte;  + 8*(320/8);  +  +border_offset_byte*(320+2*border_offset)/8 

;======================================================================================================================
; Libs und co
;======================================================================================================================

; Libs
		include	"Source/Constants.s"
		include	"Source/Utils.s"
		include	"Lib/music.s"


START:
		;--------------------------------------------------------------------------------------------------------------
		; Saving everything for startup file
		;--------------------------------------------------------------------------------------------------------------

		movem.l	d0-d7/a0-a6,-(SP)

		; bsr.w	WaitForRaster

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		; DMA Set / Enable
		move.w	#DMASET,$96(a5)		; DMACON - Enable Bitplane, Copper DMA, Sprties

		; Disable AGA for compatibility
		move.w	#0,$1fc(a5)			; Disable AGA
		move.w	#$c00,$106(a5)		; Disable AGA
		move.w	#$11,$10c(a5)		; Disable AGA

		; ----------------------
		; BLITTER ENABLING
		; ----------------------
		move.w #$8040,$dff096 ; enable blitter
		; move.w #$87e0,$dff096
		
		;--------------------------------------------------------------------------------------------------------------
		; Init Main Game Screen
		; This only need to be initialised once
		;--------------------------------------------------------------------------------------------------------------

		; bsr.w	InitBitPlanes
		; bsr.w	InitColours

	

		;--------------------------------------------------------------------------------------------------------------
		; Init the Intro Screen
		;--------------------------------------------------------------------------------------------------------------

		; Init the Intro Screen Bitplanes and Colours
		; bsr.w	InitIntroScr  ; wird nachträglich gemacht!
		; bsr.w	SetIntroCol	

		;--------------------------------------------------------------------------------------------------------------
		; The following is more setup to complete the startup file 
		;--------------------------------------------------------------------------------------------------------------

		; Custom Chips HW Base Address
		lea		$dff000,a5

		;--------------------------------------------------------------------------------------------------------------
		; ENABLE COPPER
		;--------------------------------------------------------------------------------------------------------------
		lea		$dff000,a5
		move.l	#CopperList,$80(a5)	; Point to our copper


		;--------------------------------------------------------------------------------------------------------------
		; Init Bitplanes
		;--------------------------------------------------------------------------------------------------------------

		move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSize,d2			; Add the bitplane size to the source start Image Address
		bsr.w	SetBitPlanes				; Set the Bitplane Pointers

		;--------------------------------------------------------------------------------------------------------------
		; Init Music
		;--------------------------------------------------------------------------------------------------------------

		IF musicMode
			bsr.w	mt_init
		ENDIF


		; jsr colorsToGameColors

		; -----------------------------
		; create mask for 
		; font 
		; -----------------------------
		IF createFontMask


				move.l #2,d6

				move.l #screen,a0
				add.l #(512-6*16)*(64+320)/8,a0

			lines3:

				move.l #(320+64)*16/8,d3
			xorit:

				; plane 0
				clr.l d0
				move.b (a0),d0			
				move.l a0,a1
				; plane 1
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0
				; plane 2
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0
				; plane 3
				add.l #BitplaneSizeWide,a1
				or.b (a1),d0

				; store
				move.l a0,a2
				add.l  #16*(320+64)/8,a2
;				move.b #111,(a2)
				move.b d0,(a2)

				add.l #1,a0
				dbra d3,xorit


				add.l #16*(64+320)/8,a0

				dbra d6,lines3

		ENDIF

		;--------------------------------------------------------------------------------------------------------------
		; setup borders & co
		;--------------------------------------------------------------------------------------------------------------
		; https://www.amigarealm.com/computing/knowledge/hardref/ch3.htm#:~:text=The%20register%20DIWSTRT%20(for%20%22Display,DIWSTRT%20for%20a%20basic%20playfield.
		; display area
		; 
		; []
		; low-resolution:
		; playfield 320x200 

		move.w #border_offset_byte*2,screenoffset_x_borderleft ; odd  ; border_offset_byte
		move.w #border_offset_byte*2,screenoffset_x_borderright ; even

	
		move.w #0,scrollX
		move.w #0,scrollY
;		move.w #256,scrollY
		jsr updateCameraAndScrolling

		; move.w    $DFF006,$DFF180 ; background

		; up & down 
		move.w #1,direction

		; ------------------
		; some democode
		; ------------------
		; more complex than in the code
		; in the demo of course (32 pixels border)
			move.l #screen+(320+2*32)/8*(512+238),a0 ; screen-address:
			move.l #(320+2*32)/8*8,d3	; bytes of one line * 8 
		copyfor: 						; jump 
			move.b #%011001010,(a0)+    ; set the pixels activ 
			dbra d3,copyfor				; d3 = d3-1 ; if (d3>0) jmp copfor

scrollTextY = 196

		; ------------------
		; copy background
		; ------------------
		move.w #scrollTextY,copySourceY
		move.w scrollerPositionY,copySourceY
		move.w #256+80+16+16,copyTargetY
		jsr copySliceVertical		


; ------------------
demoloop:
; ------------------

			; vsync
		    bsr.w	WaitForRaster

		; move.w #0,cursorLeft

		; keyboard
		jsr _keyboard


		IF musicMode
			bsr.w	mt_music
		ENDIF

		; -------------------
		; up/down
		; -------------------
		cmp.w #1,showTech
		bne  showTech_if

			; up
			cmp.w #1,direction
			bne go_up
				add.w #1,scrollY
			cmp.w #255,scrollY
			bne   go_up
				move.w #0,direction
			go_up:

			; down
			cmp.w #0,direction
			bne go_down
				sub.w #1,scrollY
			cmp.w #1,scrollY
			bne   go_down
				move.w #1,direction
			go_down:

			jsr updateCameraAndScrolling

			; move.w    $DFF006,$DFF180 ; background
			; move.w scrollY,$DFF180

		showTech_if:

		; scroll down or up
		cmp.w #1,scrollDoIt
		bne scroll_xyt

			; scrollYTo: dc.w 0
			move.w scrollY,d0
			cmp.w scrollYTo,d0
			blt if_lowerthan
				sub.w #1,scrollY
				jsr updateCameraAndScrolling
				jmp iflowerthan_x
			if_lowerthan:
			cmp.w scrollYTo,d0
			bgt if_lowerthant
				add.w #1,scrollY
				jsr updateCameraAndScrolling
			if_lowerthant:
			iflowerthan_x:

			; end?
			move.w scrollY,d0
			cmp.w scrollYTo,d0
			bne tax
				move.w #0,scrollDoIt
			tax:
		scroll_xyt:


		; ------------------
		; copy up
		; ------------------
;		move.w #256+256-16,copySourceY
;		move.w #120,copyTargetY
;		jsr copySliceVertical		

; copyBlock16
;		move.w #64,copySourceX
;		move.w #512-16,copySourceY
;		move.w #64,copyTargetX
;		move.w #0,copyTargetY
;		jsr copyBlock16

		; ------------------
		; waiting
		; ------------------
		cmp.l #0,waitingCounter
		beq   if_waitingCE
			sub.l #1,waitingCounter
		if_waitingCE:

		cmp.l #0,waitingCounter
		bne   if_waitingC
			sub.w #1,scrollTextX ; scroller		

			cmp.w #1,scrollTextX
			blt   if_waitingC
			cmp.w #1,cursorLeft
			bne if_cursorleft
				sub.w #1,scrollTextX ; scroller		

			if_cursorleft:
		if_waitingC:

		; ------------------
		; scroller default
		; ------------------
		; more speed
		
		

		; default
		cmp.l #0,waitingCounter
		bne   if_scrollerTextX
		cmp.w #-1,scrollTextX
		bne if_scrollerTextX

	dumplyX:

			; from the beginning
			move.w #15,scrollTextX

			cmp.w #1,cursorLeft
			bne ohnono 
				move.w #14,scrollTextX
		ohnono:

			; jsr rainbow

			; scroll 16 pixel left ... 
;			move.w #256+80,copySourceY
;			move.w #256+80,copyTargetY
;			jsr copySliceVerticalShiftLeft
;
;				; mask
;				move.w #256+80+16,copySourceY
;				move.w #256+80+16,copyTargetY
;				jsr copySliceVerticalShiftLeft

			; copy left
			; scroll
			move.w #256+80,copySourceY
			move.w #256+80,copyTargetY
			move.w #32,copyHeight
			jsr copySliceVerticalShiftLeft
			move.w #16,copyHeight


			; scroll index 
			add.l #1,scrollindex

			; scrolltext: 
			move.l #scrolltext,a0
			add.l  scrollindex,a0
			clr.l d0
			move.b (a0),d0

			; end of the string
			cmp.b #0,d0
			bne ifnull
			   move.l #0,scrollindex
			   move.b #32,d0	
			ifnull:
			
			; commands

			; 103 - g - glitch
			cmpi.b #103,d0
			bne _keyboard_ifg
				move.w    $DFF006,$DFF180 ; background	  
				jmp nextchar
			_keyboard_ifg:

			; 119 - w - wait
			cmpi.b #119,d0
			bne _keyboard_ifw
				move.w #10,waitingCounter
				jmp nextchar
			_keyboard_ifw:

			; 116 - t - to
			cmpi.b #116,d0
			bne _keyboard_ift

				move.w #0,scrollYTo
				move.w #1,scrollDoIt

;				move.w #0,scrollX
;				move.w #0,scrollY
;				jsr updateCameraAndScrolling	
				jmp nextchar
			_keyboard_ift:

			; 99 - c - show code
			cmpi.b #99,d0
			bne _keyboard_ifc

				move.w #40,scrollYTo
				move.w #1,scrollDoIt

				; waitingCounter
;				move.w #0,scrollX
;				move.w #0,scrollY
;				jsr updateCameraAndScrolling	
				jmp nextchar
			_keyboard_ifc:

			; 100 - d - show code
			cmpi.b #100,d0
			bne _keyboard_ifd

				move.w #256,scrollYTo
				move.w #1,scrollDoIt

				; waitingCounter
;				move.w #0,scrollX
;				move.w #0,scrollY
;				jsr updateCameraAndScrolling	
				jmp nextchar
			_keyboard_ifd:

			; 102 - e - end show font
			cmpi.b #101,d0
			bne _keyboard_ife

				move.w #1,showfont

				jmp nextchar
			_keyboard_ife:

			; 103 - f - end show font
			cmpi.b #102,d0
			bne _keyboard_iff

				move.w #0,showfont

				jmp nextchar
			_keyboard_iff:


			; 109 - m - message
			cmpi.b #109,d0
			bne _keyboard_ifm
				move.w #0,scrollX
				move.w #185,scrollY
				jsr updateCameraAndScrolling	
				jmp nextchar
			_keyboard_ifm:


			; copy new char
			move.w #320+32+32-16,copyTargetX
			move.w #256+80,copyTargetY
			move.w #32,copyHeight
			jsr copyCharAt 
			move.w #16,copyHeight

			nextchar:

			; copy char
			;move.w #64,copySourceX
			;move.w #512-16,copySourceY
			;move.w #320+32+32-16,copyTargetX
			;move.w #256+80,copyTargetY
			;jsr copyBlock16


; BACKGROUND FROM A POINT
; 
		cmp.w #0,showfont
		bne if_fonttexture
			add.l #1,scrollCharXCounter
			cmp.l #20,scrollCharXCounter
			bne nft_fuck
				move.l #0,scrollCharXCounter
		nft_fuck:
			move.l scrollCharXCounter,d0
			mulu #16,d0
			add.l #32,d0
			move.w d0,copySourceX

			move.w #512-8*16,copySourceY

			move.w #320+32+32-16,copyTargetX
			move.w #256+80,copyTargetY
			jsr copyBlock16		
		if_fonttexture:



; always to this somewhere > same speed

			; add new char

		jmp if_scrollerTextX_End
		if_scrollerTextX:

			; some add ons? 
		

		if_scrollerTextX_End:




			; ------------------
			; backupground
			; ------------------
			; restore
			move.w #256+80+16+16,copySourceY
			move.w #scrollTextY,copyTargetY
			move.w scrollerPositionY,copyTargetY			
			jsr copySliceVertical	


			; ------------------
			; waving/wave
			; ------------------
			; no waving
			cmp.l #0,wave
			bne   if_waveactive
				move.w #scrollTextY,scrollerPositionY
			if_waveactive:

			; waving
			cmp.l #1,wave
			bne   if_waveactive_yes

				add.l #1,waveindex
				move.l #wave_tab,a0
				add.l waveindex,a0
				clr.l d1
				move.b (a0),d1

				cmp.b #255,d1
				bne restart_it
				   move.l #0,waveindex	
				restart_it:

				move.w #scrollTextY,scrollerPositionY
				sub.w #50,scrollerPositionY
				; move.w #10,d0
				add.w d1,scrollerPositionY

			if_waveactive_yes:
	

			; ------------------
			; copy background
			; ------------------
			move.w #scrollTextY,copySourceY
			move.w scrollerPositionY,copySourceY
			move.w #256+80+16+16,copyTargetY
			jsr copySliceVertical		


			; new text
			move.w #0,copySourceX
			move.w #256+80,copySourceY
			move.w scrollTextX,copyTargetX
			move.w #scrollTextY,copyTargetY
			move.w scrollerPositionY,copyTargetY			
			jsr bobCopyShifted






		; mouse click?
  	    btst   #6,$BFE001      
   		bne   if_mouseclicked


			cmp.l #1,clicked
			beq eee
				move.w #0,scrollX
	;			move.w #0,scrollY
				cmp.w #256,scrollY
				bne gbt 
				move.w #0,scrollY
				jmp xtl
				gbt:
				move.w #256,scrollY
				xtl:
				jsr updateCameraAndScrolling
			eee:

			move.l #1,clicked

			jmp if_mouseclicked_e
		if_mouseclicked:

			move.l #0,clicked

		if_mouseclicked_e:



; ------------------
		jmp demoloop
; ------------------

		bsr.w	mt_end

		; ---------------------------
		; BACK TO AMIGADOS
		; ---------------------------

;		movem.l	d0-d7/a0-a6,-(SP)
		movem.l	(SP)+,d0-d7/a0-a6

		rts


; ---------------------------
; SUBROUTINES
; ---------------------------

copySourceX: 	dc.w 0 ; 16?
copySourceY: 	dc.w 0

copyTargetX: 	dc.w 0  ; default 0
copyTargetY: 	dc.w 0

copyHeight: 	dc.w 16

; ----------------------------------
; COPYSLICE (Vertical)
; ----------------------------------
copySliceVertical:

		movem.l	d0-d7/a0-a6,-(SP)
		; movem.l	(SP)+,d0-d7/a0-a6

		; ----------------------------------
		; direct copying
		; ----------------------------------
		move.l #3,d4

			move.l #screen,tmpScreenAddress		

		copy_direct:
			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddress,a4

			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!!
				move.w #64*16+(2*32+320)/16,BLTSIZE(a6) ; $dff058 ; set size		

			add.l #BitplaneSizeWide,tmpScreenAddress
		dbra d4,copy_direct

		movem.l	(SP)+,d0-d7/a0-a6

		rts


; ----------------------------------
; copyBlock16:
; ----------------------------------
copyBlock16:

		movem.l	d0-d7/a0-a6,-(SP)


		; ----------------------------------
		; direct copying
		; ----------------------------------
		move.l #3,d4

			move.l #screen,tmpScreenAddress					
				clr.l d0
				move.w copySourceX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddress

			move.l #screen,tmpScreenAddressTarget		
				clr.l d0
				move.w copyTargetX,d0
				divu  #8,d0
				ext.w d0
				; mulu #2,d0
				add.l d0,tmpScreenAddressTarget

		copy_direct16:
			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddressTarget,a4

			jsr waitForBlitter		
			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
		
			move.w #(2*32+320-16)/8,BLTAMOD(a6); $dff066
			move.w #(2*32+320-16)/8,BLTDMOD(a6) ; todo: add skip factor !!!
			
;			move.w #64*16+16/16,BLTSIZE(a6) ; $dff058 ; set size		

				clr.l d1
				move.w copyHeight,d1
				mulu #64,d1
				add.l #+16/16,d1
				move.w d1,BLTSIZE(a6)

			add.l #BitplaneSizeWide,tmpScreenAddress
			add.l #BitplaneSizeWide,tmpScreenAddressTarget

		dbra d4,copy_direct16

		movem.l	(SP)+,d0-d7/a0-a6

		rts

; ----------------------------------
; COPY SHIFT LEFT SLICE (Vertical)
; ----------------------------------
copySliceVerticalShiftLeft:

		move.l #3,d4

			move.l #screen,tmpScreenAddress	
			add.l #2,tmpScreenAddress	
			move.l #screen,tmpScreenAddressTarget	

		copy_direct_shift:

			move.l tmpScreenAddress,a5			
			move.l tmpScreenAddressTarget,a4

			jsr waitForBlitter	

			move.l #$09f00000,BLTCON0(a6);$dff040 mode : combination + XORETC	
			move.l #$ffffffff,BLTAFWM(a6) ; mask 
				; SOURCE
			clr.l d1
			move.w copySourceY,d1 ; 16*y
				mulu #(2*border_offset_byte+40),d1
				add.l  d1,a5
				move.l a5,BLTAPTH(a6); $dff054  ; high & low
				; TARGET
			clr.l d1
			move.w copyTargetY,d1
				mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #2,BLTAMOD(a6); $dff066
				move.w #2,BLTDMOD(a6) ; todo: add skip factor !!!
				; move.w #64*16+(2*32+320-16)/16,BLTSIZE(a6) ; $dff058 ; set size
				clr.l d1
				move.w copyHeight,d1
				mulu #64,d1
				add #(2*32+320-16)/16,d1
				move.w d1,BLTSIZE(a6)		

			add.l #BitplaneSizeWide,tmpScreenAddress
			add.l #BitplaneSizeWide,tmpScreenAddressTarget

		dbra d4,copy_direct_shift

		rts

; --------------
; COPY & SHIFT Horizontal
; --------------
bobCopyShifted:

			; params
			move.l #screen,scrollingSource

			move.l #screen,scrollingTarget

			move.l #3,d6
all_planes:

			jsr waitForBlitter

				move.w #0,bob1616_x_raster
				move.w #0,bob1616_x_rest

				; bob1616_x_raster
				clr.l  d0
				move.w copyTargetX,d0
				divu   #16,d0
				swap.w   d0
				move.w d0,bob1616_x_rest
				clr.w  d0
				swap.w   d0
				move.w d0,bob1616_x_raster

				; COMMAND
					clr.l d1
					move.w  bob1616_x_rest,d1 
					ror.w	#4,d1
					move.w	d1,BLTCON1(a6) ;  set up the B scroll value !!!! (forgotten)   --- was not set!!!! 4 
					or.w	#$0fca,d1	; 	set up the A scroll value and the
					move.w	d1,BLTCON0(a6)	;	minterm for D = notA.C + B
				; TYPE OF MASK
				move.l #$ffff0000,BLTAFWM(a6) ; mask 
				; SOURCE
					move.l scrollingSource,a5
					clr.l d1
				move.w copySourceY,d1
					mulu #(2*border_offset_byte+40),d1
					add.l  d1,a5
					cmp.l #3,d6
					bne notthe_defaultmask

						move.l a5,scrollingSourceMask
						; version 1: no add
						; version 2: add on
						add.l #16*(320+64)/8,scrollingSourceMask

					notthe_defaultmask:

; try out
;	move.l scrollingSource,a5
;	add.l  #(320+2*32)/8,a5

					move.l a5,BLTBPTH(a6); 
				; MASK
				move.l scrollingSourceMask,BLTAPTH(a6); MASK

				; TARGET
					move.l scrollingTarget,a4
					clr.l d1
					move.w copyTargetY,d1
					mulu #(2*border_offset_byte+40),d1
				add.l    d1,a4

				move.l a4,BLTCPTH(a6); target - screen - xor screen
				move.l a4,BLTDPTH(a6); $dff054  ; high & low
				move.w #0,BLTAMOD(a6); $dff066 ; skip source
				move.w #0,BLTBMOD(a6); $dff066 ; skip source
				move.w #0,BLTCMOD(a6) ; todo: add skip factor !!! ; skip target
				move.w #0,BLTDMOD(a6) ; todo: add skip factor !!! ; skip target

			; SIZE - copyHeight
			move.w #64*16+(2*32+320)/16,BLTSIZE(a6) ; $dff058 ; set size	

			add.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight,scrollingSource 
			add.l #(320*screenFactorWidth+2*border_offset)/8*256*screenFactorHeight,scrollingTarget
				
		dbra d6,all_planes
		; all 4 planes :-(

		rts


; ---------------------------
; CHAR
; ---------------------------

charParsed: dc.l 1

copyCharAt:

			move.l #0,charParsed
			movem.l	d0-d7/a0-a6,-(SP)

			; start x/y
			move.w #32+16,copySourceX
			move.w #512-6*16,copySourceY

			; space
			cmp.b #32,d0
			bne if_space
				move.w #32,copySourceX
				move.w #0,d0
				move.l #1,charParsed
				jmp direct_char				
			if_space:

			; 0-9 48
			cmp.b #48,d0
			blt if_num
			cmp.b #48+10,d0
			bgt if_num
				sub.l #48,d0
				move.w #32,copySourceX				
				move.w #512-2*16,copySourceY
				move.l #1,charParsed
				jmp direct_char
			if_num:

			; T+
			cmp.w #84,d0
			blt if_tplus
			cmp.w #65+28,d0
			bgt if_tplus
				sub.w #84,d0
				move.w #32,copySourceX
				move.w #512-4*16,copySourceY
				move.l #1,charParsed
				jmp direct_char
			if_tplus:

; sonderzeichen
			move.l #sonderzeichen,a0
		searchchar:
			clr.l d1
			clr.l d2
			move.b (a0)+,d1
			move.b (a0)+,d2

				cmp.b d0,d1
				bne if_foundsonderzeichen
					move.w #32,copySourceX
					clr.l d0
					move.w d2,d0
					move.w #512-4*16,copySourceY	
					move.l #1,charParsed				
					jmp direct_char		
				if_foundsonderzeichen:

			cmp.b #0,d1
			bne searchchar

		sonderzeichen_done:

			; default
			; d0
			cmp.w #64,d0
			bls   if_aplus
			cmp.w #65+30,d0
			bgt   if_aplus
				sub.l #65,d0
				move.l #1,charParsed
			if_aplus:
			; update source

			

			cmp.l #0,charParsed
			bne parsedXYZ
			    move.w #0,d0
				move.w #144,copySourceX
				move.w #480,copySourceY		
			parsedXYZ:

		direct_char:

			; copy char
			mulu #16,d0
			add.w d0,copySourceX

		direct_char_direct: ; .-) stupid name

			jsr copyBlock16

			; and the mask!
			; copy the mask now

		; todo: param!

			add.w #16,copySourceY
			add.w #16,copyTargetY
			jsr copyBlock16

			movem.l	(SP)+,d0-d7/a0-a6

			rts
; ---------------------------
; HELPERS
; ---------------------------

waitForBlitter:
			lea $dff000,a6  ; blitter base 
					move.w #$8040,DMACON(a6) ; enable blitter with offset
					tst DMACONR(a6); $dff002
			waitblittingbob16:
					btst #6,DMACONR(a6); $dff002
					bne waitblittingbob16

			rts 


; ------------------------
; debug effect
; ------------------------
rainbow: 
		move.w    $DFF006,$DFF180 ; background
		rts

work_start: 
		move.w    $0,$DFF180 ; background
		rts

work_stop: 
		move.w    $DFF002,$DFF180 ; background
		rts


; ------------------------
; screen
; ------------------------

updateCameraAndScrolling: 

		jmp xyz
		; check if something changed
		move.w  scrollX,d0
		cmp.w hscrollX,d0
		bne   updateCamera
		move.w  scrollY,d0
		cmp.w hscrollY,d0
		bne   updateCamera
		jmp   nocameraupdate
updateCamera:

		xyz:



BitplaneSizeWide =((320*screenFactorWidth+2*32)/8)*256*screenFactorHeight	; 256!			; Size of 1 Bitplanes

	    move.l	#GameScreenBitplanes,d0		; Source Image Address that is the address of Bitplane 1
;		cmp.l #0,scrollCameraAddress
;		beq    noextracamera
;			move.l scrollCameraAddress,d0
noextracamera:		

	   add.l   #address_screen_addframe,d0  ; border

;
;		clr.l   d5
;		move.w  scrollY,d5
;		divu    #16,d5
;		ext.l   d5
;		add.l   d5,d0
		
		; yscroll
		clr.l   d5
		move.w scrollY,d5
		mulu    #40*screenFactorWidth+2*border_offset_byte,d5
		add.l   d5,d0
		lea		GameBitplanePointers,a0		; Bitplane Pointers in the Copper

		lea		$dff000,a5
		moveq.l	#NoOfBpls-1,d1				; Number of Bitplanes
		move.l	#BitplaneSizeWide,d2			; Add the bitplane size to the source start Image Address
		bsr	SetBitPlanes 



nocameraupdate:

		rts

;======================================================================================================================
;  Chip Data Section / Chipmemory
;======================================================================================================================

;======================================================================================================================
; Requires Chip Mememory
;======================================================================================================================

		SECTION	Copper,DATA_C

;======================================================================================================================
; Main Game Screen - Copper List
;======================================================================================================================

CopperList:


SpritePointers:
SpritePointer0:
		dc.w	$0120,$0000,$0122,$0000		; Sprite 0
SpritePointer1:
		dc.w	$0124,$0000,$0126,$0000		; Sprite 1
SpritePointer2:
		dc.w	$0128
EnemySpritePtr:
		dc.w	$0000,$012a,$0000			; Sprite 2
SpritePointer3:
		dc.w	$012c,$0000,$012e,$0000		; Sprite 3
SpritePointer4:
		dc.w	$0130,$0000,$0132,$0000		; Sprite 4
SpritePointer5:
		dc.w	$0134,$0000,$0136,$0000		; Sprite 5
SpritePointer6:
		dc.w	$0138,$0000,$013a,$0000		; Sprite 6
SpritePointer7:
		dc.w	$013c,$0000,$013e,$0000		; Sprite 7

ScreenDefinition:
		; Screen Definition

ScreenDefStartY:
		dc.w	$008e,$2c81					; DiwStrt
		dc.w	$0090,$2cc1					; DiwStop
		dc.w	$0092,$0038					; DdfStart LoRes
		dc.w	$0094,$00d0					; DdfStop LoRes
		dc.w	$0102,$0000					; BplCon1
		dc.w	$0104,$003f					; BplCon2 - Sprite on top of Both Playfields (%0000 0000 0011 1111)
;       screen offset 
		dc.w	$0108
screenoffset_x_borderleft:		
		dc.w $0000					; Bpl1Mod - left - even 		
		dc.w	$010a
screenoffset_x_borderright:
		dc.w $0000					; Bpl2Mod - right - odd?

		;15	HIRES	    HIRES = High resolution (640*200/640*400 interlace) mode
		;14	BPUx	    Bit planes use
		;13	BPUx	    Bit planes use
		;12	BPUx	    Bit planes use
		;11	HAM	        Hold and modify mode, now using either 6 or 8 bit planes.
		;10	DPF	        Double playfield (PF1 = odd & PF2 = even bit planes) now available in all resolutions.
		;               If BPU = 6 and HAM = 0 and DPF = 0 a special mode is defined that allows bitplane
		;               6 to cause an intensity reduction of the other 5 bitplanes. 
		;               The color register output selected by 5 bitplanes is shifted to half intensity by the 6th bit plane.
		;               This is called EXTRA-HALFBRITE Mode.
		;09	COLOR	    Enables color burst output signal
		;08	GAUD	    Genlock audio enable. This level appears on the ZD pin on denise during all blanking periods, unless ZDCLK bit is set.
		;07	UHRES	    Ultrahi res enables the UHRES pointers (for 1k*1k) also needs bits in DMACON (hires chips only).
		;               Disables hard stops for vert, horiz display windows.
		;06	SHRES	    Super hi-res mode (35ns pixel width)
		;05	BYPASS=0	Bit planes are scrolled and prioritized normally, but bypass color table and 8 bit wide data appear on R(7:0).
		;04	BPU3=0	    See above (BPUx)
		;03	LPEN	    Light pen enable (reset on power up)
		;02	LACE	    Interlace enable (reset on power up)
		;01	ERSY	    External resync (HSYNC, VSYNC pads become inputs) (reset on power up)
		;00	ECSENA=0	When low (default), the following bits in BPLCON3 are disabled: BRDRBLNK,BRDNTRAN,ZDCLKEN,BRDSPRT, and EXTBLKEN.
		;               These 5 bits can always be set by writing to BPLCON3, however there effects are inhibited until ECSENA goes high.
		;               This allows rapid context switching between pre-ECS viewports and new ones.

	BPLCON0:
					;  5432109876543210
		dc.w	$0100,%0100001000000000		; bit 13 - 4 bitplanes, 16 colors, Lo-Res

		;15	ENSP7	Enable Sprite 7 (ORed with Sprite 6)
		;14	ENSP5	Enable Sprite 5 (ORed with Sprite 4)
		;13	ENSP3	Enable Sprite 3 (ORed with Sprite 2)
		;12	ENSP1	Enable Sprite 1 (ORed with Sprite 0)
		;11	ENSP6	Enable bit plane 6 (match reqd. for collision)
		;10	ENSP5	Enable bit plane 5 (match reqd. for collision)
		;09	ENSP4	Enable bit plane 4 (match reqd. for collision)
		;08	ENSP3	Enable bit plane 3 (match reqd. for collision)
		;07	ENSP2	Enable bit plane 2 (match reqd. for collision)
		;06	ENSP1	Enable bit plane 1 (match reqd. for collision)
		;05	ENSP6	Match value for bit plane 6 collision
		;04	ENSP5	Match value for bit plane 5 collision
		;03	ENSP4	Match value for bit plane 4 collision
		;02	ENSP3	Match value for bit plane 3 collision
		;01	ENSP2	Match value for bit plane 2 collision
		;00	ENSP1	Match value for bit plane 1 collision

				;      5432109876543210
		dc.w	$0098,%1111000000000000		; CLXCON  $dff098
; 		dc.w	$0098,%1110000000000000		; CLXCON  $dff098

		dc.w	$00e0
GameBitplanePointers:
		dc.w	$0000,$00e2,$0000			; bitplane 1
		dc.w	$00e4,$0000,$00e6,$0000		; bitplane 2
		dc.w	$00e8,$0000,$00ea,$0000		; bitplane 3
		dc.w	$00ec,$0000,$00ee,$0000		; bitplane 4

InGameColors:
    dc.w    $0180
GameScreenColours:

; PALETTE CHANGE HERE ... 

; {0X000,0X111,0X610,0X444,0X910,0X060,0X088,0Xf10,0X888,0X0a0,0X0cc,0Xccc,0X0ff,0X0f0,0Xff0,0Xfff}

color_0:
    dc.w    $0000                       ; color00 - plane 1
    dc.w    $0182
color_1:
	dc.w $0111                 ; color01 - plane 1 
    dc.w    $0184
color_2:	
	dc.w $0610                 ; color02 - plane 2
    dc.w    $0186
color_3:	
	dc.w $0444                 ; color03 - plane 2
    dc.w    $0188
color_4:		
	dc.w $0910                 ; color04 - plane 3
    dc.w    $018A
color_5:			
	dc.w $0060                 ; color05 - plane 3
    dc.w    $018C
color_6:
	dc.w $0088                 ; color06 - plane 3
    dc.w    $018E
color_7:
	dc.w $0f10                 ; color07 - plane 3
    dc.w    $0190
color_8:	
	dc.w $0888                 ; color08 - plane 4
    dc.w    $0192

; 0X0a0,0X0cc,0Xccc,0X0ff,0X0f0,0Xff0,0Xfff}

color_9:
	dc.w $00a0                ; color09 - plane 4
    dc.w    $0194
color_10:
	dc.w $00cc                 ; color10 - plane 4
    dc.w    $0196
color_11:
	dc.w $0ccc                 ; color11 - plane 4
    dc.w    $0198
color_12:	
	dc.w $00ff                 ; color12 - plane 4
    dc.w    $019A
color_13:	
	dc.w $00f0                ; color13 - plane 4
    dc.w    $019C
color_14:
	dc.w $0ff0                ; color14 - plane 4
    dc.w    $019E
color_15:	
	dc.w $0fff                 ; color15 - plane 4
 
;    dc.w    $0000                       ; color00 - plane 1
;    dc.w    $0182,$0fff                 ; color01 - plane 1 
;    dc.w    $0184,$0fff                 ; color02 - plane 2
;    dc.w    $0186,$0fff                 ; color03 - plane 2
;    dc.w    $0188,$0fff                 ; color04 - plane 3
;    dc.w    $018A,$0fff                 ; color05 - plane 3
;    dc.w    $018C,$0fff                 ; color06 - plane 3
;    dc.w    $018E,$0fff                 ; color07 - plane 3
;    dc.w    $0190,$0fff                 ; color08 - plane 4
;    dc.w    $0192,$0fff                 ; color09 - plane 4
;    dc.w    $0194,$0fff                 ; color10 - plane 4
;    dc.w    $0196,$0fff                 ; color11 - plane 4
;    dc.w    $0198,$0fff                 ; color12 - plane 4
;    dc.w    $019A,$0fff                 ; color13 - plane 4
;    dc.w    $019C,$0fff                 ; color14 - plane 4
;    dc.w    $019E,$0fff                 ; color15 - plane 4


; 0 always transprent
; _1,2,3 for two sprites !

SpritesColours:
		; Sprite 0 and 1 Colours
		dc.w	$01A0
spritecolor_01_0:		
		dc.w	$0000					; color16 - Transparent
		dc.w	$01A2
spritecolor_01_1:				
		dc.w 	$0fff					; color17 - Sprite Colour 1 - White 
		dc.w	$01A4

PlayerColour:
spritecolor_01_2:		
		dc.w	$0fff							; color18 - Sprite Colour 2 - Brown
		dc.w	$01A6
spritecolor_01_3:		
		dc.w 	$0fff					; color19 - Sprite Colour 3 - Black

		; Sprite 2 and 3 Colours
spritecolor_4:
		dc.w	$01A8
spritecolor_23_0:		
		dc.w    $0000					; color20 - Transparent
		dc.w	$01AA
spritecolor_23_1:				
		dc.w 	$00c0					; color21 - Sprite Colour 1
		dc.w	$01AC
spritecolor_23_2:						
		dc.w 	$0080					; color22 - Sprite Colour 2
		dc.w	$01AE
spritecolor_23_3:						
		dc.w 	$0040					; color23 - Sprite Colour 3

		; Sprite 4 and 5 Colours
		dc.w	$01b0
spritecolor_45_0:				
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b2
spritecolor_45_1:						
		dc.w 	$0c00					; color21 - Sprite Colour 1
		dc.w	$01b4
spritecolor_45_2:					
		dc.w 	$0800					; color22 - Sprite Colour 2
		dc.w	$01b6
spritecolor_45_3:
		dc.w 	$0400					; color23 - Sprite Colour 3

		; Sprite 6 and 7 Colours
		dc.w	$01b8
spritecolor_67_0:		
		dc.w 	$0000					; color20 - Transparent
		dc.w	$01b
spritecolor_67_1:		
		dc.w 	$00cc					; color21 - Sprite Colour 1
		dc.w	$01bC
spritecolor_67_2:		
		dc.w 	$0088					; color22 - Sprite Colour 2
		dc.w	$01bE
spritecolor_67_3:
		dc.w    $0044					; color23 - Sprite Colour 3

		; band
;		DC.W    $FFA1,$FF00 	; wait 
		; http://amigadev.elowar.com/read/ADCD_2.1/Hardware_Manual_guide/node004B.html
;		dc.w	$0180,$0200   ; set color
;		DC.W    $FFA8,$FF00 	; wait 
;		dc.w	$0180,$0900   ; set color

		
		dc.w	$ffdf,$fffe		; ?
		dc.w	$FFFF,$FFFE					; End of copperlist


; -----------------------------
 ; KEYBOARD
 ; -----------------------------

		even
keyPressed:
	dc.w 1

_keyboard:
	movem.l d0-d2,-(sp)

	;Vérifier dans ICR que la requête est bien générée par le CIA A aur l'événement SP (bascule des 8 bits reçus du clavier dans SDR)

	btst #3,$BFED01
	beq _keyboardNotKeyboard

	;Lire les 8 bits dans SDR et détecter s'il s'agit de la pression ou du relâchement d'une touche

	move.b $BFEC01,d0
	btst #0,d0
	bne _keyboardKeyDown
	move.w #$00F0,d1		;Touche relâchée : couleur vert
	bra _keyboardKeyUp
_keyboardKeyDown:
	move.w #$0F00,d1		;Touche pressée : couleur rouge
_keyboardKeyUp:

	;Changer la couleur de fond si la touche pressée est celle attendue (ESC)

	not.b d0
	lsr.b #1,d0

	move.l #0,d1

	; key pressed
	clr.l d2
	move.b d0,d2
	move.w d2,keyPressed

	; speed 1x 
	cmpi.b #$20,d0
	bne _keyboardNotA

		move.w #0,cursorLeft
		move.w #0,scrollLeftUp

	_keyboardNotA:

	; speed 2x
	cmpi.b #$21,d0
	bne _keyboardNotS

		move.w #1,cursorLeft
		move.w #0,scrollLeftUp

	_keyboardNotS:






	cmpi.b #$45,d0
	bne _keyboardNotESC
	; move.w d1,COLOR00(a5)
	  move.w    $DFF006,$DFF180 ; background
	;  move.w #1,cursorLeft
_keyboardNotESC:

	; 1 ... 
	cmpi.b #$01,d0
	bne _keyboardNot1
		move.l #demo_project-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot1:

	; 2 ... 
	cmpi.b #$02,d0
	bne _keyboardNot2
		move.l #team_project-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot2:

	; 3 ... 
	cmpi.b #$03,d0
	bne _keyboardNot3
		move.l #demo_greets-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot3:

	; 4
	cmpi.b #$04,d0
	bne _keyboardNot4
		move.l #demo_tech-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot4:

	; 5
	cmpi.b #$05,d0
	bne _keyboardNot5
		move.l #team_zuerich-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot5:

	; 6 
	cmpi.b #$06,d0
	bne _keyboardNot6
		move.l #team_hkb-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot6:

	; 7 
	cmpi.b #$07,d0
	bne _keyboardNot7
		move.l #team_unibe-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot7:

	; 8
	cmpi.b #$08,d0
	bne _keyboardNot8
		move.l #team_unil-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot8:

	; 9
	cmpi.b #$09,d0
	bne _keyboardNot9
		move.l #demo_results-scrolltext,scrollindex
		move.l #1,d1
_keyboardNot9:

	; jump to ... 
	cmp.l #1,d1
	bne if_scrolljump

		move.w    $DFF006,$DFF180 ; background

		move.w #256-8,copySourceY
		move.w #256+80,copyTargetY
		jsr copySliceVertical	

		move.w #256-8,copySourceY
		move.w #256+80+16,copyTargetY
		jsr copySliceVertical	

		jsr reset_all

	if_scrolljump:


	;Acquitter auprès du clavier en maintenant à 0 le signal sur sa ligne KDAT durant 85 us, ce qui s'effectue en positionnant SPMODE à 1 dans CRA ("software must pulse the line low for 85 microseconds to ensure compatibility with all keyboard models" et "the KDAT line is active low [...] a low level (0V) is interpreted as 1"). Pour rappel, une ligne raster, c'est 227,5 cycles de 280 ns, donc 63,7 us, ce qui signifie qu'il faut attendre que le raster ait parcouru deux lignes. Maintenant, ce n'est pas très élégant d'attendre que le raster se balade en se tournant les pouces...

	bset #6,$BFEE01
	
	move.l $DFF004,d0
	lsr.l #8,d0
	and.w #$01FF,d0
	moveq #2-1,d1
_keyboardWait85us:
	move.l $DFF004,d2
	lsr.l #8,d2
	and.w #$01FF,d2
	cmp.w d0,d2
	beq _keyboardWait85us
	move.w d2,d0
	dbf d1,_keyboardWait85us

	bclr #6,$BFEE01

_keyboardNotKeyboard:
	movem.l (sp)+,d0-d2
	rts

 
 ; rest all 
 reset_all:
    
		move.l #0,direction
		move.l #0,waitingCounter

		move.w #0,scrollDoIt

		move.w #1,showfont

		; waitingCounter
		move.w #0,scrollX
		move.w #0,scrollY
		jsr updateCameraAndScrolling		

	rts

 even

;======================================================================================================================
;  VARS
;======================================================================================================================

clicked: dc.l 0

counter: dc.w 0

scrollTextX: dc.w 1 

showTech: dc.w 0

direction: dc.w 1

waitingCounter: dc.l 0

scrollingSource: dc.l 0
scrollingSourceMask: dc.l 0
scrollingTarget: dc.l 0

bob1616_screen: dc.l 0

bob1616_id:	dc.w 0
bob1616_x:	dc.w 10   
bob1616_y:	dc.W 10  

bob1616_x_raster: dc.w 10
bob1616_x_rest: dc.w 0

actualHiddenScreenAddress: dc.l 0
actualHiddenScreenAddressAdd: dc.l 0

tmpScreenAddress: dc.l 0
tmpScreenAddressTarget: dc.l 0

scrollX: dc.w 0
scrollY: dc.w 0
hscrollX: dc.w 2001
hscrollY: dc.w 2001

; scrolling
scrollDoIt: dc.w 0
scrollYTo: dc.w 0

scrollTextPositionY: dc.w 196

scrollCameraAddress: dc.l 0

scrollCharXCounter: dc.l 0

showfont: dc.w 1

scrollerPositionY: dc.w 196

cursorLeft: dc.w 0

scrollLeftUp: dc.w 0

wave: dc.l 0
waveindex: dc.l 0
	even 
wave_tab: 
	dc.b 0
	dc.b 0
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 3
	dc.b 3
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 4
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 3
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 2
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 1
	dc.b 255

; --------------------------------
; SCROLLING-TEXT
; --------------------------------
	even
scrollindex: dc.l 0
	even
scrolltext: 
	; test
	; dc.b "  FONT:  +':,()[]#.-!? ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 "

;	dc.b "  COMMANDS: GLITCH gggg WAIT  SCROLLING s TOP t CODE c MESSAGE _ TOGGLEFONT f "

	; dc.b "  CODEggc  f  WAS SOLL DAS? WO BIST DU? e  WOW d IS ALL GOD THIS t "

;	dc.b " HELLO WORLD. wARE YOU OUT THERE? I LIVE INSIDE THIS COMPUTER. AND GUESS WHAT. ONCE COMPUTERS WILL RULE THE WORLD HAHA "




;	dc.b " f'FUCK WHAT A DIRTY PLAIN FONT! COULDNT YOU DO SOMETHING WITH MORE COLORS AND HAND RENDERED 3D? THE AMIGA IS ABOUT COLORS!' e OF COURSE WE CAN. :-) "

; f //// e 

	dc.b " (PIONIEERS) YOU ARE THE PIONEERS OF THE DIGITAL! ON YOUR APPLE II, TI99, MS-DOS, BBC MICRO, C64, MSX, UNIX, MAC, HYPERTEXT, ATARI ST, AMIGA, WIN95, HTML, SHOCKWAVE, JAVASCRIPT, FLASH, JAVA AND AND AND. YOU ARE THE DEVELOPERS OF GAMES, DEMOS, (CRACKS AND VIRUSES). WE WOULD LIKE TO THANK YOU FOR ALL YOUR WORK FROM 1970 - 2000! THANK YOU! YOU BUILT SOMETHING IN A TIME WHEN TECHNOLOGY WAS NOT LOVED AND GAMES WERE HELLISH. YOU DEVELOPED GRAPHICS, ANIMATIONS, SOUND EFFECTS, MUSIC AND A LOT OF CODE. AND PUT THIS ALL TOGETHER. GAMES IN ACTION. INTERACTIVE MULTIMEDIA IN THE EARLY DAYS. YOU DEVELOPED NOT EXISTING - NEW WORLDS IN DEMOS OR GAMES: THE CYBERSPACE. THE LIST OF GAMES FROM YOU IS NOW 200 ENTRIES LONG. ALTHOUGH MANY OF YOU DIDN'T STAY IN GAME DESIGN, YOU ALSO BUILD UP THE NEW  FIELD OF IT.  WE ALSO SAY HERE; THANK YOU VERY MUCH.         YOUR ARTIFACTS ARE THE SUBJECT OF THE CONFOEDERATIO LUDENS PROJECT. "

demo_project: 

	dc.b " (DEMO) YOU CAN SEE THE MAP OF SWITZERLAND. TO THE LEFT OF THE MAP YOU CAN SEE THE HARDWARE AND SOFTWARE DEVELOPMENTS THAT CAME FROM OUTSIDE. IN THE CENTER IS SWITZERLAND WITH ITS DEVELOPMENTS AND THE SHIFT IN DEVELOPMENT FROM THE JOYSTICK TO THE MOUSE AS AN INPUT DEVICE FOR SELF-DEVELOPED PERSONAL COMPUTER GAMES. ON THE RIGHT-HAND SIDE YOU CAN SEE THE SOFTWARE INNOVATIONS AND THE POLITICAL CHANGES. THIS IS A SIMPLE RESEARCH DEMO OF OUR EXPERIMENTAL ARCHEOLOGY FOCUS. THE RESEARCH QUESTION WAS;'HOW COMPLEX WAS IT TO CREATE A SIMPLE AMIGA DEMO?'. THE TOPIC THE RESEARCH PROJECT CHLUDENS. THE RESULT YOU FIND AT THE END OF THE SCROLLTEXT OR ON RESEARCH.SWISSIGITIZATION.CH.  THE DEMO WAS RELEASED AT MOUNTAINBYTES.CH 2025. CODE AND VISUALS BY LA1N, MUSIC BY COMPUTERMUSIKER.  "

team_project:
	dc.b " (PROJECT) "
	dc.b " CONFOEDERATIO LUDENS IS AN SNF RESEARCH PROJECT EXPLORING THE SWISS GAME DESIGN SCENE FROM 1970-2000. DO YOU STILL HAVE A GAME ON A DISK? THEN LET US KNOW VIA OUR WEBSITE. YOU CAN ALSO FIND OUT MORE ABOUT THE PROJECT IN GENERAL AT; WWW.CHLUDENS.CH OR WRITE AN E-MAIL TO INFO AT CHLUDENS.CH "
	dc.b " THE PARTNERS OF THE PROJECT ARE ZHDK, HKB, UNIBE, UNIL  "

demo_greets: 
	; demo
	dc.b " (GREETINGS) THANKS TO DEPECHE FOR ALL THE HELP AND OF COURSE RWERNER, SCA, RHEUBI, CHALLER, JESPERSON, DEPECHE, PACKERMANN, PRESOLE, BANDIT, BLOODY MARY, CARINA, UNLOCK, SHANA, DIPSWITCH AND JJUUL. CODE IS EVERYTHING IN DEMOS BUT THERE IS NO SOURCE CODE INSIDE DEMOS GREETINGS FROM R2GF; LET THE SWISS NATIONAL VIDEO GAME MUSEUM BE! "

demo_tech: 
	; demo
	dc.b " (TECHNICS)  IT IS IN 68000 ASSEMBLY - 16+32 BIT. A VERY COOL PROCESSOR FOR DEVELOPERS. SIMPLE STRAIGHT NOT LIKE THE CHEAP 6502! "

	dc.b "THE 'SCREEN' HAS A 32 PX BORDER LEFT AND RIGHT (FOR HIDDING THE CREATING OF THE SCROLLTEXT). IT IS 512 PIXEL HEIGHT. ONLY THE FIRST 256 PX YOU SEE, THE REST IS SCROLLTEXT BUFFER AND THE FONT. YOU CAN ALWAYS WITH THE MOUSEBUTTON SWITCH BETWEEN THE 'TWO SCREENS' (IN FACT IT IS ONE MEMORY AREA, THERFORE YOU CAN SCROLL IN IT DOWN LIKE IN SOME SECONDS). THE SCREEN HAS 4 LAYERS (PLANES) - MEANS 16 COLORS. EXAMPLE 4 LAYERS (BITPLANES) ; 1 0 0 1 IS THE COLOR 9 (1+8). AND EVEN MORE COMPLICATED; 1 BYTE IN THIS BITPLANE CODES FOR 8 PIXELS.  "
	dc.b "WRITING DIRECTLY IN A BITPLANE YOU SEE HERE IN GREEN. c THIS CODE CREATES THE DARK RED PATTERN. IT WRITES 8 LINES WITH 40 BYTES (320 BYTES) INTO THE SCREEN-MEMORY. "
	dc.b "BUT FOR A 16 COLOR PIXEL, YOU HAVE TO DO THIS ON 4 LAYERS. SO YOU HAVE TO DO THE SAME THING 4 TIMES. A LOT OF BLITTER WORK.  t STUPID THING! EXPANDABLE YES. BUT EVERYTHING IS SPREADED IN THE MEMORY. "
	dc.b "WHY IS SO FLICKERING? THE GLITCH HAPPENS BECAUSE THE SCROLLTEXT IS NOT EVERY TIME PAINTED, WHEN THE CATHODIC BEAMS COMES BY. YOU COULD SOLVE THIS BY USING DOUBLEBUFFERING. YOU SHOW ONE SCREEN AND IN THE BACKGROUND YOU CREATE THE OTHER AND THEN SHOW IT. THIS WOULD BE MUCH MORE WORK AND WE WOULDNT SEE THE PROBLEMS OF A 'SIMPLE' DEMO. "
	dc.b "THE 'SCROLLER'; THE ONLY CHALLENGE IN THIS DEMO. d HOW IT WORKS; "
	dc.b " 0. YOU TAKE THE BACKUP AND COPY IT BACK TO THE SCREEN. "
	dc.b " 1. YOU MAKE A BACKUP AGAIN. "
	dc.b " 2. YOU SHIFT LEFT - 15 TIMES THE TEXTBUFFER TO THE VISIBLE SCREEN (BLITTER)"
	dc.b " 3. YOU SHIFT NOW THE TEXTBUFFER (INCL. MASK) 16 PIXELS LEFT AND ADD THE NEXT CHAR (AND MASK) FROM THE CHARBLOCKS "
	dc.b " 4. YOU WAIT FOR THE NEXT SCREEN-REFRESH "
	dc.b " 5. AND THEN ENDLESS FROM 0 "

;	dc.b " (AMIGA) A VERY INTERESTING MACHINE THE SOUND POSSIBILITIES ARE OF COURSE FANTASTIC. "
;	dc.b " AS I GAMEDESIGNER I WOULD LIKE TO HAVE MORE SPRITES (NO COMPUTING POWER USED) AND USE THEM FOR THE SCROLLTEXT. BUT THE SPRITES ARE TRASH (8 x SPRITES WITH 4 COLORS AND 2 HAVE THE SAME COLOR). SO YOU HAVE TO USE THE BLITTER, WHICH IS A COOL THING FOR 1985. BUT YOU HAVE TO DO A LOT ON YOUR OWN. BACKUP THE BACKGROUND, COPY THE BITPLANES AND AFTER USAGE, RESTORE. THIS IS A LOT OF MANGEMENT WORK AND USES A LOT OF TIME.    "


team_zuerich:
	dc.b "  "
	dc.b "  (TEAM ZHDK) "
	dc.b " HEY SIS AND BROS, DON'T YOU KNOW, WE ARE THE KINGS AND PROS. CREDIT TO US.  THAT'S MELAKKO, THE ARCADE LIGHTNING BOLT, IXISTENZ, THE RELENTLESS  EXCAVATOR AND RE-MAKER OF INNOVATIONS, INMIU, THE ENTHUSIASTIC AND CRITICAL DEVELOPER ASSESSOR, ZIJAN, THE INCREDIBLE WEBFLOWING DATA AND NETWORK ANALYZER, DAVEBENTFIELD, THE OMNISCIENT COMMUNITY MOLE, FLUFFYADRENALINE, THE UNBELIEVABLY FOCUSED PLOWER OF MEDIA ARCHIVES, AND CYBERSUTER, THE UNRESTRAINED FAST-PACED INFORMATION JUNKIE. THAT'S US, THE GAMELAB OF ZHDK, THE GREAT CH-LUDENS ZURICH TEAM, THE KEEPERS OF TIME AND HISTORY OF SWISS GAME DESIGN.  LARISSA; GREETINGS EARTHLINGS DID YOU KNOW EVEN ALIENS ARE INTERESTED IN THE HISTORY OF SWISS GAME DEVELOPMENT THIS MEANS YOU SHOULD DEFINITELY ALSO BE INTERESTED IN OUR PROJECT CH-LUDENS MY FOCUS IS ON RESEARCHING HOW EARLY SWISS GAME DEVELOPERS MADE GAMES YOU KNOW, I’M INTERESTED IN THE WORKFLOWS AND PRACTISES THAT WERE COMMON IN THE 80S AND 90S IN SWISS VIDEO GAME PRODUCTION WERE THEY ALL JUST FREAKS? OR WERE THEY GENUIS AND INNOVATORS?MAYBE BOTH! BUT THE GAME DESIGN SCENE IN THE 80S WAS VERY ACTIVE OUR DATABASE CONTAINS OVER 200 SWISS GAMES MADE IN THE YEARS BETWEEN 1968 TO 2000! INCREDIBLE! BEFORE I GIVE THE WORD BACK TO THE TEAM I WANT TO GREET PANDALF AND PERLIN. WHO THE HELL ARE THEY? THEY ARE MY CATS! MEOW MEOW MEOW  HERE IS FUN FACT THE LONGEST SCROLLTEXT HAS AROUNDD 450 BLOCKS AND WAS RELEASED IN 1990 IN A COMMODORE 64 DEMO CALLED THE LONGEST SCROLLTEXT BY BABOONS  DAVE; SHOUTOUT TO THE EARLY SWISS GAMEDEVS ;P MANY THANKS TO SSI, CHRIS H., BIG APPLE, SATURNUS THE INVINCIBLE AND RENE S.!   MELAKKO; HEYALL FELLOW PINBALL LOVERS! SORRY FOR THE HOMECOMPUTERS, BUT PINBALL IS NOT DEAD! LET'S KEEP TILTING, KEEP FLIPPERING! GREETS TO YOU FROM MELAKKO  CYBERSUTER;  THE OLD SWISS GAME DESIGN SCENE WAS HIP AND HOT AND A LOT BETTER THAN YOU THOUGHT! LOCKED UP IN A CHICKEN COOP THEY MADE A SHOOT’EM UP. HURDLED TOGETHER IN A RAILROAD KEEPER'S COTTAGE FAR FROM CIVILIZATION, THEY CODED AND MADE ADVENTURE GAMES WHILE GETTING FED NOTHING BUT  POLENTA DAY IN, DAY OUT. "  

team_hkb:
	dc.b " "
	dc.b "  (TEAM HKB BERN) "
	dc.b " THE FIRST GAME OF PONG. A LITTLE SOLITAIRE ON THE COMPUTER IN THE OFFICE. PLAYING ARCADE MACHINES IN THE VILLAGE PUB. AFTERNOONS AT YOUR FRIENDS CONSOLES. SWAPPING GAMES IN THE SCHOOL YARD. THE FIRST GAMES STORES, MAJOR GAMING EVENTS, COMMUNITY MEETINGS. PLAYING IN THE TOY DEPARTMENT OF THE JELMOLI DEPARTMENT STORE.  ALL THESE MEMORIES ARE AN IMPORTANT PART OF EARLY GAMING CULTURE IN SWITZERLAND. THE AIM OF THE CH-LUDENS SUB-PROJECT SWISS GAMESCAPES+ IS IT TO USE ORAL HISTORY TO PRESERVE THE EVERYDAY HISTORY OF THIS EARLY GAMING CULTURE AND THUS ALSO TO EXPAND HISTORICAL KNOWLEDGE ABOUT DIGITAL MEDIA AND THEIR USE IN SWITZERLAND AND THIS EARLY PHASE OF THE DIGITALIZATION OF SOCIETY.  EUGEN PFISTER; MEIN VATER BRACHTE MIR VON DER KINDHEIT AN BEI COMPUTER ALS GANZ SELBSTVERSTAENDLICHEN BESTANDTEIL MEINER WELT ZU VERSTEHEN. ICH BIN MIT COMPUTERN AUFGEWACHSEN, ZUERST EINEN SCHNEIDER CPC, DANN SEHR FRUEH EINEN EIGENEN IBM PC, OHNE DAS JE ZU HINTERFRAGEN. DAS FORSCHUNGSINTERESSE VON HISTORIKER*INNEN IST IMMER AUCH ZU EINEM TEIL AUTOBIOGRAPHISCH BEDINGT. SO AUCH BEI MIR. VERMUTLICH ERFORSCHE ICH DIE GESCHICHTE DIGITALER SPIELE, WEIL SIE SEIT MEINER KINDHEIT ZENTRALER MOMENT MEINES LEBENS SIND. HEUTE HABE ICH ABER DAS WERKZEUG, DIESE SELBSTVERSTAENDLICHKEIT HISTORISCH KRITISCH ZU HINTERFRAGEN, UND SO ERKENNTNISSE ZU GEWINNEN, DIE UEBER MEINE PERSOENLICHE BIOGRAFIE WEIT HINAUSREICHEN.  ADRIAN; THGIE SENDS MUCH LOVE TO HIS FOLKS AT LUDENS, ALL LURKERS AND HIS SISTER (YOURE AWESOME). LUDOLOGY VS. NARRATOLOGY? LOL ;3 YOURE BOTH WRONG. DRINK COFFEE AND EAT DONUTS LIKE ITS 1990 AND DALE COOPER IS IN THE HOUSE.    "

team_unibe:
	dc.b " "
	dc.b "  (TEAM BERN UNIVERSITY) "
	dc.b "  NO TEXT  "

team_unil:
	dc.b " "
	dc.b "  (TEAM UNIL LAUSANNE) "
	dc.b " THE LAUSANNE TEAM IN CHLUDENS CONSISTS OF PIERRE-YVES, SOPHIE, GUILLAUME, JOHAN AND YANNICK. THEY EXCAVATE AND STUDY DIODES AND VIDEO GAMES CREATED IN WELSCHLAND, FOCUSING ON THE PRACTICE OF CREATING THESE GAMES AND MANIPULATING WHAT WERE ONCE FUTURISTIC MACHINES THAT PROMISED TO FREE US FROM CORRUPTION AND DECREPITUDE (THOUGH WE KNOW THAT THE FUTURE TOOK A DIFFERENT DIRECTION). WE WOULD LIKE TO PAY TRIBUTE TO ALL OF THE RACCOONS IN THE WORLD, WITH THEIR TINY HANDS, WHO HELP US SEE THINGS FROM A DIFFERENT PERSPECTIVE. SHOUT OUT TO ALCATRAZ, ARC ANGELS, LIQUID SQUAD, INSERT COIN, DACTAR VII, THE AMIGA TASK FORCE, CATHY, JDN, BLUPI, COLONEL YAGOV, CURZIO, ARIZONA SOFTWARE, MARIELLE STAMM, ELECLUB READERS, GONISOFT, VTX, LE CONCEPT MODERNE, CHRIS CHAUFFAT, ARCANTEL, ROSSET, AND JUERI! WE FORGET MANY OTHERS...   "

demo_results:

	dc.b "   (RESULTS) FIRST PROBLEM WAS TO FIND A TOPIC TO BE HONEST. ABOUT WHAT? IF I DO SIZECODING IT IS CLEAR, BUT A SIMPLE DEMO? YOU WILL SAY; 'THERE MUST BE A MESSAGE.' BUT TECHNIC CAN NOT BE THE ONLY MESSAGE.  "
	dc.b " MORE ABOUT THE RESULTS DIRECTLY HERE; "
	dc.b " RESEARCH.SWISSDIGITIZATION.CH SEARCH FOR CHLUDENS AND DEMO  "
	dc.b " "

restart: 
	dc.b " THIS IS NO BOOK, SO YOU DON'T HAVE TO READ TO THE END. THERE IS NO AHA EFFECT. NO 3 ACTS. SORRY 3 2 1 [RESTART]  "
	dc.b 0
	even


; https://www.gladir.com/LEXIQUE/POLICES/amigaascii.htm
sonderzeichen: ; there is no better word than sonderzeichen .-) 
			   ; it is also one point, why so long there were no german/french software versions .-(

	; +':,()[]#.-!?

	dc.b 43,7 ;+ 
	dc.b 39,8 ;'
	dc.b 58,9 ;:
	dc.b 59,9 ; ; < :
	dc.b 44,10 ;,

	dc.b 40,11 ;(
	dc.b 41,12 ;)

	dc.b 91,13 ;[
	dc.b 93,14 ;]

	dc.b 35,15 ;#
	dc.b 46,16 ;.

	dc.b 45,17 ;-
	dc.b 33,18 ;!
	dc.b 63,19 ;?

	dc.b 0,0	


	even

; --------------------------------
; MUSIC AREA
; --------------------------------
mt_data:
		incbin "music.mod"
mt_data_End:

; --------------------------------
; SCREEN AREA
; --------------------------------
screen:
BackofficeBitplanes:
GameScreenBitplanes:
IntroScreen:
		incbin "gfx/title.planes"
		; blk.b (2*border_offset_byte+40*screenFactorWidth)*256*screenFactorHeight*4,0 ; 256 y coords


 
  