; ad libitum techno pot
; 256b tiny executable music - lovebyte 2o25
; 386+/dos/opl at 0x388
;
; yet another boring tekkkno stuff, this time on almighty OPL2
;
; altp.com   - compo version, 256b, no OPL register write delays
; altp_d.com - 307b version with register delays
;
; ------------
; artёmka // ot0mata labs ^ sibkrew // 15.o2.2o25
; t.me/wbcbz7 | discord:wbcbz7 | wbcbz7.at@gmail.com | github.com/wbcbz7
;
; best regards to otl guys for moral (and not only) support =)
;
        org     0x100
        use16

; minimal tracker interface :D (right to left)
SEQ_TRACK       equ     0b0000000000000000  ; ref track
;-----------------------------------------
;                         ddddwwwwvvvviiii
SEQ_DRUM        equ     0b0111011101111111
SEQ_HAT         equ     0b1111111011111000
SEQ_RIM         equ     0b1111000011111100
SEQ_RESOBASS    equ     0b1111111111111110
SEQ_SNARE       equ     0b1111000011110000
SEQ_RIDE        equ     0b1111110011000000
SEQ_PLUCK       equ     0b1111011100000000

; add OPL register write delays for real hardware
;%define ADD_DELAYS

; clear OPL registers
;%define CLEAR_REGISTERS

start:
        mov     dx, 0x388

%ifdef CLEAR_REGISTERS
        ; ------------------
        ; OPL init loop
        xor     ax, ax
.1:
        out     dx, ax
        inc     al
        jnz     .1
        ; ------------------
%endif

        ; initialize instruments
        mov     si, instr
.set_instr:
        mov     cl, 7       ; number of instruments loaded
.chanloop:
        push    cx
        lodsw
        mov     cl, 4       ; reuse cl
.oploop:
        out     dx, al
%ifdef ADD_DELAYS
        call    delay
%endif
        inc     dx
%ifndef ADD_DELAYS
        outsb
%else
        call    outsb_delay
%endif
        dec     dx
        add     al, dh      ; dh = 3
        out     dx, al
%ifdef ADD_DELAYS
        call    delay
%endif

        inc     dx
%ifndef ADD_DELAYS
        outsb
%else
        call    outsb_delay
%endif
        dec     dx
        add     al, (0x20 - 0x03)
        loop    .oploop
        mov     cl ,2
        mov     al, ah
.regloop:
        out     dx, al
%ifdef ADD_DELAYS
        call    delay
%endif
        inc     dx
%ifndef ADD_DELAYS
        outsb
%else
        call    outsb_delay
%endif
        dec     dx
        add     al, 0x20
        loop    .regloop
        pop     cx
        loop    .chanloop

        ; main lOOOOp
        ; bx - bar counter
.mainloop:
        hlt
        shld    di, bx, (16 - 7)   ; cx - pattern number (128 ticks per pattern)

%if 1
        ; resobass "fliter sweep"
        ;lea     ax, [di+48]
        mov     ax, di
        or      al, 0x30
        neg     ax
        mov     ah, al
        mov     al, 0x29+0x20
%ifndef ADD_DELAYS
        out     dx, ax
%else
        call    outpw_delay
%endif
%endif

%if 1
        ; kick
        mov     bp, SEQ_DRUM
        mov     si, 0b0000000100000001
        mov     ax, 0x00B0
        call    seq16
%endif

%if 1
        ; rim
        mov     bp, SEQ_RIM
        mov     esi, 0b10011000000100000001100000010000
        mov     ah, 0x15
        call    seq
%endif

%if 1
        ; hat
        mov     bp, SEQ_HAT
        mov     si, 0b0001000000010000
        mov     ah, 0x15
        call    seq16
%endif

%if 1
        ; snare
        mov     bp, SEQ_SNARE
        mov     si, 0b0000000100000000
        mov     ah, 0x06
        call    seq16
%endif

%if 1
        ; reso bass
        mov     bp, SEQ_RESOBASS
        mov     si, 0b0000000100000001
        mov     ah, 0x01
        call    seq16
%endif

%if 1
        ; ride cymbal
        mov     bp, SEQ_RIDE
        mov     ah, 0x16
        call    seq16                   ; reuse same inner seq
%endif

%if 1
        ; sub plucks
        mov     bp, SEQ_PLUCK
        mov     esi, 0b10001000100110001001100010011000
        mov     ah, bl
        shr     ah, 1
        and     ah, 6
        add     ah, 0x15    ; 0x15

        call    seq
%endif

        ; increment tick counter
        inc     bx

        ; kbhit()
        in      al, 0x60
        dec     al
        jnz     .mainloop

        ; cleanup and exit
        ret

        ; play sequence
        ; bp - pattern sequence, esi - inner sequence, ah - block, al - block reg index
        ; di - tick number, cx - pattern number
seq16   equ     $+1         ; skip 0x66 prefix -> bt si, bx
seq:
        bt      esi, ebx    ; test inner sequence
        jnc     retretret
        bt      bp, di      ; test pattern sequnece
        jnc     retretret

        ; retrig the instrument
        ; dx - 0x388, al - reg, ah - data with bit 5 reset
retrig:
%ifndef ADD_DELAYS
        out     dx, ax
%else
        call    outpw_delay
%endif
        or      ah, 0x20
%ifndef ADD_DELAYS
        out     dx, ax
%else
        call    outpw_delay
%endif
retretret:
        inc     ax          ; advance to next channel
        ret

        ; register format:
        ; 20, 23, 40, 43, 60, 63, 80, 83, a0, c0
instr:
        ; ch0 - kick drum
        dw      0xA020  ; chanbase/opbase
        db      0x02    ; op0 mult
        db      0x03    ; op1 mult
        db      0x00    ; op0 tl
        db      0x00    ; op1 tl
        db      0xf8    ; op0 ad
        db      0xf1    ; op1 ad
        db      0xd9    ; op0 sr
        db      0x41    ; op1 sr
        db      0xd9    ; fnum
        db      0x36    ; fb

        ; ch1 - closed hat
        dw      0xA121  ; chanbase/opbase
        db      0x08    ; op0 mult
        db      0x0F    ; op1 mult
        db      0x01    ; op0 tl
        db      0x00    ; op1 tl
        db      0xf6    ; op0 ad
        db      0xf8    ; op1 ad
        db      0xf7    ; op0 sr
        db      0xFD    ; op1 sr
        db      0xcc    ; fnum
        db      0x08    ; fb

        ; ch2 - semi-open hat
        dw      0xA222  ; chanbase/opbase
        db      0x03    ; op0 mult
        db      0x00    ; op1 mult
        db      0x00    ; op0 tl
        db      0x02    ; op1 tl
        db      0xA8    ; op0 ad
        db      0xF7    ; op1 ad
        db      0xFD    ; op0 sr
        db      0xFA    ; op1 sr
        db      0xB2    ; fnum
        db      0x30    ; fb

        ; ch3 - "snare"
        dw      0xA328  ; chanbase/opbase
        db      0x0C    ; op0 mult
        db      0x00    ; op1 mult
        db      0x02    ; op0 tl
        db      0x00    ; op1 tl
        db      0xF5    ; op0 ad
        db      0xD6    ; op1 ad
        db      0x2D    ; op0 sr
        db      0x4D    ; op1 sr
        db      0x44    ; fnum
        db      0x3C    ; fb

        ; ch4 - main bass
        dw      0xA429  ; chanbase/opbase
        db      0x05    ; op0 mult
        db      0x08    ; op1 mult
        db      0x0A    ; op0 tl
        db      0x00    ; op1 tl
        db      0x22    ; op0 ad
        db      0x48    ; op1 ad
        db      0x09    ; op0 sr
        db      0x6F    ; op1 sr
        db      0xB3    ; fnum
        db      0x3A    ; fb

        ; ch5 - ride cymbal (FINALLY!)
        ; ripped from abstract's eon opl3 cover and tuned a bit :)
        dw      0xA52A  ; chanbase/opbase
        db      0x89    ; op0 mult
        db      0x06    ; op1 mult
        db      0x0E    ; op0 tl
        db      0x00    ; op1 tl
        db      0xF0    ; op0 ad
        db      0xC7    ; op1 ad
        db      0xF0    ; op0 sr
        db      0x44    ; op1 sr
        db      0x23    ; fnum
        db      0x3E    ; fb

        ; ch6 - sub plucks or idk
        dw      0xA630  ; chanbase/opbase
        db      0xCB    ; op0 mult
        db      0x01    ; op1 mult
        db      0x08    ; op0 tl
        db      0x04    ; op1 tl
        db      0xF8    ; op0 ad
        db      0xD8    ; op1 ad
        db      0xFC    ; op0 sr
        db      0xCD    ; op1 sr
        db      0xB3    ; fnum
        db      0x30    ; fb

%ifdef ADD_DELAYS
        ; write register
outpw_delay:
        push    ax
        out     dx, al
        call    delay
        inc     dx
        mov     al, ah
        out     dx, al
        dec     dx
        call    delay
        pop     ax
        ret

outsb_delay:
        outsb
        call    delay
        ret

delay:
        push    ax
        mov     ah, 30
.1:
        in      al, dx
        dec     ah
        jnz     .1
        pop     ax
        ret
%endif

        ; ps.  hitech >> tekno. prove me wrong =)
