;------------------------------
;Fireflies
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;512b intro
;Lovebyte 2025
;
;326 bytes of code
;168 bytes of data
;2 bytes of header
;496 bytes total
;------------------------------

.TARGET_SIZE=512

NextCharsPtrL=$fa
NextCharsPtrH=$fb
TmpPtrL=$fc
TmpPtrH=$fd

OldX=$02
OldY=$03
CurrentChar=$04
CurrentOffset=$05
ObjectsIndex=$06
IsOutsideEdge=$07


;OffsetLStack=$08-$0f (8 objects max)
;.............$10-$18 (2nd part of trail)
;....................
;.............$40-$47 (8th part of trail)
;.............$48-$50 (clear part of trail - $20)
;OffsetHStack=$50-$57
;.............$58-$5f
;....................
;.............$88-$8f
;.............$90-$97
;CharStack   =$98-$9f
;.............$a0-$a7
;....................
;.............$e0-$e7
;.............$e8-$ef
;NextCharsPtrLTable=$f0-$f7

OffsetLStack=$08
OffsetHStack=$50
CharStack=$98
NextCharsPtrLTable=$f0

Delay=$fe

PosX=$1000
PosY=$1100

START_X=19
START_Y=12
MAX_X=40
MAX_Y=25
MAX_OBJECTS=8 ;>=0 <=8

USE_RND_TIMER=0


*=$080d ; SYS 2061

.CODE_START
   sei
   
   jsr $e544  
   
   dex
   stx $d020
   stx $d021
   
   

   
;"clear" $08-$f7   
;we use NextChars
;low byte pointer
;for initial char printing
;address also (this is
;somewhere behind the code)

   ldx #$ef
   lda #<NextChars
-
   sta $08,x
   dex
   bne -
   
   
   ldx #MAX_OBJECTS-1
-
   lda #START_X
   sta PosX,x
   lda #START_Y
   sta PosY,x
   
   lda #<($0400+START_Y*40+START_X)
   sta OffsetLStack,x
   lda #>($0400+START_Y*40+START_X)
   sta OffsetHStack,x
   dex
   bpl -
   
!if USE_RND_TIMER=0{   
   inx
   stx $d40f
   lda #$1f
   sta $d40e
   lda #$80
   sta $d412
}   
   
   lda #>NextChars
   sta NextCharsPtrH 
   

WaitForRaster   
   lda #250
-
   cmp $d012
   bne -
   
   dec Delay
   bne +
   lda .MaxObjects
   tax
   sbx #256-1
   cpx #MAX_OBJECTS
   bcs +
   stx .MaxObjects
+   
      
.MaxObjects=*+1    
   lda #0;MAX_OBJECTS-1
   sta ObjectsIndex

ObjectsLoop

;Get low byte of
;NextChars table
   ldx ObjectsIndex
   lda NextCharsPtrLTable,x
   sta NextCharsPtrL
   
;Random index
!if USE_RND_TIMER=1{   
   lda $dc04
   and #$1f
   sta $d40e
   lda $dc04
   adc $d41b
}else{   
   lda $dc04
   lsr
   ora $dc05
}
   and #%00001110   
   tay   
   
;Get next character   
   lda (NextCharsPtrL),y   
   sta CurrentChar
   tax
   lda Chars,x  
   
   ldx ObjectsIndex
   sta CharStack,x
   
   lda PosX,x
   sta OldX
   lda PosY,x
   sta OldY         
   
;Screen offset   
   iny
   lda (NextCharsPtrL),y  
   tay 
   sta CurrentOffset
  
;Accumulated offset
;to dx,dy   
   ldx #8
-
   dex
   lda Offsets,x
   cmp CurrentOffset
   bne -

;Calc new pos  
   txa
   asl
   tay
   
   lda #0
   sta IsOutsideEdge
      
   ldx ObjectsIndex

   lda PosX,x
   clc
   adc Deltas,y
   sta PosX,x
   
   lda PosY,x
   clc
   adc Deltas+1,y
   sta PosY,x
   bpl +
   inc IsOutsideEdge
+   
   cmp #MAX_Y
   bmi +
   inc IsOutsideEdge
+
   lda PosX,x
   bpl +
   inc IsOutsideEdge
+   
   cmp #MAX_X
   bmi +
   inc IsOutsideEdge
+   

;Is outside edge?
   lda IsOutsideEdge
   beq +
   
;Yes
;Revert old pos
   lda OldX
   sta PosX,x
   lda OldY
   sta PosY,x
   
;and set opposite
;direction char
   lda CurrentChar
   eor #1
   sta CurrentChar
   lda #0
   sta CurrentOffset

+      
;Update offset
   lda CurrentOffset
   clc
   adc OffsetLStack,x
   sta OffsetLStack,x
   lda CurrentOffset
   and #$80
   beq +
   lda #$ff
+
   adc OffsetHStack,x
   sta OffsetHStack,x
   

;Draw trail
   txa
   sbx #256-8*8
   
   ldy #0
-   
   lda OffsetLStack,x
   sta TmpPtrL
   lda OffsetHStack,x
   sta TmpPtrH   
   pha
   lda CharStack,x
  ; beq +
   sta (TmpPtrL),y
   pla
   clc
   adc #$d4
   sta TmpPtrH
   txa
   pha
   lsr
   lsr
   lsr
   tax
   lda Colors,x
   sta (TmpPtrL),y
   pla
   tax
;+   
;   txa
   sbx #8
   bpl -
   
;Move queue
   ldx ObjectsIndex
   sbx #256-7*8
   
   lda #$20
   sta CharStack,x
-   
   lda OffsetLStack,x
   sta OffsetLStack+$8,x
   lda OffsetHStack,x
   sta OffsetHStack+$8,x
   lda CharStack,x
   sta CharStack+$8,x
   
   txa
   sbx #8
   bpl -
   
   lda CurrentChar
   asl
   asl
   asl
   asl
   ;clc
   adc #<NextChars
   ldx ObjectsIndex
   sta NextCharsPtrLTable,x
   
   dec ObjectsIndex
   bmi +
   jmp ObjectsLoop
+   

   jmp WaitForRaster   
   
.CODE_END   
   
   
.DATA_START

NextChars
!byte 4,-40,0,-40,0,-40,4,-40,6,-39,3,1,6,-39,5,1
!byte 6,1,2,40,3,41,7,40,7,40,1,40,5,41,2,40
!byte 7,-1,6,-40,7,-1,1,-1,0,-41,4,-41,2,-1,1,-1
!byte 3,1,0,-40,4,-40,0,-40,6,-39,5,1,4,-40,6,-39
!byte 2,-1,0,-41,4,-41,6,-40,1,-1,1,-1,7,-1,7,-1
!byte 1,40,6,1,3,41,3,41,7,40,2,40,6,1,5,41
!byte 3,1,0,-40,0,-40,6,-39,4,-40,6,-39,5,1,4,-40
!byte 0,-1,4,-1,7,39,5,40,1,39,3,40,2,39,0,-1

Chars
;0 top
!byte $67 
;1 down
!byte $67
;2 left
!byte $77
;3 right
!byte $77
;4 left-top
!byte $4d
;5 right-down
!byte $4d
;6 right-top
!byte $4e
;7 left-down
!byte $4e


Offsets
!byte -41
!byte -40
!byte -39
!byte -1
!byte 1
!byte 39
!byte 40
!byte 41

Deltas
!byte -1,-1
!byte 0,-1
!byte 1,-1
!byte -1,0
!byte 1,0
!byte -1,1
!byte 0,1
!byte 1,1

Colors
;!byte 1,7,13,3,14,4,2,6   ;color
;!byte 1,1,10,10,8,8,2,2,9,9 ;red
;!byte 1,1,15,15,12,12,11,11 ;gray
;!byte 1,7,13,3,5,14,4,6 ;green
!byte 1,3,3,14,14,4,4,6 ;blue

.DATA_END


!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   