;------------------------------
;Zefram Cochrane's first flight
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;256b intro
;Lovebyte 2025
;
;169 bytes of code
;75 bytes of data
;2 bytes of header
;246 bytes total
;------------------------------

.TARGET_SIZE=256

*=$2b80-3 ; SYS 11133
.CODE_START
   sei
   bvc Start

Rocket
!byte $06,$00,$00
!byte $06,$00,$00
!byte $0f,$00,$00
!byte $09,$00,$00
!byte $00,$00,$00
!byte $10,$80,$00
!byte $14,$80,$00
!byte $14,$80,$00
!byte $10,$80,$00
!byte $14,$80,$00
!byte $10,$80,$00
!byte $10,$80,$00
!byte $14,$80,$00
!byte $10,$80,$00
!byte $30,$c0,$00
!byte $70,$e0,$00
!byte $f9,$f0,$00
!byte $ff,$f0,$00
!byte $c6,$30,$00
!byte $06,$00,$00
!byte $00,$00,$00

Start

;Clear screen 
;set ink color
;enable sprite 0
   lda #1
   sta $d021
   jsr $e536
   
   stx $d015
   stx $d01a
   
;Sprite 0 PosX
;and pointer   
   lda #24+19*8-2
   sta $d000
   sta $7f8 ;$2b80=174*64

;Sid noise
;generator
;sprite 0 PosY
;and fore/background
   ldx #$80; $81
   stx $d001
   stx $d020
   stx $d021   
   stx $d412
   dex
   stx $dc0d
   stx $d40e   
   
;Setup IRQ
   lda #<IRQ
   sta $314
   lda #$94
  ; asl
   ;sbc #8
   sta $d012
   lda #>IRQ
   sta $315
   ;lda #$1b
   lsr
   sta $d011
   
   cli
      
Loop     
;Scroll-down
;screen
   ldx #22
--   
   jsr $e9f0
   lda $d1
   adc #40
   sta $fc
   lda $d2
   adc #0
   sta $fd
   
   ldy #39
-
   lda ($d1),y
   sta ($fc),y
   dey
   bpl -
   
   dex
   bpl --
   
;Clear line 0   
   ldy #39
   jsr $ea0a
      
;Exhaust
   ldx #11
   ldy #19
-
   txa
   pha
   sbx #256-12
   jsr $e9f0
   pla
   tax
   
   lda Chars,x
   pha
   sta ($d1),y

   jsr $ea24

   pla
   sta ($f3),y
   dex
   bpl -  
   
;Draw random star
;at line 0   
   ldy $d41b
   lda #$2e
   sta $0400,y
      
   bvc Loop

IRQ
   ldy #100
--
   ldx $d012
-
   cpx $d012
   beq -
   
;ROM data as shifts
   lda ($05),y ;$06=$b3
   eor $dc04
   and #3
   sta $d016      
   
   dey
   bne --

   inc $05
   
   asl $d019
   
   jmp $ea31


   
.CODE_END

.DATA_START

Chars
;!byte $42,$42,$e7,$f5,$e7,$f4,$e7,$f4,$a0,$a0
;!byte $21,$21,$7f,$ff,$ac,$af,$dc,$ac,$dc,$bb,$bb
;!byte $3a,$18,$3a,$18,$dc,$cc,$dc,$cb,$bb,$cb,$bb
;!byte $3a,$18,$3a,$18,$bf,$bf,$dc,$cc,$dc,$cb,$bb
;!byte $21,$47,$21,$47,$ea,$ea,$c8,$c8,$d9,$d9,$f9,$f9
;!byte $47,$ea,$ea,$e8,$e8,$dc,$cc,$dc,$cb,$bb,$cb
;!byte $21,$47,$21,$47,$ea,$ea,$c8,$c8,$dc,$cc,$cc
!byte $47,$ea,$ea,$e8,$e8,$81,$a1,$dc,$9c,$dc,$9c,$dc

.DATA_END

!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   