;-------------------
;Airshow
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;256b intro
;Lovebyte 2025
;
;203 bytes of code
;44 bytes of data
;2 bytes of header
;249 bytes total
;-------------------

.TARGET_SIZE=256

Sine=$1000
SpriteDest=$c40
AircraftsCounter=$02


*=$080d ; SYS 2061

.CODE_START

   sei

   jsr $e544
      
   ;ldx #$00
   dex
   stx $d020
   stx $d021
  ; stx $fa
  ; stx $fb
  ; stx $fc
  ; stx $fd
   
   
;Sinus quarter counter    
   ldy #$3f
;and 6 sprites enabler   
   sty $d015   
   
;White Flame's
;sinus generator   
-
   lda $fb
 ;  clc
   adc $fd
   sta $fb
   lda $fc
   adc $fe
   sta $fc

   sta Sine+$c0,x
   sta Sine+$80,y
   eor #$7f
   sta Sine+$40,x
   sta Sine+$00,y
 
   lda $fd
   adc #8
   sta $fd
   bcc +
   inc $fe
+
   inx

;Copy 64 bytes
;of sprite
   lda Sprite,y
   sta SpriteDest,y
;emptying half
   lda #0
   sta SpriteDest+30,y
   
   
;Sprites X at the end
   dcp $d000+10-$3f,y
      
   dey
   bpl -
  
   sty $5a
   sty $58
   
 ;  iny
   sty $fc
   
;Copy ROM
   jsr $a3e8

   lda #$60
   sta $e777

   lda #$35
   sta $01

MainLoop
;Scroll left
   ldx #24
-   
   ldy #0
   jsr $e9f0
   jsr $ea24
   jsr $e762
   dex 
   bpl -

;Sinus wave
;index
   ldy $fc
   sty $fd
   
   inc $fc   

AircraftsCounter=*+1
   ldx #0
-   
   txs

;Set sprites
;colors and pointers
   lda #SpriteDest/64;1
   sta $d027,x
   ;lda #SpriteDest/64
   sta $7f8,x
   
;Multiply x by 2
   txa
   asl
   tax
   
;Sprites Y according to wave
  ; ldy $fd
   lda Sine,y
   adc #40+8*4
   sta $d001,x
   
   pha
;Screen Y
;128/8=16
   lsr
   lsr
   lsr
   
;Y to screen ptr
   tay
   ldx #7
   lda $d3,y
   sax $ad
   lda $ecea,y
   sta $ac
   pla
   sbx #0
;Value & 7
   lda Chars,x
   ldy #28
   sta ($ac),y
;Color RAM pointer
   jsr $e9e3
   tsx
   lda Colors,x
;Wave color
   sta ($ae),y

;Next wave
;starts 28b further
   tya
   adc $fd
   sta $fd
   tay
   
;Increment number
;of aircrafts
   bne +
   
   lda AircraftsCounter
   cmp #5
   bcs +
   inc AircraftsCounter
+
;Next aircraft
   dex
   bpl -
   
;Animate propeller   
   lda SpriteDest+8
   eor #1
   sta SpriteDest+8
   ;eor #1
   sta SpriteDest+20

   jmp MainLoop
  

.CODE_END

.DATA_START   
Colors
!byte 2,8,7,5,14,4
Chars
!byte $77,$45,$44,$43,$43,$46,$52,$6f

Sprite
!byte $20,$03,$f8,$60,$06,$d8,$f8,$01,$20,$fe,$76,$fe,$ff,$fd,$bf,$0f
!byte $ff,$fe,$08,$1f,$f8,$00,$00,$00,$00,$00,$30,$00,$00,$30

.DATA_END


!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   