
{$r vga_1024.rc}

//{$define romoff}

uses crt, vbxe, atari;


const
	pic = VBXE_OVRADR;

	pic1 = VBXE_OVRADR+320*240;
	pic2 = pic1+80*240;
	pic3 = pic2+80*240;
	pic4 = pic3+80*240;


var	i,j, v: byte;

	xdl: txdl absolute VBXE_XDLADR+VBXE_WINDOW;


procedure movBlt(src, dst: cardinal; w: word; h: byte); assembler;
asm
	:3 mva src+# _src+#
	:3 mva dst+# _dst+#

	lda w
	sta _src_w
	sub #1
	sta _width
	lda w+1
	sta _src_w+1
	sbc #0
	sta _width+1

	ldy h
	dey
	sty _height

	mwa MAIN.SYSTEM.SCREENWIDTH _dst_w

		fxs FX_MEMS #$80+MAIN.SYSTEM.VBXE_XDLADR/$1000

		ldy #20
		mva:rpl bltCop,y MAIN.SYSTEM.VBXE_WINDOW+MAIN.SYSTEM.VBXE_BCBTMP,y-

		fxs FX_BL_ADR0 #MAIN.SYSTEM.VBXE_BCBTMP	; program blittera od adresu MAIN.SYSTEM.VBXE_BCBTMP
		fxs FX_BL_ADR1 #$00			; zaraz za programem VBXE Display List
		fxsa FX_BL_ADR2

		fxs FX_BLITTER_START #$01		; !!! start gdy 1 !!!

wait		fxla FX_BLITTER_BUSY
		bne wait

		fxs FX_MEMS #$00

		rts

bltCop

_src		.long $000000				; source address
_src_w		.word 256				; source step y
		.byte 1					; source step x
_dst		.long $000000				; destination address
_dst_w		.word 320				; destination step y
		.byte 1					; destination step x
_width		.word 256-1				; width
_height		.byte 256-1				; height

blt_mask	dta 0xff				; and mask (and mask equal to 0, memory will be filled with xor mask)
		dta 0x00				; xor mask
		dta 0x00				; collision and mask
		dta 0x00				; zoom
		dta 0x00				; pattern feature
		dta 0x00				; control
end;


begin

 if VBXE.GraphResult <> VBXE.grOK then begin
  writeln('VBXE not detected');
  halt;
 end;

// VBXEMemoryBank($80);
// xdl.ov_width := %00010001;	// playfield pal = 0 ; overlay pal = 1 ; width = 2

 SetHRes(VBXE.VGAMed, 320);

 SetTopBorder(1);
 SetXDLHeight(240);

 ColorMapOn;

 poke(559,0);



 for j:=1 to 30 do		// color map -> col 35..40
  for i:=1 to 40 do begin

   v:=((i-1) div 10) shl 4;

   ColorMapControl:=v;	// overlay palette #2

   GotoXY(i,j);
   SetColorMapEntry;
  end;


 movBlt(pic1, pic, 80, 240);
 movBlt(pic2, pic+80, 80, 240);
 movBlt(pic3, pic+160, 80, 240);
 movBlt(pic4, pic+240, 80, 240);

 repeat until keypressed;

 VBXEOff;

end.
