
/*
0-4 pattern intro
4-8 perushimmailua
8-14 realpart 1
14-20 realpart 2

*/


Demo.prototype.sceneIntro = function () {
  //Utils.setSeed(8008717);
  Utils.setSeed(4508712);
  this.setScene('intro');

  this.loader.addAnimation({
    image: '_embedded/defaultWhite.png',
    shape: { type: 'SKYSPHERE' },
    scale: [{ uniform2d: 1.0}],   
    color: [{r:.1,g:.2,b:.6}
      ,{duration:91.25, r:.1,g:.2,b:.6}
      ,{duration:0, r:.4,g:.15,b:.15}]
  });





  this.loader.addAnimation({
    image: ['_embedded/defaultWhite.png'],
    perspective: '3d',
    position:[{"x":()=>window.camPos,"y":()=>window.camPos,"z":0.0}],
    scale: [{ uniform2d: 1.0}],        
    "material":{
      depthTest: true,
      depthWrite: true,
      blending: 'NormalBlending'
    },
    "shader":{
      "name":["rayMarcher.vs","rayMarcher.fs"],
      "variable":
      [          
        {"name":"MAX_STEPS","type":"float","value":[100.0]},
        {"name":"inCamPos","type":"vec3","value":[()=>window.camPos]},
        {"name":"camDirection","type":"vec3","value":[()=>window.camDirection]},
        {"name":"camNear","type":"mat4","value":[()=>window.camNear]},
        {"name":"camFar","type":"mat4","value":[()=>window.camFar]},
        {"name":"camFov","type":"mat4","value":[()=>window.camFov]},
        {"name":"carrotPosZ","type":"float","value":[0]},
        {"name":"outro","type":"float","value":[()=>Sync.get('General:Outro')]}
      ]
    }
});


// submarine
  let prevSubZ = 0;
  let prevSubY = 0;
  this.loader.addAnimation([{
    "object":{
        "name":"obj/submarine.obj"
      }
    ,"position":[{
      "x":()=>Sync.get('Sub:X'),
      "y":()=>Sync.get('Sub:Y'),
      "z":()=>Sync.get('Sub:Z'),
    }]
    ,"id":"submarine"
    ,"color":[{
        "r":1.0,
        "g":1.0,
        "b":1.0
    }]
    ,"scale":[{"uniform3d":1.0}]
    ,"angle":[{"degreesY":180,"degreesX":()=>Sync.get('Sub:Rot2'),"degreesZ":()=>Sync.get('Sub:Rot')}]
  }]);

  this.loader.addAnimation([{
    "object":{
        "name":"obj/submarine_perisocope.obj"
      }
    ,"parent":"submarine"
    ,"color":[{
        "r":1.0,
        "g":1.0,
        "b":1.0
    }]
    ,"scale":[{"uniform3d":1.0}]
    ,"angle":[{"degreesY":()=>90.0*getSceneTimeFromStart()}]
    }]);

  this.loader.addAnimation([{
    "object":{
        "name":"obj/submarine_propeller.obj"
      }
    ,"parent":"submarine"
    ,"color":[{
        "r":1.0,
        "g":1.0,
        "b":1.0
    }]
    ,"scale":[{"uniform3d":1.0}]
    ,"angle":[{"degreesX":()=>360.0*getSceneTimeFromStart()}]
    }]);

    //subpartikle
    this.addEffectWaterSplash(0,200,100,0.5,"multiSceneEffects/tex_bubbleParticle.png",-2.25,0,0,15,15,.09,0);
    this.addEffectWaterSplash(91,200,100,2.5,"multiSceneEffects/tex_lavaParticle.png",.15,-.15,1,15,15,.15,-5);

    let objectStart = 55;

    this.loader.addAnimation([{
      "start":4.8*pattern, "duration":60,
      "object":{
          "name":"obj/sponge.obj"
        }
      ,"scale":[{"uniform3d":0.75}]
      ,"position":[{
        "x":objectStart,
        "y":-3.5,
        "z":-4
      }
       ,{"duration":6, "x":objectStart-6*15}]
      ,"angle":[{"degreesY":-25, "degreesZ":()=>16*Math.sin(4*getSceneTimeFromStart()),"degreesX":()=>16*Math.sin(4*getSceneTimeFromStart())}]
      }]);
 
    this.loader.addAnimation([{
      "start":4.8*pattern, "duration":60,
      "object":{
          "name":"obj/star.obj"
        }
      ,"scale":[{"uniform3d":0.75}]
      ,"position":[{
        "x":objectStart+2,
        "y":-3.5,
        "z":-4
      }
       ,{"duration":6, "x":objectStart+2-6*15}]
      ,"angle":[{"degreesY":70,"degreesX":()=>16*Math.sin(4*getSceneTimeFromStart())}]
      }]);

    this.loader.addAnimation([{
      "start":6.25*pattern, "duration":10,
      "object":{
          "name":"obj/eagles.obj"
        }
      ,"scale":[{"uniform3d":5}]
      ,"position":[{
        "x":objectStart+2,
        "y":1,
        "z":-35
      }
       ,{"duration":10, "x":objectStart+2-10*15}]
      ,"angle":[{"degreesY":40,"degreesZ":25}]
      }]);     
      
    for(let i = 0;i<78;i++)
    {
        this.spawnBomb(14*window.pattern+i*beat*.25+Utils.random()*.25*beat, "bomb"+i);
    }
    Utils.setSeed(666);
    for(let i = 0;i<34;i++)
      {
          this.spawnMine(11.5*window.pattern+i*beat*.25+Utils.random()*.25*beat, "mine"+i,i);
      }
    this.addEffectStarfield(0,240, 2000, "multiSceneEffects/tex_basicParticle.png", 250,250,250, .1, null, 0,0,0);

    this.addEffectMeshStarfield(0, 240, 50, "obj/catfish.obj",
      400,100,500,
      0, 0, 2.1,
      'MeshInstancers:FishEnabled',
      1.0, 0.5, 0, true, false);

    this.addEffectMeshStarfield(0, 240, 50,
      "obj/catfish.obj", 400,100,500,0, 0, 2.1,
      'MeshInstancers:FishEnabled', 0.0, 1.0, 0.5, true, false);

    this.addEffectMeshStarfield(0, 240, 50,
      "obj/catfish.obj", 400,100,500,0, 0, 2.1,
      'MeshInstancers:FishEnabled', 1.0, 0.0, 0.5, true, false);

    this.addEffectMeshStarfield(0, 240, 150,
      "obj/vesikasvi_1.obj", 400,5,500,-100, -55, 15.1,
      'MeshInstancers:VesikasviEnabled', ()=>Sync.get('Vesikasvi:R'), ()=>Sync.get('Vesikasvi:G'), 0.0, false, false);
      //Utils.setSeed(71551);
      Utils.setSeed(71552);

    this.addEffectMeshStarfield(0, 240, 45,
      "obj/ruin.obj", 300,1,1600,
      -200, -55, 53.3, // X, Y, Size
      'MeshInstancers:RuinsEnabled', .7, .5, .4, false, true);

      //delfiini
    this.loader.addAnimation([{
      "start":9.5*pattern,
      "object":{
          "name":"obj/dolphin.obj"
        }
      ,"position":[{
        "x":()=>Sync.get('Dolphin:X'),
        "y":()=>Sync.get('Dolphin:Y'),
        "z":()=>Sync.get('Dolphin:Z'),
      }]
      ,"id":"dolphin"
      ,"color":[{
          "r":0.5,
          "g":0.5,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":()=>Sync.get('Dolphin:Scale')}]
      ,"angle":[{"degreesY":0,"degreesX":()=>Sync.get('Dolphin:Rot'),"degreesZ":()=>Sync.get('Dolphin:Pitch')}]
      ,shader:{
        vertexShaderPrefix:`
          uniform float time;
        `, 
        vertexShaderSuffix:` 
          vec3 pos = position;
          
          pos.x = pos.x;
          pos.y = pos.y+0.35*sin(5.0*time+pos.x*.5);
          pos.z = pos.z;
          gl_Position = projectionMatrix * modelViewMatrix * vec4(pos, 1.0);
        `
      }  
    }]);

    this.loader.addAnimation([{
      "start":10.5*pattern,
      "object":{
          "name":"obj/dolphin_cut_1.obj"
        }
      ,"position":[{
        "x":()=>Sync.get('Dolphin:X'),
        "y":()=>Sync.get('Dolphin:Y'),
        "z":()=>Sync.get('Dolphin:Z'),
      }]
      ,"color":[{
          "r":0.5,
          "g":0.5,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":()=>Sync.get('Dolphin:ScaleCut')}]
      ,"angle":[{"degreesY":0,"degreesX":()=>Sync.get('Dolphin:Rot'),"degreesZ":()=>Sync.get('Dolphin:CutPitch')}]
    }]);

    this.loader.addAnimation([{
      "start":10.5*pattern,
      "object":{
          "name":"obj/dolphin_cut_2.obj"
        }
      ,"position":[{
        "x":()=>Sync.get('Dolphin:Cut2X'),
        "y":()=>Sync.get('Dolphin:Cut2Y'),
        "z":()=>Sync.get('Dolphin:Cut2Z'),
      }]
      ,"color":[{
          "r":0.5,
          "g":0.5,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":()=>Sync.get('Dolphin:ScaleCut')}]
      ,"angle":[{"degreesY":0,"degreesX":()=>Sync.get('Dolphin:Rot'),"degreesZ":()=>Sync.get('Dolphin:CutPitch')}]
    }]);
    // outro

    // godrays and fades

    for(let i=0;i<10;i++)
      {
        let xAdd = i*2;
        this.loader.addAnimation({
          start:80,
          duration: 12,
          perspective: '3d',
          position:[{x:()=>Sync.get('Godray:x')+xAdd,y:()=>Sync.get('Godray:y'),z:5.0+Math.random()*5.0}],
          image: 'multiSceneEffects/fade.png',
          scale: [{ x: 3.0, y:25}],
          angle:[{degreesZ:-45}],
          color:[{r:()=>Math.sin(i*2.5+getSceneTimeFromStart()*3.0)*.5+.5,g:()=>Math.sin(i*2.5+getSceneTimeFromStart()*3.0)*.5+.5,b:()=>Math.sin(i*2.5+getSceneTimeFromStart()*3.0)*.5+.5}],
          material:{
            transparent:true,
            depthTest: false,
            depthWrite: false,
            blending: 'AdditiveBlending'
          },
        });
      }

      this.loader.addAnimation({
        start:80,
        duration: 11.25,
        perspective: '3d',
        position:[{x:10,y:()=>Sync.get('Godray:halfFadeY'),z:0}],
        image: 'multiSceneEffects/halffade.png',
        scale: [{ x: 60.0, y:25}],
        material:{
          transparent:true,
          depthTest: false,
          depthWrite: false,
          blending: 'AdditiveBlending'
        },
      });

    this.loader.addAnimation({
      start:91,
      duration: 24.25,
      perspective: '3d',
      position:[{x:()=>11+Math.random(),y:()=>44+Math.random(),z:-145.0}
      ,{duration:35, "y":()=>126+Math.random()}],
      image: 'img/tex_nuke.png',
      scale: [{ uniform3d: 85.0}],   
    });

}

let fishStart = 55;
let fishEnd = -25;



Demo.prototype.spawnMine = function (startTime, bombId, index)
{
  let bombX1 = fishStart+10*Utils.random()
  let bombY = Utils.random()*2.0-0.0;


  let duration = 6;
  if(index == 26)
  {
    duration = .5*window.pattern + 1.5*window.tick;
  }
  this.loader.addAnimation([{
    "start":startTime,
    "duration": duration+6,
    "id":bombId,
    "object":null
    ,"bombY":bombY
    ,"position":[{
      "x":fishStart+20*Utils.random(),
      "y":(animation)=>bombY+Math.sin(getSceneTimeFromStart()*2.0+startTime),
      "z":Utils.random()*60-35
    }
      ,{"duration":8, "x":bombX1-8*15}]
  }]);

  this.loader.addAnimation([{
    "start":startTime,
    "duration": duration,
    "parent":bombId,
    "object":{
        "name":"obj/miina.obj"
      }
    ,"color":[{
        "r":0.65,
        "g":0.55,
        "b":0.55,
        "a":1.0
    }]
    ,"scale":[{"uniform3d":1.50}]
    ,"angle":[{"degreesY":()=>-85+10*Math.sin(getSceneTimeFromStart()*5.0)}]

  }]);

  if(index == 26)
  {



    this.addEffectExplosion(
      "multiSceneEffects/tex_basicParticle.png",
      null,                   // model
      startTime+duration,6,  // startTime, duration
      40, 35, 2,  // maxDist, amount, scale
      0,0,0,        // posX, posY, posZ
      0,0,0,        // startDim
      4,4,4,   // dimX, dimY, dimZ
      0,0.0,0,        // xOffset, yOffset, zOffset
      "AdditiveBlending", // blendmode
      bombId);
      this.addEffectExplosion(
        "multiSceneEffects/tex_basicParticle.png",
        null,                   // model
        startTime+duration,6,  // startTime, duration
        40, 25, 2,  // maxDist, amount, scale
        0,0,0,        // posX, posY, posZ
        0,0,0,        // startDim
        4,4,4,   // dimX, dimY, dimZ
        0,0.0,0,        // xOffset, yOffset, zOffset
        "SubtractiveBlending", // blendmode
        bombId);
      this.addEffectExplosion(
        "multiSceneEffects/tex_bloodParticle.png",
        null,                   // model
        startTime+duration,6,  // startTime, duration
        50, 45, 4,  // maxDist, amount, scale
        0,-2,0,        // posX, posY, posZ
        0,0,0,        // startDim
        1,.25,.25,   // dimX, dimY, dimZ
        -33,0.0,0,        // xOffset, yOffset, zOffset
        "CustomBlending", // blendmode
      bombId);
 

  }     
}



Demo.prototype.spawnBomb = function (startTime, bombId)
{
  let bombX1 = fishEnd +20 + 40*Utils.random();

  this.loader.addAnimation([{
    "start":startTime,
    "id":bombId,
    "duration": 2*beat+5,
    "object":{
        "name":"obj/bomb.obj"
      }

    ,"color":[{
        "r":0.15,
        "g":0.15,
        "b":0.15,
        "a":1.0
    }
    ,{"duration":6*beat, "a":1.0}
    ,{"duration":.01, "a":0.0}]
    ,"fishY":Utils.random()*12-3
    ,"position":[{
      "x":fishStart+20*Utils.random(),
      "y":25 ,
      "z":Utils.random()*120-80
    }
    ,{"duration":2*beat, "y":-5, "x":bombX1}
    ,{"duration":5, "x":bombX1-5*15}]
    ,"scale":[{"uniform3d":.50}]
    ,"angle":[{"degreesY":()=>-85+10*Math.sin(getSceneTimeFromStart()*5.0)}]

  }]);

  this.addEffectExplosion(
    "multiSceneEffects/tex_basicParticle.png",
    null,                   // model
    startTime+2*beat,4,  // startTime, duration
    50, 45, 2,  // maxDist, amount, scale
    0,0,0,        // posX, posY, posZ
    0,0,0,        // startDim
    2,6.0,2,   // dimX, dimY, dimZ
    0,25.0,0,        // xOffset, yOffset, zOffset
    "AdditiveBlending", // blendmode
    bombId);

    this.addEffectExplosion(
      "multiSceneEffects/tex_basicParticle.png",
      null,                   // model
      startTime+2*beat,4,  // startTime, duration
      50, 35, 1.5,  // maxDist, amount, scale
      0,0,0,        // posX, posY, posZ
      0,0,0,        // startDim
      3,3.0,3,   // dimX, dimY, dimZ
      0,2,0,        // xOffset, yOffset, zOffset
      "SubtractiveBlending", // blendmode
      bombId);  
}