Demo.prototype.sceneMap = function () {
  this.setScene('map');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });

    this.loader.addAnimation({
      image: ['sceneMap/mapbg.png'],
      perspective: '3d',
      position: [
        {
          x: 0,
          y: 0,
          z: -16
        }
      ],
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping' }],
      scale: [{ uniform3d: 20.0 }],
      color: [{ a: 0.85 }],
      shader: {
        name: 'multiSceneEffects/background.fs',
        variable: [
          // chainEffectN value = <baseeffect>.<mix amount = .0 (all), .999 (minimum)>
          { name: 'chainEffect0', value: [8] },
          { name: 'chainEffect1', value: [2] },
          { name: 'chainEffect2', value: [1] },
          // chaineffect base effect numbers:
          // 0: no-operation
          // 1: texcoordinate bias
          {
            name: 'coordBias',
            value: [
              () => -.25*getSceneTimeFromStart(),
              () => .25*getSceneTimeFromStart()
            ]
          },
          // 2: texcoordinate bias 2
          {
            name: 'coordBias2',
            value: [
              () => -2*Math.sin(getSceneTimeFromStart()*.13),
              () => 2*Math.sin(getSceneTimeFromStart()*.29),
            ]
          },
          // 3: kaleidoscope
          {
            name: 'kaleidoscopeXangle',
            value: [()=>1+Math.sin(getSceneTimeFromStart())]
          },
          // 4: funky deformation
          // 5: rotozoom
          { name: 'angle', value: [() => .25*getSceneTimeFromStart()] },
          { name: 'zoom', value: [() => .5+Math.abs(Math.sin(getSceneTimeFromStart()))] },
          // 6: tunnel
          // 7: plasma deformation
          {
            name: 'scale',
            value: [
              () => Math.sin(getSceneTimeFromStart()*15),
              () => Math.sin(getSceneTimeFromStart()*19),
            ]
          },
          { name: 'speed', value: [1.0] },
          // 8: mirror scroll
          {
            name: 'mirrorSpeed',
            value: [
              () => .1,
              () => .4
            ]
          }
        ]
      }
    });

  this.loader.addAnimation([
  {
    image: {
      name: 'images/strategic_choices.png'
    },
    perspective: '3d',
    color: [{"a":()=>1.0-Sync.get('Map:Map2A')}],
    position: [
      {
        x: 0,
        y: -.5,
        z: .1
      }
    ],
    scale: [{ uniform3d: (2.0)}],

  }]);

  this.loader.addAnimation([
  {
    image: {
      name: 'images/strategic_2.png'
    },
    perspective: '3d',
    color: [{"a":()=>Sync.get('Map:Map2A')}],
    position: [
      {
        x: 0,
        y: -.5,
        z: .1
      }
    ],
    scale: [{ uniform3d: 2.0}],

  }]);

  this.loader.addAnimation([
  {
    image: {
      name: 'images/targeting.png'
    },
    perspective: '3d',
    color: [{"g":()=>1.0-Sync.get('Map:TargetR'),"b":()=>1.0-Sync.get('Map:TargetR')}],
    position: [
      {
        x:()=> Sync.get('Map:TargetX'),
        y:()=> Sync.get('Map:TargetY'),
        z: .2
      }
    ],
    scale: [{ uniform3d:()=> Sync.get('Map:TargetSize'),}],

  }]);

    this.loader.addAnimation([
  {
    image: {
      name: 'images/scanlines.png'
    },
    perspective: '2d',
    color: [{r:0,g:0,b:0,a:.04}],

    scale: [{ x: 2.5, y:1.5}],

  }]);

  this.addTrailerText({text:"INVADE RUSSIA?",x:0,y:-.15,scale:()=>Sync.get('Map:Russia'), monoSpace:true});
 this.addTrailerText({text:"INVADE SWEDEN?",x:0,y:-.15,scale:()=>Sync.get('Map:Sweden'), monoSpace:true});


  this.addTrailerText({text:"Deep Strategy",x:0,y:.20,scale:2.5});
};