const NICKNAME_MENU_INDEX = 2;

function renderCharacterToCanvas(character) {
  const size = 128;

  const canvas = document.createElement('canvas');
  canvas.width = size;
  canvas.height = size;

  const context = canvas.getContext('2d');
  context.font = `${size/2}px monospace`;
  context.textAlign = 'center';
  context.textBaseline = 'middle';
  context.textRendering = 'geometricPrecision';
  context.fillStyle = 'white';
  context.fillText(character, size/2, size/2, size);

  return {
    image: canvas,
    properties:{
      magFilter: 'LinearFilter',
      minFilter: 'LinearMipmapLinearFilter'
    }
  };
}

Demo.prototype.loadUnicodeCharacters = function () {
  const unicodeCharacterList = [
    '◄', '►',
  ];
  unicodeCharacterList.forEach((emojiChar) => {
    const emoji = new DemoEngine.Image();
    emoji.loadCustomSync(emojiChar, renderCharacterToCanvas);
  });
};

Demo.prototype.setNickname = function () {
  this.mainMenu[window.menuSelection] = window.playerName;

  const storageKey = 'JML_AHAH_nickname';
  try {
    localStorage.setItem(storageKey, window.playerName);
  } catch (error) {
    console.error('Failed to save nickname to localStorage:', error);
  }
};

Demo.prototype.createModalDialog = function (config) {
  if (config.overlayId) {
    const existingOverlay = document.getElementById(config.overlayId);
    if (existingOverlay) {
      existingOverlay.remove();
    }
  }
  
  this.activeDialog = {
    config: config,
    type: config.overlayId === 'nicknameOverlay' ? 'nickname' : 'confirm'
  };

  const overlay = document.createElement('div');
  if (config.overlayId) {
    overlay.id = config.overlayId;
  }
  overlay.style.position = 'fixed';
  overlay.style.top = '0';
  overlay.style.left = '0';
  overlay.style.width = '100%';
  overlay.style.height = '100%';
  overlay.style.backgroundColor = 'rgba(0, 0, 0, 0.8)';
  overlay.style.zIndex = '999999';
  overlay.style.display = 'flex';
  overlay.style.alignItems = 'center';
  overlay.style.justifyContent = 'center';
  overlay.style.fontFamily = 'trailertext1, monospace';
  
  const container = document.createElement('div');
  container.style.backgroundColor = '#222';
  container.style.padding = '30px';
  container.style.borderRadius = '10px';
  container.style.border = '2px solid white';
  container.style.textAlign = 'center';
  container.style.maxWidth = '400px';
  container.style.width = '80%';
  
  const title = document.createElement('div');
  title.textContent = config.title;
  title.style.color = 'white';
  title.style.fontSize = config.titleSize || '20px';
  title.style.marginBottom = '20px';
  title.style.fontFamily = 'trailertext1, monospace';
  
  container.appendChild(title);
  
  let input = null;
  if (config.input) {
    input = document.createElement('input');
    input.type = 'text';
    input.value = config.input.value || '';
    input.maxLength = config.input.maxLength || 100;
    input.style.width = '100%';
    input.style.padding = '10px';
    input.style.fontSize = '18px';
    input.style.border = '2px solid #666';
    input.style.borderRadius = '5px';
    input.style.backgroundColor = '#333';
    input.style.color = 'white';
    input.style.fontFamily = 'trailertext1, monospace';
    input.style.textAlign = 'center';
    input.style.boxSizing = 'border-box';
    container.appendChild(input);
    
    this.activeDialog.input = input;
    
    input.oninput = () => {
      input.style.borderColor = '#666';
    };
  }
  
  const buttonContainer = document.createElement('div');
  buttonContainer.style.marginTop = '20px';
  buttonContainer.style.display = 'flex';
  buttonContainer.style.gap = config.buttonGap || '10px';
  buttonContainer.style.justifyContent = 'center';
  
  config.buttons.forEach(buttonConfig => {
    const button = document.createElement('button');
    button.textContent = buttonConfig.text;
    button.style.padding = buttonConfig.padding || '10px 20px';
    button.style.fontSize = buttonConfig.fontSize || '16px';
    button.style.backgroundColor = buttonConfig.color;
    button.style.color = 'white';
    button.style.border = 'none';
    button.style.borderRadius = '5px';
    button.style.cursor = 'pointer';
    button.style.fontFamily = 'trailertext1, monospace';
    
    button.onclick = () => {
      if (buttonConfig.callback) {
        buttonConfig.callback(input ? input.value.trim() : null);
      }
    };
    
    buttonContainer.appendChild(button);
  });
  
  container.appendChild(buttonContainer);
  overlay.appendChild(container);
  document.body.appendChild(overlay);
  
  if (input) {
    setTimeout(() => {
      input.focus();
      input.select();
    }, 100);
  }
  
  return { overlay, input };
};

Demo.prototype.showNicknameInput = function () {
  const submitNickname = (name) => {
    if (name && name.length > 0 && name.length < 20) {
      window.playerName = name;
      this.setNickname();
      this.hideNicknameInput();
    } else {
      const input = document.querySelector('#nicknameOverlay input');
      if (input) {
        input.style.borderColor = '#ff0000';
        input.focus();
      }
    }
  };
  
  const cancelNickname = () => {
    this.hideNicknameInput();
  };
  
  this.createModalDialog({
    overlayId: 'nicknameOverlay',
    title: 'Enter your nickname:',
    titleSize: '20px',
    input: {
      value: window.playerName || '',
      maxLength: 19
    },
    buttons: [
      {
        text: 'OK',
        color: '#4CAF50',
        callback: submitNickname
      },
      {
        text: 'Cancel',
        color: '#f44336',
        callback: cancelNickname
      }
    ],
    buttonGap: '10px'
  });
};

Demo.prototype.hideNicknameInput = function () {
  const overlay = document.getElementById('nicknameOverlay');
  if (overlay) {
    overlay.remove();
  }
  this.activeDialog = null;
};

Demo.prototype.getNickname = function () {
  const storageKey = 'JML_AHAH_nickname';
  try {
    const nickname = localStorage.getItem(storageKey);
    if (nickname) {
      return nickname;
    }
  } catch (error) {
    console.warn('Failed to load nickname from localStorage:', error);
  }
  return 'Your nickname';
};

Demo.prototype.showExitConfirm = function () {
  const confirmExit = () => {
    this.hideExitConfirm();
    const settings = new Settings();
    if (settings.engine.webDemoExe) {
      window.location.hash = 'webdemoexe_exit';
    } else {
      location.reload();
    }
  };
  
  const cancelExit = () => {
    this.hideExitConfirm();
  };
  
  this.createModalDialog({
    overlayId: 'exitConfirmOverlay',
    title: 'Exit the game?',
    titleSize: '24px',
    buttons: [
      {
        text: 'Yes',
        color: '#f44336',
        padding: '12px 24px',
        fontSize: '18px',
        callback: confirmExit
      },
      {
        text: 'No',
        color: '#4CAF50',
        padding: '12px 24px',
        fontSize: '18px',
        callback: cancelExit
      }
    ],
    buttonGap: '15px',
    keyHandlers: {
      'y': confirmExit,
      'Y': confirmExit,
      'n': cancelExit,
      'N': cancelExit
    }
  });
};

Demo.prototype.hideExitConfirm = function () {
  const overlay = document.getElementById('exitConfirmOverlay');
  if (overlay) {
    overlay.remove();
  }
  this.activeDialog = null;
};

Demo.prototype.exitGame = function () {
  this.showExitConfirm();
};

Demo.prototype.createBackButton = function () {
  const existingButton = document.getElementById('gameBackButton');
  if (existingButton) {
    existingButton.remove();
  }

  const backButton = document.createElement('button');
  backButton.id = 'gameBackButton';
  backButton.textContent = 'Back';
  backButton.style.position = 'fixed';
  backButton.style.top = '20px';
  backButton.style.left = '20px';
  backButton.style.zIndex = '100000';
  backButton.style.padding = '10px 20px';
  backButton.style.fontSize = '20px';
  backButton.style.backgroundColor = 'transparent';
  backButton.style.color = 'white';
  backButton.style.border = '1px solid rgba(255, 255, 255, 0.2)';
  backButton.style.borderRadius = '5px';
  backButton.style.cursor = 'pointer';
  backButton.style.fontFamily = 'trailertext1, monospace';
  backButton.style.display = 'none';
  backButton.style.opacity = '0.3';
  
  /* Prevent iOS text zoom and text selection on button */
  backButton.style.webkitTextSizeAdjust = 'none';
  backButton.style.textSizeAdjust = 'none';
  backButton.style.webkitUserSelect = 'none';
  backButton.style.userSelect = 'none';
  backButton.style.webkitTouchCallout = 'none';
  backButton.style.webkitTapHighlightColor = 'transparent';
  
  backButton.onmouseenter = () => {
    backButton.style.backgroundColor = 'transparent';
    backButton.style.opacity = '1.0';
  };
  backButton.onmouseleave = () => {
    backButton.style.backgroundColor = 'transparent';
    backButton.style.opacity = '0.3';
  };
  
  backButton.onclick = () => {
    this.backToMainMenu();
  };
  
  document.body.appendChild(backButton);
  
  this.updateBackButtonVisibility();
  
  return backButton;
};

Demo.prototype.updateBackButtonVisibility = function () {
  const backButton = document.getElementById('gameBackButton');
  if (backButton) {
    backButton.style.display = window.gameActive ? 'block' : 'none';
  }
};

Demo.prototype.selectGame = function () {
    if (window.gameActive === false) {
        window.menuSelect = true;

        console.log("menuSelect true");

        // WARNING: this.mainMenu variable's order is hardcoded in this function when checking the menuState
  
        // set song
        const songId = this.menuState[1];
        if (songId === 6)
          window.activeTrack = "test";
        else if (songId === 5)
          window.activeTrack = "testShort";
        else if (songId === 0)
          window.activeTrack = "trainer";
        else if (songId === 1)
          window.activeTrack = "rfm";
        else if (songId === 2)
          window.activeTrack = "uhka";
        else if (songId === 3)
          window.activeTrack = "farjan";
        else {
          window.activeTrack = "beethoven";
        }

        // set player count
        window.playerCount = this.menuState[2] + 1;

        // set instrument
        const instrumentId = this.menuState[3];
        if (instrumentId === 0) {
          window.activeInstrument = 'airhorn';
        } else if (instrumentId === 1) {
          window.activeInstrument = 'foghorn';
        } else if (instrumentId === 2) {
          window.activeInstrument = 'trombone';
        } else {
          window.activeInstrument = 'none';
        }


        window.gameInit = true;
        window.gameActive = true;

        this.createBackButton();

        this.startGame();

        this.getHighScores(window.activeTrack); // load high scores for the selected track

        //console.log("game selected, activeTrack: " + window.activeTrack + ", playerCount: " + window.playerCount + ", activeInstrument: " + window.activeInstrument);
    }
};

Demo.prototype.menuInput = function (action) {
  //console.log(`Menu action: ${action}`);
  
  if (this.closeHighScoreDiv()) {
    this.backFromLevelEnd();
    return;
  }

  if (this.activeDialog) {
    this.handleDialogInput(action);
    return;
  }

  if (window.levelEnd) {
    return;
  }

  if (action === 'Click') {
    if (window.menuSelectionClick !== undefined && window.menuSelectionClick !== window.menuSelection) {
      window.menuSelection = window.menuSelectionClick;
      return;
    }

    const mouseX = (new window.DemoEngine.Input()).cursorPosition?.x || 0;
    if (window.menuSelection !== window.menuSelectionClick) {
      return;
    }
    if (window.menuSelection == NICKNAME_MENU_INDEX || this.mainMenu[window.menuSelection] === 'Exit' || this.mainMenu[window.menuSelection] === 'Play') {
      action = 'Enter';
    } else if (this.menuState[window.menuSelection] !== null) {
      if (mouseX < 0.0) {
        action = 'ArrowLeft';
      } else {
        action = 'ArrowRight';
      }
    }
  }

  if (action === 'ArrowUp') {
    window.menuSelection--;
  } else if (action === 'ArrowDown') {
    window.menuSelection++;
  } else if (action === 'ArrowLeft') {
    if (window.menuSelection >= 0 && this.menuState[window.menuSelection] !== null) {
      this.menuState[window.menuSelection]--;
    }
  } else if (action === 'ArrowRight') {
    if (window.menuSelection >= 0 && this.menuState[window.menuSelection] !== null) {
      this.menuState[window.menuSelection]++;
    }
  } else if (action === 'Enter') {
    if (this.mainMenu[window.menuSelection] === 'Exit') {
      this.exitGame();
    } else if (this.mainMenu[window.menuSelection] === 'Play') {
      this.selectGame();
    } else if (window.menuSelection === NICKNAME_MENU_INDEX) {
      // name prompt - create custom input overlay for iOS compatibility
      this.showNicknameInput();
    }
  }

  if (window.menuSelection < 0) {
    window.menuSelection = this.menuState.length - 1;
  } else if (window.menuSelection >= this.menuState.length) {
    window.menuSelection = 0;
  }

  if (this.menuState[window.menuSelection] !== null) {
    if (this.menuState[window.menuSelection] < 0) {
      this.menuState[window.menuSelection] = this.mainMenu[window.menuSelection].length - 1;
    } else if (this.menuState[window.menuSelection] >= this.mainMenu[window.menuSelection].length) {
      this.menuState[window.menuSelection] = 0;
    }
  }
};

Demo.prototype.handleDialogInput = function (action) {
  if (!this.activeDialog) return;
  
  const config = this.activeDialog.config;
  const input = this.activeDialog.input;
  
  if (action === 'Enter') {
    const firstButton = config.buttons[0];
    if (firstButton && firstButton.callback) {
      firstButton.callback(input ? input.value.trim() : null);
    }
    return;
  }
  
  if (action === 'Escape') {
    const lastButton = config.buttons[config.buttons.length - 1];
    if (lastButton && lastButton.callback) {
      lastButton.callback(input ? input.value.trim() : null);
    }
    return;
  }
  
  if (config.keyHandlers && config.keyHandlers[action]) {
    config.keyHandlers[action](input ? input.value.trim() : null);
    return;
  }
};

Demo.prototype.backToMainMenu = function () {
  window.currentMusic?.stop();
  window.musicplaying = false;
  window.gameActive = false;
  window.levelEnd = false;
  window.menuSelect = false;
  window.menuSelection = 0;
  window.menuSelectionClick = undefined;
  
  this.updateBackButtonVisibility();
  
  this.setScene('mainMenu');
};

window.endxplosionplayed = false;

Demo.prototype.initBackgroundMusic = function () {
    this.loader.addAnimation({
      initFunction:(animation)=>{
          animation.sounds = {};
          const sounds =  ['menumusic_loop.mp3','endxplosion.mp3'];
          sounds.forEach((sound) => {
              const name = sound.replaceAll(/\.mp3/gi,'');
             // console.log("sound name " + name);
              const audioFile = new AudioFile();
              audioFile.load(sound);
              animation.sounds[name] = audioFile;
          });
      },

      runFunction:(animation)=>{
        if(!window.levelEnd && !window.gameActive && !animation.sounds.menumusic_loop.isPlaying())
        {
            animation.sounds.menumusic_loop.play();
            animation.sounds.menumusic_loop.setLoop(true);
        }
        else if(window.gameActive && animation.sounds.menumusic_loop.isPlaying())
        {
            animation.sounds.menumusic_loop.stop();
        }

        if(window.levelEnd && !animation.sounds.endxplosion.isPlaying() && !window.endxplosionplayed)
        {
          animation.sounds.endxplosion.play();
          
          window.endxplosionplayed = true;
        }
      }
  });
};

Demo.prototype.loadFonts = function (fonts) {
  const settings = new Settings();
  const dataPath = settings.engine.demoPathPrefix;

  fonts.forEach((font) => {
    const fontPath = `${dataPath}/multiSceneEffects/${font.file}`;
    const fontFace = new FontFace(font.name, `url(${fontPath})`);
    fontFace.load().then(() => {
      document.fonts.add(fontFace);
    }).catch(() => {
      console.warn('Failed to load custom font, falling back to monospace');
    });
  });
};

Demo.prototype.sceneMainMenu = function () {
  this.loadUnicodeCharacters();

  this.loadFonts([
    { name: 'trailertext1', file: 'trailertext1.ttf' },
    { name: 'monoSpace', file: 'monoSpace.ttf' }
  ]);

  // hack to expose this to gameInput.js
  window.demo = this;

  this.backToMainMenu();

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 1, g: 0, b: 0 }] });

    this.loader.addAnimation({
      image: ['images/tex_bgnonsense1.png'],
      perspective: '3d',
      position: [
        {
          x: 0,
          y: 0,
          z: -16
        }
      ],
      visible: ()=>!window.levelEnd,
      textureProperties: [{ wrapS: 'RepeatWrapping', wrapT: 'RepeatWrapping' }],
      scale: [{ uniform3d: 81.0 }],
      shader: {
        name: 'multiSceneEffects/background.fs',
        variable: [
          // chainEffectN value = <baseeffect>.<mix amount = .0 (all), .999 (minimum)>
          { name: 'chainEffect0', value: [0] },
          { name: 'chainEffect1', value: [4] },
          { name: 'chainEffect2', value: [5] },
          { name: 'chainEffect2', value: [2] },
          // chaineffect base effect numbers:
          // 0: no-operation
          // 1: texcoordinate bias
          {
            name: 'coordBias',
            value: [
              () => -.25*getSceneTimeFromStart(),
              () => .25*getSceneTimeFromStart()
            ]
          },
          // 2: texcoordinate bias 2
          {
            name: 'coordBias2',
            value: [
              () => -2*Math.sin(getSceneTimeFromStart()*.13),
              () => 2*Math.sin(getSceneTimeFromStart()*.29),
            ]
          },
          // 3: kaleidoscope
          {
            name: 'kaleidoscopeXangle',
            value: [()=>1+Math.sin(getSceneTimeFromStart())]
          },
          // 4: funky deformation
          // 5: rotozoom
          { name: 'angle', value: [() => .25*getSceneTimeFromStart()] },
          { name: 'zoom', value: [() => .5+Math.abs(Math.sin(getSceneTimeFromStart()))] },
          // 6: tunnel
          // 7: plasma deformation
          {
            name: 'scale',
            value: [
              () => Math.sin(getSceneTimeFromStart()*15),
              () => Math.sin(getSceneTimeFromStart()*19),
            ]
          },
          { name: 'speed', value: [1.0] },
          // 8: mirror scroll
          {
            name: 'mirrorSpeed',
            value: [
              () => .1,
              () => .4
            ]
          }
        ]
      }
    });

  window.playerName = this.getNickname();
  this.mainMenu = [
    'Play',
    [
     // "Test",
     // "Test Short",
      "Trainer",
      "Rock for Metal",
      "Uhka Idästä",
      "Finlandsfärjan",
      "Beethoven 5th symphony"
    ],
   /* [
      "1 Player",
      "2 Players",
    ],
    [
      "Airhorn",
      "Fog horn",
      "Trombone",
      "No sound :("
    ], */
    window.playerName,
    "Exit",
  ];

  this.menuState = [];
  for (let i = 0; i < this.mainMenu.length; i++) {
    const state = Array.isArray(this.mainMenu[i]) ? 0 : null;
    this.menuState.push(state);
  }


  // header
  let headerY = .31;

    this.addMenuText({
      text: 'AIRHORN ANTI-HERO',
      x: 0,
      y:headerY,
      x2: 0.003,
      y2: headerY-0.003,
      x3: -0.003,
      y3: headerY+0.003,
      rangle:0,
      wobble:true,
      cycle:true,
      scale:()=>4.0+.2*Math.sin(4.5*getSceneTimeFromStart()),
      r:1,g:1,b:1
    });

  let mvpY = .21;
  let mvpX = .25;

  this.addMenuText({
      text: '[MVP Edition]',
      x: mvpX,
      y: mvpY,
      x2: mvpX+0.002,
      y2: mvpY+0.002,
      x3: mvpX-0.002,
      y3: mvpY-0.002,
      rangle:0,
      wobble:false,
      cycle:false,
      monoSpace: true,
      rangle: 8.5,
      scale:()=>1.3+.1*Math.sin(3*getSceneTimeFromStart()),
      r:1,g:1,b:1
    });

  let jX = 0;
  let jY = -.35;

  this.addMenuText({
      text: '(C) Jumalauta Incorporated & corporated 2025',
      x: jX,
      y: jY,
      x2: jX+0.002,
      y2: jY+0.002,
      x3: jX-0.002,
      y3: jY-0.002,
      rangle:0,
      wobble:false,
      cycle:false,
      monoSpace: true,
      rangle: 0,
      scale:1.0,
      r:1,g:1,b:1
    });
  
  jY = jY-.065;
  this.addMenuText({
      text: `WWW.JUMALAUTA.ORG/AHAH`,
      x: jX,
      y: jY,
      x2: jX+0.001,
      y2: jY+0.001,
      x3: jX-0.001,
      y3: jY-0.001,
      rangle:0,
      wobble:false,
      cycle:false,
      monoSpace: true,
      rangle: 0,
      scale:0.7,
      r:1,g:1,b:1
    });  

      this.loader.addAnimation({ image: 'images/qr.png',    angle:[{degreesZ:11.5}], position: [{ x: -0.35, y: -0.2 }], scale: [{ uniform3d: ()=>1.1+.1*Math.sin(2*getSceneTimeFromStart()) }] });

  /*
  this.loader.addAnimation([{
    text: {
      string: "Choose your classic",
      name: 'multiSceneEffects/monoSpace.ttf'
    },
    perspective: "2d",
    color: [{ "r": 0, "g": 0, "b": 0 }],
    position: [{ x: 0.002, y: 0.29 }],
    scale: [{ uniform3d: 2.55 }],
    material: { depthWrite: false }
  }]);

  this.loader.addAnimation([{
    text: {
      string: "Choose your classic",
      name: 'multiSceneEffects/monoSpace.ttf'
    },
    perspective: "2d",
    color: [{ "r": 0.7, "g": 0.7, "b": 0.7 }],
    position: [{ x: 0.0, y: 0.3 }],
    scale: [{ uniform3d: 2.5 }],
    material: { depthWrite: true }
  }]);
  */
    this.loader.addAnimation({
      image: '_embedded/defaultTransparent.png',
      cursor:{onmouseover:(animation)=>{
        if (animation.cursor.oldPosition
          && animation.cursor.oldPosition.x === animation.cursor.position.x
          && animation.cursor.oldPosition.y === animation.cursor.position.y) {
          return; // No movement, no change - allow keyboard navigation
        }

        window.menuSelectionClick = undefined;
        animation.cursor.oldPosition = {x:animation.cursor.position.x, y:animation.cursor.position.y};
      }},
    });

  for(let i = 0; i<this.mainMenu.length;i++)
  {
    const positionY = 0.15 - i / this.mainMenu.length * 0.5;

    if (Array.isArray(this.mainMenu[i])) {
      const arrowPositionY = 0.15 - i / this.mainMenu.length * 0.55;
      const arrowX = 0.45;
      const arrowScale = 4.0;
      this.loader.addAnimation({
        image: '◄',
        position: [{ x: -arrowX, y: arrowPositionY}],
        scale: [{ uniform2d: arrowScale }],
        visible: () => {
          return window.menuSelection == i;
        },
        color: [{ r: 0.0, g: 0.0, b: 0.0 }],
        nextTime:0,
        interval:.2,
        runFunction:(animation)=>
        {
          if(getSceneTimeFromStart() >= animation.nextTime)
          {
            animation.color[0].r = Math.abs(Math.random());
            animation.color[0].g = Math.abs(Math.random());
            animation.color[0].b = Math.abs(Math.random());
            animation.nextTime = getSceneTimeFromStart()  + animation.interval;
          }
        }
      });
      this.loader.addAnimation({
        image: '►',
        position: [{ x: arrowX, y: arrowPositionY}],
        scale: [{ uniform2d: arrowScale }],
        visible: () => {
          return window.menuSelection == i;
        },
        color: [{ r: 0.0, g: 0.0, b: 0.0 }],
        nextTime:0,
        interval:.2,
        runFunction:(animation)=>
        {
          if(getSceneTimeFromStart() >= animation.nextTime)
          {
            animation.color[0].r = Math.abs(Math.random());
            animation.color[0].g = Math.abs(Math.random());
            animation.color[0].b = Math.abs(Math.random());
            animation.nextTime = getSceneTimeFromStart() + animation.interval;
          }
        }
      });
    }


    this.addMenuText({
      text: ()=>{ return Array.isArray(this.mainMenu[i]) ? this.mainMenu[i][this.menuState[i]] : this.mainMenu[i]; },
        cursor:{onmouseover:(animation)=>{
        if (animation.cursor.oldPosition
          && animation.cursor.oldPosition.x === animation.cursor.position.x
          && animation.cursor.oldPosition.y === animation.cursor.position.y) {
          return; // No movement, no change - allow keyboard navigation
        }

        window.menuSelectionClick = i;
        animation.cursor.oldPosition = {x:animation.cursor.position.x, y:animation.cursor.position.y};
      }},
      x: ()=>{return window.levelEnd ? 100.0 : 0.0;},
      y:positionY,
      x2: ()=>{return window.levelEnd ? 100.0 : 0.0+0.003;},
      y2: positionY-0.003,
      x3: ()=>{return window.levelEnd ? 100.0 : 0.0-0.003;},
      y3: positionY+0.003,
      rangle:0,
      scale:()=>{return window.menuSelection == i ? 3.0+.5*Math.sin(5*getSceneTimeFromStart()) : 2.5;},
      r:1,g:1,b:1
      });
/*
    this.loader.addAnimation([{
        text:{string:()=>{
          return Array.isArray(this.mainMenu[i]) ? this.mainMenu[i][this.menuState[i]] : this.mainMenu[i];
        },name:'multiSceneEffects/monoSpace.ttf'},
        perspective:"2d", 
        color:[{"r":.0,"g":.0,"b":.0 }],
        position:[{x:()=>{return window.levelEnd ? 100.0 : 0.0}, y:positionY}],
        scale: [{ uniform3d: 1.0 }],
        material:{depthWrite:true},
        runFunction:(animation)=>{

          let size = 2.0;
          if(window.menuSelection == i)
          {
            size = 2.5;
          }

          animation.scale[0].x = size;
          animation.scale[0].y = size;
          animation.scale[0].z = size;
        }     
    }]);
*/
    // Add a transparent background for each selectable song for cursor interaction
    // Technically text can be selected, but then cursor would need to precisely hit text mesh which might not be easy due to hole in letters and other whitespaces
    this.loader.addAnimation({
      image: '_embedded/defaultTransparent.png',
      cursor:{onmouseover:(animation)=>{
        if (animation.cursor.oldPosition
          && animation.cursor.oldPosition.x === animation.cursor.position.x
          && animation.cursor.oldPosition.y === animation.cursor.position.y) {
          return; // No movement, no change - allow keyboard navigation
        }

        window.menuSelectionClick = i;
        animation.cursor.oldPosition = {x:animation.cursor.position.x, y:animation.cursor.position.y};
      }},
      position:[{x:0, y:positionY}],
      scale: [{y:0.5/this.mainMenu.length}]
    });

    this.addLevelEnd();
  }
};