
Demo.prototype.sceneLargeBattle = function () {
  this.setScene('largeBattle');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });
  this.addSkysphere();

  this.addEffectStarfield(0,300, 300, "multiSceneEffects/tex_basicParticle.png", 450,450,500, 0.4, null, 0,0,0, 0.15);
  this.loader.addAnimation([{
    "id":"dunes",
    "object":{
      "name":"3d_models/obj_dunes.gltf"
    }
   ,"position":[{
      "x":0,
      "y":-1.2,
      "z":0
    },{duration:10, z:-7}]
    ,"color": [{
      "r": 1.0, "g": 1.0, "b": 1.0
    }]
   ,"angle":[{
      "degreesY":0,
      "degreesX":0,
      "degreesZ":0
	  }]
   ,"scale":[{"x":1.0,y:0.3}]
  }]);

  const tanks = [];
  for (let i = 0; i < 20; i++) {
    const y = -20;
    const x = -200;
    const z = -300;

    for (let zi = 0; zi < 6; zi++) {
      tanks.push({
        x: x + i*30 + (Utils.random()*4-2),
        y: y,
        z: z + zi*60 + (Utils.random()*4-2),

        angleY: (Utils.random()*10-5) * (Math.PI/180)
      });
    }

  }

  this.loader.addAnimation({ 
    "object":{
      "name":'3d_models/uhkatank.obj'
    },
    "perspective": "3d",
    "color":[{
      "r":1.0,
      "g":1.0,
      "b":1.0
    }],
    "scale":[{"uniform3d":0.05}],
    "instancer": {
      "count": tanks.length,
      "runInstanceFunction": (properties) =>
        {
          const i = properties.index;

          const tank = tanks[i];
        let object = properties.object;
        object.position.x = tank.x;
        object.position.y = tank.y;
        object.position.z = tank.z;

        let angle = properties.angle;
        angle.degreesY = tank.angleY;

        } 
      }
  });

  this.addTrailerText({text:"Large Scale Battles",x:0,y:.2,scale:2.4});
};