#pragma include "math.glsl"

struct Geom {
    vec3 pos;  // position in 3D space
    vec3 nrm;  // outward or surface normal
};

// Point on a sphere or inside a ball (uniform)
// - id: seed (e.g., gl_InstanceID)
// - radius: sphere/ball radius
// - volume: false → on surface; true → inside volume (uniform in volume via cbrt)
vec3 ball(int id, float radius, bool volume) {
    vec3 r   = irand3(id);                 // r in [0,1)
    float z  = r.z * 2.0 - 1.0;            // cos(theta) in [-1,1]
    float phi= r.y * TWO_PI;               // azimuth
    float s  = sqrt(max(0.0, 1.0 - z*z));  // sin(theta)

    // radius factor: 1.0 for shell, cbrt(u) for uniform volume
    float rf = volume ? pow(r.x, 0.33333333) : 1.0;

    return vec3(cos(phi)*s, sin(phi)*s, z) * (radius * rf);
}


// Generate random point on a sphere with its normal
Geom sphorm(int id, float radius) {
    vec3 r   = irand3(id);
    float z  = r.z * 2.0 - 1.0;
    float phi= r.y * TWO_PI;
    float s  = sqrt(max(0.0, 1.0 - z*z));

    vec3 n = vec3(cos(phi)*s, sin(phi)*s, z);
    Geom g;
    g.pos = n * radius;
    g.nrm = n;
    return g;
}


// Point inside an axis-aligned box centered at origin (uniform)
// - id: seed
// - he: half-extents (hx, hy, hz); box spans [-hx,hx] × [-hy,hy] × [-hz,hz]
vec3 box(int id, vec3 he) {
    vec3 r = irand3(id) * 2.0 - 1.0;       // map to [-1,1)
    return r * he;
}
