// Uniform inputs
uniform samplerBuffer u_PlyGeom;   // RGBA16F, 2 texels per point: [0]=pos.xyz, [1]=nrm.xyz
uniform samplerBuffer u_PlyCol;    // RGBA8,   1 texel per point  : color (normalized 0..1)
uniform int           u_InstanceBase; // optional base offset

struct PlyPoint {
    vec3 pos;  // px,py,pz
    vec3 nrm;  // nx,ny,nz
    vec4 col;  // rgba
};

PlyPoint plyFetch(int logicalIndex) {
    // Linear index in TBOs:
    int i = u_InstanceBase + logicalIndex;

    // GEOM: two texels per point
    vec3 pos = texelFetch(u_PlyGeom, i * 2 + 0).xyz;
    vec3 nrm = texelFetch(u_PlyGeom, i * 2 + 1).xyz;

    // COL: one texel per point (samplerBuffer returns normalized floats for RGBA8)
    vec4 col = texelFetch(u_PlyCol, i);

    // Safety normalize normal
//    nrm = normalize(nrm);

    PlyPoint point;
    point.pos = pos;
    point.nrm = nrm;
    point.col = col;
    return point;
}

float appearanceMask(vec3 pos, float progress) {
    float noise = simplex3d(pos * 0.25);

    float s = smoothstep(1.0, 2.0, noise + progress * 3.0);

    float k = 1.0 - s;
    return exp2(log2(k) * 100.0);
}

//float appearanceMask(vec3 pos, float progress) {
//    float noise = simplex3d(pos * 0.25);
//
//    float s = smoothstep(1.0, 2.0, noise + progress * 3.0);
//    float k = 1.0 - s;
//
//    // old: return pow(k, 100.0);
//    k *= k; // x^2
//    k *= k; // x^4
//    k *= k; // x^8
//    k *= k; // x^16
//    k *= k; // x^32  (OK, blisko 100 w praktyce)
//
//    return k;
//}

vec3 applyColorMask(vec3 baseColor, float mask) {
    return mix(baseColor, vec3(200.0), mask);
//    return mix(baseColor, baseColor * 200.0, mask);
}

//// Precomputed 6 directions for 60-degree sectors
const vec2 RADIAL_DIRS[6] = vec2[6](
    vec2( 1.0,  0.0),        // 0   (sector 0)
    vec2( 0.5,  0.8660254),  // 60  (sector 1)
    vec2(-0.5,  0.8660254),  // 120 (sector 2)
    vec2(-1.0,  0.0),        // 180 (sector 3)
    vec2(-0.5, -0.8660254),  // 240 (sector 4)
    vec2( 0.5, -0.8660254)   // 300 (sector 5)
);

vec2 radialSectorDir(vec2 pp) {
    // Fast zero check
    if (dot(pp, pp) < 1e-6) {
        return vec2(0.8660254, 0.5); // 30 fallback
    }

    // Angle in [0, 2PI) then shift by 30
    float ang = atan(pp.y, pp.x);
    ang = mod(ang + TWO_PI + PI_OVER_6, TWO_PI);

    // 6 sectors -> multiply instead of divide
    int sector = int(floor(ang * INV_PI_OVER_3)); // 0..5

    return RADIAL_DIRS[sector];
}