#version 410

#define NO_TANGENT
#define NO_UV

#pragma include "pipeline/vertex.glsl"

#pragma include "lib/warp.glsl"
#pragma include "lib/distrib.glsl"
#pragma include "lib/math.glsl"
#pragma include "lib/rot.glsl"
#pragma include "colors.glsl"

#pragma include "include.glsl"

#define YEL_COL vec3(1.0, 1.0, 0.0) * 200.
#define RED_COL vec3(1.0, 0.0, 0.0) * 200.
#define BLA_COL vec3(0.0, 0.0, 0.0)

// Uniform inputs
uniform bool u_Cloud;
uniform float u_Hover;
uniform float u_ObjectScale;
uniform float u_WallScale;
uniform bool u_Invert;
uniform bool u_Moto;
uniform bool u_Moto2;
uniform bool u_DoBurn;
uniform float u_Burn;
uniform bool u_DoDamage;
uniform float u_Damage;
uniform bool u_DoTron;
uniform float u_Tron;
uniform bool u_DoCluster;
uniform float u_Cluster;
uniform bool u_DoHex;

uniform float u_Morph;
uniform float u_Funnel;

out vec3 vertObjPosition;

// If you want to orient local +Z to given direction (zero roll):
vec3 eul_from_dir_localZ(vec3 dir) {
    vec3 d = normalize(dir);
    float ry = asin(clamp(d.x, -1.0, 1.0));
    float rx = atan(-d.y, d.z);
    float rz = 0.0;
    return vec3(rx, ry, rz);
}

void effect(inout Vertex v) {
    PlyPoint point = plyFetch(sid);

    vec4 col = point.col;
    if (col.a == 0.0) {
        v.color.a = 0.0;
        v.offset.z = 10000.0;
        return;
    }

    v.position.xyz *= 0.05;

    v.offset = point.pos;
    vec3 colFunnel = mix(COL_GLB, POL_COL, u_Funnel);
    v.color = vec4(colFunnel, 1.0);

    float mask;
    if (u_Progress > 0.0) {
        mask = appearanceMask(v.offset, u_Progress);
    }

    v.offset = rot(v.offset, vec3(-HALF_PI, 0.0, 0.0));
    vec3 r = radial(v.offset);   // (r, phi, theta) z NORMALNEJ

    if (u_Morph > 0.0) {
//        PlyPoint point2 = plyFetch(sid + 65536);
//        PlyPoint point2 = plyFetch(int(mod(sid, 6221)) + 65536);
        PlyPoint point2 = plyFetch(int(mod(sid, 6159)) + 65536);
        if (point2.col.a == 0.0) {
//            v.color.a = 1.0 - u_Morph;
        } else {
            vec3 offset2 = point2.pos;
            offset2 = rot(offset2, vec3(-HALF_PI, 0.0, 0.0));
            vec3 r2 = radial(offset2);   // (r, phi, theta) z NORMALNEJ
            vec3 new = mix(r, r2, u_Morph);
            v.offset.xyz = cartesian(new);
        }
    }

//    float u_Funnel = fract(osg_FrameTime * 0.2);

    float noise = rand(v.offset) * 2.0 - 1.0;
    float new_pr = smoothstep(1.0, 2.0, noise + u_Funnel * 3.0);
    float h_pr = new_pr * (2.0 - new_pr);
    v.offset.x = mix(v.offset.x, 0.0, h_pr);
    v.offset.z = mix(v.offset.z, 0.0, h_pr);
    v.offset.y = mix(v.offset.y, u_Hover / u_ObjectScale, new_pr);
    v.offset = rot(v.offset, vec3(0.0, -h_pr * 2.0, 0.0));
    if (h_pr > 0.9999) {
        v.color.a = 0.0;
        v.offset.y = 10000.0;
    }


    r = radial(v.offset);
    v.angle = vec3(r.z + HALF_PI, 0, -r.y + HALF_PI);

    if (u_Progress > 0.0) {
        v.color = vec4(applyColorMask(v.color.rgb, mask), v.color.a - mask);
    }

//     FOR DESIGNING:
//    if (mask < 1.0) {
//        v.color.rgb = vec3(0.0, 10.0, 0.0);
//        v.color.a = 1.0;
//    } else {
//        v.color.rgb = vec3(10.0, 0.0, 0.0);
//        v.color.a = 1.0;
//    }

    v.offset.y -= u_Hover / u_ObjectScale;
    v.offset.xyz *= 1.25;


    vertObjPosition = v.position.xyz;
}
