#version 410
#pragma include "pipeline/vertex.glsl"

//#pragma include "lib/warp.glsl"
//#pragma include "lib/distrib.glsl"
#pragma include "lib/math.glsl"
#pragma include "lib/constants.glsl"
#pragma include "lib/rot.glsl"
#pragma include "lib/simplex3d.glsl"
#pragma include "colors.glsl"

#define MAP_SHIFT vec2(+0.61, +0.47)

#define XEN_POS vec2(+0.000, +0.000)
#define INE_POS vec2(-0.550, -0.340)
#define DEA_POS vec2(-0.103, +0.012)
#define REV_POS vec2(-0.209, -0.095)
#define ASS_POS vec2(+0.041, +0.214)
#define EVO_POS vec2(-0.209, -0.050)
#define XXX_POS vec2(-0.250, -0.036)
#define NOV_POS vec2(-0.385, -0.043)
#define TRS_POS vec2(-0.145, +0.083)
#define FOR_POS vec2(-0.021, -0.131)
#define MOU_POS vec2(-0.187, -0.144)
#define SHA_POS vec2(-0.260, -0.090)
#define POS_POS vec2(-0.470, -0.380)
#define BUD_POS vec2(+0.010, -0.149)
#define GER_POS vec2(-0.104, +0.155)

#define MARGIN 0.02

#define PODIUM_RINGS 15
#define PODIUM_SIDS (1 + 3 * (PODIUM_RINGS - 1) * PODIUM_RINGS)

// Uniform inputs
uniform sampler2D u_MapTex;
uniform bool u_DoLodz;
uniform float u_Lodz;
uniform float u_Poland;
uniform float u_Europe;
uniform float u_Way;

uniform bool u_DoTex;
uniform float u_RotTex;

uniform bool u_DoDisco;
uniform bool u_DoMap;

uniform float u_Pendulum;

uniform bool u_DoPodium;

uniform bool u_Floor;

out float doTex;

uniform float u_Spin;

const float u_spacing = 1.0;
const float SQRT3   = 1.7320508075688772;
const float SQRT3_2 = 0.8660254037844386; // sqrt(3)/2

vec2 axialToXY(ivec2 qr, float spacing) {
    float q = float(qr.x), r = float(qr.y);
    return vec2((q + 0.5*r) * spacing,
                (SQRT3_2 * r) * spacing);
}

ivec2 linearToAxial_CW(int instId) {
    if (instId <= 0) return ivec2(0, 0);

    float f = float(instId);
    int k = int(ceil((sqrt(12.0*f + 3.0) - 3.0) / 6.0));

    int firstOnRing = 1 + 3*(k-1)*k;
    int ringIdx     = instId - firstOnRing;

    ivec2 pos = ivec2(k, 0);

    const ivec2 dirCW[6] = ivec2[6](
        ivec2( 0, -1),
        ivec2(-1,  0),
        ivec2(-1,  1),
        ivec2( 0,  1),
        ivec2( 1,  0),
        ivec2( 1, -1)
    );

    int side = ringIdx / k;        // 0..5
    int step = ringIdx - side*k;   // 0..k-1

    for (int s = 0; s < side; ++s) pos += dirCW[s] * k;
    pos += dirCW[side] * step;

    return pos;
}

vec2 hexSpiralXY_fromIndex(int instId, float spacing) {
    return axialToXY(linearToAxial_CW(instId), spacing);
}

// Pass-through / varyings:
out vec3 vertObjPosition;
out float instanceID;


float loc(vec2 uv, vec2 demoparty) {
    return smoothstep(MARGIN, 0.0, length(uv - demoparty));
}

void effect(inout Vertex v) {

    vertObjPosition = v.position.xyz;
    instanceID = sid;

    vec2 hexXY = hexSpiralXY_fromIndex(sid, u_spacing);

    v.offset.xz = hexXY;

    vec3 angleSeed = vec3(v.offset.xz * 0.2, t * TWO_PI * 0.125);
    v.angle = vec3(
        simplex3d(angleSeed.xyz),
        simplex3d(angleSeed.zxy),
        simplex3d(angleSeed.yzx)
    );
//    v.angle = pow(v.angle, vec3(3)) * 2.0 * u_Pendulum;
    v.angle = (v.angle * v.angle * v.angle) * (2.0 * u_Pendulum);

    v.color.a = 1.0;

    vec2 uv;
    if (u_DoLodz || u_DoMap) {
        uv = rotY(v.offset, PI_OVER_6).xz * 0.012;
    }

    if (u_DoMap) {
        vec3 probeLod = textureLod(u_MapTex, uv + MAP_SHIFT, 2).rgb;
        if (probeLod.g == 1.0) {
            v.color.a = 0.0;
        } else {
            v.color.rgb = mix(NRM_COL, EUR_COL, u_Europe);
        }

        if (probeLod.r == 1.00) {
            v.color.rgb = mix(NRM_COL, POL_COL, u_Poland);
        }

        vec2 ine_pos = mix(INE_POS, XEN_POS, u_Way);
        vec2 dea_pos = mix(DEA_POS, XEN_POS, u_Way);
        vec2 rev_pos = mix(REV_POS, XEN_POS, u_Way);
        vec2 ass_pos = mix(ASS_POS, XEN_POS, u_Way);
        vec2 evo_pos = mix(EVO_POS, XEN_POS, u_Way);
        vec2 xxx_pos = mix(XXX_POS, XEN_POS, u_Way);
        vec2 nov_pos = mix(NOV_POS, XEN_POS, u_Way);
        vec2 trs_pos = mix(TRS_POS, XEN_POS, u_Way);
        vec2 for_pos = mix(FOR_POS, XEN_POS, u_Way);
        vec2 mou_pos = mix(MOU_POS, XEN_POS, u_Way);
        vec2 sha_pos = mix(SHA_POS, XEN_POS, u_Way);
        vec2 pos_pos = mix(POS_POS, XEN_POS, u_Way);
        vec2 bud_pos = mix(BUD_POS, XEN_POS, u_Way);
        vec2 ger_pos = mix(GER_POS, XEN_POS, u_Way);

        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, ine_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, dea_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, rev_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, ass_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, evo_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, xxx_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, nov_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, trs_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, for_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, mou_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, sha_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, pos_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, bud_pos));
        v.color.rgb = mix(v.color.rgb, DEM_COL, loc(uv, ger_pos));
    } else {
        v.color.rgb = NRM_COL;
    }

    if (u_DoLodz) {
        v.color.rgb = mix(v.color.rgb, LDZ_COL, loc(uv, XEN_POS) * u_Lodz);
    }

    if (u_DoTex && sid == 0) {
        float ang = u_RotTex * TWO_PI * 8.0;
        v.angle.x += ang;

        float minAng = HALF_PI;
        float maxAng = (TWO_PI * 8.0) - HALF_PI;

        doTex = float(ang > minAng && ang < maxAng);
    } else {
        doTex = 0.0;
    }

    if (u_DoDisco) {
        uint h = sid;
        h ^= h >> 16;
        h *= 0x7feb352du;
        h ^= h >> 15;
        h *= 0x846ca68bu;
        h ^= h >> 16;
        float r = float(h) * (1.0 / 4294967296.0);  // [0,1)
        int hid = int(r * 3.0);                     // 0,1,2

        #define DISCO_BASE 1.0

        vec3 normalR = vec3(DISCO_BASE / 0.2126, 0, 0);
        vec3 normalG = vec3(0, DISCO_BASE / 0.7152, 0);
        vec3 normalB = vec3(0, 0, DISCO_BASE / 0.0722);

        float maxVal = max(max(normalR.r, normalG.g), normalB.b);

        vec3 discoColors[3] = vec3[](
            normalR / maxVal,
            normalG / maxVal,
            normalB / maxVal
        );

        vec3 disco = discoColors[hid] * 200. + NRM_COL;

        float tt   = u_Time;
        float tInt = floor(tt);
        float tFrac = tt - tInt;

        int activeGroup = int(mod(tInt, 3.0));

        float x = 1.0 - tFrac;
        float baseBeat = x * x * x;

        float beat = baseBeat * float(hid == activeGroup);

        v.color.rgb = mix(v.color.rgb, disco, beat);
    }

    if (sid == 0 && u_Floor) {
        float ang = u_Spin * PI;
        v.angle.y += ang;
    }

}
