#ifndef PC_GLSL
#define PC_GLSL
// pc.glsl — minimal point-cloud fetch helpers (GLSL 4.10+)

uniform int u_InstanceBase;

uniform samplerBuffer u_PosStatic;
uniform samplerBuffer u_ColStatic;
uniform samplerBuffer u_PosDynamic;
uniform samplerBuffer u_ColDynamic;

struct PC { vec2 pos; vec4 col; };

// generic fetch
PC pcfetch(samplerBuffer posBuf, samplerBuffer colBuf, int base, int inst) {
    int idx = base + inst;
    return PC(texelFetch(posBuf, idx).rg, texelFetch(colBuf, idx));
}

// wrappers
PC pcstat(int inst) { return pcfetch(u_PosStatic,  u_ColStatic,  u_InstanceBase, inst); }
PC pcdyn (int inst) { return pcfetch(u_PosDynamic, u_ColDynamic, u_InstanceBase, inst); }

#endif // PC_GLSL