#version 410

#define NO_NORMAL
#define NO_TANGENT
#define NO_UV
#define NO_SHADOWS

#pragma include "pipeline/vertex_light.glsl"

#pragma include "lib/warp.glsl"
#pragma include "include.glsl"

#define EFFECT false
#define ROTATE false

// Uniform inputs
uniform float u_Hover;
uniform float u_ObjectScale;
uniform float u_WallScale;

void effect(inout Vertex v) {
    bool end = v.position.x > 0.0;
//    float end = step(0.0, v.position.x);

    PlyPoint point = plyFetch(sid);
    v.color = point.col;

    float mask = appearanceMask(point.pos.xyz, u_Progress);
    v.color = vec4(vec3(200.0), float(mask > 0.0 && mask < 1.0));

    vec2 dir = radialSectorDir(point.pos.xy);

    float invObj = 1.0 / u_ObjectScale;

    if (end) {
        v.position.xyz = point.pos + vec3(0.0, 0.0, u_Hover * invObj);
    } else {
        float ws = u_WallScale * invObj;
        v.position.xyz = vec3(dir * ws, ws);
    }

}
