#pragma include "simplex3d.glsl"

// Approximate rotation using small-angle cross product (faster than full sin/cos)
vec3 trot(vec3 v, vec3 angle) {
    return v + cross(angle, v);
}

// Radian swirl morphing (fast: 3×noise, trot-based rotation)
vec3 swirl(vec3 offset, float rad_scale, float off_scale, float time_scale)
{
    float tt = t * time_scale;          // scaled global time
    vec3  ot = offset * off_scale;      // scaled input position

    // noise direction vectors for decorrelated sampling
    const vec3 A = vec3(0.7, 1.0, 1.3);
    const vec3 B = vec3(1.3, 0.7, 1.0);
    const vec3 C = vec3(1.0, 1.3, 0.7);

    // sample 3 independent noise values
    float mx = simplex3d( ot.xyz + A * tt );
    float my = simplex3d( ot.zxy + B * tt );
    float mz = simplex3d( ot.yzx + C * tt );

    // build small-angle rotation vector (reduced amplitude for stability)
    vec3 ang   = vec3(mx, my, mz) * (PI * 0.5);

    // apply approximate rotation (trot)
    vec3 shift = trot(offset, ang);

    // blend strength factor based on average noise
    float mw = (mx + my + mz) * (1.0 / 3.0);
    shift *= (mw*mw*mw + 1.0) * rad_scale;

    return shift; // final morphed offset
}
