-- title:   guckidemo
-- author:  Familie Tulpenbein
-- desc:    A fun little Sunday project for #Graffathon
-- site:    https://graffathon.org
-- license: CC0 Public Domain
-- version: 0.1
-- script:  lua

local t = 0
local musicplay = false

function TIC()
	cls()
	draw_stars(t // 6)
	draw_sprites(t // 6)
	t = t + 1
	if not musicplay then
		music(0, 0, 0, false, true, 150, 6)
		musicplay = true
	end
end

-- screen wave and sky gradient snippet by Darkhog
wavelimit = 100
function scanline(row)
	-- skygradient
	poke(0x3fc0, 100 - row)
	poke(0x3fc1, 100 - row)
	poke(0x3fc2, 150 - row)
	-- screen wave
	if row > wavelimit then
		poke(0x3ff9, math.sin((time() / 200 + row / 5)) * 3)
	else
		poke(0x3ff9, 0)
	end
end

thestars = {}
function draw_stars(t)
	-- draw a starry sky
	if #thestars == 0 then
		for i = 1, 10 do
			local x = math.random(1, 240)
			local y = math.random(1, 95)
			local r = math.floor(i % 3)
			thestars[i] = { x = x, y = y, r = r }
		end
	end
	local dir = t % 8 == 0
	for i = 1, #thestars do
		local x = thestars[i].x
		local y = thestars[i].y
		local r = thestars[i].r
		if dir then
			r = r + 1
		end
		x = x - 0.5
		if x < 0 then
			x = 240
		end
		thestars[i].x = x
		bill_circles(x, y, r, 10)
	end
end

function bill_circles(cx, cy, r, col)
	-- Midpoint circle algorithm by Bill Atkinson (R.I.P.)
	function plot_points(cx, cy, x, y, col)
		pix(cx + x, cy + y, col)
		pix(cx - x, cy + y, col + 1)
		pix(cx + x, cy - y, col)
		pix(cx - x, cy - y, col + 1)
		pix(cx + y, cy + x, col)
		pix(cx - y, cy + x, col + 1)
		pix(cx + y, cy - x, col)
		pix(cx - y, cy - x, col + 1)
	end

	x = 0
	y = r
	d = 1 - r

	plot_points(cx, cy, x, y, col)

	while x < y do
		x = x + 1
		if d < 0 then
			d = d + 2 * x + 1
		else
			y = y - 1
			d = d + 2 * (x - y) + 1
		end
		plot_points(cx, cy, x, y, col)
	end
end

thecacti = {
	{ x = 150, y = 88, ix = 289, w = 2, h = 2 }, -- big cactus
	{ x = 100, y = 93, ix = 256, w = 1, h = 1 }, -- small cactus
	{ x = 230, y = 93, ix = 256, w = 1, h = 1 }, -- small cactus
	{ x = 30, y = 93, ix = 256, w = 1, h = 1 }, -- small cactus
}
thesprites = {
	{ x = 200, y = 200, ix = 292, w = 2, h = 1 }, -- red truck
	{ x = 200, y = 200, ix = 280, w = 4, h = 2 }, -- big truck
	{ x = 200, y = 200, ix = 336, w = 4, h = 2 }, -- red bus
	{ x = 200, y = 200, ix = 416, w = 4, h = 1 }, -- blue bus
	{ x = 200, y = 200, ix = 341, w = 2, h = 2 }, -- gucki
}
for i = 1, #thesprites do
	thesprites[i].x = math.floor(i * 240 / #thesprites)
	thesprites[i].y = math.random(95, 136)
end
function draw_sprites(t)
	-- draw the ross
	if t // 2 % 2 == 0 then
		spr(406, 100, 45, 0, 2, 0, 0, 2, 1)
	else
		spr(422, 100, 45, 0, 2, 0, 0, 2, 1)
	end
	-- draw the cacti
	for i = 1, #thecacti do
		spr(thecacti[i].ix, thecacti[i].x, thecacti[i].y, 0, 1, 0, 0, thecacti[i].w, thecacti[i].h)
	end
	-- draw the rest
	for i = 1, #thesprites do
		local x = thesprites[i].x
		x = x + 1
		if x > 250 then
			x = -20
			thesprites[i].y = math.random(95, 136)
		end
		thesprites[i].x = x
		local y = thesprites[i].y
		local w = thesprites[i].w
		local h = thesprites[i].h
		local ix = thesprites[i].ix
		spr(ix, x, y, 0, 1, 0, 0, w, h)
	end
end
