// https://www.shadertoy.com/view/tcdXz2

// Graffathon 2025
// Evoke (Bystander)
// by sndels

// ---------------------------------- hg_sdf -----------------------------------
// http://mercury.sexy/hg_sdf/

// Utils
float PI = 3.14159265;
float INF = 1e30;

#define sat(x) clamp(x, 0., 1.)

float sgn(float x) {
    return (x < 0.) ? -1. : 1.;
}

// Maximum/minumum elements of a vector

float vmax(vec3 v) {
    return max(max(v.x, v.y), v.z);
}

// Geometry

float fSphere(vec3 p, float r) {
    return length(p) - r;
}

// Box: correct distance to corners
float fBox(vec3 p, vec3 b)
{
    vec3 d = abs(p) - b;
    return length(max(d, vec3(0))) + vmax(min(d, vec3(0)));
}

float fCapsule(vec3 p, float r, float c)
{
    return mix(
        length(p.xz) - r, length(vec3(p.x, abs(p.y) - c, p.z)) - r,
        step(c, abs(p.y)));
}

float fCylinder(vec3 p, float r, float height)
{
    float d = length(p.xz) - r;
    d = max(d, abs(p.y) - height);
    return d;
}

float fOpUnionRound(float a, float b, float r)
{
    vec2 u = max(vec2(r - a, r - b), vec2(0));
    return max(r, min(a, b)) - length(u);
}

float fOpIntersectionRound(float a, float b, float r)
{
    vec2 u = max(vec2(r + a, r + b), vec2(0));
    return min(-r, max(a, b)) + length(u);
}

float fOpDifferenceRound(float a, float b, float r)
{
    return fOpIntersectionRound(a, -b, r);
}

// Space ops

void pR(inout vec2 p, float a) {
    p = cos(a) * p + sin(a) * vec2(p.y, -p.x);
}


// Mirror at an axis-aligned plane which is at a specified distance <dist> from
// the origin.
float pMirror(inout float p, float dist)
{
    float s = sgn(p);
    p = abs(p) - dist;
    return s;
}


// --------------------------------- GLOBALS ---------------------------------


vec2 RESOLUTION;

float TIME_S;
float IDLE_LOOP;

// Marching
float MIN_DIST = 0.0001;
float MAX_DIST = 256.;
int MAX_STEPS = 256;

// Light
vec3 POINT_O;
float POINT_L;

// Fog
float FOG_DENSITY;
int FOG_SAMPLES = 20;
float FOG_ANISOTROPY;
float FOG_DEPTH;
float MAX_STEP_SIZE;

// ------------------------------- RNG/NOISE----------------------------------

// From iq
float SEED; // initialized in main
float rnd() {
    return fract(sin(SEED++) * 43758.5453123);
}

// -------------------------------- GEOMETRY ---------------------------------


vec2 scene(vec3 p, bool volume)
{
    vec3 rot = vec3(2.140, 2.512, 0.753);
    p.y += .16 * IDLE_LOOP;

    vec3 pp;
    float dd;
    vec2 d = vec2(INF, 0);


    vec3 ppp;
    { // Figure
        // This model is hideously misfigured when inspected from any angle other than the default one :)

        p -= vec3(0., -3., -6.);
        pR(p.zy, PI / 5.);
        // Torso
        pp = p;
        pMirror(pp.x, 0.);
        pR(pp.xz, .557);
        pR(pp.yz, -.035);
        pR(pp.xy, -.316);
        dd = fCylinder(pp - vec3(.8, -2, 0), 1.1, 1.5);
        pp = p;
        dd = fOpUnionRound(dd, fCylinder(pp - vec3(0, -4, -.1), .8, 1.5), .2);

        // Arms
        pp = p;
        pp -= vec3(1.25, -.49, .25);
        float upperArmLength = 1.5;
        pR(pp.xz, 0.8 - .05 * IDLE_LOOP);
        pR(pp.yz, -2.194 - .05 * IDLE_LOOP);
        pR(pp.xy, .194);
        pp.y -= upperArmLength;
        dd = fOpUnionRound(dd, fCylinder(pp, 0.4, upperArmLength), .9);
        pp = p;
        pp -= vec3(-1.45, -.99, .25);
        pR(pp.xz, -1.6 - .05 * IDLE_LOOP);
        pR(pp.yz, -1.594 - .05 * IDLE_LOOP);
        pR(pp.xy, -.194);
        pp.y -= upperArmLength * 2.;
        dd = fOpUnionRound(dd, fCylinder(pp, 0.4, upperArmLength * 2.), 1.5);

        // Head
        pp = p;
        pR(pp.zy, -.464);
        pR(pp.yx, -.1 * (1. + IDLE_LOOP));
        pp -= vec3(0., .45, -.5);
        pR(pp.yz, -.1 * (1. + IDLE_LOOP));
        float ddd = fSphere(pp, .8);
        ppp = pp;
        pR(ppp.yz, .36);
        ppp.y -= 1.5;
        ppp = pp;
        ppp -= vec3(7.2, -.61, -.4);
        pR(ppp.xz, -.3);
        pR(ppp.yz, -.04);
        pR(ppp.xy, -.76);
        ddd = fOpDifferenceRound(ddd, fBox(ppp, vec3(5.)), .1);
        ppp = pp;
        ppp -= vec3(-7.2, -.61, -.4);
        pR(ppp.xz, .3);
        pR(ppp.yz, .04);
        pR(ppp.xy, .73);
        ddd = fOpDifferenceRound(ddd, fBox(ppp, vec3(5.)), .1);
        ppp = pp;
        ppp -= vec3(0, .5, 0);
        ddd = min(fCapsule(ppp, .8, .2), ddd);
        dd = fOpUnionRound(dd, ddd, .3);

        if (dd < d.x)
        {
            ppp = pp;
            ppp.y -= .4;
            pR(ppp.yx, -PI / 4.);
            float dx = fBox(ppp, vec3(.5, .1, 2.));
            pR(ppp.yx, PI / 2.);
            dx = min(fBox(ppp, vec3(.5, .1, 2.)), dx);
            if (dx <= 0.)
                d = vec2(dd, 1);
            else
                d = vec2(dd, 0);
        }

        // Hand
        pp = p;
        pR(pp.yz, -.1 * (1. + IDLE_LOOP));
        pp -= vec3(-2., 1., -.4);
        pR(pp.yz, .85);
        pR(pp.yx, 1.25);
        dd = min(
                fOpUnionRound(
                    fCylinder(pp, .15, .25),
                    fCylinder(pp - vec3(.4, 0, 0), .15, .25),
                    .25
                ),
                dd
            );
        pp -= vec3(-.04, .65, 0);
        dd = min(fCylinder(pp, .1, .4), dd);
        pp.x -= .15;
        dd = min(fCylinder(pp, .1, .4), dd);
        pR(pp.xy, .6);
        pp -= vec3(-.75, -.45, 0);
        dd = min(fCylinder(pp, .1, .15), dd);
        pR(pp.xy, .1);
        pp -= vec3(.02, .3, 0);
        dd = min(fCylinder(pp, .1, .15), dd);
        pR(pp.xy, .34);
        dd = max(dd, -fBox(pp - vec3(.1, .2, 0), vec3(.1, .4, .2)));
        pp -= vec3(-3.46, -4.3, 0);
        pR(pp.xy, 2.39);
        dd = fOpUnionRound(fCylinder(pp, .25, 5.), dd, .2);
        d = dd < d.x ? vec2(dd, 0) : d;

        // Rays
        if (!volume)
        {
            pp = p;
            pp -= vec3(-.76, 1.3, -.1);
            pR(pp.xy, PI / 4. + IDLE_LOOP * .1);
            pp.y -= 5.;
            dd = fCylinder(pp, .02, 5.);
            pp.y += 5.;
            pR(pp.yz, PI / 1.6 + IDLE_LOOP * .1);
            pp.y += 5.;
            dd = min(fCylinder(pp, .02, 5.), dd);
            pp = p;
            pR(pp.xy, -1.3);
            pp -= vec3(-1.45, -5, -.1);
            dd = min(fCylinder(pp, .02, 5.), dd);
            d = dd < d.x ? vec2(dd, 1) : d;
        }
    }

    return d;
}

// -------------------------------- MARCHING ---------------------------------

// Naive sphere tracing
vec2 march(vec3 ro, vec3 rd, float tMax)
{
    float t = MIN_DIST;
    float mat = -1.;
    for (int i = 0; i < MAX_STEPS; ++i) {
        vec2 h = scene(ro + rd * t, false);
        if (h.x < MIN_DIST || h.x > tMax)
            break;
        t += h.x;
        mat = h.y;
    }
    if (t > tMax)
        t = INF;
    return vec2(t, mat);
}

// ---------------------------------- LIGHT ----------------------------------

// Adapted from iq
float shadow(vec3 p, vec3 l, float tMax, float k)
{
    float ret = 1.;
    float ph = 1e20;
    for (float t = 0.; t < tMax; ) {
        // Fudge around volume artifacts near small objects
        float h = scene(p + l * t, true).x + (rnd() - 0.4) / 10.;
        if (h < 0.01)
            return 0.0;
        float y = h * h / (2. * ph);
        float d = sqrt(h * h - y * y);
        ret = min(ret, k * d / max(0., t - y));
        ph = y;
        t += h;
    }
    return ret;
}

float evalPoint(vec3 p, vec3 n)
{
    vec3 l = POINT_O - p;
    float dist2 = dot(l, l);
    float dist = sqrt(dist2);
    l /= dist;

    // Check if point sees the light
    float shadow_amount = shadow(p + n / 1000., l, dist, 3.);
    float L = POINT_L / dist2;

    float volume_absorption = exp(-FOG_DENSITY * dist);
    return shadow_amount * POINT_L * volume_absorption * dot(n, l);
}

// --------------------------------- VOLUME ----------------------------------

float henyeyGreenstein(vec3 l, vec3 v)
{
    float cos_theta = dot(l, -v);
    return 1. / (PI * 4.) * (1. - FOG_ANISOTROPY * FOG_ANISOTROPY) /
        pow(1. + FOG_ANISOTROPY * FOG_ANISOTROPY -
                2. * FOG_ANISOTROPY * cos_theta,
            3.0 / 2.);
}

float volume(float t, vec3 ray_o, vec3 ray_d)
{
    // "Stratified" random
    float step_size = FOG_DEPTH / float(FOG_SAMPLES);
    float frame_offset = step_size * rnd();
    float step_absorption = exp(-FOG_DENSITY * step_size);
    float step_color = (1. - step_absorption) *
            henyeyGreenstein(normalize(POINT_O - ray_o), -ray_d);
    float absorption = 1.;
    float I = 0.;
    for (int i = 0; i < FOG_SAMPLES; ++i) {
        float s = float(i) * step_size + frame_offset;
        // Break on final hit
        if (s > t)
            break;

        vec3 p = ray_o + ray_d * s;

        absorption *= step_absorption;
        I += step_color * absorption * evalPoint(p, normalize(POINT_O - p));
    }
    return I;
}

// --------------------------------- SETUP ----------------------------------

float dirac(float x, float x0, float width)
{
    return abs(1. / ((x - x0) + .001) * width);
}

void initGlobals(vec2 px)
{
    RESOLUTION = iResolution.xy;
    // Sequencing
    TIME_S = iTime;
    float loopSpeed = 1.5;
    TIME_S = mod(TIME_S * loopSpeed, 2. * PI);

    IDLE_LOOP = sin(TIME_S);

    POINT_L = 100.;
    POINT_O = vec3(-6.5, -4.5 + 1.75 * IDLE_LOOP, 10.);

    FOG_DENSITY = 0.05;
    FOG_ANISOTROPY = 0.8;
    FOG_DEPTH = 5.;
    MAX_STEP_SIZE = FOG_DEPTH / float(FOG_SAMPLES);

    SEED = px.y * px.x / RESOLUTION.x +
            px.y / RESOLUTION.y + TIME_S;
}

// #define MODELING_CAMERA

void camRay(vec2 uv, inout vec3 ray_o, inout vec3 ray_d)
{
    ray_o = vec3(0, -2., -9.3);
    vec3 camRot = vec3(0, 0, 0);
#ifdef MODELING_CAMERA
    if (uv.x < .5 && uv.y < .5)
    {
        ;
    }
    else if (uv.x < .5)
    {
        ray_o = vec3(-5., -2., -5.);
        camRot = vec3(PI / 2., 0., 0.);
        uv *= 2.;
        uv.y -= 1.;
    }
    else if (uv.y < .5)
    {
        ray_o = vec3(0., -2., -10.);
        camRot = vec3(0., 0., 0.);
        uv *= 2.;
        uv.x -= 1.;
    }
    else
    {
        ray_o = vec3(0., 2., -5.);
        camRot = vec3(0., -PI / 2., 0.);
        uv = uv * 2. - 1.;
    }
#endif // MODELING_CAMERA


    uv -= 0.5; // origin at center
    uv /= vec2(RESOLUTION.y / RESOLUTION.x, 1); // fix aspect ratio
    ray_d = normalize(vec3(uv, 0.7)); // pull ray

    pR(ray_d.yx, camRot.z);
    pR(ray_d.yz, camRot.y);
    pR(ray_d.xz, camRot.x);
}

void tonemap(inout vec3 color)
{
    // ACES tonemap
    color =
        sat((color * (2.51 * color + 0.03)) /
                (color * (2.43 * color + 0.59) + 0.14));

    // Gamma correction, of course
    color = pow(color, vec3(0.45));
}

// ---------------------------------- MAIN -----------------------------------

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 color = vec3(0);
    float targetResX = trunc(240.);
    float resolutionScale = sat(targetResX / iResolution.x);
    vec2 px = trunc(vec2(fragCoord.xy * resolutionScale));
    vec2 uv = px / (iResolution.xy * resolutionScale);
    initGlobals(px);

    vec3 ray_o, ray_d;
    camRay(uv, ray_o, ray_d);

    // Trace them spheres
    vec2 tm = march(ray_o, ray_d, MAX_DIST);
    float t = tm.x;
    float mat = tm.y;
    vec3 p;
    if (t < MAX_DIST) {
        p = ray_o + ray_d * t;

        if (mat == 1.) {
            color += 2. * vec3(3.) - 2. * IDLE_LOOP;
        }

        color += volume(t, ray_o, ray_d);
    }
    else
    {
        color += volume(FOG_DEPTH, ray_o, ray_d);
        p = vec3(MAX_DIST);
        // color += .4;
    }

    color *= vec3(.75, .7, .4);

    // Posterization
    // float luminance = dot(vec3(.2126, .7152, .0722), color);
    // color /= luminance;
    // float luminanceDepth = 10.;
    // color *= trunc(.4 + luminance * luminanceDepth) / (luminanceDepth * 4.);

    // Tonemap before fade to get linear fade
    tonemap(color);

    // "21:9" from 16:9
    // if (abs(uv.y - 0.5) > 0.38 && p.z > -7.)
    //    color = vec3(1.);

    fragColor = vec4(vec3(color), 1);
}

