#version 450

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inNormal;
layout(location = 2) in vec3 inColor;

layout(location = 0) out vec4 outColor;

#include "ubo_perframe.glsl"

void main() {

    vec3 N = normalize(inNormal);
    vec3 V = normalize(cameraPosition.xyz-inPosition);
    
    float NdotV = max(dot(N, V), 0.0f);
    
    vec3 lightPos = cameraPosition; //vec3(15.0f*sin(time*0.1f),40.0f,15.0f*cos(time*0.1f));
    vec3 L = normalize(lightPos-inPosition);
    
    float lambert = max(dot(N, L), 0.0f);

    //vec3 H = normalize(L+V);
    //float specular = 1.0f * pow(max(dot(N,H),0.0), 22.0f);

    vec3 result = lambert*vec3(0.4f, 0.4f, 0.4f);

    outColor = vec4(result, 1.0f);
}



