
.include "fb32x32.inc"

.include "globals.inc"

.segment "DATA"

charwidth:
   .byte 2,2,4,6,6,4,6,3,4,4,4,4,3,3,2,6,4,4,4,4,4,4,4,4,4,4,2,8,4,3,4,6
   .byte 6,5,5,5,5,5,5,5,5,4,5,5,5,6,5,5,5,5,5,5,4,5,6,6,6,6,6,3,6,3,8,8

.segment "PADATA"

charset:
   .byte $00,$00,$00,$00,$00,$00,$00,$00 ; ' '
   .byte $80,$80,$80,$80,$00,$00,$80,$00 ; '!'
   .byte $a0,$a0,$00,$00,$00,$00,$00,$00 ; '"'
   .byte $00,$50,$f8,$50,$f8,$50,$00,$00 ; '#'
   .byte $20,$78,$a0,$70,$28,$f0,$20,$00 ; '$'
   .byte $00,$80,$20,$40,$80,$20,$00,$00 ; '%'
   .byte $60,$90,$a0,$40,$a8,$90,$68,$00 ; '&'
   .byte $40,$80,$00,$00,$00,$00,$00,$00 ; '''
   .byte $20,$40,$80,$80,$80,$40,$20,$00 ; '('
   .byte $80,$40,$20,$20,$20,$40,$80,$00 ; ')'
   .byte $00,$00,$a0,$40,$a0,$00,$00,$00 ; '*'
   .byte $00,$00,$40,$e0,$40,$00,$00,$00 ; '+'
   .byte $00,$00,$00,$00,$00,$40,$40,$80 ; ','
   .byte $00,$00,$00,$c0,$00,$00,$00,$00 ; '-'
   .byte $00,$00,$00,$00,$00,$00,$80,$00 ; '.'
   .byte $00,$08,$10,$20,$40,$80,$00,$00 ; '/'
   .byte $e0,$a0,$a0,$a0,$a0,$a0,$e0,$00 ; '0'
   .byte $40,$c0,$40,$40,$40,$40,$e0,$00 ; '1'
   .byte $c0,$20,$20,$40,$80,$80,$e0,$00 ; '2'
   .byte $c0,$20,$20,$60,$20,$20,$c0,$00 ; '3'
   .byte $a0,$a0,$a0,$e0,$20,$20,$20,$00 ; '4'
   .byte $e0,$80,$80,$e0,$20,$20,$c0,$00 ; '5'
   .byte $60,$80,$80,$e0,$a0,$a0,$e0,$00 ; '6'
   .byte $e0,$20,$20,$20,$20,$20,$20,$00 ; '7'
   .byte $e0,$a0,$a0,$e0,$a0,$a0,$e0,$00 ; '8'
   .byte $e0,$a0,$a0,$e0,$20,$20,$c0,$00 ; '9'
   .byte $00,$00,$80,$00,$00,$80,$00,$00 ; ':'
   .byte $00,$00,$40,$00,$00,$40,$40,$80 ; ';'
   .byte $00,$10,$20,$40,$20,$10,$00,$00 ; '<'
   .byte $00,$00,$c0,$00,$c0,$00,$00,$00 ; '='
   .byte $00,$80,$40,$20,$40,$80,$00,$00 ; '>'
   .byte $70,$88,$08,$10,$20,$00,$20,$00 ; '?'
   .byte $70,$88,$b8,$a8,$b8,$80,$70,$00 ; '@'
   .byte $60,$90,$90,$f0,$90,$90,$90,$00 ; 'A'
   .byte $e0,$90,$90,$e0,$90,$90,$e0,$00 ; 'B'
   .byte $60,$90,$80,$80,$80,$90,$60,$00 ; 'C'
   .byte $c0,$a0,$90,$90,$90,$a0,$c0,$00 ; 'D'
   .byte $f0,$80,$80,$e0,$80,$80,$f0,$00 ; 'E'
   .byte $f0,$80,$80,$e0,$80,$80,$80,$00 ; 'F'
   .byte $60,$90,$80,$80,$b0,$90,$60,$00 ; 'G'
   .byte $90,$90,$90,$f0,$90,$90,$90,$00 ; 'H'
   .byte $e0,$40,$40,$40,$40,$40,$e0,$00 ; 'I'
   .byte $70,$10,$10,$10,$10,$90,$60,$00 ; 'J'
   .byte $90,$90,$a0,$c0,$a0,$90,$90,$00 ; 'K'
   .byte $80,$80,$80,$80,$80,$80,$f0,$00 ; 'L'
   .byte $88,$d8,$a8,$88,$88,$88,$88,$00 ; 'M'
   .byte $90,$d0,$d0,$b0,$b0,$90,$90,$00 ; 'N'
   .byte $60,$90,$90,$90,$90,$90,$60,$00 ; 'O'
   .byte $e0,$90,$90,$e0,$80,$80,$80,$00 ; 'P'
   .byte $60,$90,$90,$90,$90,$a0,$50,$00 ; 'Q'
   .byte $e0,$90,$90,$e0,$c0,$a0,$90,$00 ; 'R'
   .byte $60,$90,$80,$60,$10,$90,$60,$00 ; 'S'
   .byte $e0,$40,$40,$40,$40,$40,$40,$00 ; 'T'
   .byte $90,$90,$90,$90,$90,$90,$60,$00 ; 'U'
   .byte $88,$88,$88,$88,$88,$50,$20,$00 ; 'V'
   .byte $88,$88,$88,$88,$a8,$d8,$88,$00 ; 'W'
   .byte $88,$88,$50,$20,$50,$88,$88,$00 ; 'X'
   .byte $88,$88,$50,$20,$20,$20,$20,$00 ; 'Y'
   .byte $f8,$08,$10,$20,$40,$80,$f8,$00 ; 'Z'
   .byte $c0,$80,$80,$80,$80,$80,$c0,$00 ; '['
   .byte $00,$80,$40,$20,$10,$08,$00,$00 ; '\'
   .byte $c0,$40,$40,$40,$40,$40,$c0,$00 ; ']'
   .byte $00,$6c,$fe,$7c,$38,$10,$00,$00 ; '^'
   .byte $00,$00,$00,$00,$00,$00,$00,$00 ; '_'

.assert <* = 0, error, "not page aligned"

.segment "CODE"

getchar:
   ; IN A: ASCII char
   ; OUT charbuffer: data
   ; OUT A: char width in pixel
   ; OUT X: index of char = ASCII-$20
   sec
   sbc   #$20
   and   #$3f              ; just make sure that lowercase don't kill
   pha
   asl
   asl
   asl
   sta   @data+1
   lda   #>charset
   adc   #$00
   sta   @data+2

   ldx   #$07
@data:
   lda   charset,x
   sta   charbuffer,x
   dex
   bpl   @data
   plx
   lda   charwidth,x
   rts


text_setfb:
   ; vector: pointer to
   ; A/X: vector to framebuffer
   ; Y: color
   sta   dest+1
   stx   dest+2
   sty   color+1
   rts

text_draw:
   ; fast implementation, only for up to 32 pixels wide
   ; A/X: vector to text
   sta   nextchar+1
   stx   nextchar+2

   ldy   #$00
nextchar:
   lda   $ffff
   bne   :+
end:
   rts
:
   inc   nextchar+1
   bne   :+
   inc   nextchar+2
:
   jsr   getchar
   sta   tmp8

nextcolumn:
   ldx   #$00
nextline:
   rol   charbuffer,x
   bcc   skipline
color:
   lda   #$ff
dest:
   sta   $ffff,y
skipline:
   tya
   sec
   adc   #$1f
   tay
   inx
   cpx   #$08
   bcc   nextline
   iny
   beq   end              ; more than 256 pixels per line makes never sense
   dec   tmp8
   bne   nextcolumn
   beq   nextchar
