
.include "fb32x32.inc"

.include "globals.inc"

.segment "DATA"

wb0:
   .byte $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f
   .byte $0f,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$0f
   .byte $0f,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f,$ff,$0f,$ff,$0f
   .byte $0f,$ff,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f
   .byte $0f,$ff,$0f,$ff,$ff,$ff,$ff,$ff,$0f,$ff,$ff,$0f,$ff,$ff,$ff,$ff,$ff,$0f,$ff,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f
   .byte $0f,$ff,$0f,$ff,$ff,$0f,$ff,$ff,$ff,$0f,$ff,$ff,$ff,$ff,$ff,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f
   .byte $0f,$ff,$0f,$ff,$ff,$ff,$ff,$0f,$ff,$ff,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f
   .byte $0f,$ff,$0f,$d3,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$ff,$0f

wb1:
   .byte $00,$20,$40,$20,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$20,$00

wb2:
   .byte $00,$20,$40,$20,$60,$80,$a0,$c0,$e0,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$60,$20,$00

fadecolors:
   .byte $00
   .byte $54,$a8,$fc,$ff

handcolors:
   .byte $00,$0b,$03,$ff


kickhand:
   .incbin "gfx/kickhand.bin"

myschedule:
   .word $0000, colors
   .word $0050, unpackhand
   .word $009f, wbcopy
   .word $00a0, stepwb1
   .word $00c0, stepwb2
   .word $00d0, amigaprecalc
   .word $011f, schedulenext

.segment "GFXDATA"

mousecolors:
   .byte $c0,$c0,$c0,$ff


fillbuf  = $03c0

step     = localram

.segment "CODE"

amigaboot:
   lda   #<myschedule
   ldx   #>myschedule
   jmp   subschedule

colors:
   stz   FB32X32_COLMAP
   lda   frmcnt+0
   lsr
   lsr
   lsr
   lsr
   tax
   lda   fadecolors,x
fillscreen:
   ldx   #$3f
:
   sta   TMPBUFFER,x
   dex
   bpl   :-

   lda   #<TMPBUFFER
   sta   FB32X32_SRC+0
   lda   #>TMPBUFFER
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT
   stz   FB32X32_STEP

   stz   FB32X32_COPY
   rts


addmouse:
   lda   #$c0
   sta   FRAMEBUFFER+$000
   sta   FRAMEBUFFER+$001
   sta   FRAMEBUFFER+$020
   rts

unpackhand:
   stz   vector+0
   lda   #>FRAMEBUFFER
   sta   vector+1

   ldx   #$00
:
   lda   kickhand,x
   sta   TMPBUFFER,x
   inx
   bne   :-

   lda   #$04
   sta   tmp8
   ldy   #$00
:
   lda   #$00
   rol   TMPBUFFER,x
   rol
   rol   TMPBUFFER,x
   rol
   tax
   lda   handcolors,x
   sta   (vector),y
   iny
   tya
   tax
   bne   :-
   inc   vector+1
   dec   tmp8
   bne   :-

   jmp   showfb

wbcopy:
   ldx   #$00
:
   lda   wb0,x
   sta   TMPBUFFER,x
   inx
   bne   :-

   ldx   #$00

   rts

stepwb1:
   lda   #<wb1
   ldx   #>wb1
   bra   wbcommon

stepwb2:
   lda   #<wb2
   ldx   #>wb2

wbcommon:
   sta   vector+0
   stx   vector+1

   ldy   #$1f
   stz   FB32X32_COLMAP
:
   lda   (vector),y
   sta   FB32X32_SRC+0
   lda   #>TMPBUFFER
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   sty   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_WIDTH
   stz   FB32X32_HEIGHT
   sta   FB32X32_STEP

   dey
   stz   FB32X32_COPYN
   bpl   :-

.if 1
   ; WORKAROUND FOR BUFFER NOT COPIED PROPERLY
   lda   #$60
   sta   FB32X32_SRC+0
   lda   #$1d
   sta   FB32X32_DEST_Y
   stz   FB32X32_COPYN
.endif

   lda   #<mousecolors
   sta   FB32X32_SRC+0
   lda   #>mousecolors
   sta   FB32X32_SRC+1

   lda   #$01
   sta   FB32X32_DEST_X
   sta   FB32X32_DEST_Y
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT
   sta   FB32X32_STEP

   stz   FB32X32_COPY
   rts

amigaprecalc:
   lda   #<FRAMEBUFFER
   sta   FB32X32_SRC+0
   sta   vector+0
   lda   #>FRAMEBUFFER
   sta   FB32X32_SRC+1
   sta   vector+1

   ldx   #$00
@loop2:
   ldy   #$00
@loop1:
   cpx   #$00
   bne   @notnew
   lda   RANDOM
   and   #$07
   adc   #$03
   tax
   lda   RANDOM
@notnew:
   sta   (vector),y
   dex
   iny
   bne   @loop1
   inc   vector+1
   ldy   vector+1
   cpy   #>(FRAMEBUFFER+$400)
   bne   @loop2

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_STEP
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT

   stz   FB32X32_COPY
   rts

