/**************************
***** Compiler Parameters *****
***************************
@P EffectName: TextureFXEffect
@P   - EffectNodeBase.EffectNodeBaseShader: mixin NoiseDithering_Internal_TextureFX [{Control = InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>}, {Grain = InputFloat<ShaderFX.InputValueFloat.i1,PerUpdate>}, {Time = InputFloat<ShaderFX.InputValueFloat,PerUpdate>}]
@P Time: InputFloat<ShaderFX.InputValueFloat,PerUpdate>
@P Grain: InputFloat<ShaderFX.InputValueFloat.i1,PerUpdate>
@P Control: InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>
***************************
****  ConstantBuffers  ****
***************************
cbuffer PerDraw [Size: 64]
@C    MatrixTransform_id73 => SpriteBase.MatrixTransform
cbuffer PerUpdate [Size: 32]
@C    InputValue_id92 => ShaderFX.InputValueFloat4
@C    InputValue_id93 => ShaderFX.InputValueFloat.i1
@C    InputValue_id94 => ShaderFX.InputValueFloat
cbuffer PerView [Size: 32]
@C    NearClipPlane_id74 => Camera.NearClipPlane
@C    FarClipPlane_id75 => Camera.FarClipPlane
@C    ZProjection_id76 => Camera.ZProjection
@C    ViewSize_id77 => Camera.ViewSize
@C    AspectRatio_id78 => Camera.AspectRatio
cbuffer Globals [Size: 96]
@C    Texture0TexelSize_id15 => Texturing.Texture0TexelSize
@C    Texture1TexelSize_id17 => Texturing.Texture1TexelSize
@C    Texture2TexelSize_id19 => Texturing.Texture2TexelSize
@C    Texture3TexelSize_id21 => Texturing.Texture3TexelSize
@C    Texture4TexelSize_id23 => Texturing.Texture4TexelSize
@C    Texture5TexelSize_id25 => Texturing.Texture5TexelSize
@C    Texture6TexelSize_id27 => Texturing.Texture6TexelSize
@C    Texture7TexelSize_id29 => Texturing.Texture7TexelSize
@C    Texture8TexelSize_id31 => Texturing.Texture8TexelSize
@C    Texture9TexelSize_id33 => Texturing.Texture9TexelSize
@C    Levels_id90 => NoiseDithering_Internal_TextureFX.Levels
@C    Uniform_id91 => NoiseDithering_Internal_TextureFX.Uniform
***************************
******  Resources    ******
***************************
@R    PerDraw => PerDraw [Stage: Vertex, Slot: (0-0)]
@R    LinearSampler_id44 => Texturing.LinearSampler [Stage: Pixel, Slot: (0-0)]
@R    Sampler0_id52 => Texturing.Sampler0 [Stage: Pixel, Slot: (1-1)]
@R    Texture0_id14 => Texturing.Texture0 [Stage: Pixel, Slot: (0-0)]
@R    PerUpdate => PerUpdate [Stage: Pixel, Slot: (0-0)]
@R    PerView => PerView [Stage: Pixel, Slot: (1-1)]
@R    Globals => Globals [Stage: Pixel, Slot: (2-2)]
***************************
*****     Sources     *****
***************************
@S    NoiseDithering_Internal_TextureFX => c99677d6f09811cd46454366259cbbf6
@S    FilterBase => 5bd9cb7e7eb80aa436e148c74d845c07
@S    TextureFX => 27bb4f1f808a5eedf6dfeaa75c669c29
@S    ImageEffectShader => 8064e30cc02e5eb4052f420259dbf05e
@S    SpriteBase => 5a7aa9dfd5b5c7613053f4f66c79ca0d
@S    ShaderBase => 4ecbcd2528b64a79eebe81a863892d8c
@S    ShaderBaseStream => b705b699a7385d39c7de52a8d13f3978
@S    Texturing => 91ef3011c1071c2e5d41cd3ee0418b18
@S    Camera => f5d1a113ef7a27319900e8cc2e11ae0d
@S    ShaderUtils => 27e27e08e991883f970444d1aebe3b58
@S    ComputeFloat4 => f871947e9f604da432ea9fc3c9cb4363
@S    ComputeColor => c875a0e093379dd74cd9a5a73aca830f
@S    ComputeFloat => 3607bb1fa125ec30a7afa60be79c4817
@S    InputFloat4 => f6891eacc9ea2d912dcfded49ea96a71
@S    DeclFloat4 => 03cb445d0e450d0a37ad5f24c8a93feb
@S    InputFloat => f487ac725dafb0434d14d0273ee628a8
@S    DeclFloat => 75bf7e6f5246ed3d7aa33ab3c7183aa4
***************************
*****     Stages      *****
***************************
@G    Vertex => 79eb7ff071584feaa45b858a38e87b6a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerDraw
// {
//
//   float4x4 MatrixTransform_id73;     // Offset:    0 Size:    64
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerDraw                           cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// POSITION                 0   xyzw        0     NONE   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
vs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input v0.xyzw
dcl_input v1.xy
dcl_output_siv o0.xyzw, position
dcl_output o1.xy
//
// Initial variable locations:
//   v0.x <- __input__.Position_id72.x; v0.y <- __input__.Position_id72.y; v0.z <- __input__.Position_id72.z; v0.w <- __input__.Position_id72.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o1.x <- <VSMain return value>.TexCoord_id62.x; o1.y <- <VSMain return value>.TexCoord_id62.y; 
//   o0.x <- <VSMain return value>.ShadingPosition_id0.x; o0.y <- <VSMain return value>.ShadingPosition_id0.y; o0.z <- <VSMain return value>.ShadingPosition_id0.z; o0.w <- <VSMain return value>.ShadingPosition_id0.w
//
#line 222 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_12d5dafcb980a9932a2a524f22d23cba.hlsl"
dp4 o0.x, v0.xyzw, cb0[0].xyzw
dp4 o0.y, v0.xyzw, cb0[1].xyzw
dp4 o0.z, v0.xyzw, cb0[2].xyzw
dp4 o0.w, v0.xyzw, cb0[3].xyzw

#line 226
mov o1.xy, v1.xyxx
ret 
// Approximately 6 instruction slots used
@G    Pixel => 9ab0b3f27dcc905e1468e7f77b418eb3
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerUpdate
// {
//
//   float4 InputValue_id92;            // Offset:    0 Size:    16
//   float InputValue_id93;             // Offset:   16 Size:     4
//   float InputValue_id94;             // Offset:   20 Size:     4
//
// }
//
// cbuffer PerView
// {
//
//   float NearClipPlane_id74;          // Offset:    0 Size:     4 [unused]
//      = 0x3f800000 
//   float FarClipPlane_id75;           // Offset:    4 Size:     4 [unused]
//      = 0x42c80000 
//   float2 ZProjection_id76;           // Offset:    8 Size:     8 [unused]
//   float2 ViewSize_id77;              // Offset:   16 Size:     8
//   float AspectRatio_id78;            // Offset:   24 Size:     4 [unused]
//
// }
//
// cbuffer Globals
// {
//
//   float2 Texture0TexelSize_id15;     // Offset:    0 Size:     8 [unused]
//   float2 Texture1TexelSize_id17;     // Offset:    8 Size:     8 [unused]
//   float2 Texture2TexelSize_id19;     // Offset:   16 Size:     8 [unused]
//   float2 Texture3TexelSize_id21;     // Offset:   24 Size:     8 [unused]
//   float2 Texture4TexelSize_id23;     // Offset:   32 Size:     8 [unused]
//   float2 Texture5TexelSize_id25;     // Offset:   40 Size:     8 [unused]
//   float2 Texture6TexelSize_id27;     // Offset:   48 Size:     8 [unused]
//   float2 Texture7TexelSize_id29;     // Offset:   56 Size:     8 [unused]
//   float2 Texture8TexelSize_id31;     // Offset:   64 Size:     8 [unused]
//   float2 Texture9TexelSize_id33;     // Offset:   72 Size:     8 [unused]
//   float Levels_id90;                 // Offset:   80 Size:     4
//      = 0x43800000 
//   bool Uniform_id91;                 // Offset:   84 Size:     4
//      = 0x00000000 
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// LinearSampler_id44                sampler      NA          NA             s0      1 
// Sampler0_id52                     sampler      NA          NA             s1      1 
// Texture0_id14                     texture  float4          2d             t0      1 
// PerUpdate                         cbuffer      NA          NA            cb0      1 
// PerView                           cbuffer      NA          NA            cb1      1 
// Globals                           cbuffer      NA          NA            cb2      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float       
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Target                0   xyzw        0   TARGET   float   xyzw
//
ps_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[2], immediateIndexed
dcl_constantbuffer CB1[2], immediateIndexed
dcl_constantbuffer CB2[6], immediateIndexed
dcl_sampler s0, mode_default
dcl_sampler s1, mode_default
dcl_resource_texture2d (float,float,float,float) t0
dcl_input_ps linear v1.xy
dcl_output o0.xyzw
dcl_temps 9
//
// Initial variable locations:
//   v0.x <- __input__.ShadingPosition_id0.x; v0.y <- __input__.ShadingPosition_id0.y; v0.z <- __input__.ShadingPosition_id0.z; v0.w <- __input__.ShadingPosition_id0.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o0.x <- <PSMain return value>.ColorTarget_id2.x; o0.y <- <PSMain return value>.ColorTarget_id2.y; o0.z <- <PSMain return value>.ColorTarget_id2.z; o0.w <- <PSMain return value>.ColorTarget_id2.w
//
#line 201 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_12d5dafcb980a9932a2a524f22d23cba.hlsl"
sample_l_indexable(texture2d)(float,float,float,float) r0.xyzw, v1.xyxx, t0.xyzw, s1, l(0.000000)  // r0.x <- <InTex0_id26 return value>.x; r0.y <- <InTex0_id26 return value>.y; r0.z <- <InTex0_id26 return value>.z; r0.w <- <InTex0_id26 return value>.w

#line 186
sample_l_indexable(texture2d)(float,float,float,float) r1.xyzw, v1.xyxx, t0.xyzw, s0, l(0.000000)  // r1.x <- c.x; r1.y <- c.y; r1.z <- c.z; r1.w <- c.w

#line 189
if_z cb2[5].y

#line 191
  mul r2.x, v1.x, cb1[1].x

#line 149
  add r2.y, cb0[1].y, l(0.000010)  // r2.y <- RandomSeed

#line 150
  mul r3.xyz, r2.yyyy, l(13.000000, 11.000000, 7.000000, 0.000000)
  mad r4.xyzw, v1.xyxy, cb1[1].xyxy, r3.zzxx
  mad r5.xyzw, v1.xyxy, cb1[1].xyxy, l(-59.000000, -59.000000, 127.000000, 127.000000)
  mad r2.zw, r5.xxxy, l(0.000000, 0.000000, 0.006623, 0.006623), r3.yyyz
  sincos r2.zw, null, r2.zzzw
  dp2 r2.z, r2.zwzz, r2.zwzz
  sqrt r6.z, r2.z

#line 144
  mov r6.xy, r4.zwzz
  add r3.xzw, r6.xxyz, l(52.700001, 0.000000, 52.700001, 0.700000)
  dp3 r2.z, r3.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r2.z <- u.x

#line 145
  sincos r2.w, null, r2.z
  add r2.w, r2.w, l(0.100000)
  mul r6.x, r2.w, r2.z  // r6.x <- <_dnoise1_id29 return value>

#line 150
  mul r7.xyzw, r2.yyyy, l(13.000000, 5.000000, 7.000000, 17.000000)
  mad r2.zw, r5.zzzw, l(0.000000, 0.000000, 0.006135, 0.006135), r7.xxxy
  sincos r2.zw, null, r2.zzzw
  dp2 r2.z, r2.zwzz, r2.zwzz
  sqrt r4.z, r2.z

#line 144
  add r3.xzw, r4.xxyz, l(298.700012, 0.000000, 298.700012, 0.700000)
  dp3 r2.z, r3.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r2.z <- u.x

#line 145
  sincos r2.w, null, r2.z
  add r2.w, r2.w, l(0.100000)
  mul r6.y, r2.w, r2.z  // r6.y <- <_dnoise1_id29 return value>

#line 150
  mad r4.xy, v1.xyxx, cb1[1].xyxx, r7.yyyy
  mad r5.xyzw, v1.xyxy, cb1[1].xyxy, l(191.000000, 191.000000, -37.000000, -37.000000)
  mul r2.zw, r5.zzzw, l(0.000000, 0.000000, 0.005525, 0.005525)
  mad r3.xz, r5.xxyx, l(0.005780, 0.000000, 0.005780, 0.000000), r7.zzwz
  sincos r3.xz, null, r3.xxzx
  dp2 r3.x, r3.xzxx, r3.xzxx
  sqrt r4.z, r3.x

#line 144
  add r3.xzw, r4.xxyz, l(120.699997, 0.000000, 120.699997, 0.700000)
  dp3 r3.x, r3.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r3.x <- u.x

#line 145
  sincos r3.z, null, r3.x
  add r3.z, r3.z, l(0.100000)
  mul r6.z, r3.z, r3.x  // r6.z <- <_dnoise1_id29 return value>

#line 150
  mad r3.xy, v1.xyxx, cb1[1].xyxx, r3.yyyy
  mad r2.zw, r2.yyyy, l(0.000000, 0.000000, 5.000000, 23.000000), r2.zzzw
  sincos r2.zw, null, r2.zzzw
  dp2 r2.z, r2.zwzz, r2.zwzz
  sqrt r3.z, r2.z

#line 144
  add r3.xyz, r3.xyzx, l(110.699997, 110.699997, 0.700000, 0.000000)
  dp3 r2.z, r3.xyzx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r2.z <- u.x

#line 145
  sincos r2.w, null, r2.z
  add r2.w, r2.w, l(0.100000)
  mul r6.w, r2.w, r2.z  // r6.w <- <_dnoise1_id29 return value>

#line 151
  mad r3.xyzw, r2.xxxx, l(2.000000, 2.000000, 2.000000, 2.000000), r6.xyzw
  add r2.xyzw, r2.yyyy, r3.xyzw
  dp4 r3.x, r6.xyzw, l(1.000000, 1.000000, 1.000000, 1.000000)
  add r2.xyzw, r2.xyzw, r3.xxxx
  frc r2.xyzw, r2.xyzw  // r2.x <- <_dnoise4_id30 return value>.x; r2.y <- <_dnoise4_id30 return value>.y; r2.z <- <_dnoise4_id30 return value>.z; r2.w <- <_dnoise4_id30 return value>.w

#line 156
  mul r3.xyzw, r2.wxyz, l(15.842979, 15.842979, 15.842979, 15.842979)
  frc r3.xyzw, r3.xyzw  // r3.x <- nois2.x; r3.y <- nois2.y; r3.z <- nois2.z; r3.w <- nois2.w

#line 157
  mul r4.xyzw, r1.xyzw, cb2[5].xxxx  // r4.x <- c.x; r4.y <- c.y; r4.z <- c.z; r4.w <- c.w

#line 158
  mul r5.x, cb0[1].x, l(0.100000)
  add r3.xyzw, r3.xyzw, l(-0.500000, -0.500000, -0.500000, -0.500000)
  dp4 r5.y, r3.xyzw, r3.xyzw
  rsq r5.z, r5.y
  mul r6.xyzw, r3.wxyz, r5.zzzz
  mul r6.xyzw, r5.xxxx, r6.xyzw
  mul r5.x, r5.y, r5.y
  mul r5.xyzw, r5.xxxx, r6.xyzw
  exp r5.xyzw, r5.xyzw
  mul r4.xyzw, r4.xyzw, r5.xyzw

#line 159
  round_ni r5.xyzw, r4.xyzw
  frc r4.xyzw, r4.xyzw
  add r4.xyzw, r4.xyzw, l(-0.500000, -0.500000, -0.500000, -0.500000)
  mul r2.xyzw, r2.xyzw, r4.xyzw
  mad r2.xyzw, r2.xyzw, l(2.000000, 2.000000, 2.000000, 2.000000), r5.xyzw
  add r2.xyzw, r3.xyzw, r2.xyzw
  add r2.xyzw, r2.xyzw, l(0.500000, 0.500000, 0.500000, 0.500000)  // r2.x <- c.x; r2.y <- c.y; r2.z <- c.z; r2.w <- c.w

#line 160
  div r2.xyzw, r2.xyzw, cb2[5].xxxx

#line 192
else 

#line 195
  mul r3.x, v1.x, cb1[1].x

#line 149
  add r3.y, cb0[1].y, l(0.000010)  // r3.y <- RandomSeed

#line 150
  mul r4.xyz, r3.yyyy, l(13.000000, 11.000000, 7.000000, 0.000000)
  mad r5.xyzw, v1.xyxy, cb1[1].xyxy, r4.zzxx
  mad r6.xyzw, v1.xyxy, cb1[1].xyxy, l(-59.000000, -59.000000, 127.000000, 127.000000)
  mad r3.zw, r6.xxxy, l(0.000000, 0.000000, 0.006623, 0.006623), r4.yyyz
  sincos r3.zw, null, r3.zzzw
  dp2 r3.z, r3.zwzz, r3.zwzz
  sqrt r7.z, r3.z

#line 144
  mov r7.xy, r5.zwzz
  add r4.xzw, r7.xxyz, l(52.700001, 0.000000, 52.700001, 0.700000)
  dp3 r3.z, r4.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r3.z <- u.x

#line 145
  sincos r3.w, null, r3.z
  add r3.w, r3.w, l(0.100000)
  mul r7.x, r3.w, r3.z  // r7.x <- <_dnoise1_id29 return value>

#line 150
  mul r8.xyzw, r3.yyyy, l(13.000000, 5.000000, 7.000000, 17.000000)
  mad r3.zw, r6.zzzw, l(0.000000, 0.000000, 0.006135, 0.006135), r8.xxxy
  sincos r3.zw, null, r3.zzzw
  dp2 r3.z, r3.zwzz, r3.zwzz
  sqrt r5.z, r3.z

#line 144
  add r4.xzw, r5.xxyz, l(298.700012, 0.000000, 298.700012, 0.700000)
  dp3 r3.z, r4.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r3.z <- u.x

#line 145
  sincos r3.w, null, r3.z
  add r3.w, r3.w, l(0.100000)
  mul r7.y, r3.w, r3.z  // r7.y <- <_dnoise1_id29 return value>

#line 150
  mad r5.xy, v1.xyxx, cb1[1].xyxx, r8.yyyy
  mad r6.xyzw, v1.xyxy, cb1[1].xyxy, l(191.000000, 191.000000, -37.000000, -37.000000)
  mul r3.zw, r6.zzzw, l(0.000000, 0.000000, 0.005525, 0.005525)
  mad r4.xz, r6.xxyx, l(0.005780, 0.000000, 0.005780, 0.000000), r8.zzwz
  sincos r4.xz, null, r4.xxzx
  dp2 r4.x, r4.xzxx, r4.xzxx
  sqrt r5.z, r4.x

#line 144
  add r4.xzw, r5.xxyz, l(120.699997, 0.000000, 120.699997, 0.700000)
  dp3 r4.x, r4.xzwx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r4.x <- u.x

#line 145
  sincos r4.z, null, r4.x
  add r4.z, r4.z, l(0.100000)
  mul r7.z, r4.z, r4.x  // r7.z <- <_dnoise1_id29 return value>

#line 150
  mad r4.xy, v1.xyxx, cb1[1].xyxx, r4.yyyy
  mad r3.zw, r3.yyyy, l(0.000000, 0.000000, 5.000000, 23.000000), r3.zzzw
  sincos r3.zw, null, r3.zzzw
  dp2 r3.z, r3.zwzz, r3.zwzz
  sqrt r4.z, r3.z

#line 144
  add r4.xyz, r4.xyzx, l(110.699997, 110.699997, 0.700000, 0.000000)
  dp3 r3.z, r4.xyzx, l(1.000000, 57.000000, 21.000000, 0.000000)  // r3.z <- u.x

#line 145
  sincos r3.w, null, r3.z
  add r3.w, r3.w, l(0.100000)
  mul r7.w, r3.w, r3.z  // r7.w <- <_dnoise1_id29 return value>

#line 151
  mad r4.xyzw, r3.xxxx, l(2.000000, 2.000000, 2.000000, 2.000000), r7.xyzw
  add r3.xyzw, r3.yyyy, r4.xyzw
  dp4 r4.x, r7.xyzw, l(1.000000, 1.000000, 1.000000, 1.000000)
  add r3.xyzw, r3.xyzw, r4.xxxx
  frc r3.xyzw, r3.xyzw  // r3.x <- <_dnoise4_id30 return value>.x; r3.y <- <_dnoise4_id30 return value>.y; r3.z <- <_dnoise4_id30 return value>.z; r3.w <- <_dnoise4_id30 return value>.w

#line 167
  add r3.xyzw, r3.xyzw, l(-0.500000, -0.500000, -0.500000, -0.500000)
  mul r3.xyzw, r3.xyzw, cb0[1].xxxx
  mad r1.xyzw, r1.xyzw, cb2[5].xxxx, r3.xyzw  // r1.x <- c.x; r1.y <- c.y; r1.z <- c.z; r1.w <- c.w

#line 168
  div r2.xyzw, r1.xyzw, cb2[5].xxxx

#line 196
endif 

#line 206
add r1.xyzw, -r0.xyzw, r2.xyzw
mad o0.xyzw, cb0[0].xyzw, r1.xyzw, r0.xyzw

#line 215
ret 
// Approximately 137 instruction slots used
***************************
*************************/
struct PS_STREAMS 
{
    float2 TexCoord_id62;
    float4 ColorTarget_id2;
};
struct PS_OUTPUT 
{
    float4 ColorTarget_id2 : SV_Target0;
};
struct PS_INPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_STREAMS 
{
    float4 Position_id72;
    float2 TexCoord_id62;
    float4 ShadingPosition_id0;
};
struct VS_OUTPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_INPUT 
{
    float4 Position_id72 : POSITION;
    float2 TexCoord_id62 : TEXCOORD0;
};
cbuffer PerDraw 
{
    float4x4 MatrixTransform_id73;
};
cbuffer PerUpdate 
{
    float4 InputValue_id92;
    float InputValue_id93;
    float InputValue_id94;
};
cbuffer PerView 
{
    float NearClipPlane_id74 = 1.0f;
    float FarClipPlane_id75 = 100.0f;
    float2 ZProjection_id76;
    float2 ViewSize_id77;
    float AspectRatio_id78;
};
cbuffer Globals 
{
    float2 Texture0TexelSize_id15;
    float2 Texture1TexelSize_id17;
    float2 Texture2TexelSize_id19;
    float2 Texture3TexelSize_id21;
    float2 Texture4TexelSize_id23;
    float2 Texture5TexelSize_id25;
    float2 Texture6TexelSize_id27;
    float2 Texture7TexelSize_id29;
    float2 Texture8TexelSize_id31;
    float2 Texture9TexelSize_id33;
    float Levels_id90 = 256.0f;
    bool Uniform_id91 = 0;
};
Texture2D Texture0_id14;
Texture2D Texture1_id16;
Texture2D Texture2_id18;
Texture2D Texture3_id20;
Texture2D Texture4_id22;
Texture2D Texture5_id24;
Texture2D Texture6_id26;
Texture2D Texture7_id28;
Texture2D Texture8_id30;
Texture2D Texture9_id32;
TextureCube TextureCube0_id34;
TextureCube TextureCube1_id35;
TextureCube TextureCube2_id36;
TextureCube TextureCube3_id37;
Texture3D Texture3D0_id38;
Texture3D Texture3D1_id39;
Texture3D Texture3D2_id40;
Texture3D Texture3D3_id41;
SamplerState Sampler_id42;
SamplerState PointSampler_id43 
{
    Filter = MIN_MAG_MIP_POINT;
};
SamplerState LinearSampler_id44 
{
    Filter = MIN_MAG_MIP_LINEAR;
};
SamplerState LinearBorderSampler_id45 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border;
    AddressV = Border;
};
SamplerComparisonState LinearClampCompareLessEqualSampler_id46 
{
    Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
    ComparisonFunc = LessEqual;
};
SamplerState AnisotropicSampler_id47 
{
    Filter = ANISOTROPIC;
};
SamplerState AnisotropicRepeatSampler_id48 
{
    Filter = ANISOTROPIC;
    AddressU = Wrap;
    AddressV = Wrap;
    MaxAnisotropy = 16;
};
SamplerState PointRepeatSampler_id49 
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState LinearRepeatSampler_id50 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState RepeatSampler_id51 
{
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState Sampler0_id52;
SamplerState Sampler1_id53;
SamplerState Sampler2_id54;
SamplerState Sampler3_id55;
SamplerState Sampler4_id56;
SamplerState Sampler5_id57;
SamplerState Sampler6_id58;
SamplerState Sampler7_id59;
SamplerState Sampler8_id60;
SamplerState Sampler9_id61;
float _dnoise1_id29(float3 u)
{
    u = dot(u + .2, float3(1, 57, 21));
    return (u.x * (.1 + sin(u.x)));
}
float4 _dnoise4_id30(float2 x, float RandomSeed)
{
    RandomSeed += 0.00001;
    float4 c = { _dnoise1_id29(float3((x + RandomSeed * 13 + 41) + 11, length(sin((x - 59) / 151 + RandomSeed * float2(11, 7)))) + .5), _dnoise1_id29(float3((x + RandomSeed * 7 + 293) + 5, length(sin((x + 127) / 163 + RandomSeed * float2(13, 5)))) + .5), _dnoise1_id29(float3((x + RandomSeed * 5 + 113) + 7, length(sin((x + 191) / 173 + RandomSeed * float2(7, 17)))) + .5), _dnoise1_id29(float3((x + RandomSeed * 11 + 97) + 13, length(sin((x - 37) / 181 + RandomSeed * float2(5, 23)))) + .5)};
    return frac(c + x.x * 2 + RandomSeed + dot(c, 1));
}
float4 NoiseDither_id31(float4 c, float2 x, float RandomSeed = 0, float Grain = 0, float Levels = 256, float LevelNoise = 1, float AddNoise = 1)
{
    float4 nois = _dnoise4_id30(x, RandomSeed);
    float4 nois2 = frac(nois.wxyz * sqrt(251));
    c *= Levels;
    c *= pow(2, Grain * 0.1 * normalize(nois2.wxyz - .5) * pow(length(nois2.wxyz - .5), 4));
    c = floor(c) + nois * (frac(c) - .5) * 2 * LevelNoise + 0.5 + (nois2 - .5) * AddNoise;
    c /= Levels;
    return c;
}
float4 _dither_id32(float4 c, float2 uv, float RandomSeed = 0, float Levels = 255, float AddNoise = 1)
{
    float4 nois = _dnoise4_id30(uv, RandomSeed);
    c *= Levels;
    c += (nois - 0.5) * AddNoise;
    c /= Levels;
    return c;
}
float Compute_id36()
{
    return InputValue_id93;
}
float Compute_id35()
{
    return InputValue_id94;
}
float4 Compute_id34()
{
    return InputValue_id92;
}
float4 Filter_id33(inout PS_STREAMS streams, float4 tex0col)
{
    float2 uv = streams.TexCoord_id62;
    float4 c = Texture0_id14.SampleLevel(LinearSampler_id44, uv, 0);
    float time = Compute_id35();
    float grain = Compute_id36();
    if (!Uniform_id91)
    {
        c = NoiseDither_id31(c, uv * ViewSize_id77, time, grain, Levels_id90);
    }
    else
    {
        c = _dither_id32(c, uv * ViewSize_id77, time, Levels_id90, grain);
    }
    return c;
}
float4 InTex0_id26(inout PS_STREAMS streams)
{
    return Texture0_id14.SampleLevel(Sampler0_id52, streams.TexCoord_id62, 0);
}
float4 Shading_id28(inout PS_STREAMS streams)
{
    float4 col = InTex0_id26(streams);
    return lerp(col, Filter_id33(streams, col), Compute_id34());
}
PS_OUTPUT PSMain(PS_INPUT __input__)
{
    PS_STREAMS streams = (PS_STREAMS)0;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ColorTarget_id2 = Shading_id28(streams);
    PS_OUTPUT __output__ = (PS_OUTPUT)0;
    __output__.ColorTarget_id2 = streams.ColorTarget_id2;
    return __output__;
}
VS_OUTPUT VSMain(VS_INPUT __input__)
{
    VS_STREAMS streams = (VS_STREAMS)0;
    streams.Position_id72 = __input__.Position_id72;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ShadingPosition_id0 = mul(streams.Position_id72, MatrixTransform_id73);
    VS_OUTPUT __output__ = (VS_OUTPUT)0;
    __output__.ShadingPosition_id0 = streams.ShadingPosition_id0;
    __output__.TexCoord_id62 = streams.TexCoord_id62;
    return __output__;
}
