#define PI 3.14159265359

uniform sampler2D image;  // The input texture (your PNG image)
uniform float iTime;      // Time, from 0 (scattered) to 1 (original)

// Back easing function for smoother overshoot
float easeInOutBack(float t) {
    float c1 = 1.70158;
    float c2 = c1 * 1.525;

    return t < 0.5
        ? (pow(2.0 * t, 2.0) * ((c2 + 1.0) * 2.0 * t - c2)) / 2.0
        : (pow(2.0 * t - 2.0, 2.0) * ((c2 + 1.0) * (t * 2.0 - 2.0) + c2) + 2.0) / 2.0;
}

// Function to generate random displacement
vec2 randomDisplacement(vec2 uv, vec2 seed) {
    float displacementX = fract(sin(dot(uv + seed, vec2(12.9898, 78.233))) * 43758.5453);
    float displacementY = fract(sin(dot(uv + seed, vec2(43.5421, 19.4525))) * 24612.3456);
    return vec2(displacementX, displacementY) * 2.0 - 1.0;  // Output between -1 and 1
}

void main() {
    vec2 iResolution = vec2(1920., 1080.);
    vec2 uv = gl_TexCoord[0].xy;

    // Ease the time progression using the back easing
    float easedTime = easeInOutBack(clamp(iTime, 0.0, 1.0));

    // Increase the strength of the scatter
    float scatterStrength = 5.0;  // Adjust this value to scatter pixels further offscreen

    // Calculate random displacement based on UV coordinates and a seed
    vec2 randomOffset = randomDisplacement(uv, vec2(0.5, 0.7));

    // Interpolate between fully scattered and original pixel positions, with stronger scatter
    vec2 scatteredUV = uv + randomOffset * scatterStrength * (1.0 - easedTime);  // Stronger scatter when iTime is near 0

    // Sample the texture at the scattered coordinates
    vec4 color = texture2D(image, scatteredUV);

    gl_FragColor = color;
}
