uniform float intensity = 0.95f;     // Uniform to control the intensity of the effect (overall erratic behavior)
uniform float waveIntensity = 0.f; // Uniform to control the waviness (0.0 = flat, 1.0 = very wavy)
uniform vec3 laserColor = vec3(1, 1, 1);     // Uniform to control the color of the laser (RGB)
uniform float xOffset = 0.4f;       // Uniform to control the horizontal offset (scrolling effect)
uniform float u_lineThickness = 0.3f;

void main()
{

    vec2 uv = gl_TexCoord[0].xy;
    uv = uv * 2.0 - 1.0; // Now uv.x and uv.y range from -1 to 1
    uv.x *= 1920 / 1080; // Adjust for aspect ratio

    // Apply the horizontal offset to the UV coordinates
    uv.x += xOffset;

    // Laser properties
    float laserSpeed = 0.5;  // Speed at which the laser moves horizontally
    float frequency = 20.0;  // Frequency of the laser wave
    float lineThickness = u_lineThickness / mix(1.0, 3.0, intensity);  // Thinner laser at higher intensity

    // Wave amplitude controlled by the 'waveIntensity' uniform
    float amplitude = 0.5 * waveIntensity * mix(1.0, 3.0, intensity);  // More erratic at higher intensity and waveIntensity
    // Add randomness to the vertical oscillation (more erratic at higher intensity)
    float randomness = sin(uv.x * 4.0) * 0.5 + 0.5;
    float randomFactor = cos(uv.x * 8.0) * randomness;

    // Compute horizontal laser position with oscillation (moving wave)
    float laserPosition = uv.x;

    // Vertical oscillation effect for the laser beam based on waveIntensity
    float wave = sin(laserPosition * frequency) * amplitude * randomFactor;

    // Center the laser along the Y-axis, adding erratic wave motion
    float distanceFromLaser = abs(uv.y - wave);

    // Smooth laser edge
    float laserEdge = smoothstep(lineThickness, 0.0, distanceFromLaser);

    // Apply color based on the laserColor uniform
    vec3 finalColor = laserEdge * laserColor;

    // Output final fragment color
    gl_FragColor = vec4(finalColor, 1.0);
}
