uniform float iTime;

vec3 coloring(vec3 a, vec3 b, vec3 c, vec3 d, float t)
{
    return a + b * cos(6.28 * (c * t + d));
}

void main()
{

    vec2 iResolution = vec2(1920., 1080.);

    // Normalized pixel coordinates (from 0 to 1)
    float t = iTime * 0.5;
    vec2 center = vec2(- sin(iTime) / 600., -cos(iTime) / 600.);
    center.x *= iResolution.x / iResolution.y;
    vec2 uv = gl_TexCoord[0].xy /*/ iResolution.xy*/ * vec2(2., 2.) - vec2(1. - sin(iTime) / 6., 1. - cos(iTime) / 6.);//vec2(sin(t) * 2. + 0.25, cos(t) * 2. + 0.25);
    //uv.x *= iResolution.x / iResolution.y;
    
    
    float xx = length(uv);
    
    // Time varying pixel color
    vec3 col = coloring(vec3(0.500, 0.500, -2.222), vec3(0.500, 0.500, 3.138), vec3(1.000, 1.000, 2.728), vec3(0.000, 0.333, 0.808), exp(sin(iTime) / xx) + t);
    col -= coloring(vec3(-1.172, -1.562, -2.222), vec3(3.138, 2.358, 3.138), vec3(-1.782, -0.942, -1.002), vec3(-1.142, -0.582, -0.532), exp(cos(iTime) / xx) - t);
    //col = col * smoothstep(0.1, 0.12, distance(uv, center));
    
    
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}