vec3 normal(vec3 p) {
    return normalize(vec3(
            sdf(vec3(p.x + EPSILON, p.y, p.z)).x - sdf(vec3(p.x - EPSILON, p.y, p.z)).x,
            sdf(vec3(p.x, p.y + EPSILON, p.z)).x - sdf(vec3(p.x, p.y - EPSILON, p.z)).x,
            sdf(vec3(p.x, p.y, p.z + EPSILON)).x - sdf(vec3(p.x, p.y, p.z - EPSILON)).x
        ));
}

vec2 marchBasic(vec3 o, vec3 d) {
    float t = EPSILON + 0.1;
    vec2 dist = vec2(0.);
    for (int i = 0; i < 256; i++) {
        dist = sdf(o + d * t);
        t += dist.x;
        if (dist.x < EPSILON) {
            break;
        }
        if (t > 1024.) {
            break;
        }
    }
    return vec2(t, dist.y);
}

float marchShadow(vec3 o, vec3 d, float soft) {
    float t = EPSILON + 0.1;
    float dist = 0.;
    float shadow = 1.;
    for (int i = 0; i < 128; i++) {
        dist = sdf(o + d * t).x;
        t += dist;
        shadow = min(shadow, soft * dist / t);
        if (dist.x < EPSILON) {
            shadow = 0.;
            break;
        }
        if (t > 1024.) {
            break;
        }
    }
    return shadow;
}

vec3 march(vec3 o, vec3 d, vec3 param, float side) {
    float t = param.x;
    vec2 dist = vec2(0.);
    float shadow = 1.;
    for (int i = 0; i < 256; i++) {
        dist = sdf(o + d * t) * side;
        t += dist.x * 0.8;
        shadow = min(shadow, param.z * dist.x / t);
        if (dist.x < EPSILON) {
            shadow = 0.;
            break;
        }
        if (t > param.y) {
            break;
        }
    }
    return vec3(t, dist.y, shadow);
}
