const std = @import("std");

pub fn build(b: *std.Build) void {
    const target = b.standardTargetOptions(.{});
    const optimize = b.standardOptimizeOption(.{});

    const dep__logu = b.dependency("logu", .{
        .target = target,
        .optimize = optimize,
    });
    const module__logu = dep__logu.module("logu");
    const dep__raylib = b.dependency("raylib", .{
        .target = target,
        .optimize = optimize,
    });
    const module__raylib = dep__raylib.module("raylib"); // Main raylib module.
    const raylib__artifact = dep__raylib.artifact("raylib"); // Raylib C library.
    const dep__scraw = b.dependency("scraw", .{
        .target = target,
        .optimize = optimize,
    });
    const module__scraw = dep__scraw.module("scraw");
    const dep__zigimg = b.dependency("zigimg", .{
        .target = target,
        .optimize = optimize,
    });
    const module__zigimg = dep__zigimg.module("zigimg");
    const dep__c332 = b.dependency("c332", .{
        .target = target,
        .optimize = optimize,
    });
    const module__c332 = dep__c332.module("c332");
    const dep__args = b.dependency("args", .{
        .target = target,
        .optimize = optimize,
    });
    const module__args = dep__args.module("args");

    const exe = b.addExecutable(.{
        .name = "gosia__gfx__host",
        .root_source_file = b.path("src/main.zig"),
        .target = target,
        .optimize = optimize,
    });
    exe.linkLibrary(raylib__artifact);
    exe.linkLibC();
    if (target.result.os.tag == .windows) {
        exe.linkSystemLibrary("winscard");
    } else if (target.result.os.tag == .linux) {
        exe.linkSystemLibrary("pcsclite");
    } else {
        @panic("Platform unsupported.");
    }
    exe.root_module.addImport("scraw", module__scraw);
    exe.root_module.addImport("zigimg", module__zigimg);
    exe.root_module.addImport("raylib", module__raylib);
    exe.root_module.addImport("logu", module__logu);
    exe.root_module.addImport("c332", module__c332);
    exe.root_module.addImport("args", module__args);
    exe.root_module.strip = true;
    b.installArtifact(exe);

    const run_cmd = b.addRunArtifact(exe);
    run_cmd.step.dependOn(b.getInstallStep());
    if (b.args) |args| {
        run_cmd.addArgs(args);
    }

    const run_step = b.step("run", "Run the app");
    run_step.dependOn(&run_cmd.step);

    const exe_unit_tests = b.addTest(.{
        .root_source_file = b.path("src/main.zig"),
        .target = target,
        .optimize = optimize,
    });
    const run_exe_unit_tests = b.addRunArtifact(exe_unit_tests);

    const test_step = b.step("test", "Run unit tests");
    test_step.dependOn(&run_exe_unit_tests.step);
}
