#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _1075
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    float transparency;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1066;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1084;

layout(set = 1, binding = 4, std140) uniform VM5
{
    layout(row_major) ModifierFactorNoise_Params VM5_params;
} _1208;

layout(set = 1, binding = 5, std140) uniform VM6
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM6_params;
} _1223;

layout(set = 1, binding = 6, std140) uniform VM7
{
    ModifierFactorMulAdd_Params VM7_params;
} _1238;

layout(set = 1, binding = 7, std140) uniform VM8
{
    ModifierFactorClamp_Params VM8_params;
} _1251;

layout(set = 1, binding = 8) uniform sampler2D s_Curves;
layout(set = 1, binding = 9) uniform sampler2D material_textures[64];

layout(location = 1) in _1075 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

uint octahedral_32(inout vec3 nor, uint sh)
{
    nor /= vec3((abs(nor.x) + abs(nor.y)) + abs(nor.z));
    vec2 _209;
    if (nor.z >= 0.0)
    {
        _209 = nor.xy;
    }
    else
    {
        _209 = (vec2(1.0) - abs(nor.yx)) * sign(nor.xy);
    }
    nor.x = _209.x;
    nor.y = _209.y;
    vec2 v = vec2(0.5) + (nor.xy * 0.5);
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(floor((v * float(mu)) + vec2(0.5)));
    return (d.y << sh) | d.x;
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint param_1 = 15u;
    uint _265 = octahedral_32(param, param_1);
    uint normal_material = _265;
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _850 = vector_transform_by_mat43(param, param_1);
        coords = _850;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _857 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _857;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _914 = vector_transform_by_mat43(param, param_1);
        coords = _914;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _925 = vector_transform_by_mat43(param_2, param_3);
            coords = _925;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _935 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _935;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec4 getMaterialAlbedo(MaterialPropertiesGPU material, vec4 albedo, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return albedo;
}

vec3 getMaterialEmissive(MaterialPropertiesGPU material, vec3 emissive, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return emissive;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

float getMaterialRoughness(MaterialPropertiesGPU material, float roughness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return roughness;
}

float getMaterialMetalness(MaterialPropertiesGPU material, float metalness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return metalness;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _311 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _311.x;
    o.y = _311.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _1073;
    _1073.diffuse = materials.material_properties[_1066.materialIndex].diffuse;
    _1073.transparency = materials.material_properties[_1066.materialIndex].transparency;
    _1073.emissive = materials.material_properties[_1066.materialIndex].emissive;
    _1073.roughness = materials.material_properties[_1066.materialIndex].roughness;
    _1073.triplanar_factor = materials.material_properties[_1066.materialIndex].triplanar_factor;
    _1073.refraction = materials.material_properties[_1066.materialIndex].refraction;
    _1073.normal_factor = materials.material_properties[_1066.materialIndex].normal_factor;
    _1073.emissive_factor = materials.material_properties[_1066.materialIndex].emissive_factor;
    _1073.temporal_accumulation_factor = materials.material_properties[_1066.materialIndex].temporal_accumulation_factor;
    _1073.shadowmap_bias = materials.material_properties[_1066.materialIndex].shadowmap_bias;
    _1073.metalness = materials.material_properties[_1066.materialIndex].metalness;
    _1073.albedo_sampler = materials.material_properties[_1066.materialIndex].albedo_sampler;
    _1073.emissive_sampler = materials.material_properties[_1066.materialIndex].emissive_sampler;
    _1073.normal_sampler = materials.material_properties[_1066.materialIndex].normal_sampler;
    _1073.metalic_roughness_sampler = materials.material_properties[_1066.materialIndex].metalic_roughness_sampler;
    _1073.flags = materials.material_properties[_1066.materialIndex].flags;
    _1073._pad0 = materials.material_properties[_1066.materialIndex]._pad0;
    _1073._pad1 = materials.material_properties[_1066.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1073;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _1084.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_11 = normal;
    int param_12 = _1066.materialId;
    outNormalMaterial = encode_normal_material(param_11, param_12);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1084.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1084.transform_params.mModelInv;
    modifier_factor.position = vtx_input.vCameraRelativeWorldPos + _1084.transform_params.vCameraPosition;
    ModifierFactorNoise_Params _1213;
    _1213.transform_local_to_gizmo = _1208.VM5_params.transform_local_to_gizmo;
    _1213.noise_domain_scale = _1208.VM5_params.noise_domain_scale;
    _1213.modifier_function = _1208.VM5_params.modifier_function;
    _1213.noise_domain_offset = _1208.VM5_params.noise_domain_offset;
    _1213.noise_value_scale = _1208.VM5_params.noise_value_scale;
    _1213.noise_value_offset = _1208.VM5_params.noise_value_offset;
    _1213.influence_scope = _1208.VM5_params.influence_scope;
    _1213._pad0 = _1208.VM5_params._pad0;
    _1213._pad1 = _1208.VM5_params._pad1;
    ModifierFactorNoise_Params param_13 = _1213;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_noise_default(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorDistanceRadial_Params _1228;
    _1228.transform_local_to_gizmo = _1223.VM6_params.transform_local_to_gizmo;
    _1228.falloff_curve_idx = _1223.VM6_params.falloff_curve_idx;
    _1228.falloff_inverse = _1223.VM6_params.falloff_inverse;
    _1228.domain_repeat_x = _1223.VM6_params.domain_repeat_x;
    _1228.domain_repeat_y = _1223.VM6_params.domain_repeat_y;
    _1228.domain_repeat_z = _1223.VM6_params.domain_repeat_z;
    _1228.influence_scope = _1223.VM6_params.influence_scope;
    _1228.modifier_function = _1223.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_16 = _1228;
    ModifierFactor param_17 = modifier_factor;
    CoordinateSystemTrasforms param_18 = cs_transforms;
    modifier_factor_distance_radial(param_16, param_17, param_18);
    modifier_factor = param_17;
    ModifierFactorMulAdd_Params _1243;
    _1243.multiply_value = _1238.VM7_params.multiply_value;
    _1243.add_value = _1238.VM7_params.add_value;
    ModifierFactorMulAdd_Params param_19 = _1243;
    ModifierFactor param_20 = modifier_factor;
    modifier_factor_mul_add(param_19, param_20);
    modifier_factor = param_20;
    ModifierFactorClamp_Params _1256;
    _1256.clamp_min = _1251.VM8_params.clamp_min;
    _1256.clamp_max = _1251.VM8_params.clamp_max;
    _1256.clamp_min_enable = _1251.VM8_params.clamp_min_enable;
    _1256.clamp_max_enable = _1251.VM8_params.clamp_max_enable;
    ModifierFactorClamp_Params param_21 = _1256;
    ModifierFactor param_22 = modifier_factor;
    modifier_factor_clamp(param_21, param_22);
    modifier_factor = param_22;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _1066.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.transparency = material.transparency;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    outAlbedo = vec4(material.diffuse, _1066.colorDiffuse.w);
    MaterialPropertiesGPU param_23 = material;
    vec4 param_24 = outAlbedo;
    vec3 param_25 = worldPos;
    vec3 param_26 = vtx_input.vLocalPos;
    vec3 param_27 = vtx_input.vNorm;
    vec3 param_28 = vtx_input.vWorldNorm;
    outAlbedo = getMaterialAlbedo(param_23, param_24, param_25, param_26, param_27, param_28);
    vec4 _1348 = outAlbedo;
    vec3 _1350 = _1348.xyz * vtx_input.vColor.xyz;
    outAlbedo.x = _1350.x;
    outAlbedo.y = _1350.y;
    outAlbedo.z = _1350.z;
    outEmissive = vec4(0.0);
    outEmissive.w = material.transparency;
    MaterialPropertiesGPU param_29 = material;
    vec3 param_30 = outEmissive.xyz;
    vec3 param_31 = worldPos;
    vec3 param_32 = vtx_input.vLocalPos;
    vec3 param_33 = vtx_input.vNorm;
    vec3 param_34 = vtx_input.vWorldNorm;
    vec3 _1378 = getMaterialEmissive(param_29, param_30, param_31, param_32, param_33, param_34);
    outEmissive.x = _1378.x;
    outEmissive.y = _1378.y;
    outEmissive.z = _1378.z;
    if (false)
    {
        bool _1389 = material.emissive_sampler >= 0;
        bool _1396;
        if (_1389)
        {
            _1396 = material.emissive_sampler < 16;
        }
        else
        {
            _1396 = _1389;
        }
        if (_1396)
        {
            if ((material.flags & 1024u) != 0u)
            {
                vec3 param_35 = vtx_input.vLocalPos;
                vec3 param_36 = norm;
                vec3 param_37 = material.triplanar_factor;
                vec4 _1423 = outEmissive;
                vec3 _1425 = _1423.xyz * mapping_triplanar(material_textures[material.emissive_sampler], param_35, param_36, param_37).xyz;
                outEmissive.x = _1425.x;
                outEmissive.y = _1425.y;
                outEmissive.z = _1425.z;
            }
            else
            {
                vec4 _1440 = outEmissive;
                vec3 _1442 = _1440.xyz * texture(material_textures[material.emissive_sampler], uv0).xyz;
                outEmissive.x = _1442.x;
                outEmissive.y = _1442.y;
                outEmissive.z = _1442.z;
            }
        }
    }
    float roughness = material.roughness;
    MaterialPropertiesGPU param_38 = material;
    float param_39 = roughness;
    vec3 param_40 = worldPos;
    vec3 param_41 = vtx_input.vLocalPos;
    vec3 param_42 = vtx_input.vNorm;
    vec3 param_43 = vtx_input.vWorldNorm;
    roughness = getMaterialRoughness(param_38, param_39, param_40, param_41, param_42, param_43);
    float metalness = material.metalness;
    MaterialPropertiesGPU param_44 = material;
    float param_45 = metalness;
    vec3 param_46 = worldPos;
    vec3 param_47 = vtx_input.vLocalPos;
    vec3 param_48 = vtx_input.vNorm;
    vec3 param_49 = vtx_input.vWorldNorm;
    metalness = getMaterialMetalness(param_44, param_45, param_46, param_47, param_48, param_49);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_1066.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_1066.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_50 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_50);
}

 